/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.packages.uploaders;

import cc.arduino.packages.BoardPort;
import cc.arduino.packages.Uploader;
import cc.arduino.packages.ssh.NoInteractionUserInfo;
import cc.arduino.packages.ssh.SCP;
import cc.arduino.packages.ssh.SSH;
import cc.arduino.packages.ssh.SSHConfigFileSetup;
import cc.arduino.packages.ssh.SSHPwdSetup;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import processing.app.BaseNoGui;
import processing.app.I18n;
import processing.app.PreferencesData;
import processing.app.debug.RunnerException;
import processing.app.debug.TargetPlatform;
import processing.app.helpers.PreferencesMap;
import processing.app.helpers.StringUtils;

public class SSHUploader
extends Uploader {
    private static final List<String> FILES_NOT_TO_COPY = Arrays.asList(".DS_Store", ".Trash", "Thumbs.db", "__MACOSX");
    private final BoardPort port;

    public SSHUploader(BoardPort boardPort) {
        this.port = boardPort;
    }

    @Override
    public boolean requiresAuthorization() {
        return true;
    }

    @Override
    public String getAuthorizationKey() {
        return "runtime.pwd." + this.port.getAddress();
    }

    @Override
    public boolean uploadUsingPreferences(File file, String string, String string2, boolean bl, List<String> list) throws RunnerException {
        if (bl) {
            throw new RunnerException(I18n._("Network upload using programmer not supported"));
        }
        Session session = null;
        SCP sCP = null;
        try {
            JSch jSch = new JSch();
            SSHConfigFileSetup sSHConfigFileSetup = new SSHConfigFileSetup(new SSHPwdSetup());
            session = sSHConfigFileSetup.setup(this.port, jSch);
            session.setUserInfo((UserInfo)new NoInteractionUserInfo(PreferencesData.get("runtime.pwd." + this.port.getAddress())));
            session.connect(30000);
            sCP = new SCP(session);
            SSH sSH = new SSH(session);
            this.scpFiles(sCP, sSH, file, string, string2, list);
            boolean bl2 = this.runAVRDude(sSH);
            return bl2;
        }
        catch (JSchException jSchException) {
            String string3 = jSchException.getMessage();
            if ("Auth cancel".equals(string3) || "Auth fail".equals(string3)) {
                boolean bl3 = false;
                return bl3;
            }
            if (jSchException.getMessage().contains("Connection refused")) {
                throw new RunnerException(I18n.format("Unable to connect to {0}", this.port.getAddress()));
            }
            throw new RunnerException((Exception)((Object)jSchException));
        }
        catch (Exception exception) {
            throw new RunnerException(exception);
        }
        finally {
            if (sCP != null) {
                try {
                    sCP.close();
                }
                catch (IOException iOException) {
                    throw new RunnerException(iOException);
                }
            }
            if (session != null) {
                session.disconnect();
            }
        }
    }

    private boolean runAVRDude(SSH sSH) throws IOException, JSchException {
        TargetPlatform targetPlatform = BaseNoGui.getTargetPlatform();
        PreferencesMap preferencesMap = PreferencesData.getMap();
        preferencesMap.putAll(BaseNoGui.getBoardPreferences());
        preferencesMap.putAll(targetPlatform.getTool((String)preferencesMap.get("upload.tool")));
        String string = this.verbose ? (String)preferencesMap.get("upload.params.verbose") : (String)preferencesMap.get("upload.params.quiet");
        boolean bl = sSH.execSyncCommand("merge-sketch-with-bootloader.lua /tmp/sketch.hex", System.out, System.err);
        sSH.execSyncCommand("kill-bridge");
        bl = bl && sSH.execSyncCommand("run-avrdude /tmp/sketch.hex '" + string + "'", System.out, System.err);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scpFiles(SCP sCP, SSH sSH, File file, String string, String string2, List<String> list) throws JSchException, IOException {
        try {
            sCP.open();
            sCP.startFolder("tmp");
            sCP.sendFile(new File(string, string2 + ".hex"), "sketch.hex");
            sCP.endFolder();
            if (this.canUploadWWWFiles(file, sSH, list)) {
                sCP.startFolder("www");
                sCP.startFolder("sd");
                sCP.startFolder(file.getName());
                this.recursiveSCP(new File(file, "www"), sCP);
                sCP.endFolder();
                sCP.endFolder();
                sCP.endFolder();
            }
        }
        finally {
            sCP.close();
        }
    }

    private boolean canUploadWWWFiles(File file, SSH sSH, List<String> list) throws IOException, JSchException {
        File file2 = new File(file, "www");
        if (!file2.exists() || !file2.isDirectory()) {
            return false;
        }
        if (!file2.canExecute()) {
            list.add(I18n._("Problem accessing files in folder ") + file2);
            return false;
        }
        if (!sSH.execSyncCommand("special-storage-available")) {
            list.add(I18n._("Problem accessing board folder /www/sd"));
            return false;
        }
        return true;
    }

    private void recursiveSCP(File file, SCP sCP) throws IOException {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            if (StringUtils.stringContainsOneOf(file2.getName(), FILES_NOT_TO_COPY)) continue;
            if (file2.isDirectory() && file2.canExecute()) {
                sCP.startFolder(file2.getName());
                this.recursiveSCP(file2, sCP);
                sCP.endFolder();
                continue;
            }
            if (!file2.isFile() || !file2.canRead()) continue;
            sCP.sendFile(file2);
        }
    }

    @Override
    public boolean burnBootloader() throws RunnerException {
        throw new RunnerException("Can't burn bootloader via SSH");
    }
}

