/*
 * Decompiled with CFR 0.152.
 */
package processing.app.debug;

import cc.arduino.packages.BoardPort;
import cc.arduino.packages.Uploader;
import cc.arduino.packages.UploaderFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import processing.app.BaseNoGui;
import processing.app.I18n;
import processing.app.PreferencesData;
import processing.app.SketchCode;
import processing.app.SketchData;
import processing.app.debug.MessageConsumer;
import processing.app.debug.MessageSiphon;
import processing.app.debug.RunnerException;
import processing.app.debug.Sizer;
import processing.app.debug.TargetPlatform;
import processing.app.helpers.FileUtils;
import processing.app.helpers.PreferencesMap;
import processing.app.helpers.PreferencesMapException;
import processing.app.helpers.ProcessUtils;
import processing.app.helpers.StringReplacer;
import processing.app.helpers.filefilters.OnlyDirs;
import processing.app.legacy.PApplet;
import processing.app.packages.Library;
import processing.app.packages.LibraryList;
import processing.app.preproc.PdePreprocessor;

public class Compiler
implements MessageConsumer {
    public static final String BUILD_PREFS_FILE = "buildprefs.txt";
    private SketchData sketch;
    private PreferencesMap prefs;
    private boolean verbose;
    private List<File> objectFiles;
    private boolean sketchIsCompiled;
    private RunnerException exception;
    private ProgressListener progressListener;
    private LibraryList importedLibraries;

    public static String build(SketchData sketchData, String string, File file, ProgressListener progressListener, boolean bl) throws RunnerException, PreferencesMapException {
        if (SketchData.checkSketchFile(sketchData.getPrimaryFile()) == null) {
            BaseNoGui.showError(I18n._("Bad file selected"), I18n._("Bad sketch primary file or bad sketch directory structure"), null);
        }
        String string2 = sketchData.getName() + ".cpp";
        Compiler compiler = new Compiler(sketchData, string, string2);
        File file2 = new File(string, BUILD_PREFS_FILE);
        String string3 = compiler.buildPrefsString();
        boolean bl2 = compiler.buildPreferencesChanged(file2, string3);
        compiler.cleanup(bl2, file);
        if (bl2) {
            try {
                PrintWriter printWriter = new PrintWriter(file2);
                printWriter.print(string3);
                printWriter.close();
            }
            catch (IOException iOException) {
                System.err.println(I18n._("Could not write build preferences file"));
            }
        }
        compiler.setProgressListener(progressListener);
        if (compiler.compile(bl)) {
            compiler.size(compiler.getBuildPreferences());
            return string2;
        }
        return null;
    }

    public static Uploader getUploaderByPreferences(boolean bl) {
        TargetPlatform targetPlatform = BaseNoGui.getTargetPlatform();
        String string = PreferencesData.get("board");
        if (bl) {
            return new UploaderFactory().newUploader(targetPlatform.getBoards().get(string), null, bl);
        }
        BoardPort boardPort = BaseNoGui.getDiscoveryManager().find(PreferencesData.get("serial.port"));
        return new UploaderFactory().newUploader(targetPlatform.getBoards().get(string), boardPort, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean upload(SketchData sketchData, Uploader uploader, String string, String string2, boolean bl, boolean bl2, List<String> list) throws Exception {
        if (uploader == null) {
            uploader = Compiler.getUploaderByPreferences(bl2);
        }
        boolean bl3 = false;
        if (uploader.requiresAuthorization() && !PreferencesData.has(uploader.getAuthorizationKey())) {
            BaseNoGui.showError(I18n._("Authorization required"), I18n._("No athorization data found"), null);
        }
        boolean bl4 = false;
        if (list == null) {
            list = new LinkedList<String>();
            bl4 = true;
        }
        try {
            bl3 = uploader.uploadUsingPreferences(sketchData.getFolder(), string, string2, bl, list);
        }
        finally {
            if (uploader.requiresAuthorization() && !bl3) {
                PreferencesData.remove(uploader.getAuthorizationKey());
            }
        }
        if (bl4) {
            for (String string3 : list) {
                System.out.print(I18n._("Warning"));
                System.out.print(": ");
                System.out.println(string3);
            }
        }
        return bl3;
    }

    public Compiler(SketchData sketchData, String string, String string2) throws RunnerException {
        this.sketch = sketchData;
        this.prefs = this.createBuildPreferences(string, string2);
        this.progressListener = new ProgressListener(){

            @Override
            public void progress(int n) {
            }
        };
    }

    protected boolean buildPreferencesChanged(File file, String string) {
        String string2;
        if (!file.exists()) {
            return true;
        }
        try {
            string2 = FileUtils.readFileToString(file);
        }
        catch (IOException iOException) {
            System.err.println(I18n._("Could not read prevous build preferences file, rebuilding all"));
            return true;
        }
        if (!string2.equals(string)) {
            System.out.println(I18n._("Build options changed, rebuilding all"));
            return true;
        }
        return false;
    }

    protected String buildPrefsString() {
        PreferencesMap preferencesMap = this.getBuildPreferences();
        String string = "";
        TreeSet treeSet = new TreeSet(preferencesMap.keySet());
        for (String string2 : treeSet) {
            if (!string2.startsWith("build.") && !string2.startsWith("compiler.") && !string2.startsWith("recipes.")) continue;
            string = string + string2 + " = " + (String)preferencesMap.get(string2) + "\n";
        }
        return string;
    }

    protected void setProgressListener(ProgressListener progressListener) {
        this.progressListener = progressListener == null ? new ProgressListener(){

            @Override
            public void progress(int n) {
            }
        } : progressListener;
    }

    protected void cleanup(boolean bl, File file) {
        System.gc();
        if (bl) {
            BaseNoGui.removeDescendants(file);
        } else if (file.exists()) {
            String[] stringArray;
            for (String string : stringArray = file.list()) {
                File file2;
                if (!string.endsWith(".c") && !string.endsWith(".cpp") && !string.endsWith(".s") || (file2 = new File(file, string)).delete()) continue;
                System.err.println("Could not delete " + file2);
            }
        }
    }

    protected void size(PreferencesMap preferencesMap) throws RunnerException {
        long[] lArray;
        String string = (String)preferencesMap.get("upload.maximum_size");
        String string2 = (String)preferencesMap.get("upload.maximum_data_size");
        if (string == null) {
            return;
        }
        long l = Integer.parseInt(string);
        long l2 = -1L;
        if (string2 != null) {
            l2 = Integer.parseInt(string2);
        }
        Sizer sizer = new Sizer(preferencesMap);
        try {
            lArray = sizer.computeSize();
        }
        catch (RunnerException runnerException) {
            System.err.println(I18n.format(I18n._("Couldn't determine program size: {0}"), runnerException.getMessage()));
            return;
        }
        long l3 = lArray[0];
        long l4 = lArray[1];
        System.out.println();
        System.out.println(I18n.format(I18n._("Sketch uses {0} bytes ({2}%%) of program storage space. Maximum is {1} bytes."), l3, l, l3 * 100L / l));
        if (l4 >= 0L) {
            if (l2 > 0L) {
                System.out.println(I18n.format(I18n._("Global variables use {0} bytes ({2}%%) of dynamic memory, leaving {3} bytes for local variables. Maximum is {1} bytes."), l4, l2, l4 * 100L / l2, l2 - l4));
            } else {
                System.out.println(I18n.format(I18n._("Global variables use {0} bytes of dynamic memory."), l4));
            }
        }
        if (l3 > l) {
            throw new RunnerException(I18n._("Sketch too big; see http://www.arduino.cc/en/Guide/Troubleshooting#size for tips on reducing it."));
        }
        if (l2 > 0L && l4 > l2) {
            throw new RunnerException(I18n._("Not enough memory; see http://www.arduino.cc/en/Guide/Troubleshooting#size for tips on reducing your footprint."));
        }
        int n = Integer.parseInt((String)preferencesMap.get("build.warn_data_percentage"));
        if (l2 > 0L && l4 > l2 * (long)n / 100L) {
            System.err.println(I18n._("Low memory available, stability problems may occur."));
        }
    }

    public boolean compile(boolean bl) throws RunnerException, PreferencesMapException {
        String[] stringArray;
        this.preprocess((String)this.prefs.get("build.path"));
        this.verbose = bl || PreferencesData.getBoolean("build.verbose");
        this.sketchIsCompiled = false;
        this.objectFiles = new ArrayList<File>();
        String string = (String)this.prefs.get("compiler.pre_install.cmd");
        if (string != null && string.length() != 0) {
            stringArray = new String[]{BaseNoGui.getHardwarePath() + File.separator + string};
            this.execAsynchronously(stringArray);
        }
        this.progressListener.progress(20);
        stringArray = new ArrayList();
        stringArray.add(this.prefs.getFile("build.core.path"));
        if (this.prefs.getFile("build.variant.path") != null) {
            stringArray.add(this.prefs.getFile("build.variant.path"));
        }
        for (String[] stringArray2 : this.importedLibraries) {
            if (this.verbose) {
                System.out.println(I18n.format(I18n._("Using library {0} in folder: {1} {2}"), stringArray2.getName(), stringArray2.getFolder(), stringArray2.isLegacy() ? "(legacy)" : ""));
            }
            stringArray.add(stringArray2.getSrcFolder());
        }
        if (this.verbose) {
            System.out.println();
        }
        ArrayList arrayList = new ArrayList();
        arrayList.add(BaseNoGui.getTargetPlatform().getId());
        if (this.prefs.containsKey("architecture.override_check")) {
            String[] stringArray2;
            stringArray2 = ((String)this.prefs.get("architecture.override_check")).split(",");
            arrayList.addAll(Arrays.asList(stringArray2));
        }
        for (Library library : this.importedLibraries) {
            if (library.supportsArchitecture(arrayList)) continue;
            System.err.println(I18n.format(I18n._("WARNING: library {0} claims to run on {1} architecture(s) and may be incompatible with your current board which runs on {2} architecture(s)."), library.getName(), library.getArchitectures(), arrayList));
            System.err.println();
        }
        this.progressListener.progress(30);
        this.compileSketch((List<File>)stringArray);
        this.sketchIsCompiled = true;
        this.progressListener.progress(40);
        this.compileLibraries((List<File>)stringArray);
        this.progressListener.progress(50);
        this.compileCore();
        this.progressListener.progress(60);
        this.compileLink();
        this.progressListener.progress(70);
        this.runRecipe("recipe.objcopy.eep.pattern");
        this.progressListener.progress(80);
        this.runRecipe("recipe.objcopy.hex.pattern");
        this.progressListener.progress(90);
        return true;
    }

    private PreferencesMap createBuildPreferences(String string, String string2) throws RunnerException {
        Object object;
        Object object2;
        if (BaseNoGui.getBoardPreferences() == null) {
            RunnerException runnerException = new RunnerException(I18n._("No board selected; please choose a board from the Tools > Board menu."));
            runnerException.hideStackTrace();
            throw runnerException;
        }
        TargetPlatform targetPlatform = BaseNoGui.getTargetPlatform();
        TargetPlatform targetPlatform2 = null;
        PreferencesMap preferencesMap = BaseNoGui.getBoardPreferences();
        String string3 = (String)preferencesMap.get("build.core");
        if (string3.contains(":")) {
            object2 = string3.split(":");
            string3 = object2[1];
            targetPlatform2 = BaseNoGui.getTargetPlatform((String)object2[0], targetPlatform.getId());
            if (targetPlatform2 == null) {
                RunnerException runnerException = new RunnerException(I18n.format(I18n._("Selected board depends on '{0}' core (not installed)."), object2[0]));
                runnerException.hideStackTrace();
                throw runnerException;
            }
        }
        object2 = new PreferencesMap();
        ((HashMap)object2).putAll(PreferencesData.getMap());
        if (targetPlatform2 != null) {
            ((HashMap)object2).putAll(targetPlatform2.getPreferences());
        }
        ((HashMap)object2).putAll(targetPlatform.getPreferences());
        ((HashMap)object2).putAll(BaseNoGui.getBoardPreferences());
        Object object3 = ((LinkedHashMap)object2).keySet().iterator();
        while (object3.hasNext()) {
            object = (String)object3.next();
            if (((LinkedHashMap)object2).get(object) != null) continue;
            ((HashMap)object2).put(object, "");
        }
        ((HashMap)object2).put("build.path", string);
        ((HashMap)object2).put("build.project_name", string2);
        ((HashMap)object2).put("build.arch", targetPlatform.getId().toUpperCase());
        if (!((HashMap)object2).containsKey("compiler.path")) {
            System.err.println(I18n._("Third-party platform.txt does not define compiler.path. Please report this to the third-party hardware maintainer."));
            ((HashMap)object2).put("compiler.path", BaseNoGui.getAvrBasePath());
        }
        if ((object3 = targetPlatform2) == null) {
            object3 = targetPlatform;
        }
        object = new File(((TargetPlatform)object3).getFolder(), "cores");
        object = new File((File)object, string3);
        ((HashMap)object2).put("build.core", string3);
        ((HashMap)object2).put("build.core.path", ((File)object).getAbsolutePath());
        File file = ((TargetPlatform)object3).getFolder();
        file = new File(file, "system");
        ((HashMap)object2).put("build.system.path", file.getAbsolutePath());
        String string4 = (String)((LinkedHashMap)object2).get("build.variant");
        if (string4 != null) {
            Object object4;
            TargetPlatform targetPlatform3;
            if (!string4.contains(":")) {
                targetPlatform3 = targetPlatform;
            } else {
                object4 = string4.split(":", 2);
                targetPlatform3 = BaseNoGui.getTargetPlatform(object4[0], targetPlatform.getId());
                string4 = object4[1];
            }
            object4 = new File(targetPlatform3.getFolder(), "variants");
            object4 = new File((File)object4, string4);
            ((HashMap)object2).put("build.variant.path", ((File)object4).getAbsolutePath());
        } else {
            ((HashMap)object2).put("build.variant.path", "");
        }
        return object2;
    }

    private List<File> compileFiles(File file, File file2, boolean bl, List<File> list) throws RunnerException, PreferencesMapException {
        String[] stringArray;
        Object object;
        File file3;
        List<File> list2 = Compiler.findFilesInFolder(file2, "S", bl);
        List<File> list3 = Compiler.findFilesInFolder(file2, "c", bl);
        List<File> list4 = Compiler.findFilesInFolder(file2, "cpp", bl);
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file4 : list2) {
            file3 = new File(file, file4.getName() + ".o");
            arrayList.add(file3);
            object = this.getCommandCompilerByRecipe(list, file4, file3, "recipe.S.o.pattern");
            this.execAsynchronously((String[])object);
        }
        for (File file4 : list3) {
            file3 = new File(file, file4.getName() + ".o");
            object = new File(file, file4.getName() + ".d");
            arrayList.add(file3);
            if (this.isAlreadyCompiled(file4, file3, (File)object, this.prefs)) continue;
            stringArray = this.getCommandCompilerByRecipe(list, file4, file3, "recipe.c.o.pattern");
            this.execAsynchronously(stringArray);
        }
        for (File file4 : list4) {
            file3 = new File(file, file4.getName() + ".o");
            object = new File(file, file4.getName() + ".d");
            arrayList.add(file3);
            if (this.isAlreadyCompiled(file4, file3, (File)object, this.prefs)) continue;
            stringArray = this.getCommandCompilerByRecipe(list, file4, file3, "recipe.cpp.o.pattern");
            this.execAsynchronously(stringArray);
        }
        return arrayList;
    }

    protected static String unescapeDepFile(String string) {
        string = string.replaceAll("\\\\([ #\\\\])", "$1");
        string = string.replace("$$", "$");
        return string;
    }

    private boolean isAlreadyCompiled(File file, File file2, File file3, Map<String, String> map) {
        boolean bl = true;
        try {
            String string;
            long l;
            if (!file2.exists()) {
                return false;
            }
            if (!file3.exists()) {
                return false;
            }
            long l2 = file.lastModified();
            if (l2 >= (l = file2.lastModified())) {
                return false;
            }
            if (l2 >= file3.lastModified()) {
                return false;
            }
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file3.getPath()));
            boolean bl2 = true;
            while ((string = bufferedReader.readLine()) != null) {
                Object object;
                if (string.endsWith("\\")) {
                    string = string.substring(0, string.length() - 1);
                }
                string = string.trim();
                if ((string = Compiler.unescapeDepFile(string)).length() == 0) continue;
                if (bl2) {
                    if (string.endsWith(":")) {
                        File file4;
                        String string2;
                        string = string.substring(0, string.length() - 1);
                        object = file2.getCanonicalPath();
                        if (((String)object).compareTo(string2 = (file4 = new File(string)).getCanonicalPath()) == 0) {
                            bl2 = false;
                            continue;
                        }
                        bl = false;
                        break;
                    }
                    bl = false;
                    break;
                }
                object = new File(string);
                if (!((File)object).exists()) {
                    bl = false;
                    break;
                }
                if (((File)object).lastModified() < l) continue;
                bl = false;
                break;
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            return false;
        }
        if (bl && this.verbose) {
            System.out.println(I18n.format(I18n._("Using previously compiled file: {0}"), file2.getPath()));
        }
        return bl;
    }

    private void execAsynchronously(String[] stringArray) throws RunnerException {
        Process process;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            if ((string = string.trim()).length() == 0) continue;
            arrayList.add(string);
        }
        stringArray = arrayList.toArray(new String[arrayList.size()]);
        if (stringArray.length == 0) {
            return;
        }
        int n = 0;
        if (this.verbose) {
            for (String string : stringArray) {
                System.out.print(string + " ");
            }
            System.out.println();
        }
        try {
            process = ProcessUtils.exec(stringArray);
        }
        catch (IOException iOException) {
            RunnerException runnerException = new RunnerException(iOException.getMessage());
            runnerException.hideStackTrace();
            throw runnerException;
        }
        MessageSiphon messageSiphon = new MessageSiphon(process.getInputStream(), this);
        MessageSiphon messageSiphon2 = new MessageSiphon(process.getErrorStream(), this);
        boolean bl = true;
        while (bl) {
            try {
                messageSiphon.join();
                messageSiphon2.join();
                n = process.waitFor();
                bl = false;
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (n > 1) {
            System.err.println(I18n.format(I18n._("{0} returned {1}"), stringArray[0], n));
        }
        if (n != 0) {
            RunnerException runnerException = new RunnerException(I18n._("Error compiling."));
            runnerException.hideStackTrace();
            throw runnerException;
        }
    }

    @Override
    public void message(String string) {
        String string2;
        String[] stringArray;
        String string3;
        if (!this.verbose) {
            int n;
            string3 = (String)this.prefs.get("build.path");
            while ((n = string.indexOf(string3 + File.separator)) != -1) {
                string = string.substring(0, n) + string.substring(n + (string3 + File.separator).length());
            }
        }
        if ((stringArray = PApplet.match(string, string3 = "([\\w\\d_]+.\\w+):(\\d+):\\s*error:\\s*(.*)\\s*")) != null) {
            string2 = stringArray[3];
            String string4 = "";
            if (stringArray[3].trim().equals("SPI.h: No such file or directory")) {
                string2 = I18n._("Please import the SPI library from the Sketch > Import Library menu.");
                string4 = I18n._("\nAs of Arduino 0019, the Ethernet library depends on the SPI library.\nYou appear to be using it or another library that depends on the SPI library.\n\n");
            }
            if (stringArray[3].trim().equals("'BYTE' was not declared in this scope")) {
                string2 = I18n._("The 'BYTE' keyword is no longer supported.");
                string4 = I18n._("\nAs of Arduino 1.0, the 'BYTE' keyword is no longer supported.\nPlease use Serial.write() instead.\n\n");
            }
            if (stringArray[3].trim().equals("no matching function for call to 'Server::Server(int)'")) {
                string2 = I18n._("The Server class has been renamed EthernetServer.");
                string4 = I18n._("\nAs of Arduino 1.0, the Server class in the Ethernet library has been renamed to EthernetServer.\n\n");
            }
            if (stringArray[3].trim().equals("no matching function for call to 'Client::Client(byte [4], int)'")) {
                string2 = I18n._("The Client class has been renamed EthernetClient.");
                string4 = I18n._("\nAs of Arduino 1.0, the Client class in the Ethernet library has been renamed to EthernetClient.\n\n");
            }
            if (stringArray[3].trim().equals("'Udp' was not declared in this scope")) {
                string2 = I18n._("The Udp class has been renamed EthernetUdp.");
                string4 = I18n._("\nAs of Arduino 1.0, the Udp class in the Ethernet library has been renamed to EthernetUdp.\n\n");
            }
            if (stringArray[3].trim().equals("'class TwoWire' has no member named 'send'")) {
                string2 = I18n._("Wire.send() has been renamed Wire.write().");
                string4 = I18n._("\nAs of Arduino 1.0, the Wire.send() function was renamed to Wire.write() for consistency with other libraries.\n\n");
            }
            if (stringArray[3].trim().equals("'class TwoWire' has no member named 'receive'")) {
                string2 = I18n._("Wire.receive() has been renamed Wire.read().");
                string4 = I18n._("\nAs of Arduino 1.0, the Wire.receive() function was renamed to Wire.read() for consistency with other libraries.\n\n");
            }
            if (stringArray[3].trim().equals("'Mouse' was not declared in this scope")) {
                string2 = I18n._("'Mouse' only supported on the Arduino Leonardo");
            }
            if (stringArray[3].trim().equals("'Keyboard' was not declared in this scope")) {
                string2 = I18n._("'Keyboard' only supported on the Arduino Leonardo");
            }
            RunnerException runnerException = null;
            if (!this.sketchIsCompiled) {
                runnerException = this.placeException(string2, stringArray[1], PApplet.parseInt(stringArray[2]) - 1);
            }
            if (runnerException != null && !this.verbose) {
                SketchCode sketchCode = this.sketch.getCode(runnerException.getCodeIndex());
                String string5 = sketchCode.isExtension("ino") || sketchCode.isExtension("pde") ? sketchCode.getPrettyName() : sketchCode.getFileName();
                int n = runnerException.getCodeLine() + 1;
                string = string5 + ":" + n + ": error: " + stringArray[3] + string4;
            }
            if (this.exception == null && runnerException != null) {
                this.exception = runnerException;
                this.exception.hideStackTrace();
            }
        }
        if (string.contains("undefined reference to `SPIClass::begin()'") && string.contains("libraries/Robot_Control")) {
            string2 = I18n._("Please import the SPI library from the Sketch > Import Library menu.");
            this.exception = new RunnerException(string2);
        }
        if (string.contains("undefined reference to `Wire'") && string.contains("libraries/Robot_Control")) {
            string2 = I18n._("Please import the Wire library from the Sketch > Import Library menu.");
            this.exception = new RunnerException(string2);
        }
        System.err.print(string);
    }

    private String[] getCommandCompilerByRecipe(List<File> list, File file, File file2, String string) throws PreferencesMapException, RunnerException {
        String string2 = Compiler.prepareIncludes(list);
        PreferencesMap preferencesMap = new PreferencesMap(this.prefs);
        preferencesMap.put("ide_version", "10600");
        preferencesMap.put("includes", string2);
        preferencesMap.put("source_file", file.getAbsolutePath());
        preferencesMap.put("object_file", file2.getAbsolutePath());
        String string3 = this.prefs.getOrExcept(string);
        try {
            return StringReplacer.formatAndSplit(string3, preferencesMap, true);
        }
        catch (Exception exception) {
            throw new RunnerException(exception);
        }
    }

    private void createFolder(File file) throws RunnerException {
        if (file.isDirectory()) {
            return;
        }
        if (!file.mkdir()) {
            throw new RunnerException("Couldn't create: " + file);
        }
    }

    public static List<File> findFilesInFolder(File file, String string, boolean bl) {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (FileUtils.isSCCSOrHiddenFile(file)) {
            return arrayList;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return arrayList;
        }
        for (File file2 : fileArray) {
            if (FileUtils.isSCCSOrHiddenFile(file2)) continue;
            if (file2.getName().endsWith("." + string)) {
                arrayList.add(file2);
            }
            if (!bl || !file2.isDirectory()) continue;
            arrayList.addAll(Compiler.findFilesInFolder(file2, string, true));
        }
        return arrayList;
    }

    void compileSketch(List<File> list) throws RunnerException, PreferencesMapException {
        File file = this.prefs.getFile("build.path");
        this.objectFiles.addAll(this.compileFiles(file, file, false, list));
    }

    void compileLibraries(List<File> list) throws RunnerException, PreferencesMapException {
        for (Library library : this.importedLibraries) {
            this.compileLibrary(library, list);
        }
    }

    private void compileLibrary(Library library, List<File> list) throws RunnerException, PreferencesMapException {
        File file = library.getSrcFolder();
        File file2 = this.prefs.getFile("build.path", library.getName());
        if (library.useRecursion()) {
            this.recursiveCompileFilesInFolder(file2, file, list);
        } else {
            File file3 = new File(file, "utility");
            File file4 = new File(file2, "utility");
            list.add(file3);
            this.compileFilesInFolder(file2, file, list);
            this.compileFilesInFolder(file4, file3, list);
            list.remove(file3);
        }
    }

    private void recursiveCompileFilesInFolder(File file, File file2, List<File> list) throws RunnerException, PreferencesMapException {
        this.compileFilesInFolder(file, file2, list);
        for (File file3 : file2.listFiles(new OnlyDirs())) {
            File file4 = new File(file, file3.getName());
            this.recursiveCompileFilesInFolder(file4, file3, list);
        }
    }

    private void compileFilesInFolder(File file, File file2, List<File> list) throws RunnerException, PreferencesMapException {
        this.createFolder(file);
        List<File> list2 = this.compileFiles(file, file2, false, list);
        this.objectFiles.addAll(list2);
    }

    void compileCore() throws RunnerException, PreferencesMapException {
        File file = this.prefs.getFile("build.core.path");
        File file2 = this.prefs.getFile("build.variant.path");
        File file3 = this.prefs.getFile("build.path");
        ArrayList<File> arrayList = new ArrayList<File>();
        arrayList.add(file);
        if (file2 != null) {
            arrayList.add(file2);
        }
        if (file2 != null) {
            this.objectFiles.addAll(this.compileFiles(file3, file2, true, arrayList));
        }
        File file4 = new File(file3, "core.a");
        List<File> list = this.compileFiles(file3, file, true, arrayList);
        if (file4.exists()) {
            boolean bl = false;
            for (File file5 : list) {
                if (file5.lastModified() <= file4.lastModified()) continue;
                bl = true;
                break;
            }
            if (!bl) {
                if (this.verbose) {
                    System.out.println(I18n.format(I18n._("Using previously compiled file: {0}"), file4.getPath()));
                }
                return;
            }
        }
        file4.delete();
        try {
            for (File file6 : list) {
                String[] stringArray;
                PreferencesMap preferencesMap = new PreferencesMap(this.prefs);
                preferencesMap.put("ide_version", "10600");
                preferencesMap.put("archive_file", file4.getName());
                preferencesMap.put("object_file", file6.getAbsolutePath());
                String string = this.prefs.getOrExcept("recipe.ar.pattern");
                try {
                    stringArray = StringReplacer.formatAndSplit(string, preferencesMap, true);
                }
                catch (Exception exception) {
                    throw new RunnerException(exception);
                }
                this.execAsynchronously(stringArray);
            }
        }
        catch (RunnerException runnerException) {
            file4.delete();
            throw runnerException;
        }
    }

    void compileLink() throws RunnerException, PreferencesMapException {
        String[] stringArray;
        String string = "";
        if (((String)this.prefs.get("build.mcu")).equals("atmega2560")) {
            string = ",--relax";
        }
        String string2 = "";
        for (File object2 : this.objectFiles) {
            string2 = string2 + " \"" + object2.getAbsolutePath() + '\"';
        }
        string2 = string2.substring(1);
        PreferencesMap preferencesMap = new PreferencesMap(this.prefs);
        String string3 = (String)preferencesMap.get("compiler.c.elf.flags") + string;
        preferencesMap.put("compiler.c.elf.flags", string3);
        preferencesMap.put("archive_file", "core.a");
        preferencesMap.put("object_files", string2);
        preferencesMap.put("ide_version", "10600");
        String string4 = this.prefs.getOrExcept("recipe.c.combine.pattern");
        try {
            stringArray = StringReplacer.formatAndSplit(string4, preferencesMap, true);
        }
        catch (Exception exception) {
            throw new RunnerException(exception);
        }
        this.execAsynchronously(stringArray);
    }

    void runRecipe(String string) throws RunnerException, PreferencesMapException {
        String[] stringArray;
        PreferencesMap preferencesMap = new PreferencesMap(this.prefs);
        preferencesMap.put("ide_version", "10600");
        String string2 = this.prefs.getOrExcept(string);
        try {
            stringArray = StringReplacer.formatAndSplit(string2, preferencesMap, true);
        }
        catch (Exception exception) {
            throw new RunnerException(exception);
        }
        this.execAsynchronously(stringArray);
    }

    private static String prepareIncludes(List<File> list) {
        String string = "";
        for (File file : list) {
            string = string + " \"-I" + file.getAbsolutePath() + '\"';
        }
        return string.substring(1);
    }

    public PreferencesMap getBuildPreferences() {
        return this.prefs;
    }

    public void preprocess(String string) throws RunnerException {
        this.preprocess(string, new PdePreprocessor());
    }

    /*
     * WARNING - void declaration
     */
    public void preprocess(String string, PdePreprocessor pdePreprocessor) throws RunnerException {
        void var8_25;
        SketchCode[] sketchCodeArray;
        void string2;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        SketchCode[] sketchCodeArray2 = this.sketch.getCodes();
        int n2 = sketchCodeArray2.length;
        boolean bl = false;
        while (string2 < n2) {
            SketchCode sketchCode = sketchCodeArray2[string2];
            if (sketchCode.isExtension("ino") || sketchCode.isExtension("pde")) {
                sketchCode.setPreprocOffset(n);
                stringBuffer.append("#line 1 \"" + sketchCode.getFileName() + "\"\n");
                stringBuffer.append(sketchCode.getProgram());
                stringBuffer.append('\n');
                n += sketchCode.getLineCount();
            }
            ++string2;
        }
        int n22 = 0;
        try {
            n22 = pdePreprocessor.writePrefix(stringBuffer.toString());
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            String object = I18n._("Build folder disappeared or could not be written");
            throw new RunnerException(object);
        }
        try {
            sketchCodeArray = new File(string, this.sketch.getName() + ".cpp");
            FileOutputStream string3 = new FileOutputStream((File)sketchCodeArray);
            pdePreprocessor.write(string3);
            string3.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            String string3 = I18n._("Build folder disappeared or could not be written");
            throw new RunnerException(string3);
        }
        catch (RunnerException runnerException) {
            throw runnerException;
        }
        catch (Exception exception) {
            System.err.println(I18n.format(I18n._("Uncaught exception type: {0}"), exception.getClass()));
            exception.printStackTrace();
            throw new RunnerException(exception.toString());
        }
        this.importedLibraries = new LibraryList();
        for (String string4 : pdePreprocessor.getExtraImports()) {
            Library library = BaseNoGui.importToLibraryTable.get(string4);
            if (library == null || this.importedLibraries.contains(library)) continue;
            this.importedLibraries.add(library);
        }
        sketchCodeArray = this.sketch.getCodes();
        int n3 = sketchCodeArray.length;
        boolean bl2 = false;
        while (var8_25 < n3) {
            SketchCode sketchCode = sketchCodeArray[var8_25];
            if (sketchCode.isExtension("c") || sketchCode.isExtension("cpp") || sketchCode.isExtension("h")) {
                String string5 = sketchCode.getFileName();
                try {
                    BaseNoGui.saveFile(sketchCode.getProgram(), new File(string, string5));
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    throw new RunnerException(I18n.format(I18n._("Problem moving {0} to the build folder"), string5));
                }
            } else if (sketchCode.isExtension("ino") || sketchCode.isExtension("pde")) {
                sketchCode.addPreprocOffset(n22);
            }
            ++var8_25;
        }
    }

    public RunnerException placeException(String string, String string2, int n) {
        for (SketchCode sketchCode : this.sketch.getCodes()) {
            if (!string2.equals(sketchCode.getFileName())) continue;
            return new RunnerException(string, this.sketch.indexOfCode(sketchCode), n);
        }
        return null;
    }

    public static interface ProgressListener {
        public void progress(int var1);
    }
}

