/*
 * Decompiled with CFR 0.152.
 */
package processing.app.debug;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import processing.app.debug.MessageConsumer;
import processing.app.debug.MessageSiphon;
import processing.app.debug.RunnerException;
import processing.app.helpers.PreferencesMap;
import processing.app.helpers.ProcessUtils;
import processing.app.helpers.StringReplacer;

public class Sizer
implements MessageConsumer {
    private long textSize;
    private long dataSize;
    private long eepromSize;
    private RunnerException exception;
    private PreferencesMap prefs;
    private String firstLine;
    private Pattern textPattern;
    private Pattern dataPattern;
    private Pattern eepromPattern;

    public Sizer(PreferencesMap preferencesMap) {
        this.prefs = preferencesMap;
        this.textPattern = Pattern.compile((String)this.prefs.get("recipe.size.regex"));
        this.dataPattern = null;
        String string = (String)this.prefs.get("recipe.size.regex.data");
        if (string != null) {
            this.dataPattern = Pattern.compile(string);
        }
        this.eepromPattern = null;
        string = (String)this.prefs.get("recipe.size.regex.eeprom");
        if (string != null) {
            this.eepromPattern = Pattern.compile(string);
        }
    }

    public long[] computeSize() throws RunnerException {
        int n = 0;
        try {
            String string = (String)this.prefs.get("recipe.size.pattern");
            String[] stringArray = StringReplacer.formatAndSplit(string, this.prefs, true);
            this.exception = null;
            this.textSize = -1L;
            this.dataSize = -1L;
            this.eepromSize = -1L;
            Process process = ProcessUtils.exec(stringArray);
            MessageSiphon messageSiphon = new MessageSiphon(process.getInputStream(), this);
            MessageSiphon messageSiphon2 = new MessageSiphon(process.getErrorStream(), this);
            boolean bl = true;
            while (bl) {
                try {
                    messageSiphon.join();
                    messageSiphon2.join();
                    n = process.waitFor();
                    bl = false;
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (Exception exception) {
            this.exception = new RunnerException(exception.toString() == null ? exception.getClass().getName() + n : exception.toString() + n);
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.textSize == -1L) {
            throw new RunnerException(this.firstLine);
        }
        return new long[]{this.textSize, this.dataSize, this.eepromSize};
    }

    @Override
    public void message(String string) {
        Matcher matcher;
        Matcher matcher2;
        if (this.firstLine == null) {
            this.firstLine = string;
        }
        if ((matcher2 = this.textPattern.matcher(string.trim())).matches()) {
            if (this.textSize < 0L) {
                this.textSize = 0L;
            }
            this.textSize += Long.parseLong(matcher2.group(1));
        }
        if (this.dataPattern != null && (matcher = this.dataPattern.matcher(string.trim())).matches()) {
            if (this.dataSize < 0L) {
                this.dataSize = 0L;
            }
            this.dataSize += Long.parseLong(matcher.group(1));
        }
        if (this.eepromPattern != null && (matcher = this.eepromPattern.matcher(string.trim())).matches()) {
            if (this.eepromSize < 0L) {
                this.eepromSize = 0L;
            }
            this.eepromSize += Long.parseLong(matcher.group(1));
        }
    }
}

