/*
 * Decompiled with CFR 0.152.
 */
package processing.app.debug;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import processing.app.I18n;
import processing.app.debug.TargetBoard;
import processing.app.debug.TargetPackage;
import processing.app.debug.TargetPlatformException;
import processing.app.helpers.PreferencesMap;

public class TargetPlatform {
    private String id;
    private File folder;
    private TargetPackage containerPackage;
    private Map<String, TargetBoard> boards = new LinkedHashMap<String, TargetBoard>();
    private TargetBoard defaultBoard;
    private Map<String, PreferencesMap> programmers = new LinkedHashMap<String, PreferencesMap>();
    private PreferencesMap preferences = new PreferencesMap();
    private PreferencesMap customMenus = new PreferencesMap();

    public TargetPlatform(String string, File file, TargetPackage targetPackage) throws TargetPlatformException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        this.id = string;
        this.folder = file;
        this.containerPackage = targetPackage;
        File file2 = new File(this.folder, "boards.txt");
        if (!file2.exists() || !file2.canRead()) {
            throw new TargetPlatformException(I18n.format(I18n._("Could not find boards.txt in {0}. Is it pre-1.5?"), this.folder.getAbsolutePath()));
        }
        try {
            object4 = new PreferencesMap(file2).firstLevelMap();
            object3 = object4.get("menu");
            if (object3 != null) {
                this.customMenus = ((PreferencesMap)object3).topLevelMap();
            }
            object4.remove("menu");
            object2 = object4.keySet();
            object = object2.iterator();
            while (object.hasNext()) {
                String string2 = object.next();
                PreferencesMap preferencesMap = object4.get(string2);
                TargetBoard targetBoard = new TargetBoard(string2, preferencesMap, this);
                this.boards.put(string2, targetBoard);
                if (this.defaultBoard != null) continue;
                this.defaultBoard = targetBoard;
            }
        }
        catch (IOException iOException) {
            throw new TargetPlatformException(I18n.format(I18n._("Error loading {0}"), file2.getAbsolutePath()), iOException);
        }
        object4 = new File(this.folder, "platform.txt");
        try {
            object3 = System.getProperty("os.name");
            if (((File)object4).exists() && ((File)object4).canRead()) {
                this.preferences.load((File)object4);
            } else if (((String)object3).indexOf("Windows") != -1) {
                object2 = new File(file, "platform.win.txt");
                if (((File)object2).exists()) {
                    this.preferences.load((File)object2);
                }
            } else if (((String)object3).indexOf("Mac") != -1) {
                object2 = new File(file, "platform.osx.txt");
                if (((File)object2).exists()) {
                    this.preferences.load((File)object2);
                }
            } else if (((String)object3).indexOf("Linux") != -1) {
                if (System.getProperty("os.arch").indexOf("amd64") != -1) {
                    object2 = new File(file, "platform.linux64.txt");
                    if (((File)object2).exists()) {
                        this.preferences.load((File)object2);
                    }
                } else {
                    object2 = new File(file, "platform.linux.txt");
                    if (((File)object2).exists()) {
                        this.preferences.load((File)object2);
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new TargetPlatformException(I18n.format(I18n._("Error loading {0}"), ((File)object4).getAbsolutePath()), iOException);
        }
        object3 = new File(this.folder, "platform.local.txt");
        try {
            if (((File)object3).exists() && ((File)object3).canRead()) {
                this.preferences.load((File)object3);
            }
        }
        catch (IOException iOException) {
            throw new TargetPlatformException(I18n.format(I18n._("Error loading {0}"), ((File)object3).getAbsolutePath()), iOException);
        }
        object2 = new File(this.folder, "programmers.txt");
        try {
            if (((File)object2).exists() && ((File)object2).canRead()) {
                object = new PreferencesMap();
                ((PreferencesMap)object).load((File)object2);
                this.programmers = ((PreferencesMap)object).firstLevelMap();
            }
        }
        catch (IOException iOException) {
            throw new TargetPlatformException(I18n.format(I18n._("Error loading {0}"), ((File)object2).getAbsolutePath()), iOException);
        }
    }

    public String getId() {
        return this.id;
    }

    public File getFolder() {
        return this.folder;
    }

    public Map<String, TargetBoard> getBoards() {
        return this.boards;
    }

    public PreferencesMap getCustomMenus() {
        return this.customMenus;
    }

    public Set<String> getCustomMenuIds() {
        return this.customMenus.keySet();
    }

    public Map<String, PreferencesMap> getProgrammers() {
        return this.programmers;
    }

    public PreferencesMap getProgrammer(String string) {
        return this.getProgrammers().get(string);
    }

    public PreferencesMap getTool(String string) {
        return this.getPreferences().subTree("tools").subTree(string);
    }

    public PreferencesMap getPreferences() {
        return this.preferences;
    }

    public TargetBoard getBoard(String string) {
        if (this.boards.containsKey(string)) {
            return this.boards.get(string);
        }
        return this.defaultBoard;
    }

    public TargetPackage getContainerPackage() {
        return this.containerPackage;
    }

    public String toString() {
        String string = "TargetPlatform: name=" + this.id + " boards={\n";
        for (String string2 : this.boards.keySet()) {
            string = string + "  " + string2 + " = " + this.boards.get(string2) + "\n";
        }
        return string + "}";
    }
}

