/*
 * Decompiled with CFR 0.152.
 */
package processing.app.macosx;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SystemProfilerParser {
    private static final String DEVICE_PATH = "device_path";
    private static final String VID = "vid";
    private static final String PID = "pid";
    private static final String SERIAL_NUMBER = "serial_number";
    private static final String DEV_TTY_USBSERIAL = "/dev/tty.usbserial-";
    private static final String DEV_CU_USBSERIAL = "/dev/cu.usbserial-";
    private static final String DEV_TTY_USBMODEM = "/dev/tty.usbmodem";
    private static final String DEV_CU_USBMODEM = "/dev/cu.usbmodem";
    private final Pattern vidRegex;
    private final Pattern serialNumberRegex = Pattern.compile("^Serial Number: (.+)$");
    private final Pattern locationRegex = Pattern.compile("^Location ID: (.+)$");
    private final Pattern pidRegex = Pattern.compile("^Product ID: (.+)$");

    public SystemProfilerParser() {
        this.vidRegex = Pattern.compile("^Vendor ID: (.+)$");
    }

    public String extractVIDAndPID(String string, String string2) throws IOException {
        String string3;
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        String string4 = string2.startsWith(DEV_TTY_USBSERIAL) ? DEV_TTY_USBSERIAL : (string2.startsWith(DEV_CU_USBSERIAL) ? DEV_CU_USBSERIAL : (string2.startsWith(DEV_TTY_USBMODEM) ? DEV_TTY_USBMODEM : DEV_CU_USBMODEM));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while ((string3 = bufferedReader.readLine()) != null) {
            String string5;
            string3 = string3.trim();
            Matcher matcher = this.serialNumberRegex.matcher(string3 = string3.replaceAll("\\s+", " "));
            if (matcher.matches()) {
                hashMap.put(SERIAL_NUMBER, matcher.group(1));
                if (!string2.startsWith(DEV_TTY_USBSERIAL) && !string2.startsWith(DEV_CU_USBSERIAL)) continue;
                string5 = string4 + matcher.group(1);
                hashMap.put(DEVICE_PATH, string5);
                continue;
            }
            if ((string2.startsWith(DEV_TTY_USBMODEM) || string2.startsWith(DEV_CU_USBMODEM)) && (matcher = this.locationRegex.matcher(string3)).matches()) {
                string5 = matcher.group(1).substring(2, 6).replaceAll("0", "");
                String string6 = string4 + string5 + "1";
                hashMap.put(DEVICE_PATH, string6);
                continue;
            }
            matcher = this.pidRegex.matcher(string3);
            if (matcher.matches()) {
                string5 = matcher.group(1);
                if (string5.indexOf(" ") > 0) {
                    string5 = string5.substring(0, string5.indexOf(" "));
                }
                hashMap.put(PID, string5);
                continue;
            }
            matcher = this.vidRegex.matcher(string3);
            if (matcher.matches()) {
                string5 = matcher.group(1);
                if (string5.indexOf(" ") > 0) {
                    string5 = string5.substring(0, string5.indexOf(" "));
                }
                hashMap.put(VID, string5);
                continue;
            }
            if (!string3.equals("")) continue;
            if (hashMap.containsKey(DEVICE_PATH) && ((String)hashMap.get(DEVICE_PATH)).equals(string2)) {
                return ((String)hashMap.get(VID) + "_" + (String)hashMap.get(PID)).toUpperCase();
            }
            hashMap = new HashMap();
        }
        return null;
    }
}

