/*
 * Decompiled with CFR 0.152.
 */
package processing.app.packages;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import processing.app.helpers.FileUtils;
import processing.app.helpers.PreferencesMap;

public class Library {
    private String name;
    private String version;
    private String author;
    private String maintainer;
    private String sentence;
    private String paragraph;
    private String url;
    private String category;
    private String license;
    private List<String> architectures;
    private File folder;
    private boolean isLegacy;
    private LibraryLayout layout;
    private static final List<String> MANDATORY_PROPERTIES = Arrays.asList("name", "version", "author", "maintainer", "sentence", "paragraph", "url");
    private static final List<String> CATEGORIES = Arrays.asList("Display", "Communication", "Signal Input/Output", "Sensors", "Device Control", "Timing", "Data Storage", "Data Processing", "Other", "Uncategorized");
    public static final Comparator<Library> CASE_INSENSITIVE_ORDER = new Comparator<Library>(){

        @Override
        public int compare(Library library, Library library2) {
            return library.getName().compareToIgnoreCase(library2.getName());
        }
    };

    public static Library create(File file) throws IOException {
        File file2 = new File(file, "library.properties");
        if (!file2.exists() || !file2.isFile()) {
            return Library.createLegacyLibrary(file);
        }
        return Library.createLibrary(file);
    }

    private static Library createLibrary(File file) throws IOException {
        String string;
        Object object;
        Object object2;
        File file2;
        File file3 = new File(file, "library.properties");
        PreferencesMap preferencesMap = new PreferencesMap();
        preferencesMap.load(file3);
        if (!preferencesMap.containsKey("maintainer") && preferencesMap.containsKey("email")) {
            preferencesMap.put("maintainer", preferencesMap.get("email"));
        }
        if ((file2 = new File(file, "arch")).isDirectory()) {
            throw new IOException("'arch' folder is no longer supported! See http://goo.gl/gfFJzU for more information");
        }
        for (String object32 : MANDATORY_PROPERTIES) {
            if (preferencesMap.containsKey(object32)) continue;
            throw new IOException("Missing '" + object32 + "' from library");
        }
        File file4 = new File(file, "src");
        if (file4.exists() && file4.isDirectory()) {
            object2 = LibraryLayout.RECURSIVE;
            object = new File(file, "utility");
            if (((File)object).exists() && ((File)object).isDirectory()) {
                throw new IOException("Library can't use both 'src' and 'utility' folders.");
            }
        } else {
            object2 = LibraryLayout.FLAT;
        }
        for (File file5 : file.listFiles()) {
            if (!file5.isDirectory() || !FileUtils.isSCCSOrHiddenFile(file5)) continue;
            System.out.println("WARNING: Spurious " + file5.getName() + " folder in '" + (String)preferencesMap.get("name") + "' library");
        }
        object = (String)preferencesMap.get("architectures");
        if (object == null) {
            object = "*";
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : ((String)object).split(",")) {
            arrayList.add(string2.trim());
        }
        Object object3 = (String)preferencesMap.get("category");
        if (object3 == null) {
            object3 = "Uncategorized";
        }
        if (!CATEGORIES.contains(object3)) {
            object3 = "Uncategorized";
            System.out.println("WARNING: Category '" + (String)object3 + "' in library " + (String)preferencesMap.get("name") + " is not valid. Setting to 'Uncategorized'");
        }
        if ((string = (String)preferencesMap.get("license")) == null) {
            string = "Unspecified";
        }
        Library library = new Library();
        library.folder = file;
        library.name = ((String)preferencesMap.get("name")).trim();
        library.version = ((String)preferencesMap.get("version")).trim();
        library.author = ((String)preferencesMap.get("author")).trim();
        library.maintainer = ((String)preferencesMap.get("maintainer")).trim();
        library.sentence = ((String)preferencesMap.get("sentence")).trim();
        library.paragraph = ((String)preferencesMap.get("paragraph")).trim();
        library.url = ((String)preferencesMap.get("url")).trim();
        library.category = ((String)object3).trim();
        library.license = string.trim();
        library.architectures = arrayList;
        library.isLegacy = false;
        library.layout = object2;
        return library;
    }

    private static Library createLegacyLibrary(File file) {
        Library library = new Library();
        library.folder = file;
        library.layout = LibraryLayout.FLAT;
        library.name = file.getName();
        library.architectures = Arrays.asList("*");
        library.isLegacy = true;
        return library;
    }

    public boolean supportsArchitecture(String string) {
        return this.architectures.contains(string) || this.architectures.contains("*");
    }

    public boolean supportsArchitecture(List<String> list) {
        if (list.contains("*")) {
            return true;
        }
        for (String string : list) {
            if (!this.supportsArchitecture(string)) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public File getFolder() {
        return this.folder;
    }

    public List<String> getArchitectures() {
        return this.architectures;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getParagraph() {
        return this.paragraph;
    }

    public String getSentence() {
        return this.sentence;
    }

    public String getUrl() {
        return this.url;
    }

    public String getCategory() {
        return this.category;
    }

    public String getLicense() {
        return this.license;
    }

    public static List<String> getCategories() {
        return CATEGORIES;
    }

    public String getVersion() {
        return this.version;
    }

    public String getMaintainer() {
        return this.maintainer;
    }

    public boolean useRecursion() {
        return this.layout == LibraryLayout.RECURSIVE;
    }

    public File getSrcFolder() {
        switch (this.layout) {
            case FLAT: {
                return this.folder;
            }
            case RECURSIVE: {
                return new File(this.folder, "src");
            }
        }
        return null;
    }

    public boolean isLegacy() {
        return this.isLegacy;
    }

    public String toString() {
        String string = "Library:";
        string = string + " (name=" + this.name + ")";
        string = string + " (version=" + this.version + ")";
        string = string + " (author=" + this.author + ")";
        string = string + " (maintainer=" + this.maintainer + ")";
        string = string + " (sentence=" + this.sentence + ")";
        string = string + " (paragraph=" + this.paragraph + ")";
        string = string + " (url=" + this.url + ")";
        string = string + " (architectures=" + this.architectures + ")";
        return string;
    }

    private static enum LibraryLayout {
        FLAT,
        RECURSIVE;

    }
}

