/*
 * Decompiled with CFR 0.152.
 */
package processing.app.preproc;

import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import processing.app.I18n;
import processing.app.PreferencesData;
import processing.app.legacy.PApplet;

public class PdePreprocessor {
    public int prototypeCount = 0;
    public int headerCount = 1;
    List<String> prototypes;
    List<String> programImports;
    List<String> codeFolderImports;
    String program;

    public int writePrefix(String string) throws FileNotFoundException {
        string = string + "\n";
        string = this.scrubComments(string);
        if (PreferencesData.getBoolean("preproc.substitute_unicode")) {
            string = PdePreprocessor.substituteUnicode(string);
        }
        String string2 = "^\\s*#include\\s*[<\"](\\S+)[\">]";
        this.programImports = new ArrayList<String>();
        String[][] stringArray = PApplet.matchAll(string, string2);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.programImports.add(stringArray[i][1]);
            }
        }
        this.codeFolderImports = new ArrayList<String>();
        this.prototypes = this.prototypes(string);
        this.prototypeCount = this.prototypes.size();
        this.program = string;
        return this.headerCount + this.prototypeCount;
    }

    static String substituteUnicode(String string) {
        int n;
        char[] cArray = string.toCharArray();
        int n2 = 0;
        for (n = 0; n < cArray.length; ++n) {
            if (cArray[n] <= '\u007f') continue;
            ++n2;
        }
        if (n2 != 0) {
            n = 0;
            char[] cArray2 = new char[cArray.length + n2 * 5];
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] < '\u0080') {
                    cArray2[n++] = cArray[i];
                    continue;
                }
                if (cArray[i] == '\u00a0') {
                    cArray2[n++] = 32;
                    continue;
                }
                char c = cArray[i];
                cArray2[n++] = 92;
                cArray2[n++] = 117;
                char[] cArray3 = Integer.toHexString(c).toCharArray();
                for (int j = 0; j < 4 - cArray3.length; ++j) {
                    cArray2[n++] = 48;
                }
                System.arraycopy(cArray3, 0, cArray2, n, cArray3.length);
                n += cArray3.length;
            }
            string = new String(cArray2, 0, n);
        }
        return string;
    }

    public void write(OutputStream outputStream) throws Exception {
        PrintStream printStream = new PrintStream(outputStream);
        this.writeProgram(printStream, this.program, this.prototypes);
        this.writeFooter(printStream);
    }

    protected void writeProgram(PrintStream printStream, String string, List<String> list) {
        int n = this.firstStatement(string);
        printStream.print(string.substring(0, n));
        printStream.print("#include \"Arduino.h\"\n");
        for (int i = 0; i < list.size(); ++i) {
            printStream.print(list.get(i) + "\n");
        }
        String[] stringArray = string.substring(0, n).split("\n", -1);
        printStream.println("#line " + (stringArray.length - 1));
        printStream.print(string.substring(n));
    }

    protected void writeFooter(PrintStream printStream) throws Exception {
    }

    public List<String> getExtraImports() {
        return this.programImports;
    }

    public int firstStatement(String string) {
        String string2 = "\\s+";
        string2 = string2 + "|(/\\*[^*]*(?:\\*(?!/)[^*]*)*\\*/)|(//.*?$)";
        string2 = string2 + "|(#(?:\\\\\\n|.)*)";
        Pattern pattern = Pattern.compile(string2, 8);
        Matcher matcher = pattern.matcher(string);
        int n = 0;
        while (matcher.find() && matcher.start() == n) {
            n = matcher.end();
        }
        return n;
    }

    public String strip(String string) {
        String string2 = "('.')";
        string2 = string2 + "|('\\\\\"')";
        string2 = string2 + "|(\"(?:[^\"\\\\]|\\\\.)*\")";
        string2 = string2 + "|(//.*?$)|(/\\*[^*]*(?:\\*(?!/)[^*]*)*\\*/)";
        string2 = string2 + "|(^\\s*#.*?$)";
        StringBuilder stringBuilder = new StringBuilder(string);
        Pattern pattern = Pattern.compile(string2, 40);
        Matcher matcher = pattern.matcher(stringBuilder);
        while (matcher.find()) {
            String string3 = this.composeReplacementString(new StringBuilder(stringBuilder.subSequence(matcher.start(), matcher.end())));
            stringBuilder.replace(matcher.start(), matcher.end(), string3);
        }
        return stringBuilder.toString();
    }

    private String composeReplacementString(StringBuilder stringBuilder) {
        for (int i = 0; i < stringBuilder.length(); ++i) {
            if (stringBuilder.charAt(i) == '\n') continue;
            stringBuilder.setCharAt(i, ' ');
        }
        return stringBuilder.toString();
    }

    private String collapseBraces(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '{') {
                if (n == 0) {
                    stringBuffer.append(string.substring(n2, i + 1));
                }
                ++n;
            }
            if (string.charAt(i) != '}' || --n != 0) continue;
            n2 = i;
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    public ArrayList<String> prototypes(String string) {
        string = this.collapseBraces(this.strip(string));
        Pattern pattern = Pattern.compile("[\\w\\[\\]\\*]+\\s+[&\\[\\]\\*\\w\\s]+\\([&,\\[\\]\\*\\w\\s]*\\)(?=\\s*;)");
        Pattern pattern2 = Pattern.compile("[\\w\\[\\]\\*]+\\s+[&\\[\\]\\*\\w\\s]+\\([&,\\[\\]\\*\\w\\s]*\\)(?=\\s*\\{)");
        ArrayList<String> arrayList = new ArrayList<String>();
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            arrayList.add(matcher.group(0) + ";");
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        Matcher matcher2 = pattern2.matcher(string);
        while (matcher2.find()) {
            arrayList2.add(matcher2.group(0) + ";");
        }
        block2: for (int i = arrayList2.size() - 1; i >= 0; --i) {
            for (int j = 0; j < arrayList.size(); ++j) {
                if (!arrayList2.get(i).equals(arrayList.get(j))) continue;
                arrayList2.remove(i);
                continue block2;
            }
        }
        return arrayList2;
    }

    private boolean isStartOrEndOfString(char[] cArray, int n) {
        if (cArray[n] != '\"') {
            return false;
        }
        if (n == 0) {
            return true;
        }
        if (cArray[n - 1] == '\\') {
            return false;
        }
        if (n - 2 >= 0 && cArray[n - 2] == '\\') {
            return true;
        }
        return true;
    }

    public String scrubComments(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        boolean bl = false;
        while (n < cArray.length) {
            if (this.isStartOrEndOfString(cArray, n)) {
                boolean bl2 = bl = !bl;
            }
            if (!bl && cArray[n] == '/' && n < cArray.length - 1 && cArray[n + 1] == '/') {
                cArray[n++] = 32;
                cArray[n++] = 32;
                while (n < cArray.length && cArray[n] != '\n') {
                    cArray[n++] = 32;
                }
                continue;
            }
            if (!bl && cArray[n] == '/' && n < cArray.length - 1 && cArray[n + 1] == '*') {
                cArray[n++] = 32;
                cArray[n++] = 32;
                boolean bl3 = false;
                while (n < cArray.length - 1) {
                    if (cArray[n] == '*' && cArray[n + 1] == '/') {
                        cArray[n++] = 32;
                        cArray[n++] = 32;
                        bl3 = true;
                        break;
                    }
                    if (cArray[n] != '\n') {
                        cArray[n] = 32;
                    }
                    ++n;
                }
                if (bl3) continue;
                throw new RuntimeException(I18n._("Missing the */ from the end of a /* comment */"));
            }
            ++n;
        }
        return new String(cArray);
    }
}

