@echo off
REM # B012 - B014 update script
REM # Update.bat $
REM #

REM # Pass in device name from arg
set dn=%~1
set mf="B010"

REM # Print device name to screen
REM #echo.
REM #echo "%dn%"

REM # Check minimum firmware level is on expander
sg_inq "%dn%" | findstr %mf% >NUL

if %errorlevel% equ 0 (
	echo.
	echo "Flash expander firmware up to B011 before updating any further"
	goto :eof
)

REM # Update firmware
echo Update firmware.
echo.
call fw_tool.bat --fw_update ..\..\binary\firmware_image.bin "%dn%"

TIMEOUT 3 /NOBREAK

call sg_ses.exe --page=0x04 --control --data=02,02 "%dn%"

REM # Power cycle expander after firmware update
REM # echo.
REM # echo "Power cycle expander"

:eof
