
/* *
 * Fuction to get the presetn time and updates the content in the mainDiv
 * */

function update() {
	var time = new Date();
	//document.getElementById('refTime').innerHTML = "Last Refresh Time: " + time.getHours() + ':' + time.getMinutes() + ':' + time.getSeconds();
	updateContent();
}

/* *
 * Handle Keyboard events
 * */

function handleKB(e) {
	var evt = (e) ? e : window.event;       //IE reports window.event not arg
        char1 = e.charCode;
    if ((e.keyCode == 27 || e.keyCode == 13) && e.charCode == 0) {
		document.onkeypress = '';
		runTask();
		e.preventDefault();
	}
}

/* *
 * Function to load the main server health page
 * */

function loadMain() {
    $.ajax({
        type: "GET",
        url: "dashboard.html",
        success: function(msg){
            $('#mainContent').empty().append(msg);
            update();
            var date_time = new Date();
            var refresh_time =checkTime(date_time.getHours()) + ":" + checkTime(date_time.getMinutes()) +  ":" +checkTime(date_time.getSeconds());
            jQuery("#lastrefresh").html("Last Refresh Time: " + refresh_time);

        },
    error: handleAjaxError
    });
}
/*Get the product version and update "About"*/
function getProductVersion() {
    $.ajax({
        url: "getsummary.php",
        type: "GET",
        data: ({
            req: 'version'
        }),
        datatype: "xml",
        success: function (xmlData) {
            var xmlDoc;
            try {
                parser = new DOMParser();
                xmlDoc = parser.parseFromString(xmlData, "text/xml");
            } catch (e) {
                xmlDoc = new ActiveXObject("Microsoft.XMLDOM");
                xmlDoc.async = "false";
                xmlDoc.loadXML(xmlData);
            }
            if (typeof xmlDoc.getElementsByTagName('IASC')[0].childNodes[0].nodeValue != "undefined") {
                var iascVersion = xmlDoc.getElementsByTagName('IASC')[0].childNodes[0].nodeValue;
                document.getElementById("version_content").innerHTML = 'Intel<sup>&reg</sup> Active System Console<br />Version ' + iascVersion + '<br />';
            }
        },
        error: handleAjaxError
    });
}
/* *
 * Function to load the main server health page
 * */

function loadGUID() {
	$.ajax({
		url: 'updateAscUser.php',
		type: "POST",
        data: ({
            reqType: "GetLocalGUID"
        }),
		datatype: "xml",

		success: function(xml) {
            if (retrycount > 20) {
				return;
			}
            if (guid != "Error" && guid == "localhost") {
				guid=getLocalhost(xml);
				loadMain();
			}
		},
	error: handleAjaxError
	});
    if (guid == "localhost") {
        if (retrycount > 20) {
		    showMsg( "Data is being retrieved, Please retry", 'index.htm', 'WARNING');
        } else {
		    setTimeout('loadGUID()', 1000);
		    retrycount++;
		}
	}
}

function loadPlatFormID() {
	$.ajax({
		url: 'updateAscUser.php',
		type: "POST",
        data: ({
            reqType: "GetPlatFormID"
        }),
		datatype: "xml",

		success: function(xml) {
			platformID = getPlatFormID(xml);
			}
	});
}


/* *
 * Function to get the last few logs
 * */

function getScrollLogs() {
    name = 'getLastEvents.php?' + Math.random();
    $.ajax({
		type: "POST",
        url: name,
        data: ({
            guid: guid
        }),
		datatype: "xml",
        success: function (msg) {
	        logs = msg.split('&&&&');
	        totalLogCount = logs.length;
	        scrollLogs();
        }
    });
}

function scrollLogs(str) {
	var scroll_delay = 12000;
	var scroll_call_time =360000;
    if (logs[presLogCount] != null) {
        jQuery("#logScroll").html( logs[presLogCount]);
	}
	presLogCount++;
	scrollCount++;
    if (presLogCount == totalLogCount) {
        if (totalLogCount == 0) {
			setTimeout('getScrollLogs()', scroll_call_time);
			scrollCount =0;
        } else {
            if (scrollCount * scroll_delay > scroll_call_time) {
			    getScrollLogs();	
			    scrollCount =0;
            } else {
				presLogCount = 0;
				setTimeout('scrollLogs()', scroll_delay);
			}
		}
		presLogCount = 0;
    } else {
		setTimeout('scrollLogs()', scroll_delay);
	}
}

/* *
 * Function to show the messsages to the user
 * */

function showMsg1(msg, task, severity) {
	$('#modalContent').empty();
	$('#modalLargeContent').empty();

	var sevType = String(severity).toUpperCase();
	nextTask = task;
    if (msg == "Invalid_Session" || msg == "Session_Time_Out" || msg == "Internel_Server_Error") {
	    nextTask =  "login.html";
		msg ="The session returned as invalid. It could have timed out due to user inactivity. Please login again.";
	}

	document.getElementById('msgText1').innerHTML = msg;
	document.getElementById('errorTitleTxt').innerHTML=sevType;
	//$('modalDiv').fadeOut('fast');

	document.getElementById('msgDiv').style.visibility = 'visible';

	/*$('#errorTitleDiv').gradient({
                from: '045196',
                to: '012d5e'
            });*/
    if (sevType == 'ERROR') {
		document.getElementById('errImg').src = 'img/icons/status_critical.png';
    } else if (sevType == 'WARNING') {
		document.getElementById('errImg').src = 'img/icons/status_warning.png';
    } else if (sevType == 'SUCCESS') {
		document.getElementById('errImg').src = 'img/icons/status_ok.png';
	}
	document.onkeypress = handleKB;
} /*Check whether SMBIOS is supported*/

function CheckSMBIOSSupport() {
    $.ajax({
		url: 'getsummary.php',
		type: "POST",
        data: ({
            req: 'SMBIOSSupport',
            guid: guid
        }),
		datatype: "xml",
        success: function (xml) {
            displayError(xml, " ");
            var xmlDoc;
            try {
                parser=new DOMParser();
                xmlDoc=parser.parseFromString(xml, "text/xml");
            } catch (e) {
                xmlDoc=new ActiveXObject("Microsoft.XMLDOM");
                xmlDoc.async="false";
                xmlDoc.loadXML(xml);
            }
            if (typeof xmlDoc.getElementsByTagName('SMBIOSOOB')[0].childNodes[0].nodeValue != "undefined") {
            var result = xmlDoc.getElementsByTagName('SMBIOSOOB')[0].childNodes[0].nodeValue;
            if (result === "data not available") {
                 isSMBIOSSupported = false;
            } else isSMBIOSSupported = true;
            } else {
                isSMBIOSSupported = false;
            }
		},
	error: handleAjaxError
	});
}
/**********************************Authentication Functionality**********************/
function login() {
	updateTips("", "#loginValidateTips");
	if (!validatelogin()) {
        return;
    }
    document.body.style.cursor = 'progress';
    document.getElementById('loginbutt').style.visibility = 'hidden';
    document.getElementById('loginusername').disabled = true;
    document.getElementById('loginpassword').disabled = true;
    $.ajax({
        url: 'auth.php',
        type: "POST",
        data: ({
            password: $("#loginpassword").val(),
            username: $("#loginusername").val()
        }),
        datatype: "xml",
        success: function (xml, textStatus) {
            document.body.style.cursor = "auto";
            document.getElementById('loginbutt').style.visibility = 'visible';
            document.getElementById('loginusername').disabled = false;
            document.getElementById('loginpassword').disabled = false;
            var xmlDoc;
            try {
                parser = new DOMParser();
                xmlDoc = parser.parseFromString(xml, "text/xml");
            } catch (e) {
                xmlDoc = new ActiveXObject("Microsoft.XMLDOM");
                xmlDoc.async = "false";
                xmlDoc.loadXML(xml);
            }
            var respCode = xmlDoc.getElementsByTagName('Status')[0].childNodes[0].nodeValue;
            if (respCode == 'Successfull') {
                document.onkeypress = '';
                window.location = './main.htm?user=' + $("#loginusername").val();
            } else {
                var errMessage = xmlDoc.getElementsByTagName("message")[0].childNodes[0].nodeValue;
                updateTips(errMessage, "#loginValidateTips");
                $("#loginusername").focus();
                //document.onkeypress = handleKB;
            }
        },
        error: function handleAjaxError(x, e) {
			document.body.style.cursor = "auto";
            document.getElementById('loginbutt').style.visibility = 'visible';
            document.getElementById('loginusername').disabled = false;
            document.getElementById('loginpassword').disabled = false;
            if (x.status == 0) {
                updateTips('You are offline!!\n Please check your network.', "#loginValidateTips");
            } else if (x.status == 404) {
                updateTips('Requested URL not found.', "#loginValidateTips");
            } else if (x.status == 500) {
                updateTips('Internel_Server_Error.', "#loginValidateTips");
            } else if (e == 'parsererror') {
                updateTips('Error.\nParsing JSON Request failed.', "#loginValidateTips");
            } else if (e == 'timeout') {
                updateTips('Request timed out.', "#loginValidateTips");
            }
        }
    });
}
    
function validatelogin() {
    var username = $("#loginusername");
    var password = $("#loginpassword");
    var allFields = $([]).add(username).add(password);
    var bValid = true;
    allFields.removeClass('ui-state-error');
    bValid = bValid && checkLength(username, "Username", 3, 15, "#loginValidateTips");
    bValid = bValid && checkLength(password, "Password", 3, 15, "#loginValidateTips");
    bValid = bValid && checkRegexp(username, /^([0-9a-zA-Z_])+$/, "Username field only allow : a-z 0-9, underscores", "#loginValidateTips", "#loginValidateTips");
    bValid = bValid && checkRegexp(password, /^([0-9a-zA-Z`!\-_=+~# @$*:;.,?&^%])+$/, "Password field only allow : a-z 0-9, Characters `!\-_=+~#@$*:;.,?&^%", "#loginValidateTips");
    return bValid;
} 
/****************************EOF - Authentication Functionality****************************/
/****************************BMC-LAN Failover**************************/
function hideIfLanFailoverEnabled(state) {
	$("#list tbody tr").each(function (i, tr) {
		var row = $("#list").getRowData(tr.id);
		var network_id = row.network;
		if (typeof network_id != "undefined") {
			if (network_id != "1" && state === "ENABLE") { //if ENABLED , hide non-primary channels
				$("#" + tr.id).hide(); 
}
			else {
				$("#" + tr.id).show(); //show all the channels.
			}
		}
	});
}
/*****************************EOL - BMC LAN Failover********************************/
/*function logOff() {
    	ascGetAjaxRsp("LogOff");

}*/




