/******************************************************************************
*
*                   INTEL CORPORATION PROPRIETARY INFORMATION
*       This software is supplied under the terms of a license agreement or
*       nondisclosure agreement with Intel Corporation and may not be copied
*       or disclosed except in accordance with the terms of that agreement.
*
*            Copyright (c) 2008-2009 Intel Corporation. All Rights Reserved.
*
*       All rights reserved.  No part of this program or publication may be
*       reproduced, transmitted, transcribed, stored in a retrieval system,
*       or translated into any language or computer language, in any form or
*       by any means, electronic, mechanical, magnetic, optical, chemical,
*       manual, or otherwise, without the prior written permission of Intel
*       Corporation.
*
*
*******************************************************************************/
#ifndef __CR_EXCEPTION_CLASS_H
#define __CR_EXCEPTION_CLASS_H

#ifndef WINEMU
#define _snprintf_s snprintf
#endif

typedef unsigned long   DWORD;

const DWORD CR_EXCEPTION	 = 0x27041975;

typedef class cr_exception {
public:
	cr_exception(){
		val=0;
		magic = CR_EXCEPTION;
		name = "default:";
	}

	~cr_exception(){
		//printf("%s: d'tor called.\n", name.c_str());

		if (magic == CR_EXCEPTION)
		{
			//printf("d'tor with val = %d\n", val);
			//printf("d'tor with magic = %x\n", magic);
			magic = 0xff;
		}
		else
		{
			printf("wrong class d'tor called.\n");
			exit(1);
		}
	}

	//copy contructor.
	cr_exception(const class cr_exception& aT) {
		//printf("copy contructor called.\n");		
		val = aT.getval();
		magic = CR_EXCEPTION;
		name = "copy constructor: " + aT.getname();
	}

	cr_exception(const STRING& n) {
		//printf("constructor called. with string.\n");
		val = 0;
		magic = CR_EXCEPTION;
		name = n;
	}

	class cr_exception& operator=(const class cr_exception& aT) {
		//printf("operator= called.\n");
		val = aT.getval();
		magic = CR_EXCEPTION;
		name = "operator=: " + aT.getname();
		return *this;
	}

	void setval(int aVal) {val = aVal;}
	int getval(void) const {return val;}
	int getmagic(void) const {return magic;}
	const STRING& getname(void) const {return name;}
	void setname(const STRING& n)
	{
		name = n;
	}

public:
	STRING name;
	
private:
	int val;
	int magic;
	
}cr_exception;

#endif //__CR_EXCEPTION_CLASS_H
