/******************************************************************************
*
*                   INTEL CORPORATION PROPRIETARY INFORMATION
*       This software is supplied under the terms of a license agreement or
*       nondisclosure agreement with Intel Corporation and may not be copied
*       or disclosed except in accordance with the terms of that agreement.
*
*            Copyright (c) 2008-2014 Intel Corporation. All Rights Reserved.
*
*       All rights reserved.  No part of this program or publication may be
*       reproduced, transmitted, transcribed, stored in a retrieval system,
*       or translated into any language or computer language, in any form or
*       by any means, electronic, mechanical, magnetic, optical, chemical,
*       manual, or otherwise, without the prior written permission of Intel
*       Corporation.
*
*
*******************************************************************************/
#ifndef __CR_MALLOC_H__
#define __CR_MALLOC_H__

#ifdef CR_EFI

#ifdef __cplusplus
extern "C" {
#endif

#define FREE	efi_free
#define REALLOC	efi_realloc
#define MALLOC	efi_malloc
#define CALLOC	efi_calloc

void *	efi_malloc(size_t sz);
void *	efi_realloc(void *ptr, size_t sz);
void *	efi_calloc(unsigned int n, size_t sz);
void	efi_free(void *ptr);

void	efi_mem_init();
void	efi_mem_print();

#ifdef __cplusplus
}
#endif

#else // CR_EFI

#include <stdlib.h>
#include <malloc.h>
#define FREE	free
#define REALLOC	realloc
#define MALLOC	malloc
#define CALLOC	calloc

#endif // CR_EFI

#endif // __CR_MALLOC_H__