/******************************************************************************
 *
 *                   INTEL CORPORATION PROPRIETARY INFORMATION
 *       This software is supplied under the terms of a license agreement or
 *       nondisclosure agreement with Intel Corporation and may not be copied
 *       or disclosed except in accordance with the terms of that agreement.
 *
 *            Copyright (c) 2008-2009 Intel Corporation. All Rights Reserved.
 *
 *       All rights reserved.  No part of this program or publication may be
 *       reproduced, transmitted, transcribed, stored in a retrieval system,
 *       or translated into any language or computer language, in any form or
 *       by any means, electronic, mechanical, magnetic, optical, chemical,
 *       manual, or otherwise, without the prior written permission of Intel
 *       Corporation.
 *
 *
 *******************************************************************************/
#ifndef __CR_OSAL_H_
#define __CR_OSAL_H_

#ifdef CR_LINUX
#define CR_NO_THROW
#include <os/include/linux/cr_osal_linux.h>
#else

#ifdef CR_WINDOWS
#define CR_NO_THROW
#include <os/include/windows/cr_osal_windows.h>
#include <assert.h>
#else

#ifdef CR_EFI
#pragma warning (disable: 4091) //typedef: ignored on left of 'x' when no variable is declared
#define CR_NO_THROW __declspec(nothrow)
#define CR_USE_ALLOCATOR
#include <os/include/efi/cr_osal_efi.h>
#include <os/include/cr_exception_class.h>
#endif //ifdef CR_EFI

#endif //ifdef CR_WINDOWS

#endif //ifdef CR_LINUX

//Namespaces
#ifndef CR_EFI
using namespace std;
#endif

//using namespace boost;
using namespace Module;
using namespace Osal;

//Common Typedefs
#ifdef CR_LINUX
typedef unsigned char 	    UINT8;
#endif
typedef unsigned short      UINT16;
typedef unsigned long long  ULONGLONG;
typedef char                CHAR;
typedef short               INT16;

#ifndef CR_EFI
typedef int 	            INTN;
#endif

TYPEDEF_MAPOF(int, STRING, ErrorStringMap);

typedef long long           LONGLONG;

typedef WSTRING				UNICODE_STR;
//typedef shared_ptr<UINT8>	BYTE_PTR;
//typedef shared_ptr<void>	VOID_PTR;

typedef enum _NODE_TYPE
{
	NODE_LEAF = 0,
	NODE_NONLEAF
} NODE_TYPE;

struct _XNode;
typedef struct _XNode XNode;
typedef XNode* XNodePtr;

typedef STRING XToken;

TYPEDEF_VECTOROF(XToken, XTokenList);

TYPEDEF_MAPOF(STRING, XNode, ResultMap);
TYPEDEF_MAPOF(STRING, XNodePtr, ResultPtrMap);

typedef STRING_TO_STRING_MAP XSettingMap;

TYPEDEF_MAPOF(STRING, STRING_TO_STRING_MAP, SettingsMap);

struct _XNode {

	NODE_TYPE mType;
	XTokenList mXNodeList;
	XSettingMap mOptionMap;
#ifdef CR_LINUX // rajneesh
	unsigned char bReadOnly;
#else
	BOOLEAN bReadOnly;
#endif
	_XNode()
		: mXNodeList()
//#ifdef CR_EFI
		, mOptionMap()
//#endif
	{}

//#ifdef CR_EFI
	//Copy Constructor
	_XNode(const _XNode& aNode) {
		mType = aNode.mType;
		mXNodeList = aNode.mXNodeList;
		mOptionMap = aNode.mOptionMap;
		bReadOnly = aNode.bReadOnly;
	}

	CR_NO_THROW inline _XNode& operator=(const _XNode& aNode) {
		mType = aNode.mType;
		mXNodeList = aNode.mXNodeList;
		mOptionMap = aNode.mOptionMap;
		bReadOnly = aNode.bReadOnly;
		return *this;
	}
//#endif

	~_XNode()
	{
		mXNodeList.clear();
#ifdef CR_EFI
		mOptionMap.clear();
#endif
	}
};


typedef STRING_TO_STRING_HMAP   STRING_STRING_MAP;

TYPEDEF_HASH_MAPOF(STRING, VECTOROF_STRING, STRING_VECTOR_STRING_MAP);

TYPEDEF_HASH_MAPOF(STRING, STRING_STRING_MAP, STRING_STRING_STRING_MAP);

TYPEDEF_HASH_MAPOF(STRING, STRING_VECTOR_STRING_MAP, STRING_STRING_VECTOR_STRING_MAP);

#ifdef CR_EFI
TYPEDEF_HASH_MAPOF(int, STRING, INT_TO_STRING_MAP);
TYPEDEF_HASH_MAPOF(int, VECTOROF_STRING, INT_TO_VECTOR_STRING_MAP);
TYPEDEF_HASH_MAPOF(STRING, VECTOROF_STRING, STRING_TO_VECTOR_STRING_MAP);
#else
TYPEDEF_MAPOF(int, STRING, INT_TO_STRING_MAP);
TYPEDEF_MAPOF(int, VECTOROF_STRING, INT_TO_VECTOR_STRING_MAP);
TYPEDEF_MAPOF(STRING, VECTOROF_STRING, STRING_TO_VECTOR_STRING_MAP);
#endif

#define _GET "GET:/"
#define _SET "SET:/"
#define UNSUPPORTED      "UNSUPPORTED"

typedef enum _FN_NAME {
	FN_IPMI,
	FN_IPMI_RESPONSE,
	FN_LOOKUP_TABLE,
	FN_STORE,
	FN_COPY,
	FN_APPEND,
	FN_TEMPLATE,
	FN_SET,
	FN_MAP,
	FN_MASK,
	FN_IF,
	FN_FOR,
	FN_WHILE,
	FN_EXPRESSION,
	FN_FORMAT_STRING,
	FN_SPLIT,
	FN_JOIN, 
	FN_PAD, 
	FN_CONVERT,
	FN_END,
	FN_FLATTEN,
	FN_FILTER,
	FN_CREATE_FILTER,
	FN_READ,
	FN_PRINT,
	FN_EXCLUDE,
	FN_SIZE,
	FN_RETURN,
	FN_DEBUG,
	FN_ASSERT,
	FN_THROW,
	FN_ELSEIF,
	FN_ELSE,
	FN_SLEEP,
	FN_INCREMENT,
	FN_STRING_LENGTH,
	FN_ASSIGN,
	FN_PREPEND,
	FN_POLL,
    FN_IPMI_WITHOUT_THROW,
	FN_MATHEMATICAL,
	FN_TEMPLATE_WITH_CATCH
} FN_NAME;

enum TYPE { STRING_TYPE, VECTOR_STRING_TYPE };

#define IPMI_MAX_BUFFER  255
#define DECIMAL_RANGE    "0123456789"
#define HEX_RANGE    "0123456789ABCDEFabcdef"
#define _OP_EQUAL_TO     "=="
#define _OP_NOT_EQUAL_TO "!="
#define _OP_LESS_THAN    "<"
#define _OP_GREATER_THAN ">"
#define _OP_GREATER_THAN_OR_EQUAL_TO ">="
#define _OP_LESS_THAN_OR_EQUAL_TO "<="

#define STR_SIZE_CHECK          "STR_SIZE_CHECK"
#define RANGE_CHECK          "RANGE_CHECK"
#define HEX2DEC          "HEX2DEC"
#define DEC2HEX          "DEC2HEX"
#define HEX2STR          "HEX2STR"
#define STR2HEX          "STR2HEX"
#define BIT_OR           "BIT_OR"
#define MASK             "MASK"
#define LEFT_SHIFT       "LEFT_SHIFT"
#define RIGHT_SHIFT      "RIGHT_SHIFT"
#define VALIDATE_MAC	 "VALIDATE_MAC"
#define VALIDATE_IPV6    "VALIDATE_IPV6" 

#define MAX_INT_FOR_LOOP_BOUND_CHECK		1024
//enum OPERATION { READ, WRITE, DELETE_OP };

#define localST(x) mST[x]
//#define sT(x) Module::BMCConfig::SymbolTable::instance()[x]
//#define sTSet(x,y) Module::BMCConfig::SymbolTable::instance().set(x,y)
//#define sTGet(x)	\
//	Module::BMCConfig::SymbolTable::instance().get(x);\
//	LOGR3("sTGet at %s: %s: %d", __FILE__, __FUNCTION__, __LINE__);
//#define sTGet((x)) Module::BMCConfig::SymbolTable::instance().get(x)

#define fD(x) filterDB[x]
//#define fDGet(x) Module::BMCConfig::IPMIFilterDB::instance().get(x)
#define tB(x) tableDB[x]
//#define tBGet(x) Module::BMCConfig::TableDB::instance().get(x)
#define pD(x) packetDB[x]
//#define pDGet(x) Module::BMCConfig::IPMIPacketDB::instance().get(x)
#define tD(x) templateDB[x]
//#define tDGet(x) Module::BMCConfig::TemplateDB::instance().get(x)


//#define fD(x) Module::BMCConfig::IPMIFilterDB::instance()[x]
//#define fDGet(x) Module::BMCConfig::IPMIFilterDB::instance().get(x)
//
//#define tB(x) Module::BMCConfig::TableDB::instance()[x]
//#define tBGet(x) Module::BMCConfig::TableDB::instance().get(x)
//
//#define pD(x) Module::BMCConfig::IPMIPacketDB::instance()[x]
//#define pDGet(x) Module::BMCConfig::IPMIPacketDB::instance().get(x)
//
//#define tD(x) Module::BMCConfig::TemplateDB::instance()[x]
//#define tDGet(x) Module::BMCConfig::TemplateDB::instance().get(x)

//#define gB(x) Module::BMCConfig::SymbolTable::instance().mark_as_garbage(x)
//#define sGB(x) Module::BMCConfig::SymbolTable::instance().mark_as_stinking_garbage(x)
//
//#define gBC() Module::BMCConfig::SymbolTable::instance().garbage_collector()
//#define sGBC() Module::BMCConfig::SymbolTable::instance().stinking_garbage_collector()

typedef struct _MEMINFO{
	STRING memload;
	STRING totalram;
	STRING freeram;
	STRING totalswap;
	STRING freeswap;
	STRING totalvirt;
	STRING freevirt;
} MEMINFO;

typedef struct _OSINFO{
	STRING hostname;
	STRING domain;
	STRING version;
	STRING machine;
	STRING type;
	STRING build;
	STRING CSDVersion;
}OSINFO;

typedef struct _DRIVEINFO{
	STRING Id;
	STRING TotalSpace;
	STRING FreeSpace;
}DRIVEINFO;

typedef struct _PHYSICALDRIVEINFO{
	STRING Id;
	STRING TotalSpace;
	STRING SerialNumber;
	STRING FWVersion;
	STRING Model;
	STRING ControllerName;
	
}PHYSICALDRIVEINFO;

typedef struct _NICINFO{
	STRING Name;
	STRING TransmitPackets;
	STRING TransmitBytes;
	STRING TransmitErrors;
	STRING ReceivePackets;
	STRING ReceiveBytes;
	STRING ReceiveErrors;
	STRING IPAddress;
	STRING IPV6;
	STRING MacAddress;
	STRING GatewayIP;
	STRING Status;
	STRING SubnetMask;
	STRING IPType;
	STRING DeviceName;
	STRING Version; 
	STRING FWVersion; 
	STRING PCIBusNumber; 
}NICINFO;
//end

TYPEDEF_VECTOROF(DRIVEINFO, DRIVEINFOVec);
TYPEDEF_VECTOROF(PHYSICALDRIVEINFO, PHYSICALDRIVEINFOVec);
TYPEDEF_VECTOROF(NICINFO, NICINFOVec);

void GetMemInfo(MEMINFO&);
void GetOSInfo(OSINFO&);
#ifdef CR_WINDOWS
	bool GetOSDisplayString(STRING& os_display_string, OSINFO osInfo);
#else
	bool GetOSDisplayString(STRING& os_display_string);
#endif
void GetDriveData(DRIVEINFOVec&);
void GetNICInfo(NICINFOVec&);
void GetPhysicalDriveData(PHYSICALDRIVEINFOVec&);

	//added by Divagar - GPT issue
typedef enum _PARTITIONTYPE{
	PARTITIONTYPE_MBR,
	PARTITIONTYPE_GPT,
	PARTITIONTYPE_RAW,
	PARTITIONTYPE_UNKNOWN,
	PARTITIONTYPE_EXCEPTION
}PARTITIONTYPE;

void GetPartitionType(PARTITIONTYPE &);
bool GetEnvVariable(char *p_var, char *p_value, int maxRetSize = 4096);
bool DoesFileExist(char * filepath);

#define ASSERT(x) assert(x)

#endif //ifndef __CR_OSAL_H_
