#!/bin/bash
echo OFF
## this is a auto script for IASC Red Hat 32 bit rpm installation from CD.
## this script only support Red Hat 6.4, 6.5 and 7.0.
## for Red Hat 6.4 used x64 CD and for 6.5 used x32bit CD.
## created by Teh Kok Piaw 
## version 1.0 :first release.
## version 1.1 :added rhat7 support

uname_r=`uname -r`
I=0;

## check the system OS to identify which Rhat installation CD need to be use.
## below checking is for Red Hat 6.4
if [ ${uname_r} = '2.6.32-358.el6.x86_64' ]; then
	echo @Automation for RHEL6.XX 32bit rpm installation.
	echo @Please put in Red Hat 6.4 X64 installation CD. Make sure OS detected CD before run the script.
	echo @Please do not access installation CD content or open any file when run this script.
	echo @or else this script will fail to mount/unmount installation CD.
	echo
	read -p "Press Enter To Start"

	## sleep for 5 second to makse sure CDROM in detected by Rhat
	sleep 5

	##unmount CD put in CDROM and remount it to new label. if fail maybe CDROM not detected
	if [ -e "/dev/cdrom" ]; then
	  ##echo "/dev/cdrom"
	  umount /dev/cdrom
	  if [ -e "/mnt/cdrom" ]; then
	      ##echo "found /mnt/cdrom"
		  mount /dev/cdrom /mnt/cdrom
		  CD_DIR='/mnt/cdrom'
	  else
	      ##echo "cannot /dev/cdrom"
	      mkdir /mnt/cdrom
	      mount /dev/cdrom /mnt/cdrom
	      CD_DIR='/mnt/cdrom'
	  fi;
	else
	for I in 1 2 3 4 5   ## use for loop to search cdrom in /dev folder.
	  do
	    if [ -e "/dev/cdrom$I" ]; then
		  umount /dev/cdrom$I
		  if [ -e "/mnt/cdrom" ]; then
		    ##echo "found /mnt/cdrom"
		    mount /dev/cdrom$I /mnt/cdrom
		    CD_DIR='/mnt/cdrom'
		    break;
		  else
		    ##echo "cannot /dev/cdrom"
		    mkdir /mnt/cdrom
		    mount /dev/cdrom$I /mnt/cdrom
		    CD_DIR='/mnt/cdrom'
		    break;
		  fi;
	    else
		  ##echo "cannot find cdrom$I or CDROM cannot be detected"
		  ##echo "Automation: script stopped."
		  continue;
	    fi;
	  done
	fi;

	## check if no /dev/cdrom found fail it.
	if [ $I == 5 ]; then
	    echo "mounting CDROM failed or CDROM cannot be detected"
	    echo "Automation: script stopped."
	    exit 1
	fi;


	
##if rpm -qa | grep libxslt-1.1.26; then
	if [ -d "${CD_DIR}" ]; then
		echo
		#echo @found the installation CD
		echo
	
		my_path=$(find /mnt/cdrom -iname "zlib-1.2.3*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh $my_path
		else
			echo @cannot find the rpm for zlib-1.2.3*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	################################################################
		my_path=$(find /mnt/cdrom -iname "libxml2-2.7.6*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh $my_path
		else
			echo @lcannot find the rpm for ibxml2-2.7.6*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	################################################################	
		my_path=$(find /mnt/cdrom -iname "libgpg-error-1.7*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh $my_path
		else
			echo @cannot find the rpm for libqpg-error-1.7*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	#################################################################
		my_path=$(find /mnt/cdrom -iname "libgcrypt-1.4.5*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh $my_path
		else
			echo @cannot find the rpm for libgcrypt-1.4.5*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	#################################################################
		my_path=$(find /mnt/cdrom -iname "libxslt-1.1.26*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh $my_path
		else
			echo @cannot find the rpm for libxslt-1.1.26*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;	
	#################################################################
		my_path=$(find /mnt/cdrom -iname "libstdc++-4.4.7*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh $my_path
		else
			echo @cannot find the rpm for libstdc++-4.4.7*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	##################################################################	
		my_path=$(find /mnt/cdrom -iname "compat-libstdc++-33-3*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh $my_path
		else
			echo @cannot find the rpm for compat-libstdc++-33-3*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	###################################################################	
		my_path=$(find /mnt/cdrom -iname "ncurses-libs-5.7-3*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh $my_path
		else
			echo @cannot find the rpm for ncurses-libs-5.7-3*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	###################################################################	
		my_path=$(find /mnt/cdrom -iname "ncurses-devel-5.7-3*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh $my_path
		else
			echo @cannot find the rpm for ncurses-devel-5.7-3*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	###################################################################	
		my_path=$(find /mnt/cdrom -iname "db4-4.7*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh $my_path
		else
			echo @cannot find the rpm for db4-4.7*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	####################################################################
		my_path=$(find /mnt/cdrom -iname "nspr-4.9*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh $my_path
		else
			echo @cannot find the rpm for nspr-4.9*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	####################################################################	
		my_path=$(find /mnt/cdrom -iname "nss-util-3.14.0*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh $my_path
		else
			echo @cannot find the rpm for nss-util-3.14.0*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	#####################################################################
		my_path=$(find /mnt/cdrom -iname "readline-6.0*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh $my_path
		else
			echo @cannot find the rpm for readline-6.0*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	#####################################################################	
		my_path=$(find /mnt/cdrom -iname "sqlite-3.6.20*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh $my_path
		else
			echo @cannot find the rpm for sqlite-3.6.20*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	######################################################################	
		my_path=$(find /mnt/cdrom -iname "nss-softokn-3.12.9*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh $my_path
		else
			echo @cannot find the rpm for nss-softokn-3.12.9*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	######################################################################	
		my_path=$(find /mnt/cdrom -iname "nss-3.14.0.0*i686*")
		if [ "$my_path" != "" ]; then 
			echo "RPM found"
			rpm -ivh $my_path
		else
			echo @cannot find the rpm for nss-3.14.0.0*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	######################################################################	
		my_path=$(find /mnt/cdrom -iname "cyrus-sasl-lib-2.1.23*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"	
			rpm -ivh $my_path
		else
			echo @cannot find the rpm for cyrus-sasl-lib-2.1.23*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	######################################################################	
		my_path=$(find /mnt/cdrom -iname "libidn-1.18-2*i686*")
		if [ "$my_path" != "" ]; then 
			echo "RPM found"
			rpm -ivh $my_path
		else
			echo @cannot find the rpm for libidn-1.18-2*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	######################################################################	
		my_path=$(find /mnt/cdrom -iname "libcom_err-1.41.12*i686*")
		if [ "$my_path" != "" ]; then 
			echo "RPM found"	
			rpm -ivh $my_path
		else
			echo @cannot find the rpm for libcom_err-1.41.12*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	#######################################################################	
		my_path=$(find /mnt/cdrom -iname "openldap-2.4.23*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"	
			rpm -ivh $my_path
		else
			echo @cannot find the rpm for openldap-2.4.23*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	#######################################################################	
		my_path=$(find /mnt/cdrom -iname "keyutils-1.4-4*x86_64*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"		
			rpm -ivh $my_path
		else
			echo @cannot find the rpm for keyutils-1.4-4*x86_64*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	#######################################################################	
		my_path=$(find /mnt/cdrom -iname "keyutils-libs-1.4-4*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"		
			rpm -ivh $my_path
		else
			echo @cannot find the rpm for keyutils-libs-1.4-4*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	#######################################################################	
		my_path=$(find /mnt/cdrom -iname "libselinux-2.0.94*i686*")
		if [ "$my_path" != "" ]; then 
			echo "RPM found"
			rpm -ivh $my_path
		else
			echo @cannot find the rpm for libselinux-2.0.94*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	#######################################################################	
		my_path=$(find /mnt/cdrom -iname "krb5-libs-1.10.3*i686*")
		if [ "$my_path" != "" ]; then 
			echo "RPM found"
			rpm -ivh $my_path
		else
			echo @cannot find the rpm for krb5-libs-1.10.3*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	#######################################################################	
		my_path=$(find /mnt/cdrom -iname "openssl-1.0.0-27*i686*")
		if [ "$my_path" != "" ]; then 
			echo "RPM found"
			rpm -ivh $my_path
		else
			echo @cannot find the rpm for openssl-1.0.0-27*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	#######################################################################	
		my_path=$(find /mnt/cdrom -iname "libssh2-1.4.2*i686*")
		if [ "$my_path" != "" ]; then 
			echo "RPM found"
			rpm -ivh $my_path
		else
			echo @cannot find the rpm for libssh2-1.4.2*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	########################################################################	
		my_path=$(find /mnt/cdrom -iname "openssl098e-0.9.8e-17*i686*")
		if [ "$my_path" != "" ]; then 
			echo "RPM found"
			rpm -ivh $my_path
		else
			echo @cannot find the rpm for openssl098e-0.9.8e-17*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	#######################################################################	
		my_path=$(find /mnt/cdrom -iname "libcurl-7.19.7*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh $my_path
		else
			echo @cannot find the rpm for libcurl-7.19.7-35.el6.i686.rpm
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
		
		echo @IASC Red Hat 6.4 32 bit rpm installation completed.....!!
		if [ $I == 0 ]; then
		  umount /dev/cdrom
		else
		  umount /dev/cdrom$I
		fi;
	else
      	  	echo @Installation CD  not detected.
			echo @make sure installation CD is not busy or in used.
			echo @suspect mount/unmount installation CD not working.
        	echo @Automation: script stopped.
        	echo 
        	exit 1
	fi;
	##below check for Red Hat 6.5
elif [ ${uname_r} = '2.6.32-431.el6.x86_64' ]; 
	then
	echo @Automation for RHEL6.XX 32bit rpm installation.
	echo @Please put in Red Hat 6.5 X32 installation CD.
	echo @Please do not access installation CD content or open any file when run this script.
	echo @or else this script will fail to mount/unmount installation CD.
	echo
	read -p "Press Enter To Start"

	## sleep for 5 second to makse sure CDROM in detected by Rhat
	sleep 5

	##unmount CD put in CDROM and remount it to new label. if fail maybe CDROM not detected
	if [ -e "/dev/cdrom" ]; then
	  ##echo "/dev/cdrom"
	  umount /dev/cdrom
	  if [ -e "/mnt/cdrom" ]; then
	      ##echo "found /mnt/cdrom"
		  mount /dev/cdrom /mnt/cdrom
		  CD_DIR='/mnt/cdrom'
	  else
	      ##echo "cannot /dev/cdrom"
	      mkdir /mnt/cdrom
	      mount /dev/cdrom /mnt/cdrom
	      CD_DIR='/mnt/cdrom'
	  fi;
	else
	for I in 1 2 3 4 5   ## use for loop to search cdrom in /dev folder.
	  do
	    if [ -e "/dev/cdrom$I" ]; then
		  umount /dev/cdrom$I
		  if [ -e "/mnt/cdrom" ]; then
		    ##echo "found /mnt/cdrom"
		    mount /dev/cdrom$I /mnt/cdrom
		    CD_DIR='/mnt/cdrom'
		    break;
		  else
		    ##echo "cannot /dev/cdrom"
		    mkdir /mnt/cdrom
		    mount /dev/cdrom$I /mnt/cdrom
		    CD_DIR='/mnt/cdrom'
		    break;
		  fi;
	    else
		  ##echo "cannot find cdrom$I or CDROM cannot be detected"
		  ##echo "Automation: script stopped."
		  continue;
	    fi;
	  done
	fi;

	## check if no /dev/cdrom found fail it.
	if [ $I == 5 ]; then
	    echo "mounting CDROM failed or CDROM cannot be detected"
	    echo "Automation: script stopped."
	    exit 1
	fi;
	
	if [ -d "${CD_DIR}" ]; then
		echo
		##echo @found the installation CD
		echo
			my_path=$(find /mnt/cdrom -iname "zlib-1.2.3*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh $my_path
		else
			echo @cannot find the rpm for zlib-1.2.3*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	################################################################
		my_path=$(find /mnt/cdrom -iname "libxml2-2.7.6*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh $my_path
		else
			echo @lcannot find the rpm for ibxml2-2.7.6*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	################################################################	
		my_path=$(find /mnt/cdrom -iname "libgpg-error-1.7*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh $my_path
		else
			echo @cannot find the rpm for libqpg-error-1.7*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	#################################################################
		my_path=$(find /mnt/cdrom -iname "libgcrypt-1.4.5*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh $my_path
		else
			echo @cannot find the rpm for libgcrypt-1.4.5*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	#################################################################
		my_path=$(find /mnt/cdrom -iname "libxslt-1.1.26*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh $my_path
		else
			echo @cannot find the rpm for libxslt-1.1.26*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;	
	#################################################################
		my_path=$(find /mnt/cdrom -iname "libstdc++-4.4.7*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh $my_path
		else
			echo @cannot find the rpm for libstdc++-4.4.7*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	##################################################################	
		my_path=$(find /mnt/cdrom -iname "compat-libstdc++-33-3*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh $my_path
		else
			echo @cannot find the rpm for compat-libstdc++-33-3*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	###################################################################	
		my_path=$(find /mnt/cdrom -iname "ncurses-libs-5.7-3*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh $my_path
		else
			echo @cannot find the rpm for ncurses-libs-5.7-3*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	###################################################################	
		my_path=$(find /mnt/cdrom -iname "ncurses-devel-5.7-3*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh $my_path
		else
			echo @cannot find the rpm for ncurses-devel-5.7-3*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	###################################################################	
		my_path=$(find /mnt/cdrom -iname "db4-4.7*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh $my_path
		else
			echo @cannot find the rpm for db4-4.7*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	####################################################################
		my_path=$(find /mnt/cdrom -iname "nspr-4.10.0*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh $my_path
		else
			echo @cannot find the rpm for nspr-4.10.0*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	####################################################################	
		my_path=$(find /mnt/cdrom -iname "nss-util-3.15.1*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh $my_path
		else
			echo @cannot find the rpm for nss-util-3.15.1*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	#####################################################################
		my_path=$(find /mnt/cdrom -iname "readline-6.0-4*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh $my_path
		else
			echo @cannot find the rpm for readline-6.0-4*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	#####################################################################	
		my_path=$(find /mnt/cdrom -iname "sqlite-3.6.20*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh $my_path
		else
			echo @cannot find the rpm for sqlite-3.6.20*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	######################################################################	
		my_path=$(find /mnt/cdrom -iname "nss-softokn-3.14.3*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh $my_path
		else
			echo @cannot find the rpm for nss-softokn-3.14.3*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	######################################################################	
		my_path=$(find /mnt/cdrom -iname "nss-3.15.1*i686*")
		if [ "$my_path" != "" ]; then 
			echo "RPM found"
			rpm -ivh $my_path
		else
			echo @cannot find the rpm for nss-3.15.1*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	######################################################################	
		my_path=$(find /mnt/cdrom -iname "cyrus-sasl-lib-2.1.23*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"	
			rpm -ivh $my_path
		else
			echo @cannot find the rpm for cyrus-sasl-lib-2.1.23*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	######################################################################	
		my_path=$(find /mnt/cdrom -iname "libidn-1.18-2*i686*")
		if [ "$my_path" != "" ]; then 
			echo "RPM found"
			rpm -ivh $my_path
		else
			echo @cannot find the rpm for libidn-1.18-2*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	######################################################################	
		my_path=$(find /mnt/cdrom -iname "libcom_err-1.41.12*i686*")
		if [ "$my_path" != "" ]; then 
			echo "RPM found"	
			rpm -ivh $my_path
		else
			echo @cannot find the rpm for libcom_err-1.41.12*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	#######################################################################	
		my_path=$(find /mnt/cdrom -iname "openldap-2.4.23*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"	
			rpm -ivh $my_path
		else
			echo @cannot find the rpm for openldap-2.4.23*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	#######################################################################	
		my_path=$(find /mnt/cdrom -iname "keyutils-libs-1.4-4*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"		
			rpm -ivh $my_path
		else
			echo @cannot find the rpm for keyutils-libs-1.4-4*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	#######################################################################	
		my_path=$(find /mnt/cdrom -iname "libselinux-2.0.94*i686*")
		if [ "$my_path" != "" ]; then 
			echo "RPM found"
			rpm -ivh $my_path
		else
			echo @cannot find the rpm for libselinux-2.0.94*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	#######################################################################	
		my_path=$(find /mnt/cdrom -iname "krb5-libs-1.10.3*i686*")
		if [ "$my_path" != "" ]; then 
			echo "RPM found"
			rpm -ivh $my_path
		else
			echo @cannot find the rpm for krb5-libs-1.10.3*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	#######################################################################	
		my_path=$(find /mnt/cdrom -iname "openssl-1.0.1e*i686*")
		if [ "$my_path" != "" ]; then 
			echo "RPM found"
			rpm -ivh $my_path
		else
			echo @cannot find the rpm for openssl-1.0.1e*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	#######################################################################	
		my_path=$(find /mnt/cdrom -iname "libssh2-1.4.2*i686*")
		if [ "$my_path" != "" ]; then 
			echo "RPM found"
			rpm -ivh $my_path
		else
			echo @cannot find the rpm for libssh2-1.4.2*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	########################################################################	
		my_path=$(find /mnt/cdrom -iname "openssl098e-0.9.8e-17*i686*")
		if [ "$my_path" != "" ]; then 
			echo "RPM found"
			rpm -ivh $my_path
		else
			echo @cannot find the rpm for openssl098e-0.9.8e-17*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	#######################################################################	
		my_path=$(find /mnt/cdrom -iname "libcurl-7.19.7*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh $my_path
		else
			echo @cannot find the rpm for libcurl-7.19.7-35.el6.i686.rpm
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
		
		echo @IASC Red Hat 6.5 32 bit rpm installation completed.....!!
		if [ $I == 0 ]; then
		  umount /dev/cdrom
		else
		  umount /dev/cdrom$I
		fi;
	else
      	  	echo @Installation CD  not detected.
			echo @make sure installation CD is not busy or in used.
			echo @suspect mount/unmount installation CD not working.
        	echo @Automation: script stopped.
        	echo 
        	exit 1
	fi;
	##below check for Rhat 7
elif [ ${uname_r} = '3.10.0-123.el7.x86_64' ]; 
	then
	echo @Automation for RHEL7.XX 32bit rpm installation.
	echo @Please put in Red Hat 7.0 X64 installation CD.
	echo @Please do not access installation CD content or open any file when run this script.
	echo @or else this script will fail to mount/unmount installation CD.
	echo
	read -p "Press Enter To Start"

	## sleep for 5 second to makse sure CDROM in detected by Rhat
	sleep 5

	##unmount CD put in CDROM and remount it to new label. if fail maybe CDROM not detected
	if [ -e "/dev/cdrom" ]; then
	  ##echo "/dev/cdrom"
	  umount /dev/cdrom
	  if [ -e "/mnt/cdrom" ]; then
	      ##echo "found /mnt/cdrom"
		  mount /dev/cdrom /mnt/cdrom
		  CD_DIR='/mnt/cdrom'
	  else
	      ##echo "cannot /dev/cdrom"
	      mkdir /mnt/cdrom
	      mount /dev/cdrom /mnt/cdrom
	      CD_DIR='/mnt/cdrom'
	  fi;
	else
	for I in 1 2 3 4 5   ## use for loop to search cdrom in /dev folder.
	  do
	    if [ -e "/dev/cdrom$I" ]; then
		  umount /dev/cdrom$I
		  if [ -e "/mnt/cdrom" ]; then
		    ##echo "found /mnt/cdrom"
		    mount /dev/cdrom$I /mnt/cdrom
		    CD_DIR='/mnt/cdrom'
		    break;
		  else
		    ##echo "cannot /dev/cdrom"
		    mkdir /mnt/cdrom
		    mount /dev/cdrom$I /mnt/cdrom
		    CD_DIR='/mnt/cdrom'
		    break;
		  fi;
	    else
		  ##echo "cannot find cdrom$I or CDROM cannot be detected"
		  ##echo "Automation: script stopped."
		  continue;
	    fi;
	  done
	fi;

	## check if no /dev/cdrom found fail it.
	if [ $I == 5 ]; then
	    echo "mounting CDROM failed or CDROM cannot be detected"
	    echo "Automation: script stopped."
	    exit 1
	fi;
	
	if [ -d "${CD_DIR}" ]; then
		echo
		##echo @found the installation CD
		echo
			my_path=$(find /mnt/cdrom -iname "zlib-1.2.7*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh --force --nodeps $my_path
		else
			echo @cannot find the rpm for zlib-1.2.7*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	################################################################
		my_path=$(find /mnt/cdrom -iname "libxml2-2.9.1*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh --force --nodeps $my_path
		else
			echo @lcannot find the rpm for ibxml2-2.9.1*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	################################################################	
		my_path=$(find /mnt/cdrom -iname "libgpg-error-1.12*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh --force --nodeps $my_path
		else
			echo @cannot find the rpm for libqpg-error-1.12*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	#################################################################
		my_path=$(find /mnt/cdrom -iname "libgcrypt-1.5.3*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh --force --nodeps $my_path
		else
			echo @cannot find the rpm for libgcrypt-1.5.3*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	#################################################################
		my_path=$(find /mnt/cdrom -iname "libxslt-1.1.28*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh --force --nodeps $my_path
		else
			echo @cannot find the rpm for libxslt-1.1.28*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;	
	#################################################################
		my_path=$(find /mnt/cdrom -iname "libstdc++-4.8.2*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh --force --nodeps $my_path
		else
			echo @cannot find the rpm for libstdc++-4.8.2*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	##################################################################	
	##	my_path=$(find /mnt/cdrom -iname "libstdc++-4.8.2*i686*")
	##	if [ "$my_path" != "" ]; then
	##		echo "RPM found"
	##		rpm -ivh --force --nodeps $my_path
	##	else
	##		echo @cannot find the rpm for libstdc++-4.8.2*i686*
	##		echo @check for correct Red Hat installation CD version
	##		exit 1
	##	fi;
	###################################################################	
		my_path=$(find /mnt/cdrom -iname "ncurses-libs-5.9-13*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh --force --nodeps $my_path
		else
			echo @cannot find the rpm for ncurses-libs-5.9-13*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	###################################################################	
		my_path=$(find /mnt/cdrom -iname "ncurses-devel-5.9-13*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh --force --nodeps $my_path
		else
			echo @cannot find the rpm for ncurses-devel-5.9-13*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	###################################################################	
		my_path=$(find /mnt/cdrom -iname "compat-db47-4.7.25*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh --force --nodeps $my_path
		else
			echo @cannot find the rpm for compat-db47-4.7.25*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	####################################################################
		my_path=$(find /mnt/cdrom -iname "nspr-4.10.2*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh --force --nodeps $my_path
		else
			echo @cannot find the rpm for nspr-4.10.2*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	####################################################################	
		my_path=$(find /mnt/cdrom -iname "nss-util-3.15.4*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh --force --nodeps $my_path
		else
			echo @cannot find the rpm for nss-util-3.15.4*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	#####################################################################
		my_path=$(find /mnt/cdrom -iname "readline-6.2-9*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh --force --nodeps $my_path
		else
			echo @cannot find the rpm for readline-6.2-9*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	#####################################################################	
		my_path=$(find /mnt/cdrom -iname "sqlite-3.7.17*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh --force --nodeps $my_path
		else
			echo @cannot find the rpm for sqlite-3.7.17*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	######################################################################	
		my_path=$(find /mnt/cdrom -iname "nss-softokn-3.15.4*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh --force --nodeps $my_path
		else
			echo @cannot find the rpm for nss-softokn-3.15.4*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	######################################################################	
		my_path=$(find /mnt/cdrom -iname "nss-3.15.4*i686*")
		if [ "$my_path" != "" ]; then 
			echo "RPM found"
			rpm -ivh --force --nodeps $my_path
		else
			echo @cannot find the rpm for nss-3.15.4*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	######################################################################	
		my_path=$(find /mnt/cdrom -iname "cyrus-sasl-lib-2.1.26*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"	
			rpm -ivh --force --nodeps $my_path
		else
			echo @cannot find the rpm for cyrus-sasl-lib-2.1.26*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	######################################################################	
		my_path=$(find /mnt/cdrom -iname "libidn-1.28-3*i686*")
		if [ "$my_path" != "" ]; then 
			echo "RPM found"
			rpm -ivh --force --nodeps $my_path
		else
			echo @cannot find the rpm for libidn-1.28-3*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	######################################################################	
		my_path=$(find /mnt/cdrom -iname "libcom_err-1.42.9*i686*")
		if [ "$my_path" != "" ]; then 
			echo "RPM found"	
			rpm -ivh --force --nodeps $my_path
		else
			echo @cannot find the rpm for libcom_err-1.42.9*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	#######################################################################	
		my_path=$(find /mnt/cdrom -iname "openldap-2.4.39*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"	
			rpm -ivh --force --nodeps $my_path
		else
			echo @cannot find the rpm for openldap-2.4.39*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	#######################################################################	
		my_path=$(find /mnt/cdrom -iname "keyutils-libs-1.5.8-3*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"		
			rpm -ivh --force --nodeps $my_path
		else
			echo @cannot find the rpm for keyutils-libs-1.5.8-3*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	#######################################################################	
		my_path=$(find /mnt/cdrom -iname "libselinux-2.2.2*i686*")
		if [ "$my_path" != "" ]; then 
			echo "RPM found"
			rpm -ivh --force --nodeps $my_path
		else
			echo @cannot find the rpm for libselinux-2.2.2*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	#######################################################################	
		my_path=$(find /mnt/cdrom -iname "krb5-libs-1.11.3*i686*")
		if [ "$my_path" != "" ]; then 
			echo "RPM found"
			rpm -ivh --force --nodeps $my_path
		else
			echo @cannot find the rpm for krb5-libs-1.11.3*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	#######################################################################	
	##	my_path=$(find /mnt/cdrom -iname "openssl-1.0.1e*i686*")
	##	if [ "$my_path" != "" ]; then 
	##		echo "RPM found"
	##		rpm -ivh --force --nodeps $my_path
	##	else
	##		echo @cannot find the rpm for openssl-1.0.1e*i686*
	##		echo @check for correct Red Hat installation CD version
	##		exit 1
	##	fi;
	#######################################################################	
		my_path=$(find /mnt/cdrom -iname "openssl098e-0.9.8e-29*i686*")
		if [ "$my_path" != "" ]; then 
			echo "RPM found"
			rpm -ivh --force --nodeps $my_path
		else
			echo @cannot find the rpm for openssl098e-0.9.8e-29*i686*
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	#######################################################################	
		my_path=$(find /mnt/cdrom -iname "libcurl-7.29.0*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh --force --nodeps $my_path
		else
			echo @cannot find the rpm for libcurl-7.29.0-19.el7.i686.rpm
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	#######################################################################	
		my_path=$(find /mnt/cdrom -iname "libssh2-1.4.3*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh --force --nodeps $my_path
		else
			echo @cannot find the rpm for libssh2-1.4.3-8.el7.i686.rpm
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	#######################################################################	
		my_path=$(find /mnt/cdrom -iname "libgcc*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh --force --nodeps $my_path
		else
			echo @cannot find the rpm for libgcc.i686.rpm
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	#######################################################################	
		my_path=$(find /mnt/cdrom -iname "glibc*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh --force --nodeps $my_path
		else
			echo @cannot find the rpm for glibc.el7.i686.rpm
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;	
	#######################################################################	
		my_path=$(find /mnt/cdrom -iname "libgcrypt*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh --force --nodeps $my_path
		else
			echo @cannot find the rpm for libgcrypt.el7.i686.rpm
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;	
	#######################################################################	
		my_path=$(find /mnt/cdrom -iname "libxslt*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh --force --nodeps $my_path
		else
			echo @cannot find the rpm for libxslt.el7.i686.rpm
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	#######################################################################	
		my_path=$(find /mnt/cdrom -iname "openssl*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh --force --nodeps $my_path
		else
			echo @cannot find the rpm for openssl.el7.i686.rpm
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	#######################################################################	
		my_path=$(find /mnt/cdrom -iname "pcre-8.32*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh --force --nodeps $my_path
		else
			echo @cannot find the rpm for pcre-8.32-12.el7.i686.rpm
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
	#######################################################################	
		my_path=$(find /mnt/cdrom -iname "xz-libs-5.1.2*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh --force --nodeps $my_path
		else
			echo @cannot find the rpm for xz-libs-5.1.2-8alpha.el7.i686.rpm
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;	
	#######################################################################	
		my_path=$(find /mnt/cdrom -iname "nss-softokn-freebl-3.15.4*i686*")
		if [ "$my_path" != "" ]; then
			echo "RPM found"
			rpm -ivh --force --nodeps $my_path
		else
			echo @cannot find the rpm for nss-softokn-freebl-3.15.4-2.el7.i686.rpm
			echo @check for correct Red Hat installation CD version
			exit 1
		fi;
		echo @IASC Red Hat 7.0 32 bit rpm installation completed.....!!
		if [ $I == 0 ]; then
		  umount /dev/cdrom
		else
		  umount /dev/cdrom$I
		fi;
	else
      	  	echo @Installation CD  not detected.
			echo @make sure installation CD is not busy or in used.
			echo @suspect mount/unmount installation CD not working.
        	echo @Automation: script stopped.
        	echo 
        	exit 1
	fi;
fi;
		
		
