<?php 
/*****************************************************************************
 *
 *                   INTEL CORPORATION PROPRIETARY INFORMATION
 *       This software is supplied under the terms of a license agreement or
 *       nondisclosure agreement with Intel Corporation and may not be copied
 *       or disclosed except in accordance with the terms of that agreement.
 *            Copyright (c) 2009 Intel Corporation. All Rights Reserved.
 *
 *****************************************************************************/

ini_set("error_reporting", E_ALL & ~E_NOTICE);

// Check for the username
define ("IASC_LOGIN_MAXLEN_USERNAME", 32);
  
/* this happens when a session already exists and user types 
index.htm in browser */
@session_unset ();
@session_destroy ();
    
/* create new session */
@session_start();


if (isset($_REQUEST["username"])) 
{
/*
    $excludeunamechars='/[^a-zA-Z0-9@._]/';

    // remove all suspsect characters - security validation 
    $sIASC_POST_loginname 
        = substr (trim (preg_replace($excludeunamechars, "", 
            $_REQUEST["username"], -1)), 0,IASC_LOGIN_MAXLEN_USERNAME );
 */
    $sIASC_POST_loginname = substr (trim (preg_replace("|[^[:alnum:]_.@]|", "", $_REQUEST["username"])), 0,IASC_LOGIN_MAXLEN_USERNAME ); 
}

if (isset($_REQUEST["password"]))
{
/*
    // a-zA-Z0-9`\-_=+!~#@$*:;.,?&^%
    $excludepwdchars='/[^a-zA-Z0-9`\-_=+!~#@$*:;.,?&\^%]/';

    // all suspsect characters - security validation 
    $sIASC_POST_password 
        = substr (trim (preg_replace($excludepwdchars, "", 
            $_REQUEST["password"], -1)), 0, IASC_LOGIN_MAXLEN_USERNAME); 
*/
    $sIASC_POST_password 
        = substr (trim (preg_replace(
                        "|[^[:alnum:]`_=+!~#@$*:;.,?&^%-]|", 
                        "", $_REQUEST["password"])),
                        0, 
                        IASC_LOGIN_MAXLEN_USERNAME); 
    
}
    
if ((!$sIASC_POST_loginname) && (!$sIASC_POST_password)) 
{
    $retXml='<?xml version="1.0" encoding="UTF-8" standalone="no" ?>
        <Response Operation="get">
        <Status>Error</Status>
        <message>Invalid User Name or Password</message>
        </Response>';
    echo $retXml;
}
else 
{
    //  echo "creating new session info";
    try
    {
        $retVal=InitializeDataManager();

        //error_log("InitializeDataManager RetVal = ".$retVal, 0);

        if($retVal != 0)
        {
            $retXml='<?xml version="1.0" encoding="UTF-8" standalone="no" ?>
                <Response Operation="get">
                <Status>Error</Status>
                <message>Login Failed Try Again</message>
                </Response>';

            echo $retXml;
            return;
        }

        $user=new User();
        $user->setCredentials($sIASC_POST_loginname,$sIASC_POST_password);
        $user->setClient($_SERVER['REMOTE_ADDR']);

        $sess=0;
        $return=LoginAsc($user,$sess);
        if($return == 0)
        {
            $_SESSION["IASC_Session_ID"] = $sess;
            $_SESSION["Username"]= $sIASC_POST_loginname;
            $_SESSION['HTTP_USER_AGENT'] = md5($_SERVER['HTTP_USER_AGENT']);
        }

        if ($return ==0)
            $retXml='<?xml version="1.0" encoding="UTF-8" standalone="no" ?><Response Operation="get"><Status>Successfull</Status></Response>';
        else if ($return ==  -41 )
            $retXml='<?xml version="1.0" encoding="UTF-8" standalone="no" ?><Response Operation="get"><Status>Error</Status><message>Invalid User Name or Password</message></Response>';
        else
            $retXml='<?xml version="1.0" encoding="UTF-8" standalone="no" ?><Response Operation="get"><Status>Error</Status><message>Login Failed Try Again</message></Response>';

        //error_log("Login  = ".$retXml, 0);
        echo $retXml;

    }
    catch(Exception $e)
    {
        error_log("Caught exception: '{e->getMessage()}' in "
                . "{e->getFile()}({e->getLine()})\n"
                . "{e->getTraceAsString()}", 0);

        $retXml='<?xml version="1.0" encoding="UTF-8" standalone="no" ?>
                <Response Operation="get">
                <Status>Error</Status>
                <message>Login Failed Try Again</message>
                </Response>';
        echo $retXml;
        return -70;
    }
}

?>
