/******************************************************************************
*
*                   INTEL CORPORATION PROPRIETARY INFORMATION
*       This software is supplied under the terms of a license agreement or
*       nondisclosure agreement with Intel Corporation and may not be copied
*       or disclosed except in accordance with the terms of that agreement.
*
*            Copyright (c) 2008-2009 Intel Corporation. All Rights Reserved.
*
*       All rights reserved.  No part of this program or publication may be
*       reproduced, transmitted, transcribed, stored in a retrieval system,
*       or translated into any language or computer language, in any form or
*       by any means, electronic, mechanical, magnetic, optical, chemical,
*       manual, or otherwise, without the prior written permission of Intel
*       Corporation.
*
*
*******************************************************************************/
#ifndef __CR_ALLOCATOR_H_
#define __CR_ALLOCATOR_H_


#include <stdio.h>


template<class T> class cr_allocator {
    public:
        //Constructor
        cr_allocator() {
            //printf("cr_allocator c'tor called.\n");
            pointer = (T*)0;

            refCount = 0;
        }

        //Destructor
        ~cr_allocator() {
           // printf("cr_allocator d'tor called.\n");

            if(pointer)
            {
                FREE(pointer);

                pointer = (T*)0;
            }

            refCount=0;
        }

        int get_refCount(void) {
            return refCount;
        }

        void incr_refCount(void){
            refCount++;
        }

        void dec_refCount(void){
            if (refCount!= 0)
                refCount--;
            else
            {
                printf("Error: refCount already zero.\n");
            }
        }

        T* get_pointer(void){
            return pointer;
        }

        void set_pointer(T* aPtr){
            pointer = aPtr;
        }

        static class cr_allocator<T>* create_node(void) {
            class cr_allocator<T>* tmp = new class cr_allocator<T>;

            return tmp;
        }

        static void delete_node(class cr_allocator<T>* aNode){

            if (aNode)
            {
                delete aNode;
            }

            return;
        }


    private:
        int refCount;
        T*  pointer;

};
#endif
