#ifndef __CR_CSTRING_H_
#define __CR_CSTRING_H_
//FIXME:: Illyas
#undef NULL
#define NULL (char*)0

#include <os/include/cr_malloc.h>
#include <string.h>
#include <new>
#include "cr_allocator.h"

#ifdef EFI
extern "C" {
static size_t strnlen(const char *c, const size_t s) {
      return strlen(c);
}
}
#endif

namespace osal_stl {
 class cr_cstring {

public:
    const static int MAX_CR_STRING_LEN=1073741820;
    const static int MIN_CR_STRING_LEN=16;
    const static unsigned int NPOS_LENGTH=4294967295U;

    typedef cr_allocator<char> T;
	typedef char value_type;
	typedef value_type *pointer;
	typedef const value_type *const_pointer;
	typedef value_type & reference;
	typedef const value_type & const_reference;
	typedef size_t size_type;
	typedef size_t difference_type;

	typedef const value_type *const_iterator;
	typedef value_type* iterator;

	typedef iterator InputIterator;

	typedef class reverse_iterator {
    public:
		typedef  cr_allocator<char> T;
		
        typedef  cr_cstring::iterator        iterator;
        typedef  const iterator              const_iterator;
        typedef  cr_cstring::value_type&     reference;
		typedef  const cr_cstring::value_type& const_reference;
        typedef  cr_cstring::size_type       size_type;
        typedef  cr_cstring::difference_type difference_type;

        reverse_iterator() {}
		 explicit reverse_iterator(iterator& itr) : i(itr) {}

        reverse_iterator(const reverse_iterator& ritr) {
            const iterator itr = ritr.get_itr();
            i = itr;
        }

        inline reverse_iterator& operator= (const reverse_iterator& ritr) {
            const iterator itr = ritr.get_itr();
            i = itr;
            return *this;
        }
        
        inline reference operator*() const {
            iterator itr = i;
            return *(--itr);
        }

        inline reverse_iterator& operator++() {
            --i;
            return *this;
        }

        inline reverse_iterator operator++(int) {
            reverse_iterator tmp = *this;
            --i;
            return tmp;
        }

        inline reverse_iterator& operator--() {
            ++i;
            return *this;
        }

        inline reverse_iterator operator--(int) {
            reverse_iterator tmp = *this;
            ++i;
            return tmp;
        }

        inline reverse_iterator operator+(difference_type n) const {
            iterator tmp = (i - n);
            return reverse_iterator(tmp); 
        }

        inline reverse_iterator& operator+=(difference_type n) {
            i -= n;
            return *this;
        }

        inline reverse_iterator operator-(difference_type n) const {
            iterator tmp = (i+n);
            return reverse_iterator(tmp);
        }

        inline reverse_iterator& operator-=(difference_type n) {
            i += n;
            return *this;
        }

        inline reference operator[](difference_type n) const {
            return *(i+n);
        }

        inline const iterator get_itr(void) const {
            return (const iterator) i;
        }
		typedef const reverse_iterator const_reverse_iterator;

	static const size_type npos = (size_type) cr_cstring::NPOS_LENGTH;
	~reverse_iterator() {
        }

    private:
        iterator i;
	}reverse_iterator;
	
typedef const reverse_iterator const_reverse_iterator;

static const size_type npos = (size_type) cr_cstring::NPOS_LENGTH;
       
/* contructor */
	 cr_cstring() {
		 //printf("cr_cstring: calling default constructor.\n");
#ifdef CR_USE_ALLOCATOR
	cr_alloc_ptr  = (cr_allocator<char>*) 0;
#endif
	    c_string = NULL;
	    aloc_capacity = 0;
        copyable = false;

	}
/* contructor */
	 cr_cstring(const char c) {
		/*printf("cr_cstring: const char c constructor\n");*/
#ifdef CR_USE_ALLOCATOR
	cr_alloc_ptr  = (cr_allocator<char>*) 0;
#endif
	    c_string = NULL;
	    aloc_capacity = 0;
        copyable = false;
	    *this = c;
	}	
//end of constructor
/* constructor */
    cr_cstring(const cr_cstring & s, size_t pos = 0, size_t n = npos)
	{
		//printf("cr_cstring: const cr_cstring & s = %s, size_t pos = 0, size_t n = npos constructor.\n", s.c_str());
#ifdef CR_USE_ALLOCATOR
	cr_alloc_ptr  = (cr_allocator<char>*) 0;
#endif
	    c_string = NULL;
	    aloc_capacity = 0;
	    const char *t = s.c_str();
        copyable = false;
	    cat_str(t, pos, n);
	}
/* constructor */
	cr_cstring(const char *s, size_t pos = 0, size_t n = npos) {
		//printf("cr_cstring: const char *s = %s, size_t pos = 0, size_t n = npos constructor\n", s);
#ifdef CR_USE_ALLOCATOR
	cr_alloc_ptr  = (cr_allocator<char>*) 0;
#endif
	    c_string = NULL;
	    aloc_capacity = 0;
        copyable = false;
	    cat_str(s, pos, n);
	}
/* operator += overloading */
	/*Equivalent to append(cstr1)*/
	inline cr_cstring & operator+=(const cr_cstring & cstr1) {
	    cat_str(cstr1.c_str(), 0, cstr1.length());
	    return *this;
	}	//end of += overloading

/* operator += overloading */
/*Equivalent to append(cstr1)*/
	inline cr_cstring & operator+=(const char *cstr) {
	    cat_str(cstr, 0, npos);
	    return *this;
	}			//end of += overloading

/* operator += overloading */
	/*Equivalent to push_back(c)*/
	inline cr_cstring & operator+=(const char c) {
	    char t[4] = { 0 };
	    t[0] = c;
	    cat_str(t, 0, 1);
	    return *this;
	}			//end of += overloading

	/* operator = overloading */
  /*  Assign a single character to a string.*/
	inline cr_cstring & operator=(char c) {
	    if (c_string)
		c_string[0] = 0;

	    char t[4] = { 0 };
	    t[0] = c;
	    cat_str(t, 0, npos);

	    return *this;
	}			//end of = overloading

	/* operator = overloading */
	/*Assign a null-terminated character array to a string.*/
	inline cr_cstring & operator=(const char* cstr) {
		//printf("%s function called.\n", __FUNCTION__);
	    if (c_string)
		c_string[0] = 0;

	    cat_str(cstr, 0, npos);

	    return *this;
	}			//end of = overloading

	/* operator = overloading */
   /* Assignment operator*/
	inline cr_cstring & operator=(const cr_cstring& cstr) {
#ifdef CR_USE_ALLOCATOR
		if (cr_alloc_ptr && cr_alloc_ptr->get_refCount() > 1)
			{
				cr_alloc_ptr->dec_refCount();
			}
		//First Clear
        if (c_string)
		{
			 if (cr_alloc_ptr && cr_alloc_ptr->get_refCount() == 1)
			 {
			FREE(c_string);
			c_string = NULL;
		}
		}
		cr_alloc_ptr  = cstr.cr_alloc_ptr;

		if(cr_alloc_ptr)
		{
			cr_alloc_ptr->incr_refCount();
			c_string = cr_alloc_ptr->get_pointer();
		}
		
		aloc_capacity = cstr.capacity();
#else
        if (cstr.get_copyable()) {

            const char* tmp = cstr.c_str();
            this->set_string(tmp);

        } else  {

            if (c_string)
                c_string[0] = 0;

            cat_str(cstr.c_str(), 0, npos);
        }
#endif

	    return *this;
	}	//end of = overloading
		
//Returns the character at 'n'th place
   inline reference operator[] (size_t n) {

	    return at(n);
	}

	inline const_reference operator[] (size_type n) const {
		const_iterator ci = begin();
		if (n < length())
			return (const_reference) *(ci + n);

		return (const_reference)*ci;
	}

	~cr_cstring() {

#ifdef CR_USE_ALLOCATOR
			if (cr_alloc_ptr && cr_alloc_ptr->get_refCount() >= 1)
			{
				cr_alloc_ptr->dec_refCount();
			}
#endif

		//printf("In cr_cstring destructor:\n");
	    if (c_string) {

#ifdef CR_USE_ALLOCATOR
			if(cr_alloc_ptr && cr_alloc_ptr->get_refCount() == 0)
			{
#endif
				/* if its used then dont free */
				if (!copyable)
				{
					//printf("In cr_cstring destructor: freeing string.\n");
					FREE(c_string);
				}

				c_string = NULL;
				aloc_capacity = 0;
#ifdef CR_USE_ALLOCATOR
			}
#endif
	    }

	}

	inline reference at(size_type n) {
#ifdef CR_USE_ALLOCATOR
	check_modify_allocator();
#endif
        
		if (n >= length()) {
			resize(n+1);
		}

		iterator ci = begin();
		return (reference) * (ci + n);
	}

	
	inline const size_t capacity(void) const {
	    return (size_t) ((aloc_capacity == 0) ? 0 : aloc_capacity - 1);
	}
	inline const char *c_str(void) const {
	    return c_string;
	} 
	inline const char *data(void) const {
	    return c_string;
	} 
    
    inline size_t size(void) const {
	    return length();
	}

	inline size_t length(void) const {
	    size_t len = 0;
	    if (c_string) {
            len = strnlen(c_string, cr_cstring::MAX_CR_STRING_LEN);
	    }

	    return len;
	}

	inline bool empty(void) const {
	    bool res = false;
	    if (length() == 0) {
		res = true;
	    }

	    return res;
	}

	inline const size_t max_size(void) const {
	    return (size_t) cr_cstring::MAX_CR_STRING_LEN;
	}
	
    inline cr_cstring substr(size_t pos = 0, size_t n = npos) const {
	    return cr_cstring(*this, pos, n);
	}

//Copies a sequence of characters from the string content to the array pointed by s. 
	inline size_t copy(char *buf, size_t n = npos, size_t pos = 0) const {
       size_t tn = 0;
	   if (buf != NULL && c_string != NULL) {
			size_t len = strnlen(c_string, cr_cstring::MAX_CR_STRING_LEN);
			if (pos <= len) {
				if ((pos + n) <= len)
				tn = n;
				else
				tn = len - pos;
				memcpy(buf, c_string + pos, tn);
			}
	    }

	    return tn;
	}
 
	inline int compare(const char *s) const {
	    if (s != NULL && c_string != NULL) {
			return strncmp(c_string, s, cr_cstring::MAX_CR_STRING_LEN);
	    }

	    return -1;
	}

	inline int compare(const cr_cstring & s) const {
	    return compare(s.c_str());
	}

	inline int compare(size_type pos, size_type n, const cr_cstring & s) const {
	    cr_cstring t;
	     t.assign(*this, pos, n);
	     return t.compare(s);
	}

	/*Erases a sequence of n characters starting at position pos.*/
inline cr_cstring & erase(size_t pos = 0, size_t n = npos) {
	#ifdef CR_USE_ALLOCATOR
	check_modify_allocator();
#endif
		if (c_string != NULL) {	
			size_t len = 0;

			len = strnlen(c_string, cr_cstring::MAX_CR_STRING_LEN);
	    
			size_t rem=0;

			if (pos <= len) {
				if ((pos + n) > len)
					n = len - pos;

				rem = len - (pos + n);

				if (rem) {
					memmove(c_string + pos, c_string + pos + n, rem);
				}

				c_string[pos + rem] = 0;
			}
#ifdef CR_USE_ALLOCATOR
	 if(cr_alloc_ptr->get_refCount() == 1)
	    {
		    /* set the vector pointer */
		    cr_alloc_ptr->set_pointer(c_string);
	    }
#endif
		}


	    return *this;
	}
inline void clear(void) {
	    erase(0, npos);
	}

	inline size_t find(const char *str, size_t pos = 0) const {
	    size_t ret = npos;
	    if (str != NULL && c_string != NULL) {
			//printf("c_string+pos = %s\n", (c_string+pos));
			//printf("str = %s\n", str);
		char *rptr = strstr(c_string + pos, str);
		//printf("rptr = %x\n", (int)rptr);

		if (rptr != NULL) {
			//printf("rptr was not NULL\n");
			//printf("rptr = %x c_string = %x\n", (int)rptr, (int)c_string);
		     ret = (rptr - c_string);
		}
	    }
		//printf("In find: returning size_t = %d\n", ret);
	    return ret;
	}

	inline size_t find(const cr_cstring & s, size_t pos = 0) const {
	    return find(s.c_str(), pos);
	} 
    
    inline size_type find(const char *s, size_type pos, size_type n) const {
	    cr_cstring t(s);
	     t.resize(n);
	     return find(t.c_str(), pos);
	} 
    
    inline size_type find(char c, size_type pos = 0) const {
	    cr_cstring t(c);
	     return find(t.c_str(), pos);
	} 

//Searches the string for the content specified in either str, s or c, and 
//returns the position of the last occurrence in the string

    inline size_type rfind(const char* s, size_type pos, size_type n) const{
        cr_cstring t;
        for (const_iterator i = end() - 1; i != begin() - 1; i--) {
            t += *i;
        } 
        
        if (pos > t.size()) {
            pos = 0;
        } else {
            pos = t.size() - pos;
        }

        cr_cstring ts;
        size_type sn = strnlen(s, cr_cstring::MAX_CR_STRING_LEN);
        sn = sn - (sn-n);
        for(size_type i = sn; i != -1; i--) {
            ts += s[i];
        }

        size_type pos1 = t.find(ts.c_str(), pos);
        if (pos1 != npos) {
            pos1 = length() - pos1 - sn;
        }

        return pos1;
    }

    inline size_type rfind(const cr_cstring& s, size_type pos = npos) const {
        return rfind(s.c_str(), pos, s.length());
    }

    inline size_type rfind(const char* s, size_type pos = npos) const {
        return rfind(s, pos, strnlen(s, cr_cstring::MAX_CR_STRING_LEN));
    }

    inline size_type rfind(char c, size_type pos = npos) const {
        cr_cstring t = c;
        return rfind(t.c_str(), pos, t.length());
    }
    
	/*Searches the string for any of the characters that are part of either str, s or c, 
		and returns the position of the first occurrence in the string.*/


    inline size_type find_first_of(const char *s, size_type pos, size_type n) const {
	    size_type pos1 = npos;
		//printf("%s function called with pos = %d\n", __FUNCTION__, pos);
	    if (c_string != NULL && pos <= length()) {
			cr_cstring t;
			t.assign(s, n);

			char *c = strpbrk(c_string + pos, t.c_str());

			if (c != NULL) {
				pos1 = (c - begin());
			}
	    }
	    return pos1;
	}

	inline size_type find_first_of(const cr_cstring & s, size_type pos =
				       0) const {
	    return find_first_of(s.c_str(), pos, s.length());
	} 
    
    inline size_type find_first_of(const char *s, size_type pos = 0) const {
	    return find_first_of(s, pos, strnlen(s, cr_cstring::MAX_CR_STRING_LEN));
	} 
    
    inline size_type find_first_of(char c, size_type pos = 0) const {
	    size_type pos1 = npos;
	    if (c_string != NULL && pos <= length()) {
		char *t = strchr(c_string + pos, c);
		if (t != NULL) {
		    pos1 = (t - begin());
		}
	    }
	    return pos1;
	}
//Searches for the first character in the object which is not part of either 
//str, s or c, and returns its position.


	inline size_type find_first_not_of(const char *s, size_type pos,
					   size_type n) const {
	    size_type pos1 = npos;
	    if (c_string != NULL && pos <= length()) {
			cr_cstring t;
			t.assign(s, n);
			size_type i;
			for(i=0; i < (length()-pos);i++)
			{
				bool matched = false;
				for(size_type j=0; j < strlen(s); j++)
				{
					if(*(c_string+pos+i) != *(s+j))
						continue;

					matched = true;
					break;
				}

				if (matched == false)
					break;
			}

			if (i != (length()-pos))
				pos1 = pos + i;
	    }
	    return pos1;
	}

	inline size_type find_first_not_of(const char *s, size_type pos =
					   0) const {
	    return find_first_not_of(s, pos,
				     strnlen(s, cr_cstring::MAX_CR_STRING_LEN));
	} 
    
    inline size_type find_first_not_of(const cr_cstring & s,
					     size_type pos = 0) const {
	    return find_first_not_of(s.c_str(), pos, s.length());
	} 
    
    inline size_type find_first_not_of(char c, size_type pos = 0) const {
	    cr_cstring t;
	     t = c;
	     return find_first_not_of(t.c_str(), pos, 1);
	} 
    
    inline size_type find_last_of(const char *s, size_type pos,
					size_type n) const {
	    cr_cstring t;
	    for (const_iterator i = end() - 1; i != begin() - 1; i--) {
		t += *i;
	    } if (pos > t.size()) {
		pos = 0;
	    } else {
		pos = t.size() - pos;
	    }

	    size_type pos1 = t.find_first_of(s, pos, n);
	    if (pos1 != npos) {
		pos1 = length() - (pos1 + 1);
	    }
	    return pos1;
	}

	inline size_type find_last_of(const char *s, size_type pos = npos) const {
	    return find_last_of(s, pos, strnlen(s, cr_cstring::MAX_CR_STRING_LEN));
	} 
    
    inline size_type find_last_of(char c, size_type pos = npos) const {
	    cr_cstring t;
	     t = c;
	     return find_last_of(t.c_str(), pos, 1);
	} 
    
    inline size_type find_last_of(const cr_cstring & s,
					size_type pos = npos) const {
	    return find_last_of(s.c_str(), pos, s.length());
	} 
    
    inline size_type find_last_not_of(const char *s, size_type pos,
					    size_type n) const {
	    cr_cstring t;
	    for (const_iterator i = end() - 1; i != begin() - 1; i--) {
		t += *i;
	    } if (pos > t.size()) {
		pos = 0;
	    } else {
		pos = t.size() - pos;
	    }

	    size_type pos1 = t.find_first_not_of(s, pos, n);
	    if (pos1 != npos) {
		pos1 = length() - (pos1 + 1);
	    }
	    return pos1;
	}

	inline size_type find_last_not_of(const char *s, size_type pos =
					  npos) const {
	    return find_last_not_of(s, pos, strnlen(s, cr_cstring::MAX_CR_STRING_LEN));
	} 
    
    inline size_type find_last_not_of(char c, size_type pos = npos) const {
	    cr_cstring t;
	     t = c;
	     return find_last_not_of(t.c_str(), pos, 1);
	} 
    
    inline size_type find_last_not_of(const cr_cstring & s,
					    size_type pos = npos) const {
	    return find_last_not_of(s.c_str(), pos, s.length());
	} 
    
    inline iterator begin(void) {
#ifdef CR_USE_ALLOCATOR
	check_modify_allocator();
#endif
	    if (c_string)
		return &c_string[0];
	    else
		return NULL;
	}

	inline iterator end(void) {
#ifdef CR_USE_ALLOCATOR
	check_modify_allocator();
#endif
	    if (c_string)
		return &c_string[length()];
	    else
		return NULL;
	}

	inline const_iterator begin(void) const {

	    if (c_string)
		return (const_iterator) & c_string[0];
	    else
		return (const_iterator) NULL;
	} 
    
    inline const_iterator end(void) const {
	    if (c_string)
		return (const_iterator) & c_string[length() + 1];
	    else
		return (const_iterator) NULL;
	} 

    reverse_iterator rbegin(void) {
        iterator tmp = end();
        return reverse_iterator(tmp);
    }

    reverse_iterator rend(void) {
        iterator tmp = begin();
        return reverse_iterator(tmp);
    }

	inline void swap(cr_cstring & s) {
#ifdef CR_USE_ALLOCATOR
	check_modify_allocator();
#endif
	    cr_cstring t = s;
	    s = c_string;
	    *this = t;
	}

	inline void push_back(value_type c) {
#ifdef CR_USE_ALLOCATOR
	check_modify_allocator();
#endif
	    *this += c;
	}

	inline void resize(size_type n, char c = char ()) {
#ifdef CR_USE_ALLOCATOR
	check_modify_allocator();
#endif
        size_type len = size();

        if ((len!=n) && (n <= cr_cstring::MAX_CR_STRING_LEN)) {

            if (len < n) {
                //size_type aloc = n+1;

                //c_string = (pointer) REALLOC(c_string, aloc);
                //aloc_capacity = aloc;
                reserve(n);

                pointer tmp = c_string+len;
                for (size_type i = len; i < n; i++) {
                    memcpy(tmp, &c, sizeof(value_type));
                    tmp++;
                }

                c_string[n] = (value_type)0;
            } else {

                if (n == 0) {
                    if(c_string) {
                        FREE(c_string);
                    }

                    c_string = NULL;
                    aloc_capacity = 0;
                }
                else {
                    c_string[n] = (value_type)0;
                }
             }

#ifdef CR_USE_ALLOCATOR
	 if(cr_alloc_ptr->get_refCount() == 1)
	    {
		    /* set the vector pointer */
		    cr_alloc_ptr->set_pointer(c_string);
	    }
#endif
		}
	}

	inline cr_cstring & assign(const cr_cstring & s) {
	    *this = s;

	    return *this;
	}

	inline cr_cstring & assign(const cr_cstring & s, size_type pos,
				  size_type n) {
	    cr_cstring t(s, pos, n);
	    *this = t;

	    return *this;
	}

	inline cr_cstring & assign(const char *s, size_type n) {
	    cr_cstring t(s, 0, n);
	    *this = t;
	    return *this;
	}

	inline cr_cstring & assign(const char *s) {
	    cr_cstring t(s);
	    *this = t;
	    return *this;
	}
	inline cr_cstring & assign(size_type n, char c) {
	    resize(0);
	    resize(n, c);
	    return *this;
	}
	inline cr_cstring & assign(InputIterator first, InputIterator last) {
	    resize(0);

	    for (InputIterator i = first; i != last; i++) {
			*this += *i;
	    }

	    return *this;
	}
//inserts s before pos
	inline cr_cstring & insert(size_type pos, const char *s) {
#ifdef CR_USE_ALLOCATOR
	check_modify_allocator();
#endif
	    if (pos >= 0 && pos <= length()) {
              size_type len = size();
              size_type n = strnlen(s, cr_cstring::MAX_CR_STRING_LEN);

              len += n;

              if (len >= capacity()) reserve(len);

              /* move string from pos n char away */
		      memmove(c_string + pos + n, c_string + pos, n);

              //for (size_type i = 0; i < n; i++)
                //c_string[pos+i] = s[i];
              memcpy(c_string + pos, s, n);
 
            //cr_cstring t;
            //t.assign(begin(), begin() + pos);
            //t += s;

            //if (pos < length()) {
            //    t.cat_str(c_string + pos, 0, (length() - pos));
            //}
            //*this = t;
	    }
#ifdef CR_USE_ALLOCATOR
	    if(cr_alloc_ptr->get_refCount() == 1)
	    {
		    /* set the vector pointer */
		    cr_alloc_ptr->set_pointer(c_string);
	    }
#endif
	    return *this;
	}

	/*Inserts the first n characters of s before pos*/
inline cr_cstring & insert(size_type pos, const char *s,
				  size_type n) {
#ifdef CR_USE_ALLOCATOR
	check_modify_allocator();
#endif
	    if (pos >= 0 && pos <= length()) {
              size_type len = size();
              len += n;

              if (len >= capacity()) reserve(len);

              /* move string from pos n char away */
		      memmove(c_string + pos + n, c_string + pos, size()-pos + 1);

              //for (size_type i = 0; i < n; i++)
                //c_string[pos+i] = s[i];
              memcpy(c_string + pos, s, n);
            
//            cr_cstring t;
//            t.assign(begin(), begin() + pos);

//            t.cat_str(s, 0, n);

//            if (pos < length()) {
//                t.cat_str(begin() + pos, 0, (length() - pos));
//            }

//            *this = t;
	    }
#ifdef CR_USE_ALLOCATOR
	    if(cr_alloc_ptr->get_refCount() == 1)
	    {
		    /* set the vector pointer */
		    cr_alloc_ptr->set_pointer(c_string);
	    }
#endif
	    return *this;
	}

//Inserts s before pos
inline cr_cstring & insert(size_type pos, const cr_cstring & s) {
	    return insert(pos, s.c_str());
	}

//Inserts a substring of s before pos.
	inline cr_cstring & insert(size_type pos, const cr_cstring & s,
				  size_type pos1, size_type n) {
#ifdef CR_USE_ALLOCATOR
	check_modify_allocator();
#endif
	    if (pos >= 0 && pos <= length()) {
              size_type len = size();
              len += n;

              if (len >= capacity()) reserve(len);

              /* move string from pos n char away */
		      memmove(c_string + pos + n, c_string + pos, size()-pos+1);

              //for (size_type i = 0; i < n; i++)
              //  c_string[pos+i] = s[pos1+i];
              memcpy(c_string + pos, s.c_str() + pos1, n);
 
            //cr_cstring t;
            //t.assign(begin(), begin() + pos);

            //t.cat_str(s.begin() + pos1, 0, n);

            //if (pos < length()) {
            //    t.cat_str(begin() + pos, 0, (length() - pos));
            //}
            //*this = t;
	    }
#ifdef CR_USE_ALLOCATOR
	    if(cr_alloc_ptr->get_refCount() == 1)
	    {
		    /* set the vector pointer */
		    cr_alloc_ptr->set_pointer(c_string);
	    }
#endif
	    return *this;
	}
//Inserts n copies of c before pos.
inline cr_cstring & insert(size_type pos, size_type n, char c) {
	    cr_cstring t;
	    t.resize(n, c);
	    return insert(pos, t.c_str());
	}


//Appends a copy of str. 

inline cr_cstring & append(const char *s) {
#ifdef CR_USE_ALLOCATOR
	check_modify_allocator();
#endif

	    *this += s;
#ifdef CR_USE_ALLOCATOR
	    if(cr_alloc_ptr->get_refCount() == 1)
	    {
		    /* set the vector pointer */
		    cr_alloc_ptr->set_pointer(c_string);
	    }
#endif
	    return *this;
	}

//Appends a copy of the string formed by the first n characters in the array of characters pointed by s. 
 inline cr_cstring & append(const char *s, size_type n) {
	    size_type len = length();
	    *this += s;
	    resize(len + n);
	    return *this;
	}

//Appends a copy of str. 
	inline cr_cstring & append(const cr_cstring & s) {
	    return append(s.c_str());
	}

//Appends a copy of a substring of str. The substring is the portion of str that begins at the 
//character position pos and takes up to n characters
	inline cr_cstring & append(const cr_cstring & s, size_type pos,
				  size_type n) {
	    return append((s.c_str() + pos), n);
	}

	//Appends a string formed by the repetition n times of character c. 

	inline cr_cstring & append(size_type n, char c) {
	    cr_cstring t;
	    t.resize(n, c);
	    return append(t.c_str());
	}

	inline cr_cstring & append(InputIterator first, InputIterator last) {
	    cr_cstring t;
	    t.assign(first, last);
	    return append(t.c_str());
	}

//The section is replaced by a copy of the string formed by the first n2 
//characters in the array of characters pointed by s. 

inline cr_cstring & replace(size_type pos, size_type n,
				   const char *s, size_type n1) {
#ifdef CR_USE_ALLOCATOR
	check_modify_allocator();
#endif
	    size_type len = (n > n1 ? (n - n1) : (n1 - n));
        if ((len+size()) >= capacity()) reserve(len+size());


        if (n <= n1)
        {
            /* first replace till n */
            memcpy(c_string+pos, s, n);

            /* some chars need to be inserted */
            len = n1 - n;
            if (len)
            {
                insert(pos+n, s+n, len);
            }
        }
        else
        {
            /* first replace till n1 */
            memcpy(c_string+pos, s, n1);

            /* some chars need to be erased */
            len = n - n1;
            erase(pos+n1, len);
        }
#ifdef CR_USE_ALLOCATOR
	    if(cr_alloc_ptr->get_refCount() == 1)
	    {
		    /* set the vector pointer */
		    cr_alloc_ptr->set_pointer(c_string);
	    }
#endif
	    return *this;
	}
//The section is replaced by a copy of the entire string object s
inline cr_cstring & replace(size_type pos, size_type n,
				   const cr_cstring & s) {
	    return replace(pos, n, s.c_str(), s.length());
	}

	inline cr_cstring & replace(size_type pos, size_type n,
				   const cr_cstring & s, size_type pos1,
				   size_type n1) {
        return replace(pos, n, s.c_str()+pos1, n1);
	}

	//The section is replaced by a copy of the string formed by the null-terminated character sequence 
	inline cr_cstring & replace(size_type pos, size_type n,
				   const char *s) {
	    return replace(pos, n, s, strnlen(s, cr_cstring::MAX_CR_STRING_LEN));
	}

	inline cr_cstring & replace(size_type pos, size_type n,
				   size_type n1, char c) {
	    cr_cstring t;
	    t.resize(n1, c);
	    return replace(pos, n, t);
	}

	inline cr_cstring & replace(iterator first, iterator last,
				   const char *s, size_type n) {
        size_type len = (size_type)(first - c_string);
        size_type n1 = (size_type)(last - first);
        return replace(len, n1, s, n);
	}

	inline cr_cstring & replace(iterator first, iterator last,
				   const cr_cstring & s) {
	    return replace(first, last, s.c_str(), s.length());
	}

	/*The section is replaced by a copy of the string formed by the null-terminated character sequence pointed by s*/
	inline cr_cstring & replace(iterator first, iterator last,
				   const char *s) {
	    return replace(first, last, s, strnlen(s, cr_cstring::MAX_CR_STRING_LEN));
	}


	inline cr_cstring & replace(iterator first, iterator last,
				   size_type n, char c) {
	    cr_cstring t;
	    t.resize(n, c);
	    return replace(first, last, t);
	}

	inline void reserve(size_t n) {
#ifdef CR_USE_ALLOCATOR
	check_modify_allocator();
#endif

	    if ((n != this->size()) && (n < MAX_CR_STRING_LEN)) {
    
            n = n<MIN_CR_STRING_LEN? MIN_CR_STRING_LEN: n;

            if (n < this->size())
                n = this->size();

            if ( (n >= this->capacity()) && (n < (2 * this->capacity())) )
                n = 2 * this->capacity();

            c_string = (char *) REALLOC(c_string, n + 1);
		 if(c_string == (char*)0)
		{
			printf("ERROR:: Unable to Malloc memory in file %s at line %d\n",__FILE__,__LINE__);
		}


            if (aloc_capacity == 0)
                c_string[0] = 0;

            aloc_capacity = n + 1;
	    } else {
		//cout << "Error:: n value asked is > than max string size."
		//    << endl;
	   }

	}
	inline void cat_str(const char *c, size_t pos, size_t n) {
#ifdef CR_USE_ALLOCATOR
	check_modify_allocator();
#endif
	    if (c != NULL) {
            size_t oldlen = size();
            size_t len1 = strnlen(c, cr_cstring::MAX_CR_STRING_LEN);

            if (n == npos) {
                n = len1;
            }

            if (pos <= len1) {
                size_t tn;
                if ((pos + n) <= len1)
                    tn = n;
                else
                    tn = len1 - pos;

                if (tn > 0) {
                    size_t alloc = oldlen + tn;

                    /* check for >= because we need to consider null character */
                    if (alloc >= this->capacity())
                        reserve(alloc);

                    memcpy(c_string + oldlen, c + pos, tn);
                    c_string[oldlen + tn] = 0;
                }
            }
#ifdef CR_USE_ALLOCATOR
	    if(cr_alloc_ptr->get_refCount() == 1)
	    {
		    /* set the vector pointer */
		    cr_alloc_ptr->set_pointer(c_string);
	    }
#endif
	    }
	}			//end of cat_str()

public:
     bool get_copyable(void) const { return copyable; }
     void set_copyable(void) { copyable = true; }
     const char* get_string() const { return c_string; }
     void  set_string(const char* s) const {
        if (this->c_string) FREE(this->c_string);
        /* force a copy */
        memcpy((void*)&c_string, (void*)&s, sizeof(char*));
     }
     bool copyable;
private:
	char  *c_string;
	size_type aloc_capacity;

private: 
#ifdef CR_USE_ALLOCATOR
	void check_modify_allocator(void) {
		/* check if allocator is already malloc'd */
		if (cr_alloc_ptr != 0)
		{
			/* allocator already malloc'd */
			if (cr_alloc_ptr->get_refCount() < 0)
			{
				printf("Error: refCount is < 0\n");
				exit(0);
			}

			/* check if more than one reference is present */
			if (cr_alloc_ptr->get_refCount() > 1)
			{
				/* create a new alloc_ptr, copy the contents and 
				 * decrement the old reference and increment the new
				 * reference count */
				cr_allocator<char>* tmp = cr_allocator<char>::create_node();

				/* malloc the size of string and copy */
				pointer tmpPtr = (pointer) MALLOC((size()+1) * sizeof(T));
				if (tmpPtr == NULL)
				{
					printf("Error: unable to malloc.\n");
					exit(0);
				}

				pointer oldPtr = cr_alloc_ptr->get_pointer();

				/* copy old memory to new */
				memcpy( (void*)tmpPtr, (void*)oldPtr, ((size()+1)*sizeof(T)) );

				cr_alloc_ptr->dec_refCount();
				tmp->incr_refCount();

				/* set the copied memory as the new pointer */
				tmp->set_pointer(tmpPtr);

				/* use the tmp as the new aloc_ptr */
				cr_alloc_ptr = tmp;

				/* set the string pointer to the new ptr */
				c_string = cr_alloc_ptr->get_pointer();

			}
		}
		else
		{
			/* allocator is not malloc'd */
			cr_alloc_ptr = cr_allocator<char>::create_node();

			/* This will set refCount to 1 */
			cr_alloc_ptr->incr_refCount();
		}
	}
	/*end of check_modify_allocator()*/
#endif

	private:
 size_type   aloc_size;

 

#ifdef CR_USE_ALLOCATOR
protected:
    cr_allocator<char>* cr_alloc_ptr;  

#endif

};
	typedef class cr_cstring cr_cstring;
	//static inline ostream& operator<<(ostream & os, const cr_cstring & s) {
//return os << s.c_str();
//}

//static inline istream& operator>>(istream & is, cr_cstring & s) {
//char c[cr_cstring::MAX_CR_LINE_LEN] = { 0 };
//s = c;
//cr_cstring::iterator cstr = s.begin();
//is >> cstr;
//return is;
//}

//static inline istream & getline(istream & is, cr_cstring & s) {
//char c[cr_cstring::MAX_CR_LINE_LEN] = { 0 };

//is.getline(c, cr_cstring::MAX_CR_LINE_LEN);
//s = c;

//return is;
//}

static inline cr_cstring operator+(const cr_cstring & s1,
                  const cr_cstring & s2) {
cr_cstring t(s1);
t += s2;
#if 0
cr_cstring t;
cr_cstring::size_type len = s1.size() + s2.size();
t.reserve(len);
t.append(s1);
t.append(s2);
t.set_copyable();

/* check if the passed string is copyable */
if (s1.get_copyable())
{
    const char* t1 = s1.get_string();
    /* force free this string */
    s1.set_string(t1);    
}
#endif

return t;
}

static inline cr_cstring operator+(const char *s1, const cr_cstring & s2) {
cr_cstring t(s1);
t += s2;
#if 0
cr_cstring t;
cr_cstring::size_type len = strnlen(s1, cr_cstring::MAX_CR_STRING_LEN);
len += s2.size();
t.reserve(len);
t.append(s1);
t.append(s2);
#endif
return t;
}

static inline cr_cstring operator+(const cr_cstring & s1, const char *s2) {
cr_cstring t(s1);
t += s2;
#if 0
cr_cstring t;
cr_cstring::size_type len = strnlen(s2, cr_cstring::MAX_CR_STRING_LEN);
len += s1.size();
t.reserve(len);
t.append(s1);
t.append(s2);
t.set_copyable();

/* check if the passed string is copyable */
if (s1.get_copyable())
{
    const char* t1 = s1.get_string();
    s1.set_string(t1);    
}
#endif

return t;
}

static inline cr_cstring operator+(char c, const cr_cstring & s2) {
char tt[4] = { 0 };
tt[0] = c;
cr_cstring::size_type len = s2.size();
cr_cstring t;
t.reserve(len+1);
t.append(tt);
t.append(s2);
return t;
}

static inline cr_cstring operator+(const cr_cstring & s1, char c) {
char tt[4] = { 0 };
tt[0] = c;
cr_cstring::size_type len = s1.size();
cr_cstring t;
t.reserve(len+1);
t.append(s1);
t.append(tt);
return t;
}

static inline bool operator==(const cr_cstring & s1,
              const cr_cstring & s2) {
return ((strncmp(s1.c_str(), s2.c_str(), cr_cstring::MAX_CR_STRING_LEN) ==
     0) ? true : false);
}

static inline bool operator==(const char *s1, const cr_cstring & s2) {
return ((strncmp(s1, s2.c_str(), cr_cstring::MAX_CR_STRING_LEN) ==
     0) ? true : false);
}

static inline bool operator==(const cr_cstring & s1, const char *s2) {
return ((strncmp(s1.c_str(), s2, cr_cstring::MAX_CR_STRING_LEN) ==
     0) ? true : false);
}

static inline bool operator!=(const cr_cstring & s1, const cr_cstring & s2) {
return ((strncmp(s1.c_str(), s2.c_str(), cr_cstring::MAX_CR_STRING_LEN) !=
     0) ? true : false);
}

static inline bool operator!=(const char *s1, const cr_cstring & s2) {
return ((strncmp(s1, s2.c_str(), cr_cstring::MAX_CR_STRING_LEN) !=
     0) ? true : false);
}

static inline bool operator!=(const cr_cstring & s1, const char *s2) {
return ((strncmp(s1.c_str(), s2, cr_cstring::MAX_CR_STRING_LEN) !=
     0) ? true : false);
}

static inline bool operator<(const cr_cstring & s1,
             const cr_cstring & s2) {
return ((strncmp(s1.c_str(), s2.c_str(), cr_cstring::MAX_CR_STRING_LEN) <
     0) ? true : false);
}

static inline bool operator<(const char *s1, const cr_cstring & s2) {
return ((strncmp(s1, s2.c_str(), cr_cstring::MAX_CR_STRING_LEN) <
     0) ? true : false);
}

static inline bool operator<(const cr_cstring & s1, const char *s2) {
return ((strncmp(s1.c_str(), s2, cr_cstring::MAX_CR_STRING_LEN) <
     0) ? true : false);
}

static inline bool operator<=(const cr_cstring & s1,
             const cr_cstring & s2) {
return ((strncmp(s1.c_str(), s2.c_str(), cr_cstring::MAX_CR_STRING_LEN) <=
     0) ? true : false);
}

static inline bool operator<=(const char *s1, const cr_cstring & s2) {
return ((strncmp(s1, s2.c_str(), cr_cstring::MAX_CR_STRING_LEN) <=
     0) ? true : false);
}

static inline bool operator<=(const cr_cstring & s1, const char *s2) {
return ((strncmp(s1.c_str(), s2, cr_cstring::MAX_CR_STRING_LEN) <=
     0) ? true : false);
}

static inline bool operator>(const cr_cstring & s1,
             const cr_cstring & s2) {
return ((strncmp(s1.c_str(), s2.c_str(), cr_cstring::MAX_CR_STRING_LEN) >
     0) ? true : false);
}

static inline bool operator>(const char *s1, const cr_cstring & s2) {
return ((strncmp(s1, s2.c_str(), cr_cstring::MAX_CR_STRING_LEN) >
     0) ? true : false);
}

static inline bool operator>(const cr_cstring & s1, const char *s2) {
return ((strncmp(s1.c_str(), s2, cr_cstring::MAX_CR_STRING_LEN) >
     0) ? true : false);
}

static inline bool operator>=(const cr_cstring & s1,
             const cr_cstring & s2) {
return ((strncmp(s1.c_str(), s2.c_str(), cr_cstring::MAX_CR_STRING_LEN) >=
     0) ? true : false);
}

static inline bool operator>=(const char *s1, const cr_cstring & s2) {
return ((strncmp(s1, s2.c_str(), cr_cstring::MAX_CR_STRING_LEN) >=
     0) ? true : false);
}

static inline bool operator>=(const cr_cstring & s1, const char *s2) {
return ((strncmp(s1.c_str(), s2, cr_cstring::MAX_CR_STRING_LEN) >=
     0) ? true : false);
}

static inline bool operator==(const cr_cstring::reverse_iterator& x, const cr_cstring::reverse_iterator& y) {
    return (x.get_itr()==y.get_itr());
}

static inline bool operator!=(const cr_cstring::reverse_iterator& x, const cr_cstring::reverse_iterator& y) {
    return (x.get_itr()!=y.get_itr());
}

static inline bool operator<(const cr_cstring::reverse_iterator& x, const cr_cstring::reverse_iterator& y) {
    return (x.get_itr()<y.get_itr());
}

static inline bool operator<=(const cr_cstring::reverse_iterator& x, const cr_cstring::reverse_iterator& y) {
    return (x.get_itr()<=y.get_itr());
}

static inline bool operator>(const cr_cstring::reverse_iterator& x, const cr_cstring::reverse_iterator& y) {
    return (x.get_itr()>y.get_itr());
}

static inline bool operator>=(const cr_cstring::reverse_iterator& x, const cr_cstring::reverse_iterator& y) {
    return (x.get_itr()>=y.get_itr());
}


}
#endif
