var questionsArray = [];
var cardsArray = [];

$(document).ready(function() {
	entryPoint();
});

//Game-specific initialization
function init(){
	$('#ajax-cont').html('<div id="cardPile"> </div><div id="questions"> </div>');
	$('#cardPile').droppable({
		accept: '.card',
		drop: function (even,ui) { 
			ui.draggable.draggable( 'option', 'revert', false );
			$slot = $('.slot[card="' + ui.draggable.text() + '"]');
			$slot.attr('card', '');
			$slot.parent().removeClass('correct incorrect show');
		},
		out: handleCardOut,
		hoverClass: 'hovered'
	});

	$(gameXMLDOM).find('MultipleAnswerQuestionItem').each(function (qIndex, question) {
		var answers = [];
		$(question).find('Answer').each(function(aIndex, answer) {
			answers.push($(answer).text());
			cardsArray.push({
				text: $(answer).text(),
				audio: $(answer).attr('url')
			});
		});
		questionsArray.push({
			'question': $(question).find('Question').text(),
			'answers': answers
		});
	});
}

//Should return the number of pages
function getPagesCount() {
	return 1;
}

//Game-specific reset procedure
function reset() {
	$('#cardPile').html( '' );
	$('#questions').html( '' );

	cardsArray.sort( function() { return Math.random() - 0.5; } );
	$.each(cardsArray, function (cIndex, card) {
		$('#cardPile').append('<div class="card">' + card.text + '</div>');
		if (card.audio !== undefined) {
			$('#cardPile .card:nth-child(' + (cIndex + 1) + ')').append($(getAudioCode(card.audio)));
			processPlayer($('#cardPile .card:nth-child(' + (cIndex + 1) + ') .audio'));
		}
		$('#cardPile .card:nth-child(' + (cIndex + 1) + ')').draggable({
			stack: '#cardPile div',
			cursor: 'move',
			revert: true,
			cancel: '.audio'
		});
	});
	
	$.each(questionsArray, function (qIndex, question) {
		var answers = '';
		$.each(question.answers, function(aIndex, answer) {
			answers += '<div class="slot-wrap"><div class="slot" card></div><img id="incorrect-icon" src="images/icon-incorrect.png"/><img id="correct-icon" src="images/icon-correct.png"/></div>';
		});
		
		var $newQuestion = $('<div class="question" id="' + qIndex + '">' + question.question + answers + '</div>');
		$newQuestion.find('.slot').droppable({
			accept: '.card',
			hoverClass: 'hovered',
			drop: handleCardDrop,
			out: handleCardOut
		});
		$('#questions').append($newQuestion);
	});
}

function handleCardDrop( event, ui ) {
	if ($(this).attr('card') === '' || $(this).attr('card') === undefined) {
		$slot = $('.slot[card="' + ui.draggable.text() + '"]');
		$slot.attr('card', '');
		$slot.parent().removeClass('correct incorrect show');
		$(this).attr('card', ui.draggable.text());
		
		ui.draggable.draggable( 'option', 'revert', false );
		ui.draggable.position({ of: $(this), my: 'center center', at: 'center center' });
	}
}

function handleCardOut (event, ui) {
	ui.draggable.draggable( 'option', 'revert', true );
}

//If there are several pages, page loading handler
function getPage(pageNumber){
	
}

//When Check Answers button is pressed
function onCheckPageAnswer() {
	$('.slot[card!=""]').each(function () {
		$(this).parent().removeClass('correct incorrect');
		if ($.inArray($(this).attr('card'), questionsArray[parseInt($(this).closest('.question').attr('id'), 10)].answers) !== -1) {
			$(this).parent().addClass( 'correct' );
		} else {
			$(this).parent().addClass( 'incorrect' );
		}
	});
	$('.slot-wrap.correct').addClass('show');
	$('.slot-wrap.incorrect').addClass('show');
}

//The score values to be displayed after the game finish
//returns: {percentage: , points: , total: }
function getScore() {
	var questions = [];
	var answers = [];
	var corrects = [];
	var points = [];
	var totals = [];
	var gamePoints = 0;
	var gameTotal = 0;
	
	$('#questions .question').each(function (qIndex, question) {
		var answer = '';
		var qPoints = 0;
		var qTotal = 0;
		
		questions.push(questionsArray[qIndex].question);
		
		$(question).find('.slot-wrap').each(function(sIndex, slotWrap) {
			var card = $(slotWrap).find('.slot').attr('card');
			if (card !== undefined) {
				answer += '<li>' + card + '</li>';
			}
			
			if ($(slotWrap).hasClass('correct')) {
				qPoints++;
				gamePoints ++;
			}
			qTotal++;
			gameTotal++;
		});
		answers.push('<ul>' + answer + '</ul>');
		
		var correct = '';
		$.each(questionsArray[qIndex].answers, function(aIndex, answer) {
			correct += '<li>' + answer + '</li>';
		});
		corrects.push('<ul>' + correct + '</ul>');
		
		points.push(qPoints);
		totals.push(qTotal);
	});
	
	return {
		'questions': questions,
		'answers': answers,
		'corrects': corrects,
		'points': points,
		'totals': totals,
		'gamePoints': gamePoints,
		'gameTotal': gameTotal
	};
}

//Audio file, if available
function getAudio() {
        return $(gameXMLDOM).find('Audio > URL').text();
}