var pageIndex;
var pages = [];

$(document).ready(function() {
	entryPoint();
});

//Game-specific initialization
function init(){
	$(gameXMLDOM).find('OrderedQuestionItems').each(function (qIndex, question) {
		var cards = [];
		$(question).find('OrderedQuestionItem').each(function(cardIndex, card) {
			cards.push($(card).text());
		});
		
		pages.push({ cards: cards, score: 0, audio: $(question).find('Audio > URL').text() });
	});
}

function getPagesCount() {
	return pages.length;
}

//If there are several pages, page loading handler
function getPage(pageNumber){
	pageIndex = pageNumber;
	$('#ajax-questions .question').hide();
	$('#ajax-questions .question:nth-child(' + (pageNumber + 1) + ')').show();
}

function getAudio () {
	return pages[pageIndex].audio;
}

//When Check Answers button is pressed
function onCheckPageAnswer(page) {
	if (typeof(page) !== 'number') {
		page = pageIndex;
	}
	
	$('#ajax-questions .question:nth-child(' + (page + 1) + ') #sortable li').each(function (index) {
		$(this).removeClass('incorrect');
		$(this).removeClass('correct');
		
		if ($(this).text() !== pages[page].cards[index]) {
			$(this).addClass('incorrect');
		} else {
			$(this).addClass('correct');
		}
	});
	$('#ajax-questions .question:nth-child(' + (page + 1) + ') #sortable').addClass('show');
}

//Game-specific reset procedure
function reset() {
	$('.question').remove();
	
	$.each(pages, function (pIndex, page) {
		var cards = pages[pIndex].cards.slice();
		cards.sort(function() { return Math.random() - 0.5; });
		$question = $('<div class="question"></div>');
		$pile = $('<ul id="sortable"></ul>');
		$.each(cards, function (cIndex, card) {
			$pile.append($('<li class="ui-state-default">' + card + '<img id="incorrect-icon" src="images/icon-incorrect.png" /><img id="correct-icon" src="images/icon-correct.png"/></li>'));
		});
		$question.append($pile);
		$('#ajax-questions').append($question);
		$('#ajax-questions .question:nth-child(' + (pIndex + 1) + ') #sortable').sortable({
			placeholder: "ui-state-highlight"
		}).disableSelection();
	});
	
	$('.question').hide();
}

//The score values to be displayed after the game finish
//returns: {percentage: , points: , total: }
function getScore() {
	var questions = [];
	var answers = [];
	var corrects = [];
	var points = [];
	var totals = [];
	var gamePoints = 0;
	var gameTotal = 0;
	
	$('#ajax-questions .question').each(function(qIndex, question) {
		questions.push('');
		
		var answer = '';
		$(question).find('#sortable li').each(function() {
			answer += $(this).text() + ' ';
		});
		answers.push(answer);
		
		var correct = '';
		$.each(pages[qIndex].cards, function(cIndex, card) {
			correct += card + ' ';
		});
		corrects.push(correct);
		
		var score = $(question).find('#sortable li.correct').length;
		points.push(score);
		gamePoints += score;
		var total = pages[qIndex].cards.length;
		totals.push(total);
		gameTotal += total;
	});
	
	return {
		'questions': questions,
		'answers': answers,
		'corrects': corrects,
		'points': points,
		'totals': totals,
		'gamePoints': gamePoints,
		'gameTotal': gameTotal
	};
}