var orient;
var navCount;
var content;
var pageCount;
var currentPage=0;

$(document).ready(function(){
	window.onresize = textScale;
	init();
});

function init() {
	//do some init junk
	$('#home-link').click(function(){
		mainNav_Home();
	});
	$('#back-link').click(function(){
		mainNav_Back()
	});

	//set the click to work on navDiv
	$('.navBox').live('click', '.navBox', function(){
		var target = $(this).attr('navTarget');
		if(target){
			window.location.href=target;
		}
	});

	//if there is no manifest file do the upper level interface spacing
	if(typeof(manifest_in) === 'undefined'){
		doSizing();
	}
	//manifest found, assume tmpl and populate and space accordingly
	else{
		readManifest(12,4);
		//put manifest into template
		$.template("panelTemplate", $("#tmpl-panel").text());
    	$.tmpl("panelTemplate", content).appendTo("#slider");
    	//calculate spacing as above
    	doSizing(12,4);
	}
}

function doSizing(itemsPerPage, cols){
	//count the rows
	if(itemsPerPage == null){
		var rowCount = $('.navRow').length;
		$('.navRow').css('height', (100/rowCount) + '%');
	}
	else{
		rowsPerPage = itemsPerPage / cols;
		$('.navRow').css('height', (100/rowsPerPage) + '%');
	}

	//count the boxes per row , then base widths on longest row
	var mostBoxes = 0;
	$('.navRow').each(function(){
		var boxesInRow = $(this).find('.navBox').length;
		mostBoxes = (boxesInRow > mostBoxes) ? boxesInRow : mostBoxes;
	});
	if (mostBoxes > 4){
		var margin = 3; 
	}
	else{
		var margin = 6;
	}
	var availWidth = 99;
	availWidth -= (margin * (mostBoxes - 1)); //acccount for the right margin;
	//set up widths based on count & margins
	var eachWidth = availWidth / mostBoxes; //(99 / navCount) - (leftMargin * navCount) + "%";
	$('.navBox').css('width', eachWidth + "%");
	$('.navBox').css('margin-left', margin + "%");

	//set the margin from the first in each row to zero
	$('.navRow').each(function(){
		var boxesInRow = $(this).find('.navBox').first().css('margin-left','0%');
	});
}

function toObject(arr) {
  var rv = {};
  for (var i = 0; i < arr.length; ++i)
    if (arr[i] !== undefined) rv[i] = arr[i];
  return rv;
}

function readManifest(itemsPerPage, cols){

	var content_type = $('#header-secondary-text').text().toLowerCase();
	console.log(typeof(manifest_in));

	manifest_in = getObjects(manifest_in, content_type, 'true');

	console.log(typeof(manifest_in));

	//rejig the manifest into paged array
	rowsPerPage = itemsPerPage / cols;
	var itemCount = manifest_in.length;
	pageCount = Math.ceil(itemCount / itemsPerPage);

	console.log(itemCount);

	//set up data structure with empty pages
	content = {};
	content.page = {};
	for(var i=0; i<pageCount; i++){
		content.page[i] = {row: {}};
		//add n rows
		for(var j=0; j<rowsPerPage; j++){
			content.page[i].row[j] = {};
			for(var k=0; k<cols; k++){
				content.page[i].row[j] = {element:{}};
			}
		}
	}
	//fill the data structure
	for (var i in manifest_in){
		var page = Math.floor(i/itemsPerPage);
		var row = (Math.floor(i / cols))-(rowsPerPage*(page));
		var elem = i % cols;
		content.page[page].row[row].element[elem] = manifest_in[i];
	}
}

function textScale() {
    //will use this later - not for bett
    if (window.innerWidth > window.innerHeight){
    	orient = "landscape";
    }
    else{
    	orient = "portrait"
    }
    var scaleSource = $('body').width();
    var scaleFactor = .10;
    var maxScale    = 200;
    var minScale    = 50;
    // Multiply the width of the body by the scaling factor
    var fontSize = scaleSource * scaleFactor; 
    //Enforce the minimum and maximums
    if (fontSize > maxScale) fontSize = maxScale;
    if (fontSize < minScale) fontSize = minScale; 
    $('#bod').css('font-size', fontSize + '%');
}

function mainNav_Home(){
	//handle main nav bar, home
	window.location.href='index.html';
}
//change this to back as per daves stuff
function mainNav_Back(){
	//handle main nav bar, back	
	history.go(-1);
}

$(window).load(function(){
	//initial scale
	textScale();
	//** if slider exists
	if(typeof(manifest_in) !== 'undefined'){
		doDragSlide('.sliderHolder');
	}
	
});

function doDragSlide(selector){

	//set up the page counter
	$('#footer').append('<div id="pageCounter"></div>');
	for(var i=0; i<pageCount; i++){
		$('#pageCounter').append('<div class="pageOff"></div>');
	}

	//handle arrows
	pageCount > 1? $('#rightArrow').show() : null;

	var c = $('#leftRightPad_bc');
	var s = $('#slider');
	var p = $('.page');
	s.width(c.width()*pageCount);
	p.width(c.width());

	var cx1 = 0 - (c.width() * (pageCount -1));
	var cy1 = c.offset().top;
	var cx2 = c.offset().left;
	var cy2 = c.offset().top;

	var panRight = true;

	//set opacity
	s.find('.page').css('opacity', 0.3);
	var a = s.find('.page')[currentPage];
	$(a).css('opacity', 1);

	//set the page counter
	$($('#pageCounter').find('div')[currentPage]).removeClass('pageOff').addClass('pageOn');

	s.draggable({
		axis: 'x',
		containment: [cx1, cy1, cx2, cy2],
		revert: false,
		start: function(event, ui){
      		xpos = ui.position.left;
		},
		stop: function(event, ui){
      		var xmove = ui.position.left - xpos;
      		console.log(xmove);
     		// define the moved direction: right(when positive), left(when negative)
	      	var xd = xmove > 0 ? 'right' : 'left';
			//if dragged far enough then move it
	      	if (Math.abs(xmove) > 60){
	      		//if dragged left
				if (xd == 'left'){
	      			if(!$(this).is(':animated')){

	      				var a = s.find('.page')[currentPage];
	      				$(a).animate({opacity:0.3}, 600);
						var a = s.find('.page')[currentPage+1];
						$(a).animate({opacity: 1}, 400);

	      				var pos = -((currentPage+1) * c.width());
						$(this).stop().animate({
							left: pos
						}, 1200, 'swing', function(){
							//on complete
		      				currentPage ++;
	      					(currentPage + 1) < pageCount? $('#rightArrow').show() : $('#rightArrow').hide();
	      					(currentPage) > 0? $('#leftArrow').show() : $('#leftArrow').hide();
	      					$($('#pageCounter').find('div')[currentPage-1]).removeClass('pageOn').addClass('pageOff');
	      					$($('#pageCounter').find('div')[currentPage]).removeClass('pageOff').addClass('pageOn');
						});

					}
				}//if dragged right
				else{
		      		if(!$(this).is(':animated')){

	      				var a = s.find('.page')[currentPage];
	      				$(a).animate({opacity:0.3}, 600);
						var a = s.find('.page')[currentPage-1];
						$(a).animate({opacity: 1}, 400);

		      			var pos = -((currentPage -1) * c.width());
						$(this).stop().animate({
							left: pos
						}, 1200, 'swing', function(){
							//on complete
				      		currentPage --;
				      		(currentPage + 1) < pageCount? $('#rightArrow').show() : $('#rightArrow').hide();
				      		(currentPage) > 0? $('#leftArrow').show() : $('#leftArrow').hide();
				      		$($('#pageCounter').find('div')[currentPage+1]).removeClass('pageOn').addClass('pageOff');
	      					$($('#pageCounter').find('div')[currentPage]).removeClass('pageOff').addClass('pageOn');
						});
					}
				}
	      	}
	      	else{
	      		//else manually revert

      			var pos = -(currentPage * c.width());
				s.animate({left: pos}, 400);
			
				
	      	}
		}
	});
}
	function getObjects(obj, key, val) {
		var objects = [];
		for (var i in obj) {
			if (!obj.hasOwnProperty(i)) continue;
			if (typeof obj[i] == 'object') {
				objects = objects.concat(getObjects(obj[i], key, val));
			} else if (i == key && obj[key] == val) {
				objects.push(obj);
			}
		}
		return objects;
	}
// pflynnx added
	function show_content(title)
	{
		if (isAndroid())
		{
			location.href="template.html?title=" + title;	
		}
		else
		{	
			window.external.showarea=title;
			location.href="template.html";	
		}
	}
	function isAndroid()
	{
		var ua = navigator.userAgent.toLowerCase();
		var isAndroid = ua.indexOf("android") > -1;
		return isAndroid;
	}