var ReorderingVertical = function(container){
	this.pageIndex;
	this.pages = [];
	this.gameDisplayOptions = 0;
	this.container = container;
	this.gameXMLDOM;
}

// starts everything
ReorderingVertical.prototype.init = function(gameXMLDOM){
	console.log('init ReorderingVertical');
	this.gameXMLDOM = gameXMLDOM;
	this.container.find("#sortable")
		.sortable({
			placeholder: "ui-state-highlight"
		})
		.disableSelection();
	var obj = this;
	$(this.gameXMLDOM).find('OrderedQuestionItems').each(function (qIndex, question) {
		var cards = [];
		$(question).find('OrderedQuestionItem').each(function(cardIndex, card) {
			cards.push({ text: $(card).text(), correct: cardIndex });
		});
		
		obj.pages.push({ cards: cards, audio: $(question).find('Audio > URL').text() });
	});
}

ReorderingVertical.prototype.getPage = function(pageNumber) {
	this.pageIndex = pageNumber;
	this.container.find('.question').hide();
	this.container.find('.question:nth-child(' + (pageNumber + 1) + ')').show();
}

ReorderingVertical.prototype.getPagesCount = function() {
	return this.pages.length;
}

ReorderingVertical.prototype.getAudio = function() {
	//return this.pages[this.pageIndex].audio;
}

ReorderingVertical.prototype.reset = function() {
	this.container.find('.question').remove();
	var obj = this;
	$.each(this.pages, function (pIndex, page) {
		var cards = obj.pages[pIndex].cards.slice();
		cards.sort(function() { return Math.random() - 0.5; });
		$question = $('<div class="question"></div>');
		$pile = $('<ul id="sortable"></ul>');
		$.each(cards, function (cIndex, card) {
			$pile.append($('<li class="ui-state-default" id=' + card.correct + '>' + card.text + '<img id="incorrect-icon" src="images/icon-incorrect.png" /><img id="correct-icon" src="images/icon-correct.png"/></li>'));
		});
		$question.append($pile);
		obj.container.find('#ajax-questions').append($question);
		
		obj.container.find('#ajax-questions .question:nth-child(' + (pIndex + 1) + ') #sortable').sortable({
			placeholder: "ui-state-highlight"
		}).disableSelection();
	});
	
	
	this.container.find('.question').hide();
}

ReorderingVertical.prototype.onCheckPageAnswer = function(page){
	if (typeof(page) !== 'number') {
		page = this.pageIndex;
	}
	
	$('#ajax-questions .question:nth-child(' + (page + 1) + ') #sortable li').removeClass('incorrect');
	$('#ajax-questions .question:nth-child(' + (page + 1) + ') #sortable li').removeClass('correct');
	
	$('#ajax-questions .question:nth-child(' + (page + 1) + ') #sortable li').each(function (index) {
		if (parseInt($(this).attr('id'), 10) !== index) {
			$(this).addClass('incorrect');
		} else {
			$(this).addClass('correct');
		}
	});
	$('#ajax-questions #sortable').addClass('show');
}

ReorderingVertical.prototype.getScore = function() {
	var questions = [];
	var answers = [];
	var corrects = [];
	var points = [];
	var totals = [];
	var gamePoints = 0;
	var gameTotal = 0;
	
	var obj = this;
	this.container.find('#ajax-questions .question').each(function(qIndex, question) {
		var answer = '';
		var qPoints = 0, qTotal = 0;
		
		questions.push('');
		
		$(question).find('#sortable li').each(function(lIndex, item) {
			answer += '<li>' + $(item).text() + '</li>';
			if ($(item).hasClass('correct')) {
				qPoints ++;
			}
			qTotal ++;
		});
		answers.push('<ul>' + answer + '</ul>');
		
		var correct = '';
		$.each(obj.pages[qIndex].cards, function (cIndex, card) {
			correct += '<li>' + card.text + '</li>';
		});
		corrects.push('<ul>' + correct + '</ul>');
		
		points.push(qPoints);
		totals.push(qTotal);
		gamePoints += qPoints;
		gameTotal += qTotal;
	});
	
	return {
		'questions': questions,
		'answers': answers,
		'corrects': corrects,
		'points': points,
		'totals': totals,
		'gamePoints': gamePoints,
		'gameTotal': gameTotal
	};
}