var TrueOrFalse = function(container){

	this.pageIndex;
	this.questionsArray = [];
	this.gameDisplayOptions = 0;

	this.container = container;
	this.gameXMLDOM;

}

//Game-specific initialization
TrueOrFalse.prototype.init = function(gameXMLDOM){
	console.log('init TrueOrFalse');
	this.gameXMLDOM = gameXMLDOM;
	//TrueOrFalse with each question on a separate page is equivalent to MultipleChoice game style
	if (this.gameDisplayOptions == 0) {
		//$('head link[href="css/TrueOrFalse.css"]').remove();
		//$('<link/>', { rel: 'stylesheet', type: 'text/css', href: 'css/MultipleChoice.css'}).appendTo('head');
		//$.getScript('js/MultipleChoice.js');
		return;
	}
	
	this.container.find('#ajax-questions').html('<ul></ul>');
	
	var defaultOptions = '';
	$(this.gameXMLDOM).find('GlobalOptions > Option').each(function(index, Element) {
		defaultOptions +=
			'<a class="options" href="javascript:void(0)" value='+$(this).attr('value')+' onclick="answerQuestion(this)">' +
				'<span>' + $(this).text() + '</span>' +
			'</a>';
	});

	var obj = this;
	$(this.gameXMLDOM).find('MultipleChoiceQuestionItem').each(function(key, Element) {
		$options = $(this).find('Option');
		var options = '';
		
		if ($options.length !== 0) {
			$options.each(function (oIndex, option) {
				options +=
					'<a class="options" href="javascript:void(0)" value="' + $(option).attr('value') + '" onclick="answerQuestion(this)">' + 
						'<span>' + $(option).text() + '</span>' +
					'</a>';
			});
		} else {
			options = defaultOptions;
		}
		
		obj.questionsArray.push({
			question: $(this).find('Question').text(),
			options: options,
			correct: $(this).find('Answer').text()
		});
	});
}

//Should return the number of pages
TrueOrFalse.prototype.getPagesCount = function() {
	return 1;
}

//If there are several pages, page loading handler
TrueOrFalse.prototype.getPage = function(pageNumber){
	
}

//Audio file, if available
TrueOrFalse.prototype.getAudio = function() {
	return '';
}

//When Check Answers button is pressed
TrueOrFalse.prototype.onCheckPageAnswer = function() {
	$('#ajax-questions li').each(function() {
		var $thisQuestion = $(this);
		var answered = $thisQuestion.attr('answered');
		var answer = $thisQuestion.data('answer');
		$thisQuestion.removeClass('correct');
		$thisQuestion.removeClass('incorrect');
		if (answer === answered) {
			$thisQuestion.addClass('correct');
		} else {
			$thisQuestion.addClass('incorrect');
		}
	});
}

//Game-specific reset procedure
TrueOrFalse.prototype.reset = function() {
	var $questionList = this.container.find('#ajax-questions ul');
	$questionList.empty();
	$.each(this.questionsArray, function (key, question) {
		var domString =
			'<li id="' + (key + 1) + '" class="items">' +
				'<span class="question">' + question.question + '</span>' +
				'<div class="btn-group">' + question.options + '</div>' +
			'</li>';
		var $domString = $(domString).data('answer', question.correct);
		$questionList.append($domString);
		console.log('-------');
		console.log($domString);
		console.log($questionList);

	});
}

//The score values to be displayed after the game finish
//returns: {percentage: , points: , total: }
TrueOrFalse.prototype.getScore = function() {
	var questions = [];
	var answers = [];
	var corrects = [];
	var points = [];
	var totals = [];
	var gamePoints = 0;
	var gameTotal = 0;
	
	$('#ajax-questions .items').each(function(qIndex, question) {
		questions.push($(question).find('.question').text());
		
		answers.push($(question).find('.btn-group .options.selected').text());
		
		corrects.push($(question).find('.btn-group .options[value="' + $(question).data('answer') + '"]').text());
		
		if ($(question).hasClass('correct')) {
			points.push(1);
			gamePoints ++;
		} else {
			points.push(0);
		}
		totals.push(1);
		gameTotal++;
	});
	
	return {
		'questions': questions,
		'answers': answers,
		'corrects': corrects,
		'points': points,
		'totals': totals,
		'gamePoints': gamePoints,
		'gameTotal': gameTotal
	};
}

TrueOrFalse.prototype.answerQuestion = function(dom) {
	$dom = $(dom);
	$dom.siblings().removeClass('selected');
	$dom.addClass('selected');
	$dom.parents('li').attr('answered', $dom.attr('value'));
}
