var rollOver_1 = function (params) {
	var parentContainer = params.container;
	var templateUIName = params.templateUI;
	var xmlType = Number(params.templateXMLTYPE);
	var domType = Number(params.templateUIType);
	var xmlObj;
	var xmlData = params.xmlData;
	var titleText;
	var bodyText = [];
	var promptText = [];
	var rectTitle = [];
	var rectDescription = [];
	var rollTitle = [];
	var rollDescription = [];
	var btnTitle = [];
	var labelText;
	var curBoxIndex;
	var previousElement = "";
	var curURL = "component/Templates/" + templateUIName + ".html";
	var _this = this;
	var inclinedLineText;
	this.create = function () {
		readXMLTexts();
	}

	this.init = function () {
		isNextPrevBtn = "true";
		var tmpStr = "";
		$(contentContainer)
			.load(curURL, function () {
			$(".indexTitle")
				.html(titleText);
			$(".explainBlock")
				.hide();
			$(".pageTxt")
				.empty();
			for (var i = 0; i < bodyText.length; i++) {
				tmpStr += bodyText[i];
				tmpStr += "<br/><br/>";
			}
			$(".pageTxt")
				.append(tmpStr);
			tmpStr = "";
			for (var j = 0; j < promptText.length; j++) {
				var numStr = (j + 1) + "."
				var str = promptText[j].replace(numStr, "");
				tmpStr += '<li>' + str + '</li>'
			}
			$(".thermalBox")
				.find('ul')
				.empty();
			$(".thermalBox")
				.find('ul')
				.append(tmpStr);
			$(".thermalBox")
				.show();
			checkDOMType();
			createGlossary();
		});
	}

// used to find the  template ui

	function checkDOMType() {
		switch (domType) {
		case 1:
			displayTexts1();
			break;
		case 2:
			displayTexts2();
			break;
		case 3:
		case 4:
			displayTexts3();
			break;
		case 5:
			displayTexts4();
			break;
		}
	}


	function displayTexts1() {
		var k = 0;
		$(".boxarea")
			.children()
			.each(function (i, j) {
			$(this)
				.find(".innerTxt")
				.html("<b>" + rectTitle[k] + "</b>");
			$(this)
				.find(".innerTxt")
				.parent()
				.attr('id', "box_" + k);
			$("#box_" + k)
				.addClass("cursorPointer");
			$("#box_" + k)
				.on('click', onClick);
			k++;
		});
	}



	function displayTexts2() {
		var k = 0;
		$(".boxarea")
			.children()
			.each(function (i, j) {
			if ($(this)
				.hasClass("singleBox")) {
				$(this)
					.find(".innerTxt")
					.html('<b>' + rectTitle[k] + '</b>')
				$(this)
					.attr('id', "box_" + k);
				if (isIPAD) {
					$("#box_" + k)
						.on('touchstart', onTouchStart);
				}
				else {
					$("#box_" + k)
						.on('mouseover', onMouseOver);
					$("#box_" + k)
						.on('mouseout', onMouseOut);
				}
				k++;
			}
		});
	}



	function displayTexts3() {
		var k = 0;
		$(".phaser3Space")
			.children()
			.each(function (i, j) {
			$(this)
				.find(".innerTxt")
				.html('<b>' + rectTitle[k] + '</b>');
			$(this)
				.attr('id', "box_" + k);
			if (isIPAD) {
				$("#box_" + k)
					.on('touchstart', onTouchStart);
			}
			else {
				$("#box_" + k)
					.on('mouseover', onMouseOver);
				$("#box_" + k)
					.on('mouseout', onMouseOut);
			}
			k++;
		});
	}



	function displayTexts4() {
		var k = 0;
		$(".xAxisTxt")
			.html(inclinedLineText);
		$(".boxarea")
			.children()
			.each(function (i, j) {
			$(this)
				.removeClass('active');
			$(this)
				.find(".innerTxt")
				.html("<b>" + rectTitle[k] + "</b>");
			$(this)
				.find(".innerTxt")
				.parent()
				.attr('id', "box_" + k);
			$("#box_" + k)
				.addClass("cursorPointer");
			$("#box_" + k)
				.on('click', onClick);
			k++;
		});
		
		if (isIPAD) {
				$(".explainBlock")
					.find('h1:eq(1)')
					.on('touchstart', showOverText);
				$(".innerExplorer_ex")
					.on('touchstart', hideOverText);
		}
		else {
				$(".explainBlock")
					.find('h1:eq(1)')
					.on('click', showOverText);
				$(".innerExplorer_ex")
					.on('click', hideOverText);
		}
		
		
	}



	function onMouseOver(e) {
		var curID = $(this)
			.attr('id');
		var index = curID.split('_')[1];
		showRollOverText(index);
		$(this)
			.addClass('active');
		$(this)
			.find('.singleBox')
			.addClass('active');
		$(".explainBlock")
			.show();
	}



	function onMouseOut(e) {
		$(this)
			.find('.singleBox')
			.removeClass('active');
		$(this)
			.removeClass('active');
		$(".explainBlock")
			.hide();
	}
	/*******For roll over popup*************/



	function showOverText() {
		$(".innerExplorer_ex")
			.find('h3')
			.html(rollTitle[curBoxIndex]);
		$(".innerExplorer_ex")
			.find('p:eq(1)')
			.empty();
		$(".innerExplorer_ex")
			.find('p:eq(0)')
			.html(rollDescription[curBoxIndex]);
		$(".innerExplorer_ex")
			.show();
	}



	function hideOverText() {
		$(".innerExplorer_ex")
			.hide();
	}
	/*******End*******/



	function onTouchStart(e) {
		var curID = $(this)
			.attr('id');
		var index = curID.split('_')[1];
		if (previousElement != curID) {
			$("#" + previousElement)
				.removeClass('active');
			$(".explainBlock")
				.hide();
		}
		$(this)
			.toggleClass('active');
		previousElement = $(this)
			.attr('id');
		showRollOverText(index);
		$(".explainBlock")
			.toggle();
	}



	function onClick(e) {
		hideOverText();
		var curID = $(this)
			.attr('id');
		var index = curID.split('_')[1];
		curBoxIndex = index;
		if (previousElement != curID) {
			$("#" + previousElement)
				.removeClass('active');
			$(".explainBlock")
				.hide();
		}
		$(this)
			.toggleClass('active');
		previousElement = $(this)
			.attr('id');
		showRollOverText(index);
		$(".explainBlock")
			.toggle();
	}



	function showRollOverText(index) {
		if (xmlType == 1 || xmlType == 2) {
			$(".explainBlock")
				.find('h1')
				.empty();
			$(".explainBlock")
				.find('h1')
				.html(rectTitle[index]);
			$(".explainBlock")
				.find('p')
				.html(rectDescription[index]);
		}
		else if (xmlType == 3) {
			$(".explainBlock")
				.find('h1')
				.empty();
			$(".explainBlock")
				.find('p')
				.html(rectDescription[index]);
		}
		else if (xmlType == 4) {
			$(".explainBlock")
				.find('h1:eq(0)')
				.empty();
			$(".explainBlock")
				.find('h1:eq(0)')
				.html(rectTitle[index]);
			$(".explainBlock")
				.find('p')
				.html(rectDescription[index]);
			$(".explainBlock")
				.find('h1:eq(1)')
				.empty();
			$(".explainBlock")
				.find('h1:eq(1)')
				.html(btnTitle[index]);
		}
		createGlossary();
	}



	function checkXMLType(xmlType) {
		switch (xmlType) {
		case 1:
			getrollOverXMLTexts1();
			break;
		case 2:
			getrollOverXMLTexts2();
			break;
		case 3:
			getrollOverXMLTexts3();
			break;
		case 4:
			getrollOverXMLTexts4();
			break;
		}
		var preloads = new Preloads(_this, 0, 0, "init");
		preloads.create();
	}



	function createGlossary() {
		$(".glossaryClick")
			.unbind('click');
		$(".glossaryClick")
			.bind("click", function (e) {
			glossoryForWords($(this));
		})
	}



	function removeTextsFromString(str, searchStr) {
		var index = str.indexOf(searchStr);
		var str1;
		var str2;
		while (index != -1) {
			index = str.indexOf(searchStr);
			if (index > -1) {
				endIndex = searchStr.length + index;
				str1 = str.substring(0, index);
				str2 = str.substring(endIndex, str.length);
				str = str1 + str2;
			}
		}
		return str;
	}


	// reads xmlvariation and handle the xml type 
	function readXMLTexts() {
		var tempText;
		$(xmlData)
			.find('p')
			.each(function (i, j) {
			if ($(this)
				.attr('id') == "title_text_1") {
				titleText = $(j)
					.text();
			}
			else if ($(this)
				.attr('id')
				.indexOf("body_text") == 0) {
				tempText = $(j)
					.text();
				tempText = removeTextsFromString(tempText, "[extra]");
				tempText = removeTextsFromString(tempText, "[/extra]");
				tempText = tempText.replaceAll('href="event:', 'class="glossaryClick" href="#event:')
				bodyText.push(tempText);
			}
			else if ($(this)
				.attr('id')
				.indexOf('prompt_text') > -1) {
				var str = $(j)
					.text();
				tempText = str.split("<br><br>");
				for (var i = 0; i < tempText.length; i++) {
					promptText.push(tempText[i]);
				}
			}
		});
		checkXMLType(xmlType);
	}



	function getrollOverXMLTexts1() {
		$(xmlData)
			.find('btn')
			.each(function (i, j) {
			if ($(this)
				.attr('id')
				.indexOf("click") > -1) {
				var text1 = $(this)
					.next()
					.text();
				var text2 = $(this)
					.next()
					.next()
					.text();
				text2 = text2.replaceAll('href="event:', 'class="glossaryClick" href="#event:')
				rectTitle.push(text1);
				rectDescription.push(text2);
			}
		});
	}



	function getrollOverXMLTexts2() {
		$(xmlData)
			.find('btn')
			.each(function (i, j) {
			if ($(this)
				.attr('id')
				.indexOf("roll") > -1) {
				var text1 = $(this)
					.next()
					.text();
				var text2 = $(this)
					.next()
					.next()
					.text();
				rectTitle.push(text1);
				rectDescription.push(text2);
			}
		});
		$(xmlData)
			.find('p')
			.each(function (i, j) {
			if ($(this)
				.attr('id') == "label_text_5") {
				rectTitle.push(labelText);
			}
		});
	}



	function getrollOverXMLTexts3() {
		$(xmlData)
			.find('btn')
			.each(function (i, j) {
			if ($(this)
				.attr('id')
				.indexOf("roll") > -1) {
				var text1 = $(this)
					.text();
				var text2 = $(this)
					.next()
					.text();
				rectTitle.push(text1);
				rectDescription.push(text2);
			}
		});
	}



	function getrollOverXMLTexts4() {
		inclinedLineText = promptText.pop();
		$(xmlData)
			.find('btn')
			.each(function (i, j) {
			if ($(this)
				.attr('id')
				.indexOf("click") > -1) {
				var text1 = $(this)
					.text();
				var text2 = $(this)
					.next()
					.next()
					.text();
				rectTitle.push(text1);
				rectDescription.push(text2);
			}
			if ($(this)
				.attr('id')
				.indexOf("roll") > -1) {
				var text1 = $(this)
					.text();
				var text2 = $(this)
					.next()
					.text();
				var text3 = $(this)
					.next()
					.next()
					.text();
				btnTitle.push(text1);
				rollTitle.push(text2);
				rollDescription.push(text3);
			}
		});
		rectTitle.reverse();
		rectDescription.reverse();
		rollTitle.reverse();
		rollDescription.reverse();
	}
}