var mainMenu = function (params) {
	var courseInfo = courseObj(params.data);
	var courseDataInfo = courseInfo;
	var localDataInfo = courseDataInfo.localObj;
	var targetElement = params.targetElement;
	var prevModuleElement;
	var prevLessonElement;
	var prevActivityElement;
	var resetButton;
	var closeButton;
	var aboutButton;
	var menuXMLData;
	
	var obj = {
		mainMenuELE: null,
		status: null,
		sharedObjData: localDataInfo,
		courseData: courseDataInfo,
		create: function () {
			createMenuUI();
		},
		hide: function () {
			
			hideMenu();
		},
		show: function () {
			$(this.mainMenuELE)
				.show();
		},
		updateMenu: function () {
			updateMenu();
		},
		updateScreen: function (num) {
			updateScreen(num);
			updateMenu();
		},
		resetMenu: function () {
			resetMenu();
		},
		getScreenData: function () {
			
		}
	};


	//function for createMenu UI
	function createMenuUI() {
		var menuUI = $(targetElement)
			.load('ui/menus.html', "", function () {
			
			readMenuXML();
			
			var modStr = createModuleContentUI();
			var modContainer = $('#menuContainer>#menu_window')
				.find('.col1')
				.html(modStr);
			assignEventsForModuleList(modContainer);
			var lessonStr = createLessonContentUI();
			var lessonContainer = $('#menuContainer>#menu_window')
				.find('.col2')
				.html(lessonStr);
			assignEventsForLessonList(lessonContainer);
			var activityStr = createActivityContentUI();
			var activityContainer = $('#menuContainer>#menu_window')
				.find('.col3')
				.html(activityStr);
			assignEventsForActivityList(activityContainer);
			resetButton = $('#menuContainer>#menu_window')
				.find('.reset_menu .reset');
			closeButton = $('#menuContainer>#menu_window')
				.find('.reset_menu a');
			aboutButton = $('#menuContainer>#menu_window')
				.find('.menuFoot .aboutBtn');
			assignEventForButtons();
			
		});
		obj.mainMenuELE = $(targetElement);
		obj.status = 'created';
	}



	function assignEventForButtons() {
		$(resetButton)
			.bind('click', function () {
			obj.resetMenu();
		});
		$(closeButton)
			.bind('click', function (e) {
			e.preventDefault();
			obj.hide();
		});
		
	}



	function createModuleContentUI() {
		var tempStr = "<ul>";
		for (var i = 0; i < courseDataInfo.totalModules; i++) {
			var domObj = $(courseDataInfo.totalModuleDOM[i]);
			var trackObj = courseInfo.menuTrackObj[i];
			var trackClass = trackObj.status;
			var titleNode = domObj.children()[0];
			var titleText = $(titleNode)
				.text();
			
			if (trackClass == COURSESTATUS_CONST[0]) {
				trackClass = "";
			}
			else if (trackClass == COURSESTATUS_CONST[2]) {
				trackClass = "complete";
			}
			else if (trackClass == COURSESTATUS_CONST[1]) {
				trackClass = "progress";
			}
			
			tempStr += "<li class='" + trackClass + "'><p><span>&nbsp;</span>" + titleText + "</p></li>";
		}
		tempStr += "</ul>";
		return tempStr;
	}



	function createLessonContentUI() {
		var tempStr = "<ul>";
		var modDOM = $(courseDataInfo.totalModuleDOM[choosenModule]);
		var lessonDOM = modDOM.children("groupnode");
		var lessonLength = lessonDOM.length;
		
		for (var i = 0; i < lessonLength; i++) {
			var trackObj = courseInfo.menuTrackObj[choosenModule];
			var trackClass = trackObj.lessonStatusArr[i].status;
			
			var titleNode = $(lessonDOM[i])
				.children()[0];
			var titleText = $(titleNode)
				.text();
			
			if (trackClass == COURSESTATUS_CONST[0]) {
				trackClass = "";
			}
			else if (trackClass == COURSESTATUS_CONST[2]) {
				trackClass = "complete";
			}
			else if (trackClass == COURSESTATUS_CONST[1]) {
				trackClass = "progress";
			}
			tempStr += "<li class='" + trackClass + "'><p><span>&nbsp;</span>" + titleText + "</p></li>";
		}
		tempStr += "</ul>";
		return tempStr;
	}



	function createActivityContentUI() {
		var tempStr = "<ul>";
		var modDOM = $(courseDataInfo.totalModuleDOM[choosenModule]);
		var lessonDOM = modDOM.children("groupnode");
		var activityDOM = $(lessonDOM[choosenLesson])
			.children("groupnode");
		var activityLength = activityDOM.length;
		for (var i = 0; i < activityLength; i++) {
			var trackObj = courseInfo.menuTrackObj[choosenModule];
			var trackClass = trackObj.lessonStatusArr[choosenLesson].activityStatusArr[i].status;
			var titleNode = $(activityDOM[i])
				.children()[0];
			var titleText = $(titleNode)
				.text();
			
			if (trackClass == COURSESTATUS_CONST[0]) {
				trackClass = "";
			}
			else if (trackClass == COURSESTATUS_CONST[2]) {
				trackClass = "complete";
			}
			else if (trackClass == COURSESTATUS_CONST[1]) {
				trackClass = "progress";
			}
			tempStr += "<li class='" + trackClass + "'><p><span>&nbsp;</span>" + titleText + "</p></li>";
		}
		tempStr += "</ul>";
		return tempStr;
	}



	function assignEventsForModuleList(data) {
		var refEle = $(data)
			.find("li")
			.each(function (ind) {
			if (ind == 0) {
				$(this)
					.addClass('active');
				toggleModuleElementClass($(this));
			}
			$(this)
				.bind("click", function (evt) {
				$(this)
					.addClass('active');
				toggleModuleElementClass($(this));
				choosenModule = ind;
				choosenLesson = 0;
				choosenActivity = 0;
				
				var lessonStr = createLessonContentUI();
				
				var lessonContainer = $('#menuContainer>#menu_window')
					.find('.col2');
				lessonContainer.empty();
				lessonContainer.html(lessonStr);
				assignEventsForLessonList(lessonContainer);
				var activityStr = createActivityContentUI();
				var activityContainer = $('#menuContainer>#menu_window')
					.find('.col3');
				activityContainer.html(activityStr);
				assignEventsForActivityList(activityContainer);
				updateModuleMenuList();
			});
		});
	}



	function toggleModuleElementClass(ele) {
		var prevEle = $(prevModuleElement);
		$(prevEle)
			.removeClass('active');
		var currEle = $(ele);
		currEle.addClass('active');
		prevModuleElement = currEle;
	}



	function assignEventsForLessonList(data) {
		var refEle = $(data)
			.find("li")
			.each(function (ind) {
			if (ind == 0) {
				var curEle=$(data).find("li:eq(0)");
				curEle.addClass('active');
				toggleLessonElementClass( curEle);
			}
			$(this)
				.bind("click", function (evt) {
				$(this)
					.addClass('active');
				toggleLessonElementClass($(this));
				var temp=$(this).index();
				choosenLesson = temp;
				//choosenLesson = ind;
				
				var activityStr = createActivityContentUI();
				var activityContainer = $('#menuContainer>#menu_window')
					.find('.col3');
				activityContainer.html(activityStr);
				assignEventsForActivityList(activityContainer);
				updateLesssonMenuList()
			});
		});
	}



	function toggleLessonElementClass(ele) {
		var prevEle = $(prevLessonElement);
		$(prevEle)
			.removeClass('active');
		var currEle = $(ele);
		currEle.addClass('active');
		prevLessonElement = currEle;
	}



	function assignEventsForActivityList(data) {
		var refEle = $(data)
			.find("li")
			.each(function (ind) {
			if (ind == 0) {
				$(this)
					.addClass('active');
				toggleActivityElementClass($(this));
			}
			$(this)
				.bind("click", function (evt) {
				$(this)
					.addClass('active');
				toggleActivityElementClass($(this));
				choosenActivity = ind;
				
				/* Added for splash screen */
				
				courseInfo.setModule(choosenModule);
				courseInfo.setLesson(choosenLesson);
				courseInfo.setActivity(choosenActivity);
				
				choosenScreen=0;
				
				
				var activityData = courseInfo.activityObj.activityData;
			    var screenData = $(activityData).children()[choosenScreen + 1];
				var isSplashScreen = $(screenData).attr('splashscreen');
				
				if(isSplashScreen == "true"){
					choosenScreen=1;
				}else{
					choosenScreen=0;	
				}
				
				/* End */
				
				updateScreenInClick();
				updateActivityMenuList();
			});
		});
	}



	function toggleActivityElementClass(ele) {
		var prevEle = $(prevActivityElement);
		$(prevEle)
			.removeClass('active');
		var currEle = $(ele);
		currEle.addClass('active');
		prevActivityElement = currEle;
	}
	
	function updateScreen(num) {
		courseInfo.menuTrackObj[choosenModule].lessonStatusArr[choosenLesson].activityStatusArr[choosenActivity].screenStatusArr[num].status = COURSESTATUS_CONST[2];
	}

	function updateMenu() {
		updateActivityMenuList();
		updateLesssonMenuList();
		updateModuleMenuList();
		localDataInfo.setData(courseInfo.menuTrackObj);
	}


	//update function for activity menu
	function updateActivityMenuList() {
		var domRef = $('#menuContainer>#menu_window')
			.find('.col3')
			.find('li:eq(' + choosenActivity + ')');
		var scrArr = courseInfo.menuTrackObj[choosenModule].lessonStatusArr[choosenLesson].activityStatusArr[choosenActivity].screenStatusArr
		var scrLen = scrArr.length;
		var inProgressCount = 0;
		var notStartedCount = 0;
		var completedCount = 0;
		for (var i = 0; i < scrLen; i++) {
			if (scrArr[i].status == COURSESTATUS_CONST[0]) {
				notStartedCount++;
			}
			else if (scrArr[i].status == COURSESTATUS_CONST[1]) {
				inProgressCount++;
			}
			else if (scrArr[i].status == COURSESTATUS_CONST[2]) {
				completedCount++;
			}
		}

		if (notStartedCount == scrLen) {
			courseInfo.menuTrackObj[choosenModule].lessonStatusArr[choosenLesson].activityStatusArr[choosenActivity].status = COURSESTATUS_CONST[0];
		}
		else if (inProgressCount > 0) {
			courseInfo.menuTrackObj[choosenModule].lessonStatusArr[choosenLesson].activityStatusArr[choosenActivity].status = COURSESTATUS_CONST[1];
			$(domRef)
				.addClass("progress");
		}
		else if (completedCount > 0 && completedCount < scrLen) {
			courseInfo.menuTrackObj[choosenModule].lessonStatusArr[choosenLesson].activityStatusArr[choosenActivity].status = COURSESTATUS_CONST[1];
			$(domRef)
				.addClass("progress");
		}
		else if (completedCount == scrLen) {
			courseInfo.menuTrackObj[choosenModule].lessonStatusArr[choosenLesson].activityStatusArr[choosenActivity].status = COURSESTATUS_CONST[2];
			$(domRef)
				.removeClass("progress");
			$(domRef)
				.addClass("complete");
		}
		
	}


	//update function for lesson menu
	function updateLesssonMenuList() {
		var domRef = $('#menuContainer>#menu_window')
			.find('.col2')
			.find('li:eq(' + choosenLesson + ')');
		var activityArr = courseInfo.menuTrackObj[choosenModule].lessonStatusArr[choosenLesson].activityStatusArr;
		var activityLen = activityArr.length;
		var inProgressCount = 0;
		var notStartedCount = 0;
		var completedCount = 0;
		for (var i = 0; i < activityLen; i++) {
			if (activityArr[i].status == COURSESTATUS_CONST[0]) {
				notStartedCount++;
			}
			else if (activityArr[i].status == COURSESTATUS_CONST[1]) {
				inProgressCount++;
			}
			else if (activityArr[i].status == COURSESTATUS_CONST[2]) {
				completedCount++;
			}
		}
		
		if (notStartedCount == activityLen) {
			courseInfo.menuTrackObj[choosenModule].lessonStatusArr[choosenLesson].status = COURSESTATUS_CONST[0];
		}
		else if (inProgressCount > 0) {
			courseInfo.menuTrackObj[choosenModule].lessonStatusArr[choosenLesson].status = COURSESTATUS_CONST[1];
			$(domRef)
				.addClass("progress");
		}
		else if (completedCount > 0 && completedCount < activityLen) {
			courseInfo.menuTrackObj[choosenModule].lessonStatusArr[choosenLesson].status = COURSESTATUS_CONST[1];
			$(domRef)
				.addClass("progress");
		}
		else if (completedCount == activityLen) {
			courseInfo.menuTrackObj[choosenModule].lessonStatusArr[choosenLesson].status = COURSESTATUS_CONST[2];
			$(domRef)
				.removeClass("progress");
			$(domRef)
				.addClass("complete");
		}
		
	}


	//update function for module menu
	function updateModuleMenuList() {
		var domRef = $('#menuContainer>#menu_window')
			.find('.col1')
			.find('li:eq(' + choosenModule + ')');
		var lessonArr = courseInfo.menuTrackObj[choosenModule].lessonStatusArr;
		var lessonLen = lessonArr.length;
		var inProgressCount = 0;
		var notStartedCount = 0;
		var completedCount = 0;
		for (var i = 0; i < lessonLen; i++) {
			if (lessonArr[i].status == COURSESTATUS_CONST[0]) {
				notStartedCount++;
			}
			else if (lessonArr[i].status == COURSESTATUS_CONST[1]) {
				inProgressCount++;
			}
			else if (lessonArr[i].status == COURSESTATUS_CONST[2]) {
				completedCount++;
			}
		}
		
		if (notStartedCount == lessonLen) {
			courseInfo.menuTrackObj[choosenModule].status = COURSESTATUS_CONST[0];
		}
		else if (inProgressCount > 0) {
			courseInfo.menuTrackObj[choosenModule].status = COURSESTATUS_CONST[1];
			$(domRef)
				.addClass("progress");
		}
		else if (completedCount > 0 && completedCount < lessonLen) {
			courseInfo.menuTrackObj[choosenModule].status = COURSESTATUS_CONST[1];
			$(domRef)
				.addClass("progress");
		}
		else if (completedCount == lessonLen) {
			
			courseInfo.menuTrackObj[choosenModule].status = COURSESTATUS_CONST[2];
			$(domRef)
				.removeClass("progress");
			$(domRef)
				.addClass("complete");
		}
		
		
		var lessonStr = createLessonContentUI();
		var lessonContainer = $('#menuContainer>#menu_window')
			.find('.col2');
		lessonContainer.html(lessonStr);
		assignEventsForLessonList(lessonContainer);
		var activityStr = createActivityContentUI();
		var activityContainer = $('#menuContainer>#menu_window')
			.find('.col3');
		activityContainer.html(activityStr);
		assignEventsForActivityList(activityContainer);
	}



	function resetMenu() {
		
		localDataInfo.clearData();
		courseInfo.resetCourseTrackObj();
		$(targetElement)
			.find('div.col1')
			.find('li')
			.removeClass('complete');
		$(targetElement)
			.find('div.col1')
			.find('li')
			.removeClass('progress');
		$(targetElement)
			.find('div.col2')
			.find('li')
			.removeClass('complete');
		$(targetElement)
			.find('div.col2')
			.find('li')
			.removeClass('progress');
		$(targetElement)
			.find('div.col3')
			.find('li')
			.removeClass('complete');
		$(targetElement)
			.find('div.col3')
			.find('li')
			.removeClass('progress');
		courseInfo.menuTrackObj[choosenModule].lessonStatusArr[choosenLesson].activityStatusArr[choosenActivity].screenStatusArr[navigationObj.screenCount].status = COURSESTATUS_CONST[2];
		
		courseInfo.menuTrackObj[0].timeBool="undefined";
	}



	function hideMenu() {
		$(targetElement)
			.find('div.col1')
			.find('li')
			.removeClass('active');
		$(targetElement)
			.find('div.col2')
			.find('li')
			.removeClass('active');
		$(targetElement)
			.find('div.col3')
			.find('li')
			.removeClass('active');
		$(obj.mainMenuELE)
			.hide();
	}
	
	function readMenuXML() {
        var options = {
            type: 'GET',
            url: commonModulePath+'course_menu.xml',
            dataType: 'xml',
            success: function (xml) {

			    menuXMLData=xml;
				
			var popupText = $(menuXMLData).find('p[id=about_txt]').text();
			popupText=popupText.replaceAll("-","<li>");
			 
			 $("#menu_window>.popup_window>.Checklist_menu>.popup_txt_menu>ul").empty();
			 $("#menu_window>.popup_window>.Checklist_menu>.popup_txt_menu>p").remove();
			 $("#menu_window>.menuFoot>.aboutBtn").bind('click', function () {
				$("#menu_window>.popup_window>.Checklist_menu>.popup_txt_menu>ul").html(popupText);
				$("#menu_window>.popup_window .closeBtn").show();
				$("#menu_window>.popup_window").show();
			 })


		
			$("#menu_window>.popup_window .closeBtn").bind('click', function (e) {
				e.stopPropagation();
				$("#menu_window>.popup_window").hide();
			})

				
            }

        };

        $.ajax(options);

    }

	createMenuUI();
	return obj;
}