var actionPlan = function (params) {
    var courseInfo = courseObj(params.structureXMLdata);
    var courseDataInfo = courseInfo;
    var localDataInfo = courseDataInfo.localObj;
    var targetElement = params.targetElement;
    var prevModuleElement;
    var prevLessonElement;
    var prevActivityElement;
    var resetButton;
    var closeButton;
    var aboutButton;
    var actionPlanXMLData;
    var moduleObjArr = [];
    var curModuleIndex = 0;
    var curActivityIndex = 0;
    var curLessionIndex = 0;
	var curScreenIndex = 0;
    var actionPlanObj = [];
    var activityLessonArr=[];
    var activityScreenArr=[];
	var templateURL = fwHtmlPath + 'action_plan.html';

    var obj = {
        actionPlanELE: null,
        status: null,
        sharedObjData: localDataInfo,
        courseData: courseDataInfo,
        create: function () {
            createActionPlanUI();
        },
        hide: function () {
            $(this.actionPlanELE).hide();
        },
        show: function () {
            $(this.actionPlanELE).show();
        },
        updateActionPlan: function () {
            updateActionPlan();
        },
        updateScreen: function (num) {
            updateScreen(num);
            updateActionPlan();
        },
        resetActionPlan: function () {
            resetActionPlan();
        },
		getScreenData: function () {
         
        },
		getTotalActivitesCount: function (ind) {
			var totalActivities=getTotalActivitesCount(ind);
			return totalActivities;
		}
    };
	//function for creating Action plan UI
    function createActionPlanUI() {
        var ActionPlanUI = $(targetElement).load(templateURL, "", function () {
            var modStr = createModuleContentUI();
            var modContainer = $('.action_plan').find('.col1').html(modStr);
            assignEventsForModuleList(modContainer);
		    curLessionIndex=getLessonIndex(0);
			var lessonStr = createLessonContentUI();
            var lessonContainer = $('.action_plan').find('.col2').html(lessonStr);
            assignEventsForLessonList(lessonContainer);
			
			curActivityIndex=getActivityIndex(0);
			
		    var activityStr = createActivityContentUI();
            var activityContainer = $('.action_plan').find('.col3').html(activityStr);
            assignEventsForActivityList(activityContainer);

            resetButton = $('.action_plan .reset_menu .reset');
            closeButton = $('.action_plan .reset_menu a');
            aboutButton = $('.action_plan .menuFoot .aboutBtn');

            assignEventForButtons();
			
			setActionPlanTexts();
			
			retrieveActionPlanStatus();
        });
        obj.actionPlanELE = $(targetElement);
        obj.status = 'created';
    }


    function assignEventForButtons() {
        $(resetButton).bind('click', function () {
            obj.resetActionPlan();
        });
        $(closeButton).bind('click', function (e) {
            e.preventDefault();
            obj.hide();
        });
    }
	//function for creating modulecontent UI
    function createModuleContentUI() {
        var tempStr = "<ul>";
        for (var i = 0; i < courseDataInfo.totalModules; i++) {
            var domObj = $(courseDataInfo.totalModuleDOM[i]);
            var lessonDOM = domObj.children("groupnode");
            var lessonLength = lessonDOM.length;
            var trackObj = courseInfo.menuTrackObj[i];
            var trackClass = trackObj.status;
            var titleNode = domObj.children()[0];
            var titleText = $(titleNode).text();
            moduleObj = {
                count: 0
            };
            moduleObjArr.push(moduleObj);
			
			if (trackClass == COURSESTATUS_CONST[0]) {
                trackClass = "";
            } else if (trackClass == COURSESTATUS_CONST[2]) {
                trackClass = "complete";
            } else if (trackClass == COURSESTATUS_CONST[1]) {
                trackClass = "progress";
            }
			
			activityLength=getTotalActivitesCount(i);
            lessonCountStr = "0/" + activityLength;
            tempStr += "<li class='" + trackClass + "'><p>" + titleText + "</p><samp>" + lessonCountStr + "</samp></li>";
        }
        tempStr += "</ul>";
        return tempStr;
    }

	//function for creating lessoncontent UI
    function createLessonContentUI() {
        var tempStr = "<ul>";
        var modDOM = $(courseDataInfo.totalModuleDOM[curModuleIndex]);
        var lessonDOM = modDOM.children("groupnode");
        var lessonLength = lessonDOM.length;
        for (var i = 0; i < lessonLength; i++) {
            var trackObj = courseInfo.menuTrackObj[curModuleIndex];
            var trackClass = trackObj.lessonStatusArr[i].status;
            var titleNode = $(lessonDOM[i]).children()[0];
            var titleText = $(titleNode).text();
			var isActivity=$(lessonDOM[i]).attr('activity');
			
			if(isActivity == "true"){
				activityLessonArr.push(i);
				if (trackClass == COURSESTATUS_CONST[0]) {
					trackClass = "";
				} else if (trackClass == COURSESTATUS_CONST[2]) {
					trackClass = "complete";
				} else if (trackClass == COURSESTATUS_CONST[1]) {
					trackClass = "progress";
				}
				tempStr += "<li class='" + trackClass + "'>" + titleText + "</li>";
			}
        }
        tempStr += "</ul>";

        return tempStr;
    }
	//function for creating Activitycontent UI
    function createActivityContentUI() {
        var tempStr = "<ul>";
        var modDOM = $(courseDataInfo.totalModuleDOM[curModuleIndex]);
        var lessonDOM = modDOM.children("groupnode");
        var activityDOM = $(lessonDOM[curLessionIndex]).children("groupnode");
        var activityLength = activityDOM.length;
		for (var i = 0; i < activityLength; i++) {
            var trackObj = courseInfo.menuTrackObj[curModuleIndex];
            var trackClass = trackObj.lessonStatusArr[curLessionIndex].activityStatusArr[i].status;
            var titleNode = $(activityDOM[i]).children()[0];
            var titleText = $(titleNode).text();
			var isActivity = $(activityDOM[i]).attr('activity');
			if(isActivity == "true"){    
				activityScreenArr.push(i);
				if (trackClass == COURSESTATUS_CONST[0]) {
					trackClass = "";
				} else if (trackClass == COURSESTATUS_CONST[2]) {
					trackClass = "complete";
				} else if (trackClass == COURSESTATUS_CONST[1]) {
					trackClass = "progress";
				}

				var curClass = "";
				var activityStatus = mainMenuObj.courseData.menuTrackObj[curModuleIndex].lessonStatusArr[curLessionIndex].activityStatusArr[i].actionPlanStatus;
				
				if (activityStatus == ACTIONPLANSTATUS_CONST[0]) {
					curClass = "";
				} else {
					curClass = "complete";
				}


				tempStr += "<li class='" + curClass + "'><p>" + titleText + "<span><label>&nbsp;</label></span></p></li>";
			}
        }
        tempStr += "</ul>";
        return tempStr;
    }

    function assignEventsForModuleList(data) {
        var refEle = $(data).find("li").each(function (ind) {

            if (ind == 0) {
                $(this).addClass('active');
                toggleModuleElementClass($(this));
            }


            $(this).bind("click", function (evt) {
                $(this).addClass('active');
                toggleModuleElementClass($(this));
                curModuleIndex = ind;
                curLessionIndex = getLessonIndex(0);
                curActivityIndex = getActivityIndex(0);
                curScreenIndex = getScreenIndex();
				
                var lessonStr = createLessonContentUI();
                var lessonContainer = $('.action_plan').find('.col2');
                lessonContainer.empty();
                lessonContainer.html(lessonStr);
                assignEventsForLessonList(lessonContainer);
                var activityStr = createActivityContentUI();
                var activityContainer = $('.action_plan').find('.col3');
                activityContainer.html(activityStr);
                assignEventsForActivityList(activityContainer);

            });
        });
    }

    function toggleModuleElementClass(ele) {
        var prevEle = $(prevModuleElement);
        $(prevEle).removeClass('active');
        var currEle = $(ele);
        currEle.addClass('active');
        prevModuleElement = currEle;
    }

    function assignEventsForLessonList(data) {
        var refEle = $(data).find("li").each(function (ind) {
            if (ind == 0) {
                $(this).toggleClass('active');
                toggleLessonElementClass($(this));
            }
            $(this).bind("click", function (evt) {
                $(this).toggleClass('active');
                toggleLessonElementClass($(this));
				curLessionIndex = getLessonIndex(ind);
				curActivityIndex = getActivityIndex(0);
                curScreenIndex = getScreenIndex();
				var activityStr = createActivityContentUI();
                var activityContainer = $('.action_plan').find('.col3');
                activityContainer.html(activityStr);
                assignEventsForActivityList(activityContainer);
            });
        });
    }
	
	
	function getLessonIndex(ind){
		var count=0;
		var curLesson;
		var totalLessons=actionPlanObj[curModuleIndex].lessonStatusArr.length;
		for(var i=0;i<totalLessons;i++){
			if(actionPlanObj[curModuleIndex].lessonStatusArr[i].hasActivity == true){
				count++;
				if(count-1 == ind){
					curLesson=i;
					break;
				}
			}
		}
		
		

		return curLesson;
	}
	
	function getActivityIndex(ind){
		var count=0;
		var curActivity;
    if (typeof(curLessionIndex) == "undefined")
    {
      curLessionIndex = 0;
    }
		var totalActivities=actionPlanObj[curModuleIndex].lessonStatusArr[curLessionIndex].activityStatusArr.length;
		
		for(var i=0;i<totalActivities;i++){
			if(actionPlanObj[curModuleIndex].lessonStatusArr[curLessionIndex].activityStatusArr[i].hasActivity == true){
				count++;
		
				if(count-1 == ind){
					curActivity=i;
					break;
				}
			}
				
		}
		
		
		
		return curActivity;
	}
	
	function getScreenIndex(){
		var count=0;
		var curScreen;
    if (typeof(curActivityIndex) == "undefined")
    {
      curActivityIndex = 0;
    }
    console.log(curActivityIndex);
		var totalScreens=actionPlanObj[curModuleIndex].lessonStatusArr[curLessionIndex].activityStatusArr[curActivityIndex].screenStatusArr.length;
		for(var i=0;i<totalScreens;i++){
			if(actionPlanObj[curModuleIndex].lessonStatusArr[curLessionIndex].activityStatusArr[curActivityIndex].screenStatusArr[i].hasActivity == true){
				curScreen=i;
			}
		}
		return curScreen;
	}
	
	function getTotalActivitesCount(ind){
		
		var count=0;
		var curActivity;
		var totalLessons=actionPlanObj[ind].lessonStatusArr.length;
		for(var i=0;i<totalLessons;i++){
			var totalActivities=actionPlanObj[ind].lessonStatusArr[i].activityStatusArr.length;
			for(var j=0;j<totalActivities;j++){
				if(actionPlanObj[ind].lessonStatusArr[i].activityStatusArr[j].hasActivity == true){
					count++;
				}
			}
		}

		return count;

	}
	
	function getActivityCountForLesson(ind){
		var count=0;
		var curActivity;
		var totalActivities=actionPlanObj[curModuleIndex].lessonStatusArr[curLessionIndex].activityStatusArr.length;
		for(var i=0;i<totalActivities;i++){
			if(actionPlanObj[curModuleIndex].lessonStatusArr[curLessionIndex].activityStatusArr[i].hasActivity == true){
				count++;
			}
				
		}
		return count;
	}
	
	
    function toggleLessonElementClass(ele) {
        var prevEle = $(prevLessonElement);
        $(prevEle).removeClass('active');
        var currEle = $(ele);
        currEle.addClass('active');
        prevLessonElement = currEle;
    }

    function assignEventsForActivityList(data) {
        var refEle = $(data).find("li").each(function (ind) {

            $(this).bind("click", function (evt) {
				evt.stopPropagation();
				choosenModule=curModuleIndex;
				choosenLesson=curLessionIndex;
				curActivityIndex = getActivityIndex(ind);
				choosenActivity=curActivityIndex;
				curScreenIndex = getScreenIndex();
				choosenScreen = curScreenIndex;
				updateScreenInClick();
				$(targetElement).hide();
            });


            $(this).find('span').bind("click", function (evt) {

                evt.stopPropagation();
				
				var curText = $(".action_plan>.menuInner>.col1>ul").children().eq(curModuleIndex).find('samp').text();
                curText = curText.split('/');

                noOfActivities = getActivityCountForLesson(curLessionIndex);
				curActivityIndex = getActivityIndex(ind);
				curScreenIndex = getScreenIndex();
				
				var activityStatus = mainMenuObj.courseData.menuTrackObj[curModuleIndex].lessonStatusArr[curLessionIndex].activityStatusArr[curActivityIndex].actionPlanStatus;
                var selectedActivityCount = 0;
                var deselectedActivityCount = 0;

                if (activityStatus == ACTIONPLANSTATUS_CONST[0]) {
                    $(this).parent().parent().addClass('complete');
                    mainMenuObj.courseData.menuTrackObj[curModuleIndex].lessonStatusArr[curLessionIndex].activityStatusArr[curActivityIndex].actionPlanStatus = ACTIONPLANSTATUS_CONST[1];
					mainMenuObj.courseData.menuTrackObj[curModuleIndex].activityCount += 1;
                } else {
                    $(this).parent().parent().removeClass('complete');
                   mainMenuObj.courseData.menuTrackObj[curModuleIndex].lessonStatusArr[curLessionIndex].activityStatusArr[curActivityIndex].actionPlanStatus = ACTIONPLANSTATUS_CONST[0];
				   mainMenuObj.courseData.menuTrackObj[curModuleIndex].activityCount -= 1;
                }

                var totalActivities=mainMenuObj.courseData.menuTrackObj[curModuleIndex].lessonStatusArr[curLessionIndex].activityStatusArr.length;
				actionPlanGlobalObj=mainMenuObj.courseData.menuTrackObj;
                localDataInfo.setData(mainMenuObj.courseData.menuTrackObj);
                var updatedText = mainMenuObj.courseData.menuTrackObj[curModuleIndex].activityCount + "/" + curText[1];
                $(".action_plan>.menuInner>.col1>ul").children().eq(curModuleIndex).find('samp').text(updatedText);
				
			});
			
			
			
        });
    }

    function toggleActivityElementClass(ele) {
        var prevEle = $(prevActivityElement);
        $(prevEle).removeClass('active');
        var currEle = $(ele);
        currEle.addClass('active');
        prevActivityElement = currEle;
    }


    function resetActionPlan() {
        resetActionPlanStatus();
        $('.action_plan').find('.col3').find('li').removeClass('complete');
        $('.action_plan').find('.col3').find('li').removeClass('complete');
        $('.action_plan').find('.col3').find('li').removeClass('complete');


    }

    function hideActionPlan() {
        $('.action_plan').find('.col3').find('li').removeClass('complete');
        $('.action_plan').find('.col3').find('li').removeClass('complete');
        $('.action_plan').find('.col3').find('li').removeClass('complete');
        $(obj.actionPlanELE).hide();
    }

    function setActionPlanTexts() {

        instructionText = $(actionPlanXMLData).find('p[type=component_title_05]').text();
        instructionTitle = $(actionPlanXMLData).find('p[type=component_title_02]').text();
        actionPlanTitle = $(actionPlanXMLData).find('p[type=component_title_01]').text();
        resetText = $(actionPlanXMLData).find('p[type=reset]').text();
        aboutText = $(actionPlanXMLData).find('p[type=about]').text();
        hrefText = $(actionPlanXMLData).find('p[type=about]').text();
        hrefSrc = $(actionPlanXMLData).find('p[type=actionplan2]').text().replace('doc', 'pdf');
        completedText = $(actionPlanXMLData).find('p[type=completed]').text();
        notStartedText = $(actionPlanXMLData).find('p[type=not_started]').text();
        popupText = $(actionPlanXMLData).find('p[type=about_txt]').text();
        $(".action_plan>.instruct>p").html(instructionText);
        $(".action_plan>.instruct>h3").html(instructionTitle);
        $(".action_plan>.menuHead>h3").html(actionPlanTitle);
        $(".action_plan>.menuHead>.reset_menu>.reset").html(resetText);
        $(".action_plan>.menuFoot>.aboutBtn>span").html(aboutText);
        $(".action_plan>.menuFoot>.aboutBtn>a").remove();
        $(".action_plan>.menuFoot>.aboutBtn").append(hrefSrc);
        $(".action_plan>.menuFoot>.aboutBtn>a").empty();
        var tmpStr = '<img src="'+fwImagesPath+'pdf.png" alt="About Menu" width="15" />'
        $(".action_plan>.menuFoot>.aboutBtn>a").append(tmpStr);
        str1 = completedText + '<span>&nbsp;</span>'
        str2 = notStartedText + '<span>&nbsp;</span>'
        $(".action_plan>.menuFoot>ul").children().eq(0).empty();
        $(".action_plan>.menuFoot>ul").children().eq(0).append(str1);
        $(".action_plan>.menuFoot>ul").children().eq(1).empty();
        $(".action_plan>.menuFoot>ul").children().eq(1).append(str2);
        $(".action_optionContainer>#menuHolder>.popup_window>.popup_txt>ul").empty();
        $(".action_plan>.menuFoot>.aboutBtn>span").bind('click', function () {
			$(".action_optionContainer>#menuHolder>.popup_window>.popup_txt>ul").html(popupText);
			$(".action_optionContainer>#menuHolder>.popup_window .closeBtn").show();
            $(".action_optionContainer>#menuHolder>.popup_window").show();
        })

        $(".action_optionContainer>#menuHolder>.popup_window .closeBtn").show();
		
		$(".action_optionContainer>#menuHolder>.popup_window .closeBtn").bind('click', function (e) {
            e.stopPropagation();
            $(".action_optionContainer>#menuHolder>.popup_window").hide();
        })

        actionPlanGlobalObj=mainMenuObj.courseData.menuTrackObj;
    }

    function resetActionPlanStatus() {
        localDataInfo.clearData();
        for (var i = 0; i < courseInfo.totalModules; i++) {
            activityLength=getTotalActivitesCount(i);
			var updatedText = "0/" + activityLength;
            mainMenuObj.courseData.menuTrackObj[i].activityCount = 0;
            $(".action_plan>.menuInner>.col1>ul").children().eq(i).find('samp').text(updatedText);
            for (var j = 0; j < mainMenuObj.courseData.menuTrackObj[i].lessonStatusArr.length; j++) {
                for (var k = 0; k < mainMenuObj.courseData.menuTrackObj[i].lessonStatusArr[j].activityStatusArr.length; k++) {
                    mainMenuObj.courseData.menuTrackObj[i].lessonStatusArr[j].activityStatusArr[k].actionPlanStatus = ACTIONPLANSTATUS_CONST[0];
                }
            }
        }

    }
	//function for creating Action planObj
	function createActionPlanObj(){
	
			  var courseInfo = mainMenuObj.courseData;
			  var courseName = courseInfo.courseName;
			  var courseID = courseInfo.courseID;
			  var totalModules = courseInfo.totalModules;
			  var totalModuleDOM = courseInfo.totalModuleDOM;

			for (var i = 0; i < totalModules; i++) {
				
				courseInfo.setModule(i);
				var totalLessons = courseInfo.moduleObj.totalLessons;
				var mObj = { lessonStatusArr: [],hasActivity:false};
	 
					for (var j = 0; j < totalLessons; j++) {
						courseInfo.setLesson(j);
						var lessonData  =  courseInfo.lessonObj.lessonData;
						var isActivity=$(lessonData).attr('activity');
						var totalActivities = courseInfo.lessonObj.totalActivities;
						var lObj = {activityStatusArr:[],hasActivity:false};
						
						if(isActivity == "true"){
							lObj.hasActivity=true;
						}
						
								for(var k=0;k<totalActivities;k++){
									courseInfo.setActivity(k);
									var activityData = courseInfo.activityObj.activityData;
									var totalScreens = courseInfo.activityObj.totalScreens;
									var isActivity=$(activityData).attr('activity');
									var aObj = {screenStatusArr:[],hasActivity:false};
									
									if(isActivity == "true"){
										aObj.hasActivity=true;
									}
								
									for (var l = 0; l < totalScreens; l++) {
											var sObj = {hasActivity:false};
											var screenDOM=$(activityData).children()[l+1];
											var isActivity=$(screenDOM).attr('activity');
											if(isActivity == "true"){
													sObj.hasActivity=true;
											}
											aObj.screenStatusArr[l] = sObj;
											lObj.activityStatusArr[k] = aObj;
											mObj.lessonStatusArr[j] = lObj;
										
									}

								}
												
					}	
					
				
				actionPlanObj[i] = mObj;
          
            }
	}
	

    function retrieveActionPlanStatus() {
        mainMenuObj.courseData.menuTrackObj = localDataInfo.getData();
        for (var i = 0; i < mainMenuObj.courseData.menuTrackObj.length; i++) {
			activityLength=getTotalActivitesCount(i);
            var completedCount = mainMenuObj.courseData.menuTrackObj[i].activityCount;
			if (completedCount == undefined) {
                completedCount = 0;
            }
            var updatedText = completedCount + "/" + activityLength;
            $(".action_plan>.menuInner>.col1>ul").children().eq(i).find('samp').text(updatedText);
        }

    }

    function readActionPlanXML() 
    {
      _ajax = xmlAjax(commonModulePath+'action_plan.xml', 'xml');
      _ajax.success(function (xml)
      {
        actionPlanXMLData = xml;
        createActionPlanObj();
        createActionPlanUI();
      });
    }

    readActionPlanXML();
    return obj;
}