function initFrameWork(setting) 
{
  function checkHash()
  {
    var _hash = document.location.hash.replace("#", "");
    if (mainMenuObj.courseData.totalModuleDOM.find("[src='"+_hash+".swf']").size() == 1)
    {
      var _hash = _hash.replace(/[a-zA-Z#]/g, "");
      var _hash = _hash.replace(/\_0/g, "_");
      _hash = _hash.split("_");
      navigationObj.moduleCount = _hash[1];
      navigationObj.lessonCount = _hash[2];
      navigationObj.activityCount = _hash[3]-1;
      navigationObj.screenCount = _hash[4] == 0 ? _hash[4] : (_hash[4]-1);
      return true;
    }
    return false;
  }

  container = setting.placeholder;
  $(container).addClass('container');
  if (!isFirefox)
  {
    $(container).disableSelection();
  }
  $(document).keydown(function (event) 
  {
    if (event.ctrlKey && event.keyCode == 65) //Ctrl + A
    {
      return false;
    }
  });
  
  var templateURL = fwHtmlPath + 'framework.html';
  if (getParameterByName("isDebugMode") == "true")
  {
    isDebugMode = true;
  }
  if (typeof(isDebugMode) != "undefined" && isDebugMode)
  {
    templateURL += "?" + Math.random();
  }
  else if (typeof(versionXML) != "undefined" && versionXML.length)
  {
    templateURL += "?v=" + versionXML;
  }
  $(container).load(templateURL, function() 
  {
    //create audio element at once
    if (!isIPAD )
    {
      audioElement = document.createElement('audio'); // this audioelement is  used to create an audio tag
      $(audioElement).attr('id', 'audio');
    }
    audioNavBar = new AudioNavBar($('#sliderController'));
    audioNavBar.create();
    navigatorNP = new NavigatorNP($('#navigatorController')); //this function call from navigator.js
    navigatorNP.create();
    //this function is used to load the Course// called from templateloader.js
    
    var options = 
    {
      type: 'GET',
      url: structureXMLPath,
      dataType: 'xml',
      success: function (xml) 
      {
        var menuConfigObj = {};
        menuConfigObj.data = xml;
        menuConfigObj.targetElement = $("#menuContainer");
        mainMenuObj = mainMenu(menuConfigObj);
        
        checkHash();
        createFirstPage(mainMenuObj);
        loadModule_fn(); //this function is used to load the Course// called from templateloader.js

        mainMenuObj.hide();
        $("#showMenu").bind('click', function () 
        {
          mainMenuObj.show();
        });
        actionPlanConfigObj = {};
        actionPlanConfigObj.structureXMLdata = xml;
        actionPlanConfigObj.targetElement = $("#action_optionContainer");
        actionPlanConfigObj = actionPlan(actionPlanConfigObj);
        $(".optionContainer").hide();
        $("#action_optionContainer").hide();
        var createHelp = new helpFn(
        {
          container: $("#help_optionContainer"),
          xmlPath: commonModulePath+'help.xml'
        });
        createHelp.create();
        $("#help_optionContainer").hide();
        var resources_Template = new resources(
        {
          container: $("#resources_optionContainer"),
          xmlPath: commonModulePath+'resources.xml'
        });
        resources_Template.create();
        $("#resources_optionContainer").hide();

        var _tmp = $("<div/>");
        if (typeof(isDebugMode) != "undefined" && isDebugMode)
        {
          defaultTemplate += "?" + Math.random();
        }
        _tmp.load(defaultTemplate, function() 
        {
          defaultTemplate = _tmp.find("#innercore");
        });
      }
    };
    $.ajax(options);
    optionMenu = new OptionMenu();
    optionMenu.glossaryFn();
    optionMenu.resourceFn();
    optionMenu.create_help();
    optionMenu.aboutFn();
    optionMenu.actionPlan();
    $('#optionContainer').hide();
  });
}
