// formatted
// this function is used to load the modules
function loadModule_fn() 
{
  structureXML_int = xmlAjax(structureXMLPath, "text");
  structureXML_int.success(function (xml) 
  {
    structureXML = $((new DOMParser).parseFromString(xml, "text/xml"))

    menuConfigObj = {};
    menuConfigObj.data = $.parseXML(xml);
    menuConfigObj.targetElement = $("#menuContainer");
    mainMenuObj = mainMenu(menuConfigObj);
    mainMenuObj.hide();
    $("#menu").bind('click', function () 
    {
      menuHideShow("optionContainer");
      mainMenuObj.show();
    })

    glossary_Template = new glossaryTemplate(
    {
      container: $("#glossary_optionContainer"),
      xmlPath: commonModulePath+'glossary.xml'
    });
    glossary_Template.create();
    $("#glossary_optionContainer").hide();

    var logosplitTxt = String(structureXML.find("title")[0].textContent).split(':');
    $('.logo a').html('<span>&nbsp;</span><b>' + logosplitTxt[0] + ':</b><br/>' + logosplitTxt[1]);
    //this start loading function is used to load preloader, whicht help to load the content area
    inStageFn();
  });
}

//breadcrumb message and progress
function breadCrumb_Fn(obj) 
{
  var currentCheckItem = obj.currentLesson;
  var totalProgressBar_Num = obj.totalLesson;
  var strProgressBar = '<div class="lesson">';
  for (var i = 0; i <= totalProgressBar_Num; i++) 
  {
    if (i <= currentCheckItem) 
    {
      strProgressBar += '<span class="active">&nbsp;</span>';
    }
    else 
    {
      strProgressBar += '<span >&nbsp;</span>';
    }
  }
  if(Number(navigationObj.lessonCount)==0 && Number(navigationObj.activityCount)==0 && Number(navigationObj.screenCount)==0)
  {
    $('.breadCrumb h1 span').html(obj.moduleName);
  }
  else
  {
    $('.breadCrumb h1 span').html('Module '+navigationObj.moduleCount); 
  }
  $('.breadCrumb h1 nobr').html(' > ' + obj.lessonName + ' > ' + obj.activityName);
  $('.progressBar nobr').html(strProgressBar);
  $('.lesson').append('Lesson ' + currentCheckItem + ' of ' + (totalProgressBar_Num));
}

function inStageFn() 
{
  if (globalIpadAudio == false) 
  {
    initIpadAudio = false; //this flag used to activiate the ipad play button at initial
  }
  clearTimeout(loopingClearAnim);
  findDialogTemp = false;
  navigatorNP.show();
  //this function call from navigator.js
  reload_Fn();
}

//this function is used to reload all data, when reload button is trigger
function reload_Fn() 
{
  $('#contentContainer').empty();
  clearTimeout(globalAudioClear);
  checkXML_Ref_Fn();
  audioNavBar.audio_refresh_Screen();
  maxSlideImage = 0;
  maxAudioSplit = []; 
  currentAduioInScreen = 0;
  //en_Dis_Controller_Fn(); // disable enable controller // this function called from controller.js
  loadCurScreen();
}

//check current modlue screen xml file
function checkXML_Ref_Fn() 
{
  currentModuleXMLPath = String(current_MLA + '.xml');
}

//current module loading function
function loadCurScreen() 
{
  $("#preloaderContainer").show();
  xmlObj = xmlAjax(commonModulePath + '' + currentModuleXMLPath, "xml");
  xmlObj.success(function (xml) 
  {
    var templateInfoObj = {};
    templateInfoObj.id            = current_MLA;
    templateInfoObj.xmlData       = xml;
    // html5Data attributes
    templateInfoObj.templateClass = $(xml).find("html5Data").attr('templateClass');
    templateInfoObj.templateType  = (typeof($(xml).find("html5Data").attr('templateType')) != "undefined") ? $(xml).find("html5Data").attr('templateType') : "";
    templateInfoObj.templateKey   = !!($(xml).find("html5Data").attr('templateKey') == "true");
    // settings
    templateInfoObj.settings = {params: {}};
    if ($(xml).find('settings, settings > *').size()) 
    {
      $(xml).find('settings, settings > *').each(function() 
      {
        if (this.attributes.length)
        {
          var _k = $(this).get(0).tagName.toLowerCase();
          var _v = {};
          for (var _i in this.attributes)
          {
            if (typeof(this.attributes[_i].value) != "undefined")
            {
              var _value = this.attributes[_i].value;
              switch(_value)
              {
                case "true":
                  _value = true;
                break;
                case "false":
                  _value = false;
                break;
              }
              if (_k == "settings")
              {
                templateInfoObj.settings[this.attributes[_i].name] = _value;
              }
              else
              {
                if (typeof(templateInfoObj.settings[_k]) == "undefined")
                {
                  templateInfoObj.settings[_k] = {};
                }
                templateInfoObj.settings[_k][this.attributes[_i].name] = _value;
              }
            }
          }
        }
      });
    }
    // title
    templateInfoObj.title = null;
    if ($(xml).find("[type=title]").size())
    {
      templateInfoObj.title = $(xml).find("[type=title]").text();
    }
    // content
    templateInfoObj.content = null;
    if ($(xml).find("[type=content]").size())
    {
      templateInfoObj.content = "";
      var _tmp = null;
      var _role = null
      $(xml).find("[type=content]").each(function()
      {
        if ($(this).attr("role") == "ul" || $(this).attr("role") == "ol")
        {
          _role = $(this).attr("role");
          if (_tmp == null)
          {
            _tmp = "<"+_role+">";
          }
          _tmp += "<li>" + $(this).text() + "</li>";
        }
        else
        {
          if (_tmp != null)
          {
            templateInfoObj.content += _tmp + "</"+_role+">";
            _tmp = null;
          }
          templateInfoObj.content += "<p>" + $(this).text() + "</p>";
        }
      });
      if (_tmp != null)
      {
        templateInfoObj.content += _tmp + "</ul>";
        _tmp = null;
      }
    }
    // directions
    templateInfoObj.directions = null;
    if ($(xml).find("[type=directions]").size())
    {
      templateInfoObj.directions = [];
      $(xml).find("[type=directions]").each(function()
      {
        templateInfoObj.directions.push($(this).text());
      });
    }
    // list
    templateInfoObj.list = {};
    if ($(xml).find("[type=list]").size())
    {
      var _key = -1;
      var _group_role = $(xml).find("[type=list]").first().attr("role");
      if (typeof(_group_role) == "undefined")
      {
        _group_role = $(xml).find("[type=list]").first().get(0).tagName.toLowerCase();
      }
      $(xml).find("[type=list]").each(function()
      {
        var _role = $(this).attr("role");
        if (typeof(_role) == "undefined")
        {
          _role = $(this).get(0).tagName.toLowerCase();
        }
        if (_role == _group_role)
        {
          _key++;
        }
        if (_key > -1)
        {
          if (typeof(templateInfoObj.list[_key]) == "undefined")
          {
            templateInfoObj.list[_key] = {};
          }
          if (typeof(templateInfoObj.list[_key][_role]) == "string" && templateInfoObj.list[_key][_role].length)
          {
            var _tmp = templateInfoObj.list[_key][_role];
            templateInfoObj.list[_key][_role] = [];
            templateInfoObj.list[_key][_role].push(_tmp);
          }
          if (typeof(templateInfoObj.list[_key][_role]) == "object")
          {
            templateInfoObj.list[_key][_role].push($(this).text());
          }
          else
          {
            templateInfoObj.list[_key][_role] = $(this).text();
          }
        }
      });
    }
    // attachment
    templateInfoObj.attachment = null;
    if ($(xml).find("[type=attachment]").size())
    {
      templateInfoObj.attachment = [];
      $(xml).find("[type=attachment]").each(function()
      {
        var _tmp = {
          title: $(this).text(),
          src: $(this).attr("document")
        };
        templateInfoObj.attachment.push(_tmp);
      });
    }
    // preload audios
    templateInfoObj.preloadAudios = [];
    if ($(xml).find('audio').size()) 
    {
      $(xml).find('audio').each(function() 
      {
        templateInfoObj.preloadAudios.push($(this).text());
      });
    }
    // screen audio
    templateInfoObj.screenAudio = null;
    if ($(xml).find('audio[for="screenAudio"]').size()) 
    {
      templateInfoObj.screenAudio = $(xml).find('audio[for="screenAudio"]').first().text();
    }
    // preload images
    templateInfoObj.preloadImages = [];
    if ($(xml).find('image').size())
    {
      $(xml).find('image').each(function() 
      {
        templateInfoObj.preloadImages.push($(this).text());
      });
    }
    // bg image
    templateInfoObj.bgImagePath = null;
    if ($(xml).find('image[for="bg"]').size()) 
    {
      templateInfoObj.bgImagePath = $(xml).find('image[for="bg"]').first().text();
    }
    // settings: reload btn
    $("#reloadBtn").hide();
    if (typeof(templateInfoObj.settings.showReply) != "undefined" && templateInfoObj.settings.showReply)
    {
      $("#reloadBtn").show();
    }
    if (typeof(isDebugMode) != "undefined" && isDebugMode)
    {
      $("#reloadBtn").show();
    }

    var curScreenObj = new window[templateInfoObj.templateClass](templateInfoObj);
    curScreenObj.create();
    dialogueObj = curScreenObj;
    if (templateInfoObj.templateClass != "T_Splash_Screen_01")
    {
      $(".introPage").hide();
    }
    document.location.hash = current_MLA;
  });
}

function initializeCurScreen(slideObj, className)
{
  if (typeof(isDebugMode) != "undefined" && isDebugMode)
  {
    $(".primary").prepend($("<p>"+currentModuleXMLPath+"</p>").css({color: "#000", position: "absolute", "z-index": 12}));
  }
  if (typeof(className) != "undefined" && className.length)
  {
    $(".frameCapture").addClass(className);
  }
  $(".hideObjects").show();
  $(".frameCapture").hide().css({position: "absolute", left: -9999, top: -9999}).show();

  // settings
  for (var _i in slideObj.settings)
  {
    var _obj = null;
    switch (_i)
    {
      case "column1":
        _obj = $(".primary");
      break;
      case "column2":
        _obj = $(".secondary");
      break;
    }

    for (var _j in slideObj.settings[_i])
    {
      switch (_j)
      {
        case "width":
          _obj.css(_j, slideObj.settings[_i][_j]);
        break;
        case "gradient":
          if (slideObj.settings[_i][_j] == false)
          {
            _obj.removeClass("whiteFade");
          }
        break;
        case "class":
          _obj.addClass(slideObj.settings[_i][_j]);
        break;
      }

    }
  }
  // bg
  if (slideObj.bgImagePath)
  {
    $(".frameCapture").css("background", "url(" + slideObj.bgImagePath + ") no-repeat 100% 0 transparent");
  }
  // set title
  $(".indexTitle").html(slideObj.title);
  // set content
  if (slideObj.content)
  {
    $(".pageTxt").html(slideObj.content);
  }
  else
  {
    $(".pageTxt").remove();
  }
  // set directions
  if (slideObj.directions)
  {
    $(".thermalBox ul").html("");
    for (var _i in slideObj.directions)
    {
      $(".thermalBox ul").append("<li>"+slideObj.directions[_i]+"</li>");
    }
    if (_i == 0)
    {
      $(".thermalBox ul").addClass("single");
    }
  }
  else
  {
    $(".thermalBox").remove();
  }
  // set docs
  if (slideObj.attachment)
  {
    $(".pdf_doc").html("");
    for (var _i in slideObj.attachment)
    {
      var _ext = slideObj.attachment[_i].src.split(".");
      _ext = _ext[_ext.length-1];
      var _li = $("<li>" + slideObj.attachment[_i].title + "</li>").data("src", slideObj.attachment[_i].src).addClass(_ext);
      _li.click(function()
      {
        window.open($(this).data("src"), '_blank');
      });
      $(".pdf_doc").append(_li);
    }
  }
  else
  {
    $(".pdf_doc").remove();
  }
  // audio
  if (slideObj.screenAudio)
  {
    maxAudioSplit = [];
    maxAudioSplit[0] = {
      'audio': slideObj.screenAudio,
      'cuePoint': ''
    };
    globalNavigator = true;
    check_enableSlider = true;
    audioCheckPlayNextClear = true;
    findDialogTemp = false;
    currentAduioInScreen = 0;
    dialogTimeDelay = [];
    audioNavBar.audio_refresh_Screen();
    en_Dis_Controller_Fn();
    audioElement_Int_fn(currentAduioInScreen);
  }
}

function finalizeCurScreen(slideObj)
{
  $(".frameCapture").hide().css({position: "static", left: 0, top: 0}).fadeIn();
  $(".preload").remove();
  for (var _i in slideObj.preloadImages)
  {
    var _img = $("<img class='preload' src='"+slideObj.preloadImages[_i]+"' style='position: absolute; left: -9999px; top: -9999px;'/>");
    $("body").append(_img);
  }
}

// enable and disable the controller 
function en_Dis_Controller_Fn() 
{
  $("#controller").removeAttr("style");
  if (maxAudioSplit.length == 0) 
  {
    $('#controller').show();      
    $('#sliderContainer').hide();
    $(".muteSet").hide(); 
    $('#controller').addClass("sliderReload");
    $(".toolTip").addClass("reloadOnly");
    maxAudioInScreen = 0;
    if ($("#controller > div:visible").size() == 0)
    {
      $("#controller").hide();
    }
  }
  else 
  {
    $('#controller').show();
    $("#controller .divider").show();
    $('.muteSet').show();
    $('#controller').removeClass("sliderReload");
    $(".toolTip").removeClass("reloadOnly");
    if (dialogTimeDelay.length > 0) 
    {
      $('#controller').removeClass('sliderWithoutSeek').removeClass('sliderRemoveMute').addClass('sliderWithSeek');
      $('#sliderContainer').show();
    }
    else 
    {
      $('#controller').removeClass('sliderWithSeek').removeClass('sliderRemoveMute').addClass('sliderWithoutSeek');
      $('#sliderContainer').hide();
    }
    $("#controller > div:visible").last().find(".divider").hide();
    var _w = 0;
    $("#controller > div:visible").each(function()
    {
      _w += $(this).outerWidth(true);
    });
    $("#controller").width(_w + 12);
    maxAudioInScreen = maxAudioSplit.length;
    slideControl.init("true"); //this function call from sliderControl.js
  }
}

//check double digit value
function checkDoubleDigit_Fn(parm)
{
  var val;
  if (parm > 10) 
  {
    val = parm;
  }
  else 
  {
    val = '0' + parm;
  }
  return val;
}

//replace particluar text in whole statements
String.prototype.replaceAll = function (token, newToken, ignoreCase) 
{
  var _token;
  var str = this + "";
  var i = -1;
  if (typeof token === "string") 
  {
    if (ignoreCase) 
    {
      _token = token.toLowerCase();
      while ((i = str.toLowerCase().indexOf(token, i >= 0 ? i + newToken.length : 0)) !== -1) 
      {
        str = str.substring(0, i) + newToken + str.substring(i + token.length);
      }
    }
    else 
    {
      return this.split(token).join(newToken);
    }
  }
  return (str);
};

//this function is used to uppercase te first letter in  word
function toTitleCase(str) 
{
  return str.replace(/\w\S*/g, function (txt) 
  {
    return txt.charAt(0).toUpperCase() + txt.substr(1).toLowerCase();
  });
}

//load xml
function xmlAjax($url, $data) 
{
  var _url = $url;
  if (typeof(isDebugMode) != "undefined" && isDebugMode)
  {
    _url += "?" + Math.random();
  }
  else if (typeof(versionXML) != "undefined" && versionXML.length)
  {
    _url += "?v=" + versionXML;
  }
  return $.ajax(
  {
    type: 'GET',
    url: _url,
    dataType: $data
  });
}

/* todo: check code below */

//this function is used to open PDF
function openPDFNewWindow(_this, param)
{
  var ind = $(_this).attr('id').split('_')[1];
  var documentTopoen = param[ind];
  
  if (documentTopoen.indexOf(".doc") > -1)
  {
    documentTopoen = documentTopoen.replace(".doc", ".pdf");
  }
  window.open(documentTopoen, '_blank');
}
