var T_Choice_01 = function (slideObj) {

  var className = slideObj.templateClass + " " + slideObj.templateType;
  var _this = this;
  var _slide_key = current_MLA;
  var templateURL = ctHtmlPath+_slide_key+".html";

  this.init = function() 
  {
    init_Screen();
  }

  var _obj = 
  {
    create: function() 
    {
      createXml();
    }
  }

  return _obj;

  function createXml() 
  {
    var preloads = new Preloads(_this, slideObj.preloadImages, slideObj.preloadAudios, "init");
    preloads.create();
  }

  function init_Screen() 
  {
    isNextPrevBtn = "true";

    $("#contentContainer").html("").append(defaultTemplate.clone(true));
    if (slideObj.templateKey)
    {
      if (typeof(isDebugMode) != "undefined" && isDebugMode)
      {
        templateURL += "?" + Math.random();
      }
      else if (typeof(versionXML) != "undefined" && versionXML.length)
      {
        templateURL += "?v=" + versionXML;
      }
      var _container = $("<div/>");
      $("#contentContainer").append(_container);
      _container.load(templateURL, "", function() 
      {
        success_Init_Screen();
      });
    }
    else
    {
      success_Init_Screen();
    }
  }

  function success_Init_Screen() 
  {
    if (typeof(slideObj.settings.params.scoreResult) == "undefined" || slideObj.settings.params.scoreResult == true)
    {
      mainMenuObj.courseData.menuTrackObj[choosenModule].lessonStatusArr[choosenLesson].activityStatusArr[choosenActivity].screenStatusArr[choosenScreen].score = ASSESSMENT_MINSCORE;
    }

    slideObj.title = '<span id="question">?</span>' + slideObj.title;
    // initialize action
    initializeCurScreen(slideObj, className);

    var _numberAttempts = 1;
    if (typeof(slideObj.settings.params.numberAttempts) != "undefined")
    {
      _numberAttempts = Number(slideObj.settings.params.numberAttempts);
    }
    var _currentAttempt = 0;

    // build test
    var _list = {};
    if ($(slideObj.xmlData).find("[type=option]").size())
    {
      $(slideObj.xmlData).find("[type=option]").each(function(i)
      {
        _list[i] = {
          title: $(this).text(),
          correct: !!($(this).attr("role") == "correct")
        };
      });
    }

    var _feedback = {};
    if ($(slideObj.xmlData).find("[type=feedback]").size())
    {
      $(slideObj.xmlData).find("[type=feedback]").each(function(i)
      {
        _feedback[$(this).attr("role")] = $(this).text();
      });
    }

    $(".secondary").html("");

    _feedback_html = $(''
      +'<div class="Feedback_box">'
      +'<div class="feedback_head">'
      +'<h2>Feedback</h2><div class="close cursor_MC">X</div>'
      +'</div>'
      +'<div class="fbDiv"></div>'
      +'</div>').hide();
    $(".primary").append(_feedback_html);
    _feedback_html.find(".close").click(function()
    {
      _feedback_html.fadeOut();
    });

    var _question_title = $('<div class="asideTxt"><span>'+$(slideObj.xmlData).find("[type=question]").text()+'</span><div class="bg"></div></div>');
    $(".secondary").append(_question_title);

    var _submit = $('<div class="submitBtn disabled">SUBMIT</div>');
    $(".secondary").after($('<div class="submit_box"></div>'));
    $(".submit_box").append(_submit);
    _submit.click(function()
    {
      if ($(".checkBox .checked").size() == 0)
      {
        return false;
      }
      if (_currentAttempt >= _numberAttempts)
      {
        return false;
      }
      _currentAttempt++;
      var _correct = true;
      $(".checkBox li").each(function()
      {
        var _i = $(this).data("index");
        if ((_list[_i].correct && !$(this).hasClass("checked"))
        || (!_list[_i].correct && $(this).hasClass("checked")))
        {
          _correct = false;
        }
      });
      if (_correct)
      {
        if (typeof(slideObj.settings.params.scoreResult) == "undefined" || slideObj.settings.params.scoreResult == true)
        {
          mainMenuObj.courseData.menuTrackObj[choosenModule].lessonStatusArr[choosenLesson].activityStatusArr[choosenActivity].screenStatusArr[choosenScreen].score = ASSESSMENT_MAXSCORE;
        }
        _feedback_html.find(".fbDiv").html(_feedback["correct"]);
        _feedback_html.fadeIn();
      }
      else
      {
        if (typeof(slideObj.settings.params.scoreResult) == "undefined" || slideObj.settings.params.scoreResult == true)
        {
          mainMenuObj.courseData.menuTrackObj[choosenModule].lessonStatusArr[choosenLesson].activityStatusArr[choosenActivity].screenStatusArr[choosenScreen].score = ASSESSMENT_MINSCORE;
        }
        if (_currentAttempt < _numberAttempts && typeof(_feedback["incorrect_first_attempt"]) != "undefined")
        {
          _feedback_html.find(".fbDiv").html(_feedback["incorrect_first_attempt"]);
        }
        else
        {
          _feedback_html.find(".fbDiv").html(_feedback["incorrect"]);
        }
        _feedback_html.fadeIn();
      }
      _submit.addClass("disabled");
      if (_currentAttempt == _numberAttempts || _correct)
      {
        $(".checkBox li").addClass("disabled");
        if (typeof(slideObj.settings.params.showCorrectAnswer) != "undefined" && slideObj.settings.params.showCorrectAnswer == true)
        {
          $(".checkBox li").removeClass("checked");
          $(".checkBox li").each(function()
          {
            var _i = $(this).data("index");
            if (_list[_i].correct)
            {
              $(this).addClass("checked");
            }
          });
        }
      }
      else
      {
        $(".checkBox li").removeClass("checked");
      }
    });

    var _html_list = $('<ul class="checkBox"></ul>');
    for (var _i in _list)
    {
      var _title = _list[_i].title
      if (typeof(isDebugMode) != "undefined" && isDebugMode)
      {
        _title += _list[_i].correct;
      }
      var _li = $("<li></li>").html("<span>" + _title + "</span><div class='bg'></div>").data("index", _i);
      _li.click(function()
      {
        if ($(this).hasClass("disabled"))
        {
          return false;
        }
        switch(slideObj.templateType)
        {
          case 'single':
            $(".checkBox .checked").removeClass("checked");
            $(this).toggleClass("checked");
          break;
          case 'multiple':
          default:
            $(this).toggleClass("checked");
          break;
        }
        if ($(".checkBox .checked").size() == 0)
        {
          _submit.addClass("disabled");
        }
        else
        {
          _submit.removeClass("disabled");
        }
      });
      if (typeof(slideObj.settings.params.fixedOption) != "undefined" && slideObj.settings.params.fixedOption - 1 == _i)
      {
        _html_list.append(_li);
      }
      else if (Math.floor(Math.random() * 1000) % 2)
      {
        _html_list.append(_li);
      }
      else
      {
        _html_list.prepend(_li);
      }
    }
    $(".secondary").append(_html_list);

    // finalize action
    finalizeCurScreen(slideObj);
  }
}