var T_Drag_Drop_01 = function (slideObj) {

  var className = slideObj.templateClass + " " + slideObj.templateType;
  var _this = this;
  var _slide_key = current_MLA;
  var templateURL = ctHtmlPath+_slide_key+".html";

  this.init = function() 
  {
    init_Screen();
  }

  var _obj = 
  {
    create: function() 
    {
      createXml();
    }
  }

  return _obj;

  function createXml() 
  {
    var preloads = new Preloads(_this, slideObj.preloadImages, slideObj.preloadAudios, "init");
    preloads.create();
  }

  function init_Screen() 
  {
    isNextPrevBtn = "true";

    $("#contentContainer").html("").append(defaultTemplate.clone(true));
    if (slideObj.templateKey)
    {
      if (typeof(isDebugMode) != "undefined" && isDebugMode)
      {
        templateURL += "?" + Math.random();
      }
      else if (typeof(versionXML) != "undefined" && versionXML.length)
      {
        templateURL += "?v=" + versionXML;
      }
      var _container = $("<div/>");
      $("#contentContainer").append(_container);
      _container.load(templateURL, "", function() 
      {
        success_Init_Screen();
      });
    }
    else
    {
      success_Init_Screen();
    }
  }

  function success_Init_Screen() 
  {
    if (typeof(slideObj.settings.params.scoreResult) == "undefined" || slideObj.settings.params.scoreResult == true)
    {
      mainMenuObj.courseData.menuTrackObj[choosenModule].lessonStatusArr[choosenLesson].activityStatusArr[choosenActivity].screenStatusArr[choosenScreen].score = ASSESSMENT_MINSCORE;
    }

    slideObj.title = '<span id="question">?</span>' + slideObj.title;
    // initialize action
    initializeCurScreen(slideObj);

    var _numberAttempts = 1;
    if (typeof(slideObj.settings.params.numberAttempts) != "undefined")
    {
      _numberAttempts = Number(slideObj.settings.params.numberAttempts);
    }
    var _currentAttempt = 0;

    // build test
    var _list = {};
    if ($(slideObj.xmlData).find("[type=option]").size())
    {
      var _key = -1;
      $(slideObj.xmlData).find("[type=option]").each(function()
      {
        var _role = $(this).attr("role");
        if (_role == "label")
        {
          _key++;
          if (_key > 0)
          {
            _list[_key] = clone(_list[_key-1]);
          }
        }
        if (typeof(_list[_key]) == "undefined")
        {
          _list[_key] = {};
        }
        _list[_key][_role] = $(this).text();
      });
    }

    var _feedback = {};
    if ($(slideObj.xmlData).find("[type=feedback]").size())
    {
      $(slideObj.xmlData).find("[type=feedback]").each(function(i)
      {
        _feedback[$(this).attr("role")] = $(this).text();
      });
    }

    $(".secondary").html("");

    _feedback_html = $(''
      +'<div class="Feedback_box">'
      +'<div class="feedback_head">'
      +'<h2>Feedback</h2><div class="close cursor_MC">X</div>'
      +'</div>'
      +'<div class="fbDiv"></div>'
      +'</div>').hide();
    $(".primary").append(_feedback_html);
    _feedback_html.find(".close").click(function()
    {
      _feedback_html.fadeOut();
    });

    var _question_title = $('<div class="asideTxt">'+$(slideObj.xmlData).find("[type=question]").text()+'</div>');
    $(".secondary").append(_question_title);

    var _submit = $('<div class="submitBtn disabled">SUBMIT</div>');
    $(".secondary").after($('<div class="submit_box"></div>'));
    $(".submit_box").append(_submit);
    _submit.click(function()
    {
      if ($(".drag-box").size() != $(".drag-box.checked").size())
      {
        return false;
      }
      if (_currentAttempt >= _numberAttempts)
      {
        return false;
      }
      _currentAttempt++;
      var _correct = true;
      $(".dragBox .drag-box").each(function()
      {
        var _i = $(this).data("index");
        var _checked_i = $(this).data("checked_index");
        if (_i != _checked_i)
        {
          _correct = false;
        }
      });
      if (_correct)
      {
        if (typeof(slideObj.settings.params.scoreResult) == "undefined" || slideObj.settings.params.scoreResult == true)
        {
          mainMenuObj.courseData.menuTrackObj[choosenModule].lessonStatusArr[choosenLesson].activityStatusArr[choosenActivity].screenStatusArr[choosenScreen].score = ASSESSMENT_MAXSCORE;
        }
        _feedback_html.find(".fbDiv").html(_feedback["correct"]);
        _feedback_html.fadeIn();
      }
      else
      {
        if (typeof(slideObj.settings.params.scoreResult) == "undefined" || slideObj.settings.params.scoreResult == true)
        {
          mainMenuObj.courseData.menuTrackObj[choosenModule].lessonStatusArr[choosenLesson].activityStatusArr[choosenActivity].screenStatusArr[choosenScreen].score = ASSESSMENT_MINSCORE;
        }
        if (_currentAttempt < _numberAttempts && typeof(_feedback["incorrect_first_attempt"]) != "undefined")
        {
          _feedback_html.find(".fbDiv").html(_feedback["incorrect_first_attempt"]);
        }
        else
        {
          _feedback_html.find(".fbDiv").html(_feedback["incorrect"]);
        }
        _feedback_html.fadeIn();
      }
      _submit.addClass("disabled");
      if (_currentAttempt == _numberAttempts || _correct)
      {
        $(".drag-box").draggable("disable");
        if (typeof(slideObj.settings.params.showCorrectAnswer) != "undefined" && slideObj.settings.params.showCorrectAnswer == true)
        {
          $(".dragBox .drag-box").each(function()
          {
            var _obj = $(this)
            var _i = _obj.data("index");
            $(".drop-box-wrap .drop-box").each(function()
            {
              if (_i == $(this).data("index"))
              {
                _obj.animate(
                {
                  top: $(this).position().top
                });
              }
            });
          });
        }
      }
      else
      {
        $(".ui-state-highlight").removeClass("ui-state-highlight");
        $("li > .drop-box").each(function()
        {
          var _obj = $(this).find(".drag-box");
          _obj.animate(
          {
            top: $(this).position().top,
            left: $(this).position().left
          });
          _obj.removeClass("checked");
          $(this).addClass("ui-state-highlight");
        });
      }
    });

    var _html_list = $('<ul class="dragBox"></ul>');
    var _li = $("<li></li>");
    for (var _i in _list)
    {
      var _label = _list[_i].label;
      if (typeof(isDebugMode) != "undefined" && isDebugMode)
      {
        _label += _i;
      }
      var _drag = $('<div class="drag-box"><span>'+_label+'</span></div>').data("index", _i).data("checked_index", -1);
      var _html = $('<div class="drop-box ui-state-highlight start"></div>').append(_drag);
      if (Math.floor(Math.random() * 1000) % 2)
      {
        _li.append(_html);
      }
      else
      {
        _li.prepend(_html);
      }
    }
    _html_list.append(_li);
    var _li = $("<li></li>");
    for (var _i in _list)
    {
      var _div = $("<div class='drop-box-wrap'></div>");
      var _description = _list[_i].description;
      if (typeof(isDebugMode) != "undefined" && isDebugMode)
      {
        _description += _i;
      }
      var _html = $('<div class="drop-box stop"></div>').data("index", _i);
      _div.append(_html);
      var _html = $('<div class="description"><span>'+_description+'</span></div>');
      _div.append(_html);
      if (Math.floor(Math.random() * 1000) % 2)
      {
        _li.append(_div);
      }
      else
      {
        _li.prepend(_div);
      }
    }
    _html_list.append(_li);
    $(".secondary").append(_html_list);
    var _h = $(".dragBox").height() / $(".drag-box").size();
    _h = _h - 10;
    $(".dragBox .drop-box, .dragBox .drag-box, .dragBox .drag-box span, .dragBox .description, .dragBox .description span").height(_h);
    $(".dragBox .drag-box").each(function() 
    {
      $(this).css("top", $(this).parent().position().top);
    });

    var _do_out = true;
    $(".drag-box").draggable(
    {
      snap: ".drop-box", 
      snapMode: "inner",
      revert: function()
      {
        if (
          $(".ui-state-highlight").size() != $(".drag-box").size()
          || $(".ui-state-highlight").hasClass("ui-state-disabled")
        )
        {
          if ($(".ui-state-revert").size())
          {
            if ($(".ui-state-revert").parent().hasClass("drop-box-wrap"))
            {
              $(".ui-draggable-dragging").addClass("checked");
              $(".ui-draggable-dragging").data("checked_index", $(".ui-state-revert").data("index"));
            }
            else
            {
              $(".ui-draggable-dragging").removeClass("checked");
              $(".ui-draggable-dragging").data("checked_index", -1);
            }
            if ($(".drag-box").size() == $(".drag-box.checked").size())
            {
              _submit.removeClass("disabled");
            }
            else
            {
              _submit.addClass("disabled");
            }
          }
          $(".ui-state-revert").addClass("ui-state-highlight").removeClass("ui-state-revert");
          $(".ui-state-highlight").removeClass("ui-state-disabled");
          _do_out = true;
          return true;
        }
      }
    });
    $(".drop-box").droppable(
    {
      tolerance: "intersect",
      activeClass: "ui-state-hover",
      hoverClass: "ui-state-active",
      drop: function( event, ui ) 
      {
        var _obj = $(this);
        _do_out = true;
        $(".ui-draggable-dragging").animate(
        {
          top: _obj.position().top,
          left: _obj.position().left
        });
        if (_obj.hasClass("ui-state-highlight"))
        {
          _obj.addClass("ui-state-disabled");
        }
        else
        {
          $(".ui-state-revert").removeClass("ui-state-revert");
          _obj.addClass( "ui-state-highlight" );
        }
        if (_obj.position().left > 0)
        {
          $(".ui-draggable-dragging").addClass("checked");
          $(".ui-draggable-dragging").data("checked_index", _obj.data("index"));
        }
        else
        {
          $(".ui-draggable-dragging").removeClass("checked");
          $(".ui-draggable-dragging").data("checked_index", -1);
        }
        if ($(".drag-box").size() == $(".drag-box.checked").size())
        {
          _submit.removeClass("disabled");
        }
        else
        {
          _submit.addClass("disabled");
        }
      },
      out: function( event, ui ) 
      {
        if (_do_out)
        {
          $( this ).addClass("ui-state-revert");
          $( this ).removeClass("ui-state-highlight");
          _do_out = false;
        }
      }
    });

    // call custom method
    var _method_exists = false;
    eval("_method_exists = !!(typeof("+_slide_key+") == 'function');");
    if (_method_exists) {
      eval(_slide_key+"(slideObj);");
    }

    // finalize action
    finalizeCurScreen(slideObj);
  }
}