var T_Slideshow_01 = function (slideObj) {

  var className = slideObj.templateClass;
  var _this = this;
  var _slide_key = current_MLA;
  var templateURL = ctHtmlPath+_slide_key+".html";

  this.init = function() 
  {
    init_Screen();
  }

  var _obj = 
  {
    create: function() 
    {
      createXml();
    }
  }

  return _obj;

  function createXml() 
  {
    var preloads = new Preloads(_this, slideObj.preloadImages, slideObj.preloadAudios, "init");
    preloads.create();
  }

  function init_Screen() 
  {
    isNextPrevBtn = "true";

    $("#contentContainer").html("").append(defaultTemplate.clone(true));
    if (slideObj.templateKey)
    {
      if (typeof(isDebugMode) != "undefined" && isDebugMode)
      {
        templateURL += "?" + Math.random();
      }
      else if (typeof(versionXML) != "undefined" && versionXML.length)
      {
        templateURL += "?v=" + versionXML;
      }
      var _container = $("<div/>");
      $("#contentContainer").append(_container);
      _container.load(templateURL, "", function() 
      {
        success_Init_Screen();
      });
    }
    else
    {
      success_Init_Screen();
    }
  }

  function success_Init_Screen() 
  {
    // initialize action
    initializeCurScreen(slideObj, className);
  
    var _start = $(slideObj.xmlData).find("[type=slide-start]").first();
    switch (_start.get(0).tagName.toLowerCase())
    {
      case 'image':
        var _img = $("<div class='slide-start'><img src='" + _start.text() + "' /></div>")
        _img.click(function(){
          openSlideshow(slideObj);
        });
        $(".secondary").append(_img);
      break;
      case 'obj':
        var _obj = $("<div class='slide-start-circle'></div>")
        _obj.click(function(){
          openSlideshow(slideObj);
        });
        $(".secondary").append(_obj);
      break;
    }

    // call custom method
    var _method_exists = false;
    eval("_method_exists = !!(typeof("+_slide_key+") == 'function');");
    if (_method_exists) {
      eval(_slide_key+"(slideObj);");
    }
  
    // finalize action
    finalizeCurScreen(slideObj);
  }

  function openSlideshow(slideObj)
  {
    var _html = $("<ul></ul class='slider'>");
    for (var _i in slideObj.list)
    {
      var _li = $("<li></li>");
      if (typeof(slideObj.list[_i]["title"]) != "undefined")
      {
        _li.append($("<div class='title'>" + slideObj.list[_i]["title"] + "</div>"));
      }
      else
      {
        _li.append($("<div class='title'>&nbsp;</div>"));
      }
      if (typeof(slideObj.list[_i]["image"]) == "object")
      {
        var _div = $("<div class='image-wrap'></div>");
        for (var _j in slideObj.list[_i]["image"])
        {
          _div.append($("<div class='image image-"+_j+"'><span><img src='" + slideObj.list[_i]["image"][_j] + "' /></span></div>"));
        }
        _li.append(_div);
      }
      else if (typeof(slideObj.list[_i]["image"]) != "undefined")
      {
        _li.append($("<div class='image'><span><img src='" + slideObj.list[_i]["image"] + "' /></span></div>"));
      }
      if (typeof(slideObj.list[_i]["content"]) == "object")
      {
        var _div = $("<div class='text'></div>");
        for (var _j in slideObj.list[_i]["content"])
        {
          _div.append($("<p>" + slideObj.list[_i]["content"][_j] + "</p>"));
        }
        _li.append(_div);
      }
      else if (typeof(slideObj.list[_i]["content"]) != "undefined")
      {
        _li.append($("<div class='text'><p>" + slideObj.list[_i]["content"] + "</p></div>"));
      }
      _html.append(_li);
    }
    $(".dialog-content .content").html("").append(_html);
    _html.jcarousel(
    {
      scroll: 1, 
      itemLoadCallback: function(_obj, event_type) 
      { 
        if (slideObj.id != current_MLA)
        {
          return false;
        }
        if (typeof(slideObj.list[_obj.first - 1]["tooltip"]) != "undefined")
        {
          var _tmp = $("<span title=''/>");
          var _div = $("<div class='text'></div>");
          if (typeof(slideObj.list[_obj.first - 1]["tooltip"]) == "object")
          {
            for (var _j in slideObj.list[_obj.first - 1]["tooltip"])
            {
              _div.append($("<p>" + slideObj.list[_obj.first - 1]["tooltip"][_j] + "</p>"));
            }
          }
          else
          {
            _div.append($("<p>" + slideObj.list[_obj.first - 1]["tooltip"] + "</p>"));
          }
          _tmp.tooltip({ content: _div.html(), show: "show"}).tooltip("open");
          $(".ui-tooltip").removeAttr("style").addClass("item-" + (_obj.first - 1));
          $('.jcarousel-container').find(".ui-tooltip").remove();
          $('.jcarousel-container').append($(".ui-tooltip"));
          $(".ui-tooltip").show();
        }
        if (typeof(jcarousel_itemLoadCallback) == "function")
        {
          jcarousel_itemLoadCallback(_obj, event_type);
        }
      }
    });
    $(".dialog").css({left: 0, top: 0});
  }
}