var glossaryText;
var searchFlag = 0;
var anchorVal;
var localVar = 0;
var initLoad = 0;
var templateURL = fwHtmlPath + "glossary.html";

var glossaryTemplate = function(params) 
{
	var xmlData;
	var parentContainer = params.container;
	var xmlPath = params.xmlPath;
	var _this = this;
	this.create = function() 
  {
		$(parentContainer).show();
		xmlObj = xmlAjax(xmlPath, "xml");
		xmlObj.success(function (xml) 
    {
			xmlData = xml;
			readXMLText();
		});
	}

	this.init = function() 
  {
		isNextPrevBtn = "true";
    if (typeof(isDebugMode) != "undefined" && isDebugMode)
    {
      templateURL += "?" + Math.random();
    }
    else if (typeof(versionXML) != "undefined" && versionXML.length)
    {
      templateURL += "?v=" + versionXML;
    }
		$(parentContainer).load(templateURL, "", function () 
    {
      $(".overview").empty();
      _this.glossaryGlobal();
		});
	}
	
	this.glossaryGlobal = function()
  {
		loadGlossary();
		glossarySearch();
		$(".glossary_close-btn").bind('click',closeBtnClick);
	}
	
	function closeBtnClick()
  {
		$("#closeBtn").unbind('click',closeBtnClick);
		$(".overview").empty();
		$('.searchicon').val('');
		$(".glossary_right").empty();
		localVar = 0;
		initLoad = 0;
		anchorVal = "";
		$(parentContainer).hide();
	}
	
	function readXMLText() 
  {
    glossaryText = {};
    if ($(xmlData).find("[type=list]").size())
    {
      var _key = -1;
      var _group_role = $(xmlData).find("[type=list]").first().attr("role");
      if (typeof(_group_role) == "undefined")
      {
        _group_role = $(xmlData).find("[type=list]").first().get(0).tagName.toLowerCase();
      }
      $(xmlData).find("[type=list]").each(function()
      {
        var _role = $(this).attr("role");
        if (typeof(_role) == "undefined")
        {
          _role = $(this).get(0).tagName.toLowerCase();
        }
        if (_role == _group_role)
        {
          _key++;
        }
        if (_key > -1)
        {
          if (typeof(glossaryText[_key]) == "undefined")
          {
            glossaryText[_key] = {};
          }
          if (typeof(glossaryText[_key][_role]) == "string" && glossaryText[_key][_role].length)
          {
            var _tmp = glossaryText[_key][_role];
            glossaryText[_key][_role] = [];
            glossaryText[_key][_role].push(_tmp);
          }
          if (typeof(glossaryText[_key][_role]) == "object")
          {
            glossaryText[_key][_role].push($(this).text());
          }
          else
          {
            glossaryText[_key][_role] = $(this).text();
          }
        }
      });
    }
		var preloads = new Preloads(_this, 0, 0, "init");
		preloads.create();
	}
	
}

function glossarySearch() 
{
  $("input").keyup(function () 
  {
    searchFlag = 0;
    initLoad = 0;
    loadGlossary();
  });
}

function anchorSearch(aValue) 
{
  anchorVal = aValue;
  searchFlag = 1;
  localVar = 0;
}

function loadGlossary() 
{
	$(".glossary_container").find('ul').empty();
	$(".glossary_right").empty();
	var indexVal = 0;
	var myRegExp;
	for (sch in glossaryText) {
		myRegExp = $('.searchicon').val().toLowerCase();
		if (searchFlag == 1) 
    {
			myRegExp = anchorVal;
		}
		if (localVar == 0) 
    {
      $('.searchicon').val(anchorVal);
      localVar = 1;
		}
		var glossaryVal = glossaryText[sch].name;
		var matchPos = glossaryVal.search(myRegExp);
		if ((myRegExp == "search") || (myRegExp == "Search")) 
    {
			matchPos = 0;
		}
		if (matchPos == 0) 
    {
			$(".glossary_container").find('ul').append("<li id='li_index_" + indexVal + "'>" + glossaryVal + "</li>");
			$(".glossary_right").append("<p id='li_description_" + indexVal + "'>" + glossaryText[sch].definition + "</p>");
			$('#li_description_' + indexVal).css("display", "none");
			if (initLoad == 0)
			{
				$('#li_description_0').css("display", "block");
				$('#li_index_0').addClass("active");
			}
			$("#li_index_" + indexVal).bind("click", function () 
      {
				for (m in glossaryText) 
        {
					$('#li_description_' + m).css("display", "none");
					$('#li_index_' + m).removeClass("active");
				}
				var elementId = $(this).attr("id");
				elementId = elementId.split("_")[2];
				$('#li_description_' + elementId).css("display", "block");
				$('#li_index_' + elementId).addClass("active");
			});
			indexVal++;
		}
	}
}

function showGlossary(obj)
{
  $('.searchicon').val('');
	$(".glossary_right").empty();
	$(".overview").empty();
	aValue = $(obj).attr("href").replace("#", "");
	anchorSearch(aValue);
	glossary_Template.glossaryGlobal();
	$("#glossary_optionContainer").show();
  return false;
}