﻿// formatted
// clone object
function clone(obj)
{
  // Handle the 3 simple types, and null or undefined
  if (null == obj || "object" != typeof obj) return obj;

  // Handle Date
  if (obj instanceof Date)
  {
    var copy = new Date();
    copy.setTime(obj.getTime());
    return copy;
  }

  // Handle Array
  if (obj instanceof Array)
  {
    var copy = [];
    for (var i = 0, len = obj.length; i < len; i++)
    {
      copy[i] = clone(obj[i]);
    }
    return copy;
  }

  // Handle Object
  if (obj instanceof Object)
  {
    var copy = {};
    for (var attr in obj)
    {
      if (obj.hasOwnProperty(attr)) copy[attr] = clone(obj[attr]);
    }
    return copy;
  }

  throw new Error("Unable to copy obj! Its type isn't supported.");
}

// format string
// '<div>{0}, {1} is {2}</div>'.format('Hello', 'me', 'here'); // <div>Hello, me is here</div>
if (!String.prototype.format) 
{
  String.prototype.format = function() 
  {
    var args = arguments;
    return this.replace(/{(\d+)}/g, function(match, number) 
    {
      return typeof args[number] != 'undefined'
        ? args[number]
        : match
      ;
    });
  };
}

// get count properties of the object
function countProperties(obj) 
{
  var count = 0;
  for(var prop in obj) 
  {
    if (obj.hasOwnProperty(prop))
    {
      ++count;
    }
  }
  return count;
}

// preload image
jQuery.fn.preload = function() 
{
  this.each(function()
  {
    $('<img/>')[0].src = this;
  });
}

// get parameter from URL
function getParameterByName(name) 
{
  name = name.replace(/[\[]/, "\\\[").replace(/[\]]/, "\\\]");
  var regex = new RegExp("[\\?&]" + name + "=([^&#]*)"),
      results = regex.exec(location.search);
  return results == null ? "" : decodeURIComponent(results[1].replace(/\+/g, " "));
}