var canvasRollOver=function(params){
	var parentContainer = params.container;
	var templateUIName = params.templateUI;
	var xmlType = Number(params.templateXMLTYPE);
	var domType = Number(params.templateUIType);
	var slideImagePath=params.imagePath;
	var xmlObj;
	var xmlData = params.xmlData;
	var titleText;
	var bodyText = [];
	var promptText = [];
	var headerText=[];
	var popupText=[];
	var imageLoadCount=0;
	var imageObjArr=[];
	var curIndex;
	var imageArr=[];
	var curURL = "component/Templates/" + templateUIName + ".html";
	var _this = this;
	
	this.create = function () {
		readXMLTexts();
	}

	this.init = function () {
		isNextPrevBtn = "true";
		var tmpStr = "";
		$(contentContainer).load(curURL, function () {
			$(".indexTitle label").html(titleText);
			$(".pageTxt").empty();
			for (var j = 0; j < bodyText.length; j++) {
				$(".pageTxt").append(bodyText[j]);
			}
			
			tmpStr = "";
			for (var j = 0; j < promptText.length; j++) {
				var str=(j+1)+"."
				promptText[j]=promptText[j].replace(str,"");
				tmpStr += '<li>' + promptText[j] + '</li>'
			}
			$(".thermalBox").find('ul').empty();
			$(".thermalBox").find('ul').append(tmpStr);
			$(".thermalBox").show();
			
			$(".imgGrid_wrapper").hide();
			
			$(".circleTriangle").attr('id','circleTriangle');
			
			$(".imgGrid_wrapper .close").bind('click',function(){
				$(".imgGrid_wrapper").hide();			
			});
			
			for(var i=0;i<slideImagePath.length;i++){
				imageArr[i]=new Image()
				imageArr[i].src=slideImagePath[i];
				imageArr[i].addEventListener('load',onImageLoad,false);
			}
			
			//loadImages();
			
			$(".glossaryClick").bind("click", function () {
				glossoryForWords($(this));
			})
			
		});
	}
	
	function onImageLoad(){
		imageLoadCount++;
		if(imageLoadCount == slideImagePath.length){
			initCanvas();
		}
	}
	
	function initCanvas(){
		
		var coordinates=[{x:86.5,y:17.3,ind:0},{x:215.2,y:55.8,ind:4},{x:217.15,y:226.15,ind:3},{x:12.95,y:226.1,ind:2},{x:1,y:59.25,ind:1}];
		
		
		var stage = new Kinetic.Stage({
										container: 'circleTriangle',
										width: 426,
										height: 452
			});
		    
		var layer = new Kinetic.Layer();
		
		
		for(var i=0;i<slideImagePath.length;i++){
			
			var curImageObj = new Kinetic.Image({
				  x: coordinates[i].x,
				  y: coordinates[i].y,
				  image: imageArr[i],
				  id:coordinates[i].ind,
				  width: imageArr[i].width,
				  height: imageArr[i].height
			});
			
			curImageObj.createImageHitRegion(function(){
				layer.draw();			
			});
			
			curImageObj.on('mouseover',function(){
				$("#circleTriangle").css('cursor','pointer');
			});

			curImageObj.on('mouseout',function(){
				$("#circleTriangle").css('cursor','default');
			});
			
			curImageObj.on('click touchstart',function(){
				var curID=this.attrs.id;
				$(".imgGrid_wrapper h1").html(headerText[curID]);
				$(".imgGrid_wrapper .imGridTxt").html(popupText[curID]);
				$(".imgGrid_wrapper").show();
			});
			
			imageObjArr.push(curImageObj);
			layer.add(curImageObj);
		}
			stage.add(layer);
	}
	
	
	function removeTextsFromString(str, searchStr) {
		var index = str.indexOf(searchStr);
		var str1;
		var str2;
		while (index != -1) {
			index = str.indexOf(searchStr);
			if (index > -1) {
				endIndex = searchStr.length + index;
				str1 = str.substring(0, index);
				str2 = str.substring(endIndex, str.length);
				str = str1 + str2;
			}
		}
		return str;
	}

	function readXMLTexts() {
		var tempText;

		$(xmlData).find('p').each(function (i, j) {
			if ($(this).attr('id') == "title_text_2") {
				titleText = $(j).text();
			}else if ($(this).attr('id') == "body_text_1" || $(this).attr('id') == "body_text_2") {
				temp = $(j).text();
				temp  = temp.replaceAll('href="event:', 'class="glossaryClick" href="#event:');
				temp = removeTextsFromString(temp, "[extra]");
				temp = removeTextsFromString(temp, "[/extra]");
				bodyText.push(temp);
			}else if ($(this).attr('id').indexOf('prompt_text') > -1) {
				var str = $(j).text();
				str = removeTextsFromString(str, "[extra]");
				str = removeTextsFromString(str, "[/extra]");
				promptText.push(str);
			}
		});
		
		checkXmlType();
		getImageArray();
		
		var preloads = new Preloads(_this,0, 0, "init");
		preloads.create();
	}
	
	function checkXmlType(){
		switch(xmlType){
			case 1:
				readXmlType1();
				break;
		}
	}
	
	function readXmlType1(){
		$(xmlData).find('p').each(function (i, j) {
			if( ( $(this).attr('id').indexOf("roll") > -1 ) && ( $(this).attr('id').indexOf("title") > -1 ) ){
				 var str1=$(j).text();
				 var str2=$(j).next().text();
				 headerText.push(str1);
				 popupText.push(str2);
			}
		});
		//headerText=headerText.reverse();
		//popupText=popupText.reverse();
	}

	function getImageArray(){
		for(var i=0;i<slideImagePath.length;i++){
			imageArr.push(slideImagePath[i]);
		}
	}
	





















}