var ellipseRollOver=function(params){
	var parentContainer = params.container;
	var templateUIName = params.templateUI;
	var xmlType = Number(params.templateXMLTYPE);
	var domType = Number(params.templateUIType);
	var slideImagePath=params.imagePath;
	var xmlObj;
	var xmlData = params.xmlData;
	var titleText;
	var bodyText = [];
	var promptText = [];
	var headerText=[];
	var popupText=[];
	var normalImageCount=5;
	var imageLoadCount=0;
	var imageObjArr=[];
	var curIndex;
	var imageArr=[];
	var prevElement="";
	var curURL = "component/Templates/" + templateUIName + ".html";
	var _this = this;
	
	this.create = function () {
		readXMLTexts();
	}

	this.init = function () {
		isNextPrevBtn = "true";
		var tmpStr = "";
		$(contentContainer).load(curURL, function () {
			$(".indexTitle label").html(titleText);
			$(".pageTxt").empty();
			for (var j = 0; j < bodyText.length; j++) {
				$(".pageTxt").append(bodyText[j]);
			}
			
			tmpStr = "";
			for (var j = 0; j < promptText.length; j++) {
				var str=(j+1)+"."
				promptText[j]=promptText[j].replace(str,"");
				tmpStr += '<li>' + promptText[j] + '</li>'
			}
			
			$(".pdf_doc").hide();
			
			$(".thermalBox").find('ul').empty();
			$(".thermalBox").find('ul').append(tmpStr);
			$(".thermalBox").show();
			
			$(".rolloverTxtBox").hide();
			
			$(".canvasRollover").attr('id','canvasRollover');
			
			//alert(slideImagePath)
			
			for(var i=0;i<slideImagePath.length;i++){
				var image=new Image(); 
				image.src=slideImagePath[i];
				image.addEventListener('load',onImageLoad,false);
				imageObjArr.push(image);
			}
			
		});
	}
	
	function onImageLoad(){
		imageLoadCount++;
		if(imageLoadCount == slideImagePath.length){
			//alert(imageLoadCount)
			initCanvas();
		}
	}
	
	function initCanvas(){
		
		var coordinates=[{x:78,y:49,ind:0},{x:164.95,y:7.3,ind:1},{x:337,y:125,ind:2},{x:180,y:266,ind:3},{x:8,y:135,ind:4}];
		
		
		var stage = new Kinetic.Stage({
										container: 'canvasRollover',
										width: 550,
										height: 500
			});
		    
		var layer = new Kinetic.Layer();
		
		
		//alert(imageObjArr)
		
		for(var i=0;i<normalImageCount;i++){
			
			var curImageObj = new Kinetic.Image({
				  x: coordinates[i].x,
				  y: coordinates[i].y,
				  image: imageObjArr[i],
				  id:coordinates[i].ind,
				  width: imageObjArr[i].width,
				  height: imageObjArr[i].height
			});
			
			if( i > 0){
			
					curImageObj.createImageHitRegion(function(){
						layer.draw();			
					})
					
					curImageObj.on('mouseover',function(){
						var curID=this.attrs.id;
						this.setImage(imageObjArr[curID+normalImageCount-1]);
						layer.draw();
						$(".rolloverTxtBox").show();
						$(".rolloverTxtBox p").html(popupText[curID-1]);
						$("#canvasRollover").css('cursor','pointer');
					});

					curImageObj.on('mouseout',function(){
						var curID=this.attrs.id;
						this.setImage(imageObjArr[curID]);
						layer.draw();
						$(".rolloverTxtBox").hide();
						$("#canvasRollover").css('cursor','default');
					});
					
					// Add touch action for screen 'sten_m04_l02_a03_s01'
					if (templateUIName == 'sten_m04_l02_a03_s01') {	
						curImageObj.off('mouseover');
						curImageObj.off('mouseout');
						curImageObj.on('click',function(){
							
							if(prevElement != ""){
								var curID=prevElement.attrs.id;
								prevElement.setImage(imageObjArr[curID]);
								layer.draw();
							}
							
							var curID=this.attrs.id;
							this.setImage(imageObjArr[curID+normalImageCount-1]);
							layer.draw();
							prevElement=this;
							$(".rolloverTxtBox").show();
							$(".rolloverTxtBox p").html(popupText[curID-1]);
						});
					}
					
					if (is_touch_device()) {	
						curImageObj.on('touchstart',function(){
							
							if(prevElement != ""){
								var curID=prevElement.attrs.id;
								prevElement.setImage(imageObjArr[curID]);
								layer.draw();
							}
							
							var curID=this.attrs.id;
							this.setImage(imageObjArr[curID+normalImageCount-1]);
							layer.draw();
							prevElement=this;
							$(".rolloverTxtBox").show();
							$(".rolloverTxtBox p").html(popupText[curID-1]);
						});
					}
			}
			
			imageObjArr.push(curImageObj);
			layer.add(curImageObj);
		} 
			stage.add(layer);
	}
	
	
	function removeTextsFromString(str, searchStr) {
		var index = str.indexOf(searchStr);
		var str1;
		var str2;
		while (index != -1) {
			index = str.indexOf(searchStr);
			if (index > -1) {
				endIndex = searchStr.length + index;
				str1 = str.substring(0, index);
				str2 = str.substring(endIndex, str.length);
				str = str1 + str2;
			}
		}
		return str;
	}

	function readXMLTexts() {
		var tempText;

		$(xmlData).find('p').each(function (i, j) {
			if ($(this).attr('id') == "title_text_1") {
				titleText = $(j).text();
			}else if ($(this).attr('id') == "body_text_1" || $(this).attr('id') == "body_text_2") {
				temp = $(j).text();
				temp  = temp.replaceAll('href="event:', 'class="glossaryClick" href="#event:');
				temp = removeTextsFromString(temp, "[extra]");
				temp = removeTextsFromString(temp, "[/extra]");
				bodyText.push(temp);
			}else if ($(this).attr('id').indexOf('prompt_text') > -1) {
				var str = $(j).text();
				str = removeTextsFromString(str, "[extra]");
				str = removeTextsFromString(str, "[/extra]");
				str=str.split("<br><br>");
				for(var i=0;i<str.length;i++){
					promptText.push(str[i]);
				}
			}
		});
		
		checkXmlType();
		getImageArray();
		
		var preloads = new Preloads(_this,imageArr, 0, "init");
		preloads.create();
	}
	
	function checkXmlType(){
		switch(xmlType){
			case 1:
				readXmlType1();
				break;
		}
	}
	
	function readXmlType1(){
		$(xmlData).find('p').each(function (i, j) {
			if( ( $(this).attr('id').indexOf("click") > -1 )  ){
				 var str1=$(j).text();
				 popupText.push(str1);
			}
		});
	}

	function getImageArray(){
		for(var i=0;i<slideImagePath.length;i++){
			imageArr.push(slideImagePath[i]);
		}
	}
	





















}