//+++++++++++++++++++++++ Variables +++++++++++++++++++
var startDate;
var exitPageStatus = false;
var lesson_loc = "";
var suspend_data = "";
var student_name = "";
var currentStatus = "";
var currentScore = 0;
var boolCourseCompleted = false;
//++++++++++++++++++++++++++++++++++++++++++++++++++++


//++++++++++++++++++++ loadPage() +++++++++++++++++++
// Initialise the scorm connection.
//+++++++++++++++++++++++++++++++++++++++++++++++++++
function loadPage()
{	
	result = doLMSInitialize();	
	if ( result == "true" ){
		var entryStatus = doLMSGetValue( "cmi.core.entry" );
		lesson_status = doLMSGetValue("cmi.core.lesson_status");
	   	if ( entryStatus == "ab-initio" || lesson_status.toLowerCase().charAt(0) == "n" ){
	   		// first time into the course, the student is now attempting the lesson
		  	doLMSSetValue( "cmi.core.lesson_status", "incomplete" );
		  	lesson_loc = "first_time";
	   	} else {
	   		// they've already started. get values in the lesson_location and suspend_data
	   		suspend_data = doLMSGetValue( "cmi.suspend_data" );
	   		lesson_loc = doLMSGetValue( "cmi.core.lesson_location" );	
	   		lesson_score = doLMSGetValue("cmi.core.score.raw");
	   		if (lesson_status == "completed" || lesson_status == "passed") boolCourseCompleted = true;
	   	}
	} else {
		// error no lms connection
	}
	var howScoWasNavigatedTo = null;
    	exitPageStatus = false;
    	startTimer();
}


//++++++++++++++++++++ unloadPage() ++++++++++++++++++++++++++++++++++++
// Called from the content.htm page when it is closed. Shuts down the
// LMS connection properly.
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function unloadPage()
{
	if (exitPageStatus != true)
	{
		if (document.flashMovie){
			var b = document.flashMovie.GetVariable("islBookmarkTracker");
			var p = document.flashMovie.GetVariable("islSuspendData");	
			//alert(b + ":" + p);	
			if (b != undefined && b.length > 1 ) doLMSSetValue( "cmi.core.lesson_location" , b );	
			if (p != undefined && p.length > 1 ) doLMSSetValue( "cmi.suspend_data" , p );
		}
		exitPageStatus = false;
		doQuit();
	} 
}

//++++++++++++++++++++ exitSCO() ++++++++++++++++++++++++++++++++++++
// Called from the flash framework when the exit button is pressed. 
// Shuts down the LMS connection properly.
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function exitSCO( strData , strBkmark )
{
	if (strData != undefined && strData.length > 0) doLMSSetValue( "cmi.suspend_data" , strData );
	if (strBkmark != undefined && strBkmark.length > 0) doLMSSetValue( "cmi.core.lesson_location" , strBkmark );
	exitPageStatus = true;
	doQuit();	
}

//++++++++++++++++++++ doQuit() ++++++++++++++++++++++++++++++++++++
// Function that correctly shuts down the LMS connection.
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function doQuit()
{
	var strSuspend;
	if (boolCourseCompleted){
		strSuspend = "";
	} else {
		strSuspend = "suspend";	
	} 
	doLMSSetValue( "cmi.core.exit", strSuspend );
		
	computeTime();
	
	var result = doLMSFinish();
	
	if (exitPageStatus) top.close();
	
}

//++++++++++++++++++++ updateTracking() +++++++++++++++++++++++++++++++++++++++
// This is the function that updates all the different LMS values. The values 
// are passed from the flash framework and updated on the LMS here.
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function updateTracking( strData , strBkmark, strCompStatus, strScore )
{
	var currentScore = doLMSGetValue("cmi.core.score.raw");
	if (strData != undefined && strData.length > 0) doLMSSetValue( "cmi.suspend_data" , strData );
	if (strBkmark != undefined && strBkmark.length > 0) doLMSSetValue( "cmi.core.lesson_location" , strBkmark );
	if (strCompStatus != undefined && strCompStatus.length > 0)
	{
	 setStatus(strCompStatus);	
	 if (strCompStatus=="completed") boolCourseCompleted = true;
	}
	if (strScore != undefined && strScore.length > 0){
		if ( strScore > 0 && strScore > currentScore) doLMSSetValue( "cmi.core.score.raw", strScore);	
	}
	doLMSCommit();	
}

//++++++++++++++++++++ setStatus() ++++++++++++++++++++++++++++++++++++++++++++
// This function sets the status of the sco
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function setStatus(sSCOCompleted){
	var mode = doLMSGetValue( "cmi.core.lesson_mode" );
	var currentStatus = doLMSGetValue("cmi.core.lesson_status");
	
	if(currentStatus == "passed" || currentStatus == "failed"  || currentStatus == "completed"){
			//return false because if this is a question (passed or failed)
			return false	
	}
	if ( mode != "review"  &&  mode != "browse" ){
		//the status is already set from "not attempted" to "incomplete" when the user first attempts a sco
		if(sSCOCompleted == "completed"){
			doLMSSetValue( "cmi.core.lesson_status", "completed" );
			doLMSCommit();
		}
	}
}

//++++++++++++++++++++ startTimer() +++++++++++++++++++++++++++
// Capture the time that the user started the course.
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function startTimer()
{
   	startDate = new Date().getTime();
}


//++++++++++++++++++++ computeTime() +++++++++++++++++++++++++++
// Calculate how much time the user has spent in the course.
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function computeTime()
{
	if ( startDate != 0 ){
		var currentDate = new Date().getTime();
		var elapsedSeconds = ( (currentDate - startDate) / 1000 );
		var formattedTime = convertTotalSeconds( elapsedSeconds );
	} else {
		formattedTime = "00:00:00.0";
	}
	
	doLMSSetValue( "cmi.core.session_time", formattedTime );
}

//++++++++++++++++++++ computeTime() ++++++++++++++++++++++++++++++++++++++
// This function will convert seconds into hours, minutes, and seconds in
// CMITimespan type format - HHHH:MM:SS.SS (Hours has a max of 4 digits &
// Min of 2 digits
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function convertTotalSeconds(ts)
{
	var sec = (ts % 60);
	
	ts -= sec;
	var tmp = (ts % 3600);  //# of seconds in the total # of minutes
	ts -= tmp;              //# of seconds in the total # of hours
	
	// convert seconds to conform to CMITimespan type (e.g. SS.00)
	sec = Math.round(sec*100)/100;
	
	var strSec = new String(sec);
	var strWholeSec = strSec;
	var strFractionSec = "";
	
	if (strSec.indexOf(".") != -1)
	{
	strWholeSec =  strSec.substring(0, strSec.indexOf("."));
	strFractionSec = strSec.substring(strSec.indexOf(".")+1, strSec.length);
	}
	
	if (strWholeSec.length < 2)
	{
	strWholeSec = "0" + strWholeSec;
	}
	strSec = strWholeSec;
	
	if (strFractionSec.length)
	{
	strSec = strSec+ "." + strFractionSec;
	}
	
	
	if ((ts % 3600) != 0 )
	var hour = 0;
	else var hour = (ts / 3600);
	if ( (tmp % 60) != 0 )
	var min = 0;
	else var min = (tmp / 60);
	
	if ((new String(hour)).length < 2)
	hour = "0"+hour;
	if ((new String(min)).length < 2)
	min = "0"+min;
	
	var rtnVal = hour+":"+min+":"+strSec;
	
	return rtnVal;
}