###############################################################################
###############################################################################
##
##  Copyright (C) 2004-2010 Red Hat, Inc.  All rights reserved.
##
##  This copyrighted material is made available to anyone wishing to use,
##  modify, copy, or redistribute it subject to the terms and conditions
##  of the GNU General Public License v.2.
##
###############################################################################
###############################################################################

###############################################################################
########################  CONFIGURABLE PARAMETERS #############################
###############################################################################

## NOTE: The name of your Driver Update. Replace "tmpl" with the name of
##       your kernel module. For example, "e1000e.ko" becomes "e1000e".
##       The build process automatically changes this to "kmod-e1000e".
%define kmod_name mpt2sas
%define version 20.00.00.00
%define release 1

Version:        %{version}
Release:        %{release}%{?dist}
Group:          System Environment/Kernel
License:        GPL
URL:            http://www.lsi.com

## NOTE: Set the kernel version to build against. This can differ
##       from the exact version in use post-installation but for
##       Driver Update Disks must match the install-time kernel.
%{!?kversion: %define kversion 2.6.18-308.el5}

## NOTE: Set this to the distribution release you are using. This allows
##       a module to be more closely tied to a specific update. It is
##       also possible not to set a specific release in some cases.
%define kmod_rel rhel5.8

###############################################################################
############################# OPTIONAL PARAMETERS #############################
###############################################################################

## NOTE: Do not set this unless you must override symbol checks
##       (replace the intial "#" with a "%" to uncomment)
##       Also uncomment "Source12: symbols.greylist" below.
#define __find_requires %_sourcedir/find-requires.ksyms
##

## NOTE: Use only if required.
#Source12: symbols.greylist

###############################################################################
################## YOU SHOULD NOT NEED TO CHANGE THE FOLLOWING ################
###############################################################################

Source10: kmodtool_mpt2sas
Source11: find-requires.ksyms

%define kmodtool bash %{SOURCE10}
%define kverrel %(%{kmodtool} verrel %{?kversion} 2>/dev/null)

%ifarch i686 x86_64 ia64
%define xenvar xen
%endif

%ifarch i686
%define paevar PAE
%endif

%ifarch ppc64
%define kdumpvar kdump
%endif

%define upvar ""
%{!?kvariants: %define kvariants %{?upvar} %{?xenvar} %{?kdumpvar} %{?paevar}}

Name:           %{kmod_name}
Summary:        %{kmod_name} kernel module
Source0:        %{kmod_name}-%{version}.tar.bz2
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
ExclusiveArch:  i686 ia64 ppc64 x86_64

%description
%{kmod_name} - LSI MPT Fusion HBA drivers

# magic hidden here:
%{expand:%(%{kmodtool} rpmtemplate_kmp %{kmod_name} %{kmod_rel} %{kverrel} %{kvariants} 2>/dev/null)}

%prep
# to understand the magic better or to debug it, uncomment this:
#{kmodtool} rpmtemplate_kmp %{kmod_name} %{kverrel} %{kvariants} 2>/dev/null
#sleep 5
%setup -q -c -T -a 0
for kvariant in %{kvariants} ; do
    cp -a %{kmod_name}-%{version} _kmod_build_$kvariant
done


%build
echo  %{kverrel}
for kvariant in %{kvariants}
do
    ksrc=%{_usrsrc}/kernels/%{kverrel}${kvariant:+-$kvariant}-%{_target_cpu}
    pushd _kmod_build_$kvariant
    make -C "${ksrc}" modules M=$PWD
    popd
done


%install
export INSTALL_MOD_PATH=$RPM_BUILD_ROOT
export INSTALL_MOD_DIR=extra/%{kmod_name}
for kvariant in %{kvariants}
do
    ksrc=%{_usrsrc}/kernels/%{kverrel}${kvariant:+-$kvariant}-%{_target_cpu}
    pushd _kmod_build_$kvariant
    make -C "${ksrc}" modules_install M=$PWD
    popd
done

# create depmod configuration
mkdir -p ${RPM_BUILD_ROOT}/etc/depmod.d
cat<<EOF > ${RPM_BUILD_ROOT}/etc/depmod.d/%{kmod_name}-%{kmod_rel}.conf
override %{kmod_name} * weak-updates/%{kmod_name}
EOF

mkdir -p ${RPM_BUILD_ROOT}/lib/firmware

%clean
rm -rf $RPM_BUILD_ROOT

%changelog
* Wed Mar 3 2010 Jon Masters <jcm@redhat.com>
- Updated some of the documentation.

* Sun Aug 9 2009 Jiri Olsa <jolsa@redhat.com>
- Initial mpt2sas package.
