%define name mpt2sas
%define version 20.00.00.00
%define release 1
%define Kernel 3.0.0
Summary: LSI MPT Fusion drivers for SAS 2.0
Name: %{name}
Version: %{version}
Release: %{release}
Vendor: LSI Corporation
License: GPL
Group: System Environment/Kernel
Source0: %{name}-%{version}.tar.gz
Source1: Module.supported
URL: http://www.lsi.com
Distribution: LSI Coporation
BuildRoot: /var/tmp/%{name}-buildroot
Packager: Sreekanth Reddy <Sreekanth.Reddy@lsi.com>

%description
Drivers for (i686, x86_64 and updates) for the
LSI Corporation MPT Fusion Architecture parts.

# prep #########################################################################
%prep
echo prep %{version}
%setup -c -b 0
cp %_sourcedir/Module.supported drivers/scsi/mpt2sas/Module.supported


# build ########################################################################
%build
echo build %{version}
for kernel in `ls /lib/modules/ | grep "%{Kernel}"`; do
	make build KERNEL=${kernel};
done

# install ######################################################################
%install
echo install %{version}
echo "%defattr(-,root,root)" > $RPM_BUILD_DIR/file.list.%{name}
for kernel in `ls /lib/modules/ | grep "%{Kernel}"`; do
	MPTLINUX_IPATH=/lib/modules/${kernel}/weak-updates/mpt2sas
	mkdir -p $RPM_BUILD_ROOT/lib/modules/${kernel}/weak-updates/mpt2sas
	echo "$MPTLINUX_IPATH/mpt2sas.ko" >> $RPM_BUILD_DIR/file.list.%{name}
	echo "install is called";
	make install PREFIX=$RPM_BUILD_ROOT KERNEL=${kernel}
done
# pre #########################################################################
%pre
echo pre %{version}
system_arch=`uname -m`
if [ %{_target_cpu} != ${system_arch} ]; then
	echo "ERROR: Failed installing this rpm!!!!"
	echo "This rpm is intended for %{_target_cpu} platform. It seems your system is ${system_arch}.";
	exit 1;
fi;

# post #########################################################################
%post
echo post %{version}

#blacklist_file="/etc/modprobe.d/blacklist"
for kernel in `ls /lib/modules`; do

	if [ ! -e /boot/vmlinuz-${kernel} ]; then
		continue;
	fi;
	MPTLINUX_IPATH=/lib/modules/${kernel}/weak-updates/mpt2sas
	if [ ! -e $MPTLINUX_IPATH/mpt2sas.ko ]; then
		continue;
	fi;

	MPTLINUX_ORIG_IPATH=/lib/modules/${kernel}/kernel/drivers/scsi/mpt2sas
	echo "The mpt driver for kernel ${kernel} is now version 20.00.00.00";

	# Remake the initrd image
	MPTLINUX_IPATH=/lib/modules/${kernel}/kernel/drivers/scsi/mpt2sas
	if [ -e $MPTLINUX_IPATH/mpt2sas.ko ]; then
		mv $MPTLINUX_IPATH/mpt2sas.ko \
			$MPTLINUX_IPATH/mpt2sas.ko.orig
	fi;

	MPTLINUX_IPATH=/lib/modules/${kernel}/updates
	if [ -e $MPTLINUX_IPATH/mpt2sas.ko ]; then
		mv $MPTLINUX_IPATH/mpt2sas.ko \
			$MPTLINUX_IPATH/mpt2sas.ko.orig
	fi;

	MPTLINUX_IPATH=/lib/modules/${kernel}/extra/mpt2sas
	if [ -e $MPTLINUX_IPATH/mpt2sas.ko ]; then
		mv $MPTLINUX_IPATH/mpt2sas.ko \
			$MPTLINUX_IPATH/mpt2sas.ko.orig
	fi;

	bootpart=/boot;
	depmod -v ${kernel} > /dev/null 2>&1;

#   By default mkinitramfs command includes only those modules present in kernel/driver path
#   in to the initrd image. So inorder to include mpt2sas.ko module which is present in weak-update
#   directory in to initrd image then append "mpt2sas" line to /etc/initramfs-tools/modules.   
#   /etc/initramfs-tools/modules stores those modules that we want to include in our initramfs.
	
	mkinitramfs_modules=/etc/initramfs-tools/modules
	pattern=`grep -R "mpt2sas" ${mkinitramfs_modules}`
	if [ $? -ne 0 ]; then
		echo "mpt2sas" >> ${mkinitramfs_modules} 
	else
		sed -e s/"$pattern"/mpt2sas/ ${mkinitramfs_modules} > /tmp/mkinitramfs_modules
		mv /tmp/mkinitramfs_modules ${mkinitramfs_modules}
	fi

	mkinitramfs -k -o ${bootpart}/initrd.img-${kernel} ${kernel}
done;
echo -e "post Install Done."

# postun #######################################################################
%postun
echo postun %{version}
for kernel in `ls -1 /lib/modules`; do

	MPTLINUX_IPATH=/lib/modules/${kernel}/weak-updates/mpt2sas

	if [ ! -e $MPTLINUX_IPATH/mpt2sas.ko ]; then

		rm -rf $MPTLINUX_IPATH;

		MPTLINUX_IPATH=/lib/modules/${kernel}/kernel/drivers/scsi/mpt2sas
		if [ -e $MPTLINUX_IPATH/mpt2sas.ko.orig ]; then
			mv $MPTLINUX_IPATH/mpt2sas.ko.orig \
				$MPTLINUX_IPATH/mpt2sas.ko
		fi;

		MPTLINUX_IPATH=/lib/modules/${kernel}/updates
		if [ -e $MPTLINUX_IPATH/mpt2sas.ko.orig ]; then
			mv $MPTLINUX_IPATH/mpt2sas.ko.orig \
				$MPTLINUX_IPATH/mpt2sas.ko
		fi;

		MPTLINUX_IPATH=/lib/modules/${kernel}/extra/mpt2sas
		if [ -e $MPTLINUX_IPATH/mpt2sas.ko.orig ]; then
			mv $MPTLINUX_IPATH/mpt2sas.ko.orig \
				$MPTLINUX_IPATH/mpt2sas.ko
		fi;
	fi;

	bootpart=/boot;

	if [ ! -f /lib/modules/${kernel}/kernel/drivers/scsi/mpt2sas/mpt2sas.ko ] && \
	   [ ! -f /lib/modules/${kernel}/udpates/mpt2sas.ko ] && \
	   [ ! -f /lib/modules/${kernel}/weak-updates/mpt2sas/mpt2sas.ko ] && \
	   [ ! -f /lib/modules/${kernel}/extra/mpt2sas/mpt2sas.ko ]; then
		sed -e '/mpt2sas/d' /etc/modprobe.conf > modprobe.edit;
		mv -f modprobe.edit /etc/modprobe.conf;
	fi;

	depmod -v ${kernel} > /dev/null 2>&1;

#  Delete the "mpt2sas" line from /etc/initramfs-tools/modules file
	mkinitramfs_modules=/etc/initramfs-tools/modules
	sed '/mpt2sas/d' ${mkinitramfs_modules} > /tmp/module_remove
	mv /tmp/module_remove ${mkinitramfs_modules}

	mkinitramfs -k -o ${bootpart}/initrd.img-${kernel} ${kernel}
done;
echo -e "Uninstall Done."

# files ########################################################################
%files -f ../file.list.%{name}
