# FORCE_EFI_BOOT

echo -off
# +
# + ============================================================== +
#  Copyright (c) 2014, 2015 Intel Corporation.

#  This source code and any documentation accompanying it ("Material") is furnished
#  under license and may only be used or copied in accordance with the terms of that
#  license.  No license, express or implied, by estoppel or otherwise, to any
#  intellectual property rights is granted to you by disclosure or delivery of these
#  Materials.  The Materials are subject to change without notice and should not be
#  construed as a commitment by Intel Corporation to market, license, sell or support
#  any product or technology.  Unless otherwise provided for in the license under which
#  this Material is provided, the Material is provided AS IS, with no warranties of
#  any kind, express or implied, including without limitation the implied warranties
#  of fitness, merchantability, or non-infringement.  Except as expressly permitted by
#  the license for the Material, neither Intel Corporation nor its suppliers assumes
#  any responsibility for any errors or inaccuracies that may appear herein.  Except
#  as expressly permitted by the license for the Material, no part of the Material
#  may be reproduced, stored in a retrieval system, transmitted in any form, or
#  distributed by any means without the express written consent of Intel Corporation.

#  Module Name:  Startup.nsh

#  Abstract:  UEFI Script file for invoking system software updates.

# + ============================================================== +
#    Program all blocks of BIOS from capsule file 
# + ============================================================== +

@echo -off
mode 80 25
;foundimage section is simply to locate the correct drive
cls
if exist .\ipmi.efi then
 goto FOUNDIMAGE
endif
if exist fs0:\ipmi.efi then
 fs0:
 echo Found Update Packages on fs0:
 goto FOUNDIMAGE
endif
if exist fs1:\ipmi.efi then
 fs1:
 echo Found Update Packages on fs1:
 goto FOUNDIMAGE
endif
if exist fs2:\ipmi.efi then
 fs2:
 echo Found Update Packages on fs2:
 goto FOUNDIMAGE
endif
 echo "Unable to find Update Packages".  
 echo "Please mount the drive with the update package".
 echo ""
 goto END
:FOUNDIMAGE
load ipmi.efi > null 

echo "================================================================================"
echo "This utility will update the BMC firmware, system BIOS (Primary and Backup Images),"
echo "ME firmware, and FRU & SDR data on the following Intel products only:"
echo ""
echo ""
echo "      - Intel(R) Server Board S2600TP Product Family"
echo "      - Intel(R) Compute Module HNS2600TP Product Family"
echo ""
echo ""
echo "Do NOT interrupt or reboot the system during any update process. Updates that"
echo "have completed successfully will display an update completion message "
echo ""
echo " *** If you have not read the README file providing the Update Instructions,"
echo "     it is highly advisable you do that before continuing with this update. ***"
echo ""
echo "================================================================================"

pause

echo ""
echo "Starting System Update......"
echo "Loading FRU and SDR revision 1.09 data"
frusdr /cfg master.cfg
echo ""
echo ""
echo ""
echo "ME Firmware 03.00.07.154 and BIOS R01.01.0009 are being installed."
updBIOSAll.nsh
echo ""
echo "ME Firmware and BIOS updates have completed"
echo ""
echo ""
echo "BMC firmware 1.35.9065 is being installed."
echo ""
FWPIAUPD -u -bin -ni -b -o -pia -if=usb BMC_i_0135r9065.bin
echo ""
echo ""
echo ""
echo "The system code update is now complete."
echo "If required the PSUs and HSPBs will now update in the background."
echo "Since this FW can be background updated, you can reboot now but do not remove AC."
echo ""
echo *******************************************************************************
echo ***********************Do not remove AC power**********************************
echo *******************************************************************************
echo ""
echo "Remove the USB Device and Reboot the system with CTR ALT DEL or by pressing any key." 
echo "Re-configure the system BIOS settings using the BIOS Setup Utility accessed by
echo "hitting the F2 key during system POST."
echo ""
echo "READ THIS: When the system is rebooted, the screen will be blank for "
echo "approximately 2 minutes while the backup BIOS image is being loaded. "
echo "DO NOT power off or reboot your system during this time.   "
echo "A brief message will appear on the screen when the update has completed. "
echo "and the system will continue to OS boot" 
echo ""
:END
echo "Press Any Key to reboot or q to quit"
pause
reset


