var pages;
var pageIndex;

$(document).ready(function() {
	entryPoint();
});

function init() {
	$('#ajax-cont').append('<div id="cardPile"></div><div id="cardSlots"></div>');
	$('#cardPile').droppable({
		accept: '.card',
		drop: function (even,ui) { 
			ui.draggable.draggable( 'option', 'revert', false );
			$('#cardSlots .question:nth-child(' + (pageIndex + 1) + ') .slot[card="' + ui.draggable.attr('id') + '"]').attr('card', '');
		},
		out: handleCardOut,
		hoverClass: 'hovered'
	});

	pages = [];
	
	if (gameDisplayOptions === 0) {
		$(gameXMLDOM).find('GapFillAssembledQuestionItem').each(function(qIndex, question) {
			var prefixesArray = [];
			var answersArray = [];
			var suffixesArray = [];
	
			$(question).find('GapFillQuestionItem').each(function(index, subquestion) {
				prefixesArray.push($(subquestion).find('Prefix').text());
				answersArray.push({
					text: $(subquestion).find('Answer').text(),
					correct: index
				});
				suffixesArray.push($(subquestion).find('Suffix').text());
			});
	
			pages.push({
				'prefixes': prefixesArray,
				'answers': answersArray,
				'suffixes': suffixesArray,
				'audio': $(question).find('Audio > URL').text()
			});
		});
	} else {
		var prefixesArray = [];
		var answersArray = [];
		var suffixesArray = [];
		
		$(gameXMLDOM).find('GapFillQuestionItem').each(function(qIndex, question) {
			prefixesArray.push($(question).find('Prefix').text());
			answersArray.push({
				text: $(question).find('Answer').text(),
				correct: qIndex
			});
			suffixesArray.push($(question).find('Suffix').text());
		});
		
		pages.push({
			'prefixes': prefixesArray,
			'answers': answersArray,
			'suffixes': suffixesArray,
			'audio': $(gameXMLDOM).find('Audio > URL').text()
		});
	}
}

function getPage(pageNumber){
	pageIndex = pageNumber;
	$('#cardPile .question').hide();
	$('#cardPile .question:nth-child(' + (pageNumber + 1) + ')').show();
	$('#cardSlots .question').hide();
	$('#cardSlots .question:nth-child(' + (pageNumber + 1) + ')').show();
}

function getAudio () {
	return pages[pageIndex].audio;
}

function getPagesCount() {
	return pages.length;
}

function onCheckPageAnswer(page){ 
	if (typeof(page) !== 'number'){
		page = pageIndex;
	}
	
	$('#cardSlots .question:nth-child(' + (page + 1) + ') .slot').each(function () {
		$(this).parent().removeClass( 'correct incorrect' );
		if ($(this).attr('card') === $(this).attr('id')) {
			$(this).parent().addClass( 'correct' );
		} else {
			$(this).parent().addClass( 'incorrect' );
		}
		$(this).parent().addClass('show');
	});
}

function reset(){
	// Create the pile of shuffled cards
	$('#cardPile').empty();
	$('#cardSlots').empty();
	$.each(pages, function(pIndex, page) {
		page.answers.sort(function() { return Math.random() - 0.5; });
		var $question = $('<div class="question"></div>');
		$.each(page.answers, function (index, item) {
			$('<div class="card" id="' + item.correct + '">' + item.text + '</div>').appendTo($question).draggable({
				stack: '#cardPile',
				cursor: 'move',
				revert: true,
				scrollSensitivity: 1
			});
		});
		$('#cardPile').append($question);
	
		$question = $('<div class="question"></div>');
		$.each(page.prefixes, function (index, prefix) {
			var $subQuestion = $(
				'<div class="subquestion">' +
					(index + 1) + '. ' + prefix +
					'<span class="slot-wrap">' +
						'<div class="slot" id="' + index + '">&nbsp;</div>' +
						'<img id="incorrect-icon" src="images/icon-incorrect.png"/>' +
						'<img id="correct-icon" src="images/icon-correct.png"/>' +
					'</span>' +
					page.suffixes[index] +
				'</div>');
			$subQuestion.find('.slot').droppable({
				accept: '#cardPile div',
				hoverClass: 'hovered',
				drop: handleCardDrop,
				out: handleCardOut
			});
			$question.append($subQuestion);
		});
		$('#cardSlots').append($question);
	});

	$('#gameStartPopup').show();
	$('#gameStartPopup').animate( {
		left: '380px',
		top: '200px',
		width: '400px',
		height: '100px',
		opacity: 1
	});
}

function handleCardDrop( event, ui ) {
	if ($(this).attr('card') === '' || $(this).attr('card') === undefined) {
		$('#cardSlots .question:nth-child(' + (pageIndex + 1) + ') .slot[card="' + ui.draggable.attr('id') + '"]').attr('card', '');
		$(this).attr('card', ui.draggable.attr('id'));
		
		ui.draggable.draggable( 'option', 'revert', false );
		$(this).width(ui.draggable.width());
		ui.draggable.position({ of: $(this), my: 'center center', at: 'center center' });
	}
}

function handleCardOut (event, ui) {
	ui.draggable.draggable( 'option', 'revert', true );
}

function getScore () {
	var questions = [];
	var answers = [];
	var corrects = [];
	var points = [];
	var totals = [];
	var gamePoints = 0;
	var gameTotal = 0;
	
	$.each(pages, function(pIndex, page) {
		questions.push('');
		var answer = '<br/>';
		var correct = '<br/>';
		var qPoints = 0;
		var qTotal = 0;
		$('#cardSlots .question:nth-child(' + (pIndex + 1) + ') .slot').each(function(sIndex, slot) {
			var input = $('#cardPile .question:nth-child(' + (pIndex + 1) + ') .card[id="' + $(slot).attr('card') + '"]').text();
			if (input === '') {
				input = '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
			}
			answer += 
				(sIndex + 1) + '. ' + 
				page.prefixes[sIndex] + 
				' <u>' + input + '</u> ' +
				page.suffixes[sIndex] + '<br/>';
			correct += 
				(sIndex + 1) + '. ' + 
				page.prefixes[sIndex] +
				' <u>' + $('#cardPile .question:nth-child(' + (pIndex + 1) + ') .card[id="' + sIndex + '"]').text() + '</u> ' +
				page.suffixes[sIndex] + '<br/>';
			
			if ($(slot).parent().hasClass('correct')) {
				qPoints ++;
				gamePoints ++;
			}

			qTotal ++;
			gameTotal++;
		});

		answers.push(answer);
		corrects.push(correct);
		points.push(qPoints);
		totals.push(qTotal);
	});
	
	return {
		'questions': questions,
		'answers': answers,
		'corrects': corrects,
		'points': points,
		'totals': totals,
		'gamePoints': gamePoints,
		'gameTotal': gameTotal
	};
}