var questionsArray = [];
var cardsArray = [];

$(document).ready(function() {
	entryPoint();
});

//Game-specific initialization
function init(){
	$('#ajax-cont').html('<div id="cardPile"> </div><div id="questions"> </div>');
	$('#cardPile').droppable({
		accept: '.card',
		drop: function (even,ui) { 
			ui.draggable.draggable( 'option', 'revert', false );
			$('.slot[card="' + ui.draggable.attr('id') + '"]').attr('card', '').parent().removeClass('show correct incorrect');
		},
		out: handleCardOut,
		hoverClass: 'hovered'
	});

	$(gameXMLDOM).find('SimpleQuestionItem').each(function (qIndex, question) {
		questionsArray.push({
			'image': $(question).find('Image > URL').text(),
			'correct': qIndex
		});
		cardsArray.push({
			'text': $(question).find('Answer').text(),
			'audio': $(question).find('Answer').attr('url'),
			'correct': qIndex
		});
	});
}

//Should return the number of pages
function getPagesCount() {
	return 1;
}

//Game-specific reset procedure
function reset() {
	$('#cardPile').html( '' );
	$('#questions').html( '' );

	cardsArray.sort( function() { return Math.random() - 0.5; } );
	$.each(cardsArray, function (cIndex, card) {
		$card = $(
			'<div class="card" id="' + card.correct + '"><div class="text">' + card.text + '</div></div>'
		);
		if (card.audio !== undefined) {
			$card.append(getAudioCode(card.audio));
			processPlayer($card.find('.audio'));
		}
		$('#cardPile').append($card);
		$('#cardPile .card:nth-child(' + (cIndex + 1) + ')').draggable({
			stack: '#cardPile div',
			cursor: 'move',
			revert: true
		});
	});
	
	questionsArray.sort( function() { return Math.random() - 0.5; } );
	$.each(questionsArray, function (qIndex, question) {
		var $question =
		$('<div class="question">' +
			'<img class="image" src="' + question.image + '"/>' +
			'<div class="slot-wrap">' +
				'<div class="slot" id="' + question.correct + '" card></div>' +
				'<img id="incorrect-icon" src="images/icon-incorrect.png"/>' +
				'<img id="correct-icon" src="images/icon-correct.png"/>' +
			'</div>' +
		'</div>');
		$question.find('.slot').droppable({
			accept: '.card',
			hoverClass: 'hovered',
			drop: handleCardDrop,
			out: handleCardOut
		});
		$('#questions').append($question);
	});
}

function handleCardDrop( event, ui ) {
	if ($(this).attr('card') === '' || $(this).attr('card') === undefined) {
		$('.slot[card="' + ui.draggable.attr('id') + '"]').attr('card','').parent().removeClass('show correct incorrect');
		$(this).attr('card', ui.draggable.attr('id'));
		$(this).css({
			'width': ui.draggable.outerWidth(),
			'height': ui.draggable.outerHeight()
		});
		ui.draggable.draggable( 'option', 'revert', false );
		ui.draggable.position({ of: $(this), my: 'center center', at: 'center center' });
		adjustCards();
	}
}

function handleCardOut (event, ui) {
	ui.draggable.draggable( 'option', 'revert', true );
}

//If there are several pages, page loading handler
function getPage(pageNumber){
	
}

//When Check Answers button is pressed
function onCheckPageAnswer() {
	$('.slot[card!=""]').each(function () {
		$(this).parent().removeClass( 'correct' );
		$(this).parent().removeClass( 'incorrect' );
		if ($(this).attr('card') === $(this).attr('id')) {
			$(this).parent().addClass( 'correct' );
		} else {
			$(this).parent().addClass( 'incorrect' );
		}
	});
	$('.slot-wrap.correct').addClass('show');
	$('.slot-wrap.incorrect').addClass('show');
	adjustCards();
}

function adjustCards() {
	$('.slot').each(function(sIndex, slot) {
		var cardId = $(slot).attr('card');
		if (cardId !== undefined && cardId !== '') {
			$('.card[id="' + cardId + '"]').position({
				of: $(slot),
				my: 'center center', 
				at: 'center center'
			});
		}
	});
}

//The score values to be displayed after the game finish
//returns: {percentage: , points: , total: }
function getScore() {
	var questions = [];
	var answers = [];
	var corrects = [];
	var points = [];
	var totals = [];
	var gamePoints = 0;
	var gameTotal = 0;
	
	$('#questions .question').each(function(qIndex, question) {
		questions.push('<img style="height: 100px" src="' + questionsArray[qIndex].image + '"/>');
		
		var slotWrap = $(question).find('.slot-wrap');
		
		answers.push($('#cardPile .card[id="' + slotWrap.find('.slot').attr('card') + '"]').text());
		
		corrects.push($('#cardPile .card[id="' + slotWrap.find('.slot').attr('id') + '"]').text());
		
		if (slotWrap.hasClass('correct')) {
			points.push(1);
			gamePoints ++;
		} else {
			points.push(0);
		}
		totals.push(1);
		gameTotal++;
	});
	
	return {
		'questions': questions,
		'answers': answers,
		'corrects': corrects,
		'points': points,
		'totals': totals,
		'gamePoints': gamePoints,
		'gameTotal': gameTotal
	};
}

//Audio file, if available
function getAudio() {
	return '';
}