var pageIndex;
var questionsArray = [];

$(document).ready(function() {
	entryPoint();
});

//Game-specific initialization
function init(){
	var defaultOptions = '';
	var letters = 'abcdefghijklmnopqrstuvwxyz';
	$(gameXMLDOM).find('GlobalOptions > Option').each(function(index, Element) {
		defaultOptions +=
			'<a class="options" href="javascript:void(0)" value='+$(this).attr('value')+' onclick="answerQuestion(this)">' +
				'<img id="incorrect-icon" src="images/icon-incorrect.png"/>' +
				'<img id="correct-icon" src="images/icon-correct.png"/>' +
				'<span>' + letters[index] + '. ' + $(this).text() + '</span>' +
			'</a>';
	});
		
	$(gameXMLDOM).find('MultipleChoiceQuestionItem').each(function(key, Element) {
		$options = $(this).find('Option');
		var options = '';
		
		if ($options.length !== 0) {
			$options.each(function (oIndex, option) {
				options +=
					'<a class="options" href="javascript:void(0)" value="' + $(option).attr('value') + '" onclick="answerQuestion(this)">' + 
						'<img id="incorrect-icon" src="images/icon-incorrect.png"/>' +
						'<img id="correct-icon" src="images/icon-correct.png"/>' +
						'<span>' + letters[oIndex] + '. ' + $(option).text() + '</span>' +
					'</a>';
			});
		} else {
			options = defaultOptions;
		}
		
		questionsArray.push({
			text: $(this).find('Question').text(),
			options: options,
			correct: $(this).find('Answer').text(),
			audio: $(this).find('Audio > URL').text()
		});
	});
}

//Should return the number of pages
function getPagesCount() {
	return questionsArray.length;
}

//If there are several pages, page loading handler
function getPage(pageNumber){
	pageIndex = pageNumber;
	$('.question').hide();
	$('.question:nth-child(' + (pageNumber + 1) + ')').show();
	
	if (pageNumber === questionsArray.length - 1) {
		$('.next-button').text('Finish');
	} else {
		$('.next-button').text('Next question');
	}
}

//Audio file, if available
function getAudio() {
	return questionsArray[pageIndex].audio;
}

//When Check Answers button is pressed
function onCheckPageAnswer(page) {
	var finishCheck = true;
	if (typeof(page) !== 'number') {
		page = pageIndex;
		finishCheck = false;
	}
	
	question = $('#ajax-questions .question:nth-child(' + (page + 1) + ')');
	$(question).find('.options').each(function(oIndex, option) {
		if ($(option).attr('value') === $(question).data('answer')) {
			$(option).addClass('correct');
		} else {
			$(option).addClass('incorrect');
		}
	});
	
	if (finishCheck) {
		$(question).find('.options').addClass('show');
	} else {
		$(question).find('.options').removeClass('show');
		$(question).find('.options.selected').addClass('show');
	}
}

//Game-specific reset procedure
function reset() {
	$('#ajax-questions').html('');
	$.each(questionsArray, function (key, question) {
		var domString =
			'<div class="question" id="' + key + '">' +
				'<div class="text">' + question.text + '</div>' +
				'<div class="btn-group">' + question.options + '</div>' +
			'</div>';
		var $domString = $(domString).data('answer', question.correct);
		$('#ajax-questions').append($domString);
	});
	
	$('#ajax-questions').append($('<div class="next-button button">Next question</div>'));
	$('.next-button').on('click', '', function (event) {
		if (pageIndex < questionsArray.length - 1) {
			$('#ajax-pages #' + (pageIndex + 2)).click();
		} else {
			$('#finishButton').click();
		}
	});
}

//The score values to be displayed after the game finish
//returns: {percentage: , points: , total: }
function getScore() {
	var questions = [];
	var answers = [];
	var corrects = [];
	var points = [];
	var totals = [];
	var gamePoints = 0;
	var gameTotal = 0;
	
	$('#ajax-questions .question').each(function(qIndex, question) {
		questions.push($(question).find('.text').text());
		
		answers.push($(question).find('.btn-group .options.selected').text());
		
		corrects.push($(question).find('.btn-group .options[value="' + $(question).data('answer') + '"]').text());
		
		if ($(question).find('.btn-group .options.selected').hasClass('correct')) {
			points.push(1);
			gamePoints ++;
		} else {
			points.push(0);
		}
		totals.push(1);
		gameTotal++;
	});
	
	return {
		'questions': questions,
		'answers': answers,
		'corrects': corrects,
		'points': points,
		'totals': totals,
		'gamePoints': gamePoints,
		'gameTotal': gameTotal
	};
}

function answerQuestion(dom) {
	$dom = $(dom);
	$dom.siblings().removeClass('selected');
	$dom.addClass('selected');
}
