var GapFillTyping = function(container){
	this.questionsArray = [];
	this.gameDisplayOptions = 0;
	this.container = container;
	this.gameXMLDOM;
}


$(document).ready(function() {
	$.fn.autoGrowInput = function(o) {
		o = $.extend({
			maxWidth: 1000,
			minWidth: 0,
			comfortZone: 10
		}, o);
	
		this.filter('input:text').each(function(){
	
			var minWidth = o.minWidth || $(this).width(),
				val = '',
				input = $(this),
				testSubject = $('<tester/>').css({
					position: 'absolute',
					top: -9999,
					left: -9999,
					width: 'auto',
					fontSize: input.css('fontSize'),
					fontFamily: input.css('fontFamily'),
					fontWeight: input.css('fontWeight'),
					letterSpacing: input.css('letterSpacing'),
					whiteSpace: 'nowrap'
				}),
				check = function() {
	
					if (val === (val = input.val())) {return;}
	
					// Enter new content into testSubject
					var escaped = val.replace(/&/g, '&amp;').replace(/\s/g,' ').replace(/</g, '&lt;').replace(/>/g, '&gt;');
					testSubject.html(escaped);
	
					// Calculate new width + whether to change
					var testerWidth = testSubject.width(),
						newWidth = (testerWidth + o.comfortZone) >= minWidth ? testerWidth + o.comfortZone : minWidth,
						currentWidth = input.width(),
						isValidWidthChange = (newWidth < currentWidth && newWidth >= minWidth)
											 || (newWidth > minWidth && newWidth < o.maxWidth);
	
					// Animate width
					if (isValidWidthChange) {
						input.css('width', newWidth + 'px');
						input.parent().css('width', newWidth + 'px');
					}
	
				};
	
			testSubject.insertAfter(input);
	
			$(this).bind('keyup keydown blur update', check);
	
		});
	
		return this;
	
	};
	
	//entryPoint();
});

//Game-specific initialization
function init(){
	$('#ajax-cont').append('<div id="questions"></div>');
	
	$(gameXMLDOM).find('GapFillAssembledQuestionItem').each(function (qIndex, question) {
		var subQuestions = [];
		$(question).find('GapFillQuestionItem').each(function(index, item) {
			subQuestions.push({
				'prefix': $(this).find('Prefix').text(),
				'answer': $(this).find('Answer').text(),
				'suffix': $(this).find('Suffix').text()
			});
		});
		questionsArray.push(subQuestions);
	});
}

//Should return the number of pages
function getPagesCount() {
	return 1;
}

//Game-specific reset procedure
function reset() {
	$('#questions').empty();
	$.each(questionsArray, function (qIndex, question) {
		var questionNo = '';
		if (gameShowQuestionNo === "true") {
			questionNo = (qIndex + 1) + '. ';
		}
		
		var subQuestions = '';
		$.each(question, function(sqIndex, subQuestion) {
			subQuestions += ' ' + subQuestion.prefix + ' <span class="answer-wrap"><input class="answer-input" type="text" class="slot" data="' + subQuestion.answer + '"><img id="incorrect-icon" src="images/icon-incorrect.png"/><img id="correct-icon" src="images/icon-correct.png"/></span>&nbsp;' + subQuestion.suffix + ' ';
		});
		
		var $newQuestion = $('<div class="question">' + questionNo + subQuestions + '</div>');
		
		$('#questions').append($newQuestion);
		
		$('#questions input').autoGrowInput();
	});
	
	$('#gameStartPopup').show();
	$('#gameStartPopup').animate( {
		left: '380px',
		top: '200px',
		width: '400px',
		height: '100px',
		opacity: 1
	} );
}

//If there are several pages, page loading handler
function getPage(pageNumber){
	return;
}

//When Check Answers button is pressed
function onCheckPageAnswer(page) {
	$('.answer-input').each(function (index, input) {
		if (!$(this).parent().hasClass('correct') &&
			!$(this).parent().hasClass('incorrect') &&
			$(this).val() === '') {
			return;
		}
		$(this).parent().removeClass('correct');
		$(this).parent().removeClass('incorrect');

		if ($.trim($(this).val()) === $(this).attr('data') || gameNoCorrectAnswers) {
			$(this).parent().addClass('correct');
		} else {
			$(this).parent().addClass('incorrect');
		}
	});
}

//The score values to be displayed after the game finish
//returns: {percentage: , points: , total: }
function getScore() {
	var questions = [];
	var answers = [];
	var corrects = [];
	var points = [];
	var totals = [];
	var gamePoints = 0;
	var gameTotal = 0;
	
	$.each(questionsArray, function (qIndex, question) {
		questions.push('');
		var answer = '';
		var correct = '';
		var qPoints = 0;
		var qTotal = 0;
		var $subquestion = $('#questions .question:nth-child(' + (qIndex + 1) + ')');
		$.each(question, function(sIndex, subquestion) {
			$answer = $($subquestion.find('.answer-wrap').get(sIndex));
			var input = $answer.find('.answer-input').val();
			if (input === '') {
				input = '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
			}
			answer += subquestion.prefix + ' <u>' + input  + '</u> ' + subquestion.suffix + ' ';

			if (gameNoCorrectAnswers) {
				correct += subquestion.prefix + ' <u>' + input + '</u> ' + subquestion.suffix + ' ';
			} else {
				correct += subquestion.prefix + ' <u>' + subquestion.answer + '</u> ' + subquestion.suffix + ' ';
			}
			
			if ($answer.hasClass('correct')) {
				qPoints ++;
			}
			qTotal ++;
		});
		answers.push(answer);
		corrects.push(correct);
		points.push(qPoints);
		totals.push(qTotal);
		gamePoints += qPoints;
		gameTotal += qTotal;
	});
	
	return {
		'questions': questions,
		'answers': answers,
		'corrects': corrects,
		'points': points,
		'totals': totals,
		'gamePoints': gamePoints,
		'gameTotal': gameTotal,
		'message': 'There are no correct answers for this exercise'
	};
}

//Audio file, if available
function getAudio() {
	return '';
}