﻿/// <reference path="cookies.js" />
function ready(fn) {
    if (document.addEventListener) {
        document.addEventListener('DOMContentLoaded', fn);
    } else {
        document.attachEvent('onreadystatechange', function () {
            if (document.readyState === 'interactive')
                fn();
        });
    }
}

ready(function () {
    var key = "eula_accepted";
    var eulaAccepted = false;
    if(window.localStorage){
        eulaAccepted = window.localStorage.getItem(key) !== null;
    } else {
        eulaAccepted = Cookies.get(key) !== null;
    }
    if (eulaAccepted) {
        //display page
    } else {
        document.location.href = "eula.html"
    }
});