/******************************************************************************
 *
 *                   INTEL CORPORATION PROPRIETARY INFORMATION
 *       This software is supplied under the terms of a license agreement or
 *       nondisclosure agreement with Intel Corporation and may not be copied
 *       or disclosed except in accordance with the terms of that agreement.
 *
 *            Copyright (c) 2008-2009 Intel Corporation. All Rights Reserved.
 *
 *       All rights reserved.  No part of this program or publication may be
 *       reproduced, transmitted, transcribed, stored in a retrieval system,
 *       or translated into any language or computer language, in any form or
 *       by any means, electronic, mechanical, magnetic, optical, chemical,
 *       manual, or otherwise, without the prior written permission of Intel
 *       Corporation.
 *
 *
 *******************************************************************************/
#ifndef __CR_PAIR_H_
#define __CR_PAIR_H_

#include <os/include/cr_malloc.h>
#include <string.h>

#ifdef CR_EFI

#ifndef NEW_DEFINED
#define NEW_DEFINED
//Forward declaration of placement new/delete operators defined in libcpp
void *operator new(size_t, void*);
void operator delete(void*, void*);
#endif
#endif

namespace osal_stl {
template<class T1, class T2> struct cr_pair
{
    //public typedefs and member variables.
public:
    typedef T1 first_type;
    typedef T2 second_type;

    T1 first;
    T2 second;

    //public methods.
public:
    /* default constructor */
    CR_NO_THROW cr_pair() : first(), second()
    {
    }

    /* constructor */
    CR_NO_THROW cr_pair(const first_type& f, const second_type& s) : first(f), second(s)
    {
    }

    /* copy constructor */
    template<class U1, class U2>
    CR_NO_THROW cr_pair(const cr_pair<U1, U2>& aPair) : first(aPair.first), second(aPair.second)
    {
    }

    /*  The assignment operator */
    CR_NO_THROW inline cr_pair& operator=(const cr_pair& aPair)
    {
        //assign if not self
        if(this != &aPair)
        {
            first = aPair.first;
            second = aPair.second;
        }
        return *this;
    }

    /*  The assignment operator */
    template<class U1, class U2>
    CR_NO_THROW inline cr_pair& operator=(const cr_pair<U1, U2>& aPair)
    {
        first = aPair.first;
        second = aPair.second;
        return *this;
    }
};

/*
 * The equality operator. The return value is true if and only the first
 * elements of x and y are equal, and the second elements of x and y are
 * equal. This operator may only be used if both T1 and T2 are
 * EqualityComparable. This is a global function, not a member function.
 */
template <class T1, class T2>
CR_NO_THROW inline bool operator==(const cr_pair<T1, T2>& x, const cr_pair<T1, T2>& y)
{
    return((x.first == y.first) && (x.second == y.second));
}

template <class T1, class T2>
CR_NO_THROW inline bool operator!=(const cr_pair<T1, T2>& x, const cr_pair<T1, T2>& y)
{
    return !(x == y);
}


/*
 * The comparison operator. It uses lexicographic comparison:
 * the return value is true if the first element of x is less than
 * the first element of y, and false if the first element of y is
 * less than the first element of x. If neither of these is the case,
 * then operator< returns the result of comparing the second elements
 * of x and y. This operator may only be used if both T1 and T2 are
 * LessThanComparable. This is a global function, not a member function.
 */
template <class T1, class T2>
CR_NO_THROW inline bool operator<(const cr_pair<T1, T2>& x, const cr_pair<T1, T2>& y)
{
    return((x.first < y.first) || (!(y.first < x.first) && (x.second < y.second)));
}

template <class T1, class T2>
CR_NO_THROW inline bool operator>(const cr_pair<T1, T2>& x, const cr_pair<T1, T2>& y)
{
    return(y < x);
}

template <class T1, class T2>
CR_NO_THROW inline bool operator<=(const cr_pair<T1, T2>& x, const cr_pair<T1, T2>& y)
{
    return !(y < x);
}

template <class T1, class T2>
CR_NO_THROW inline bool operator>=(const cr_pair<T1, T2>& x, const cr_pair<T1, T2>& y)
{
    return !(x < y);
}

/*
 * Equivalent to cr_pair<T1, T2>(x, y). This is a global function,
 * not a member function. It exists only for the sake of convenience.
 */
template <class T1, class T2>
CR_NO_THROW inline cr_pair<T1, T2> make_pair(const T1& x, const T2& y)
{
    return cr_pair<T1, T2>(x, y);
}
} //end of namespace osal_stl
#endif //__CR_PAIR_H_

