/******************************************************************************
 *
 *                   INTEL CORPORATION PROPRIETARY INFORMATION
 *       This software is supplied under the terms of a license agreement or
 *       nondisclosure agreement with Intel Corporation and may not be copied
 *       or disclosed except in accordance with the terms of that agreement.
 *
 *            Copyright (c) 2008-2009 Intel Corporation. All Rights Reserved.
 *
 *       All rights reserved.  No part of this program or publication may be
 *       reproduced, transmitted, transcribed, stored in a retrieval system,
 *       or translated into any language or computer language, in any form or
 *       by any means, electronic, mechanical, magnetic, optical, chemical,
 *       manual, or otherwise, without the prior written permission of Intel
 *       Corporation.
 *
 *
 *******************************************************************************/
#ifndef __CR_OSAL_DLL_TYPES_H_
#define __CR_OSAL_DLL_TYPES_H_

#ifdef CR_WINDOWS

//Information for dynamic libs
typedef LPCWSTR DllNameType;
typedef HMODULE DllHandleType;
typedef LPCSTR CreationInfoFuncNameType;

#ifndef CRDllLoadLibrary
#define CRDllLoadLibrary(dllName) LoadLibrary((dllName))
#endif //#ifndef CRLoadLibrary

#ifndef CRDllLoadSymbol
#define CRDllLoadSymbol(dllName, functionName)  GetProcAddress((dllName), (functionName))
#endif //#ifdef CRLoadSymbol

#ifndef CRDllCloseLibrary
#define CRDllCloseLibrary(dllName) FreeLibrary((dllName))
#endif //#ifndef CRCloseLibrary

#ifndef CR_LOG4CPP_DLL
#define CR_LOG4CPP_DLL L"CRLog4cpp.dll"
#endif

#ifndef CR_BMCCONFIG_MODULE_DLL
#define CR_BMCCONFIG_MODULE_DLL L"BMCConfigModule.dll"
#endif

#ifndef CR_OOB_MODULE_DLL
#define CR_OOB_MODULE_DLL L"OOBLib.dll"
#endif

#ifndef CR_BIOSCONFIG_MODULE_DLL
#define CR_BIOSCONFIG_MODULE_DLL L"BIOSConfig.dll"
#endif

#ifndef CR_SYSTEMCONFIG_MODULE_DLL
#define CR_SYSTEMCONFIG_MODULE_DLL L"SystemConfig.dll"
#endif

#ifndef CR_SMBPROTOCOL_MODULE_DLL
#define CR_SMBPROTOCOL_MODULE_DLL L"SMBProtocol.dll"
#endif

#ifndef CR_MEM_MAP_DRIVER_MODULE_DLL
#define CR_MEM_MAP_DRIVER_MODULE_DLL L"MemMapDriver.dll"
#endif

#ifndef CR_SMIPROTOCOL_MODULE_DLL
#define CR_SMIPROTOCOL_MODULE_DLL L"SMIProtocol.dll"
#endif

#ifndef CR_HIIPROTOCOL_MODULE_DLL
#define CR_HIIPROTOCOL_MODULE_DLL L"HIIProtocol.dll"
#endif

#ifndef CR_ACPIPROTOCOL_MODULE_DLL
#define CR_ACPIPROTOCOL_MODULE_DLL L"ACPIProtocol.dll"
#endif

#ifndef CR_PLATFORMCONFIG_MODULE_MODULE_DLL
#define CR_PLATFORMCONFIG_MODULE_DLL L"PlatformConfig.dll"
#endif
#endif //#ifdef CR_WINDOWS
#endif //#ifndef __CR_OSAL_DLL_TYPES_H_
