<?php
include_once('asc_ws.php');
$xmlDoc = new DOMDocument;
$allEventFlag='false';
$guid='';
function createTableHeader($filetype, $header, $repfile )
{

	if($filetype == 'csv')
	{
		fwrite($repfile, "\r\n"); 
		$line="********************************************************";
		$line.="\r\n";
		$header.="\r\n";
		fwrite($repfile, $line); 
		fwrite($repfile, $header) ;
		fwrite($repfile, $line); 
	}
	else if($filetype == 'html')
	{
	$writeString = "";
	$writeString ='<h4>'.$header.'</h4>';

//		$writeString="<tr> <th>".$header."</th></tr>";
	fwrite(	$repfile, $writeString); 
	
	}
}

function createTableList($filetype,  $repfile,$ListTag )
{

	if($filetype == 'csv')
	{
		for ($tagCount = 0; $tagCount < sizeof($ListTag); $tagCount++) 
		{
		fwrite($repfile, $ListTag[$tagCount].","); 

		}
	}
	else if($filetype == 'html')
	{
		fwrite($repfile, '<table border="1"><tr>'); 
		for ($tagCount = 0; $tagCount < sizeof($ListTag); $tagCount++) 
		{
		fwrite($repfile, '<th>'.$ListTag[$tagCount].'</th>'); 

		}
		fwrite($repfile, '<tr>'); 
	}


}

function generateReport($reportType) {

	global $filename, $repfile, $xmlDoc, $docReport, $report, $filetype, $repfile, $guid;

	//$sytemSummaryListTag = array("AssetTag","BIOSVersion","GUID", "Manufacturer", "PlatformID","SDRVersion","BMCVersion","SerialNumber","SystemName","OSName","OSVersion","OSBuild");
	//kpteh update system summary tag list
	$sytemSummaryListTag = array("SystemName","AssetTag","BIOSVersion","GUID", "Manufacturer", "PlatFormID","SDRVersion","BMCVersion","HSCVersion","SerialNumber","OSName","OSVersion","OSBuild");
	$fruListTag = array("BOARD_NAME", "FRU_DEVICE_NAME", "FRU_ID", "MANUFACTURER", "PART_NUMBER", "SERIAL_NUMBER",  "VERSION_NUMBER");
	//$powerSummaryTag = array("HEALTH", "NAME", "INTERPRET_SENSOR_UNITS", "INTERPRET_SENSOR_VALUE");
	//kpteh update power summary tag list
	$powerSummaryTag = array( "HEALTH", "NAME", "CURRENTREADING"); 
	$processorXmlTags = array( "DESCRIPTION", "CURRENTSPEED", "MAXSPEED", "SOCKET", "CORES", "L1-SIZE", "L2-SIZE","L3-SIZE");
	$memoryXmlTags = array( "HEALTH", "SLOTNAME", "SIZE","SPEED", "TYPE");
	$localldriveXmlTags =array("NAME", "TOTALSPACE","FREESPACE");

	$eventsXmlTags = array( "TIMESTAMP", "DESCRIPTION", "SEVERITY", "STATE", "ID" ); //kpteh remove sourceIP to gen event report
	$sensorXmlTags = array( "HEALTH", "NAME", "CURRENTREADING", "LOWERCRITICAL","LOWERNONCRITICAL", "UPPERNONCRITICAL", "UPPERCRITICAL");
	$bmcUserListTag = array("NAME", "PRIVILEGE", "STATUS", "id", "IPMI_AUTHENTICATION" );
	$solListTag = array("id", "ENABLEUSER","BAUD_RATE", "PRIVILEGE","AUTHENTICATION", "ENCRIPTION");

	//	$lanSummaryListTag1 = array("id","ACCESS_MODE", "PRIVILEGE_LIMIT");
	$lanSummaryListTag2 = array("IP","IPTYPE", "DEFAULTGATEWAYIP" , "SUBNETMASK");


	$tempstr="";
	$header="";
	switch ($reportType) {

   case assetInfo:
	   $header ="SystemSummary";
	   if($filetype == 'xml')
	   {
		   $reportType = $docReport->createElement($header);
		   $report->appendChild($reportType);
	   }
	   else if($filetype == 'csv' || $filetype == 'html')
	   {
		   createTableHeader($filetype, $header, $repfile);
		   fwrite($repfile, '<table border="1"><tr>'); 
	   }

	   // $reportType = $docReport->createElement("SystemSummary", $repfile);
	   // $report->appendChild($reportType);



	   $reqStr="<Message><Request Operation=\"get\"><Component ID=\"SystemSummary\"><targets><target>".$guid."</target></targets><params></params></Component></Request></Message>";
	   $respStr=ASC_Get($reqStr);
	   $respStr = fix_cdata($respStr);
	   $xmlDoc->loadXML($respStr);
	   $nodeList = getElementsByTagName_safe($xmlDoc, 'data');

	   for ($tagCount = 0; $tagCount < sizeof($sytemSummaryListTag ); $tagCount++) {
		   $values = $nodeList->item($count )->getElementsByTagName($sytemSummaryListTag[$tagCount]);
		   foreach($values as $node1) {
			   if($filetype == 'xml')
			   {
				   $element = $docReport->createElement($sytemSummaryListTag[$tagCount]);
				   $element->appendChild($docReport->createTextNode($node1->nodeValue));
				   $reportType->appendChild($element);
			   }
			   else if($filetype == 'csv')
			   {
				   $tempstr=$sytemSummaryListTag[$tagCount].",".$node1->nodeValue."\r\n";
				   fwrite($repfile, $tempstr); 
			   }
			   else if($filetype == 'html')
			   {
				   $tempstr= "<tr><td>".$sytemSummaryListTag[$tagCount]."</td><td>".$node1->nodeValue."</td></tr>";
				   fwrite($repfile, $tempstr);
			   }
		   }
	   }
	   if($filetype == 'html')
	   {
	   	fwrite($repfile, "</table>"); 
	   }



	   // Case to handle the FRU data request

	   //$reportType = $docReport->createElement("FRU");
	   //$report->appendChild($reportType);


	   $reqStr="<Message><Request Operation=\"get\"><Component ID=\"SystemFRUData\"><targets><target>".$guid."</target></targets><Params><Param ID=\"Source\">Refresh</Param></Params></Component></Request></Message>";
	   $respStr=ASC_Get($reqStr);
	   $respStr = fix_cdata($respStr);
	   $xmlDoc->loadXML($respStr);
	   $ListTag = $fruListTag;
	   $nodeList = getElementsByTagName_safe($xmlDoc, 'FRU');


	   $header ="FRU";
	   if($filetype == 'xml')
	   {
		   $reportType = $docReport->createElement($header);
		   $report->appendChild($reportType);
	   }
	   else if($filetype == 'csv' || $filetype == 'html')
	   {
		   createTableHeader($filetype, $header, $repfile);
		   createTableList($filetype,  $repfile,$ListTag );
	   }


	   populateRows($reportType, $ListTag, $nodeList ); 




	   // Case to handle the Processor data request


	   //$reportType = $docReport->createElement("ProcessorInfo");
	   //$report->appendChild($reportType);

	   $reqStr="<Message><Request Operation=\"get\"><Component ID=\"Processor\"><targets><target>".$guid."</target></targets><Params><Param ID=\"Source\">Refresh</Param></Params></Component></Request></Message>";
	   $respStr=ASC_Get($reqStr);
	   $respStr = fix_cdata($respStr);
	   $xmlDoc->loadXML($respStr);
	   $ListTag = $processorXmlTags;
	   $nodeList = getElementsByTagName_safe($xmlDoc, 'ProcessorInfo');

	   $header ="ProcessorInfo";
	   if($filetype == 'xml')
	   {
		   $reportType = $docReport->createElement($header);
		   $report->appendChild($reportType);
	   }
	   else if($filetype == 'csv' || $filetype == 'html')
	   {
		   createTableHeader($filetype, $header, $repfile);
		   createTableList($filetype,  $repfile,$ListTag );
	   }

	   populateRows($reportType, $ListTag, $nodeList ); 

	   // Case to handle the Memory data request

	   //$reportType = $docReport->createElement("MemoryInfo");
	   //$report->appendChild($reportType);

	   $reqStr="<Message><Request Operation=\"get\"><Component ID=\"Memory\"><targets><target>".$guid."</target></targets><Params><Param ID=\"Source\">Refresh</Param></Params></Component></Request></Message>";
	   $respStr=ASC_Get($reqStr);
	   $respStr = fix_cdata($respStr);
	   $xmlDoc->loadXML($respStr);
	   $ListTag = $memoryXmlTags;
	   $nodeList = getElementsByTagName_safe($xmlDoc, 'DEVICE');
	   $header ="MemoryInfo";
	   if($filetype == 'xml')
	   {
		   $reportType = $docReport->createElement($header);
		   $report->appendChild($reportType);
	   }
	   else if($filetype == 'csv' || $filetype == 'html')
	   {
		   createTableHeader($filetype, $header, $repfile);
		   createTableList($filetype,  $repfile,$ListTag );
	   }
	   populateRows($reportType, $ListTag, $nodeList ); 



	   // Case to handle the localldrive data request

	   //$reportType = $docReport->createElement("localdrive");
	   //$report->appendChild($reportType);


	   $reqStr="<Message><Request Operation=\"get\"><Component ID=\"Storage\"><targets><target>".$guid."</target></targets><Params><Param ID=\"Source\">Refresh</Param></Params></Component></Request></Message>";
	   $respStr=ASC_Get($reqStr);
	   $respStr = fix_cdata($respStr);
	   $xmlDoc->loadXML($respStr);
	   $ListTag = $localldriveXmlTags;
	   $nodeList = getElementsByTagName_safe($xmlDoc, 'Drive');
	   $header ="localdrive";
	   if($filetype == 'xml')
	   {
		   $reportType = $docReport->createElement($header);
		   $report->appendChild($reportType);
	   }
	   else if($filetype == 'csv' || $filetype == 'html')
	   {
		   createTableHeader($filetype, $header, $repfile);
		   createTableList($filetype,  $repfile,$ListTag );
	   }
	   populateRows($reportType, $ListTag, $nodeList ); 



	   // Case to handle the Power Summary data request

	   // $reportType = $docReport->createElement("PowerSummary");
	   // $report->appendChild($reportType);


	   $reqStr="<Message><Request Operation=\"get\"><Component ID=\"PowerSupply\"><targets><target>".$guid."</target></targets><Params><Param ID=\"Source\">Refresh</Param></Params></Component></Request></Message>";
	   $respStr=ASC_Get($reqStr);
	   $respStr = fix_cdata($respStr);
	   $xmlDoc->loadXML($respStr);
	   $ListTag = $powerSummaryTag ;
	   $nodeList = getElementsByTagName_safe($xmlDoc, 'SENSOR');
	   $header ="PowerSummary";
	   if($filetype == 'xml')
	   {
		   $reportType = $docReport->createElement($header);
		   $report->appendChild($reportType);
	   }
	   else if($filetype == 'csv' || $filetype == 'html')
	   {
		   createTableHeader($filetype, $header, $repfile);
		   createTableList($filetype,  $repfile,$ListTag );
	   }

	   populateRows($reportType, $ListTag, $nodeList ); 

	   break;

	   /*case powerPolicy:
	   $reportType = $docReport->createElement("PowerStatus");
	   $report->appendChild($reportType);

	   // Case to handle the NM summary Present power status
	   $reqStr="<Message><Request Operation=\"get\"><Component ID=\"NMSummary\"><targets><target>".$guid."</target></targets><Params><Param ID=\"Source\">Refresh</Param></Params></Component></Request></Message>";
	   $respStr=ASC_Get($reqStr);
	   $xmlDoc->loadXML($respStr);
	   $ListTag = $powerSummaryTag ;
	   $nodeList = getElementsByTagName_safe($xmlDoc, 'data');

	   populateRows($reportType, $ListTag, $nodeList )


	   $reportType = $docReport->createElement("PowerPolicies");
	   $report->appendChild($reportType);

	   // Case to handle the NM Policies Present power status
	   $reqStr="<Message><Request Operation=\"get\"><Component ID=\"NMPolicies\"><targets><target>".$guid."</target></targets><Params><Param ID=\"Source\">Refresh</Param></Params></Component></Request></Message>";
	   $respStr=ASC_Get($reqStr);
	   $xmlDoc->loadXML($respStr);
	   $ListTag = $powerSummaryTag ;
	   $nodeList = getElementsByTagName_safe($xmlDoc, 'SENSOR');

	   populateRows($reportType, $ListTag, $nodeList )
	   */


	   break;

   case allSensors:




	   // Case to handle the Temperature Sensor request
	   $rStr="<Message><Request Operation=\"get\"><Component ID=\"Temperature\"><targets><target>".$guid."</target></targets><Params><Param ID=\"Source\">Refresh</Param></Params></Component></Request></Message>";
	   $resp=ASC_Get($rStr);
	   $resp = fix_cdata($resp);
	   $xmlDoc->loadXML($resp);
	   $ListTag = $sensorXmlTags;
	   $nodeList = getElementsByTagName_safe($xmlDoc, 'SENSOR');

	   if($filetype == 'xml')
	   {
		   $reportTypeHeader = $docReport->createElement("Sensors");
		   $report->appendChild($reportTypeHeader);

		   $reportType = $docReport->createElement("Temperature");
		   $reportTypeHeader->appendChild($reportType);
	   }

	   else if($filetype == 'csv' || $filetype == 'html')
	   {
		   $header ="Sensors";
		   createTableHeader($filetype, $header, $repfile);
		   $header ="Temperature";
		   createTableHeader($filetype, $header, $repfile);
		   createTableList($filetype,  $repfile,$ListTag );
	   }
	   populateRows($reportType, $ListTag, $nodeList ); 





	   // Case to handle the Fan Sensor request
	   $rStr= "<Message><Request Operation=\"get\"><Component ID=\"Fan\"><targets><target>".$guid."</target></targets><Params><Param ID=\"Source\">Refresh</Param></Params></Component></Request></Message>";
	   $resp=ASC_Get($rStr);
	   $resp = fix_cdata($resp);	   
	   $xmlDoc->loadXML($resp);
	   $ListTag = $sensorXmlTags;
	   $nodeList = getElementsByTagName_safe($xmlDoc, 'SENSOR');
	   if($filetype == 'xml')
	   {
		   $reportType = $docReport->createElement("FAN");
		   $reportTypeHeader->appendChild($reportType );
	   }
	   else if($filetype == 'csv' || $filetype == 'html')
	   {
		   $header ="FAN";
		   createTableHeader($filetype, $header, $repfile);
		   createTableList($filetype,  $repfile,$ListTag );
	   }
	   populateRows($reportType, $ListTag, $nodeList ); 


	   // Case to handle the Voltage Sensor request
	   $rStr= "<Message><Request Operation=\"get\"><Component ID=\"Voltage\"><targets><target>".$guid."</target></targets><Params><Param ID=\"Source\">Refresh</Param></Params></Component></Request></Message>";
	   $resp=ASC_Get($rStr);
	   $resp = fix_cdata($resp);	   
	   $xmlDoc->loadXML($resp);
	   $ListTag = $sensorXmlTags;
	   $nodeList = getElementsByTagName_safe($xmlDoc, 'SENSOR');
	   if($filetype == 'xml')
	   {
		   $reportType = $docReport->createElement("Voltage");
		   $reportTypeHeader->appendChild($reportType );
	   }
	   else if($filetype == 'csv' || $filetype == 'html')
	   {
		   $header ="Voltage";
		   createTableHeader($filetype, $header, $repfile);
		   createTableList($filetype,  $repfile,$ListTag );
	   }
	   populateRows($reportType, $ListTag, $nodeList ); 



	   break;

   case bmcSettings:



	   $rStr="<Message><Request Operation=\"get\"><Component ID=\"BMCUserConfiguration\"><targets><target>".$guid."</target></targets><Params><Param ID=\"Source\">Refresh</Param></Params></Component></Request></Message>";
	   $resp=ASC_Get($rStr);
	   $resp = fix_cdata($resp);
	   $xmlDoc->loadXML($resp);
	   $ListTag = $bmcUserListTag;
	   $nodeList = getElementsByTagName_safe($xmlDoc, 'USER');
	   if($filetype == 'xml')
	   {
		   $reportTypeHeader = $docReport->createElement("BMCSettings");
		   $report->appendChild($reportTypeHeader);

		   $reportType = $docReport->createElement("BMCUsers");
		   $reportTypeHeader->appendChild($reportType);
	   }
	   else if($filetype == 'csv' || $filetype == 'html')
	   {
		   $header ="BMCSettings";
		   createTableHeader($filetype, $header, $repfile);
		   $header ="BMCUsers";
		   createTableHeader($filetype, $header, $repfile);
		   createTableList($filetype,  $repfile,$ListTag );
	   }
	   populateRows($reportType, $ListTag, $nodeList ); 



	   // Case to handle the SOL Settings request
	   $rStr="<Message><Request Operation=\"get\"><Component ID=\"SerialOverLanConfiguration\"><targets><target>".$guid."</target></targets><Params><Param ID=\"Source\">Refresh</Param></Params></Component></Request></Message>";
	   $resp=ASC_Get($rStr);
	   $resp = fix_cdata($resp);	   
	   $xmlDoc->loadXML($resp);
	   $ListTag = $solListTag;
	   $nodeList = getElementsByTagName_safe($xmlDoc, 'CHANNEL');
	   if($filetype == 'xml')
	   {
		   $reportType = $docReport->createElement("SOLSettings");
		   $reportTypeHeader->appendChild($reportType);
	   }
	   else if($filetype == 'csv' || $filetype == 'html')
	   {
		   $header ="SOLSettings";
		   createTableHeader($filetype, $header, $repfile);
		   createTableList($filetype,  $repfile,$ListTag );
	   }
	   populateRows($reportType, $ListTag, $nodeList ); 


	   $rStr="<Message><Request Operation=\"get\"><Component ID=\"BMCLanConfiguration\"><targets><target>".$guid."</target></targets><params></params></Component></Request></Message>";
	   $resp=ASC_Get($rStr);
	   $resp = fix_cdata($resp);
	   $xmlDoc->loadXML($resp);
	   $ListTag = $lanSummaryListTag2;

	   $nodeList = getElementsByTagName_safe($xmlDoc, 'LAN');
	   if($filetype == 'xml')
	   {
		   $reportType = $docReport->createElement("LANSettings");
		   $reportTypeHeader->appendChild($reportType);
	   }
	   else if($filetype == 'csv' || $filetype == 'html')
	   {
		   $header ="LANSettings";
		   createTableHeader($filetype, $header, $repfile);
		   createTableList($filetype,  $repfile,$ListTag );
	   }
	   populateRows($reportType, $ListTag, $nodeList ); 



	   break;

   case allEvents:

	   $allEventFlag='true';
	   //kpteh disable query through Appcore use sql.php getdata function.
	   //$reqStr="<Message><Request Operation=\"get\"><Component ID=\"EventLog\"><targets><target>".$guid."</target></targets><Params><Param ID=\"Source\">Cache</Param></Params></Component></Request></Message>";
	   //$respStr=ASC_Get($reqStr);
	   $respStr=getdata('TRUE');
	   $respStr = fix_cdata($respStr);
	   $xmlDoc->loadXML($respStr);


	   if($filetype == 'xml')
	   {
		   $reportType = $docReport->createElement("AllEvents");
		   $report->appendChild($reportType);
	   }
	   else if($filetype == 'csv' || $filetype == 'html')
	   {
		   $header ="AllEvents";
		   createTableHeader($filetype, $header, $repfile);
		   createTableList($filetype,  $repfile,$eventsXmlTags);
	   }

	   $nodeList = getElementsByTagName_safe($xmlDoc, 'Row');



	   for($count = 0; $count < $nodeList->length; $count++) {
		   if($filetype == 'xml')
		   {
			   $row = $docReport->createElement('Row');
			   $reportType->appendChild($row);
		   }
		   else if($filetype == 'csv')
		   {
			   fwrite($repfile, "\r\n"); 
		   }
		   else if($filetype == 'html')
		   {
			   fwrite($repfile, "<tr>"); 
		   }		   

		   //            echo "<row id='". $count ."'>";
		   for ($tagCount = 0; $tagCount < sizeof($eventsXmlTags); $tagCount++) {
			   $values = $nodeList->item($count)->getElementsByTagName($eventsXmlTags[$tagCount]);
			   foreach($values as $node1) {
				   if($eventsXmlTags[$tagCount]=="DESCRIPTION")
				   {
					   //$cntRespStr= str_replace("(*)", "", $cntRespStr);
					   $dscrString=$node1->nodeValue;
					   $dscrString=str_replace("Warning event: ", "", $dscrString);
					   $dscrString=str_replace("Informational event: ", "", $dscrString);
					   $dscrString=str_replace("CRITICAL event: ", "", $dscrString);
					   if($filetype == 'xml')
					   {
						   $element = $docReport->createElement($eventsXmlTags[$tagCount]);
						   $element->appendChild($docReport->createTextNode($dscrString));
						   $row->appendChild($element);
					   }
					   else if($filetype == 'csv')
					   {
						   $tempstr=$dscrString.",";
						   fwrite($repfile, $tempstr); 
					   }
					   else if($filetype == 'html')
					   {
					   	$tempstr= "<td>".$dscrString."</td>";
					   	fwrite($repfile, $tempstr); 
					   }					   

				   }
				   else
				   {
					   if($filetype == 'xml')
					   {
						   $element = $docReport->createElement($eventsXmlTags[$tagCount]);
						   $element->appendChild($docReport->createTextNode($node1->nodeValue));
						   $row->appendChild($element);
					   }
					   else if($filetype == 'csv')
					   {
						   $tempstr=$node1->nodeValue.",";
						   fwrite($repfile, $tempstr); 
					   }
					   else if($filetype == 'html')
					   {
					   	$tempstr= "<td>".$node1->nodeValue."</td>";
					   	fwrite($repfile, $tempstr); 
					   }
					   

				   }
			   }
		   }
		   if($filetype == 'html')
		   {
		   	fwrite($repfile, "</tr>"); 
		   }

	   }
	   if($filetype == 'html')
	   {
	   	fwrite($repfile, "</table>"); 
	   }

	   break;



   case criticalEvents:
	   if($allEventFlag=='true')
		   break;
	   else {

		   $allEventFlag='true';
		    //kpteh disable query through Appcore use sql.php getdata function.
		   //$reqStr="<Message><Request Operation=\"get\"><Component ID=\"EventLog\"><targets><target>".$guid."</target></targets><Params><Param ID=\"Source\">Cache</Param><Param ID=\"Filter\">SEVERITY</Param><Param ID=\"FilterValue\">CRITICAL</Param></Params></Component></Request></Message>";
		   //$respStr=ASC_Get($reqStr);
		   $respStr=getdata('FALSE');
		   $respStr = fix_cdata($respStr);
		   $xmlDoc->loadXML($respStr);
		   if($filetype == 'xml')
		   {
			   $reportType = $docReport->createElement("CriticalEvents");
			   $report->appendChild($reportType);
		   }
		   else if($filetype == 'csv' || $filetype == 'html')
		   {
			   $header ="CriticalEvents";
			   createTableHeader($filetype, $header, $repfile);
			   createTableList($filetype,  $repfile,$eventsXmlTags);
		   }

		   $nodeList = getElementsByTagName_safe($xmlDoc, 'Row');


		   for($count = 0; $count < $nodeList->length; $count++) {

			   if($filetype == 'xml')
			   {
				   $row = $docReport->createElement('Row');
				   $reportType->appendChild($row);
			   }
			   else if($filetype == 'csv')
			   {
				   fwrite($repfile, "\r\n"); 
			   }
			   else if($filetype == 'html')
			   {
				   fwrite($repfile, "<tr>"); 
			   }

			   for ($tagCount = 0; $tagCount < sizeof($eventsXmlTags); $tagCount++) {
				   $values = $nodeList->item($count)->getElementsByTagName($eventsXmlTags[$tagCount]);
				   foreach($values as $node1) {
					   if($eventsXmlTags[$tagCount]=="DESCRIPTION")
					   {

						   $dscrString=$node1->nodeValue;
						   $dscrString=str_replace("Warning event: ", "", $dscrString);
						   $dscrString=str_replace("Informational event: ", "", $dscrString);
						   $dscrString=str_replace("CRITICAL event: ", "", $dscrString);

						   if($filetype == 'xml')
						   {
							   $element = $docReport->createElement($eventsXmlTags[$tagCount]);
							   $element->appendChild($docReport->createTextNode($dscrString));
							   $row->appendChild($element);
						   }
						   else if($filetype == 'csv')
						   {
							   $tempstr=$dscrString.",";
							   fwrite($repfile, $tempstr); 
						   }
						   else if($filetype == 'html')
						   {
						   	$tempstr= "<td>".$dscrString."</td>";
						   	fwrite($repfile, $tempstr); 
						   }						   

					   }
					   else
					   {
						   if($filetype == 'xml')
						   {
							   $element = $docReport->createElement($eventsXmlTags[$tagCount]);
							   $element->appendChild($docReport->createTextNode($node1->nodeValue));
							   $row->appendChild($element);
						   }
						   else if($filetype == 'csv')
						   {
							   $tempstr=$node1->nodeValue.",";
							   fwrite($repfile, $tempstr); 
						   }
						   else if($filetype == 'html')
						   {
						   	$tempstr= "<td>".$node1->nodeValue."</td>";
						   	fwrite($repfile, $tempstr); 
						   }
					   }
				   }
			   }
			   if($filetype == 'html')
			   {
			   	fwrite($repfile, "</tr>"); 
			   }

		   }
		   if($filetype == 'html')
		   {
		   	fwrite($repfile, "</table>"); 
		   }


	   }
	   break;


   default:
	   break;
	}



}


function populateRows($reportType, $ListTag, $nodeList ) 
{

	//global $filename, $repfile, $xmlDoc, $docReport, $report, $repfile;
	global  $docReport, $filetype, $repfile;


	for($count = 0; $count < $nodeList->length; $count++) 
	{


		if($filetype == 'xml')
		{
			$row = $docReport->createElement('Row');
			$reportType->appendChild($row);
		}
		else if($filetype == 'csv')
		{
			fwrite($repfile, "\r\n"); 
		}
		else if($filetype == 'html')
		{
			fwrite($repfile, "<tr>"); 
		}





		for ($tagCount = 0; $tagCount < sizeof($ListTag); $tagCount++) 
		{
			$values = $nodeList->item($count)->getElementsByTagName($ListTag[$tagCount]);
			foreach($values as $node1) 
			{
				if($filetype == 'xml')
				{
					//kpteh added to check L3-SIZE multiply by 64 to support Grantley processor.
					if($ListTag[$tagCount] == 'L3-SIZE')
					{
						if($nodeList->item($count)->getElementsByTagName('L3-UNIT')->item(0)->nodeValue=='64K Granularity')
						{
							$node1->nodeValue = $node1->nodeValue * 64;
						}
					}
					$element = $docReport->createElement($ListTag[$tagCount]);
					$element->appendChild($docReport->createTextNode($node1->nodeValue));
					$row->appendChild($element);
				}
				else if($filetype == 'csv')
				{
					//kpteh added to check L3-SIZE multiply by 64 to support Grantley processor.
					if($ListTag[$tagCount] == 'L3-SIZE')
					{
						if($nodeList->item($count)->getElementsByTagName('L3-UNIT')->item(0)->nodeValue=='64K Granularity')
						{
							$node1->nodeValue = $node1->nodeValue * 64;
						}
					}
					$tempstr=$node1->nodeValue.",";
					fwrite($repfile, $tempstr); 
				}
				else if($filetype == 'html')
				{
					//kpteh added to check L3-SIZE multiply by 64 to support Grantley processor.
					if($ListTag[$tagCount] == 'L3-SIZE')
					{
						if($nodeList->item($count)->getElementsByTagName('L3-UNIT')->item(0)->nodeValue=='64K Granularity')
						{
							$node1->nodeValue = $node1->nodeValue * 64;
						}
					}
					$tempstr= "<td>".$node1->nodeValue."</td>";
					fwrite($repfile, $tempstr); 
				}

			}
		}
		if($filetype == 'html')
		{
			fwrite($repfile, "</tr>"); 
		}


	}
	if($filetype == 'html')
	{
		fwrite($repfile, "</table>"); 
	}

}








$repName = array( "Asset Info",  "All Events", "Critical Events", "Sensor Values", "Server Configuration");
$repDiscn = array( "Report of all physical assets like CPU, memory, hard disks etc.", "Report of all events captured in the database.", "Report of all critical events captured in the database.", "Report of all sensors with current value and health.", "Report containing  Server IPMI configuration details.");
$repID = array( "assetInfo", "allEvents" , "criticalEvents", "allSensors" , "bmcSettings"  );


$req=$_REQUEST['reqType'];
$guid = $_REQUEST["guid"]; //guid number
if ($req=='reportTable')
{

	if ( stristr($_SERVER["HTTP_ACCEPT"],"application/xhtml+xml")) {
		header("Content-type: application/xhtml+xml;charset=utf-8"); 
	} else {
		header("Content-type: text/xml;charset=utf-8");
	}

	$et = ">";
	echo "<?xml version='1.0' encoding='utf-8'?$et\n";
	echo "<rows>";

	for ($count = 0; $count < sizeof($repName); $count++) {
		echo "<row id='". $count ."'>";
		echo "<cell><![CDATA[".$repName[$count]."]]></cell>";
		echo "<cell><![CDATA[".$repDiscn[$count]."]]></cell>";
		echo "<cell><![CDATA[".$repID[$count]."]]></cell>";
		echo "</row>";  
	}
	echo "</rows>";

}
else if ($req=='genReport')
{

	$selIds = $_REQUEST["reportType"]; 
	$filetype =$_REQUEST["filetype"]; 
	$guid = $_REQUEST["guid"]; //guid number
	//$filetype = 'csv';
	if($filetype == 'xml')
	{
		$filename='report.xml';
		$docReport = new DOMDocument('1.0','utf-8');
		$report = $docReport->createElement("Report");
		$docReport->appendChild($report);

	}
	else if($filetype == 'csv')
	{
		$filename='report.csv';
		$repfile=fopen($filename,"w");
		$line="---------------------------------------------------------------------------------------------------------";
		$line.="\r\n";
		fwrite($repfile, $line); 
		fwrite($repfile, "Report\r\n") ;
		fwrite($repfile, $line); 
	}

	else if($filetype == 'html')
	{
		$filename='report.html';
		$repfile=fopen($filename,"w");
		
		fwrite($repfile, '<h4>Report</h4>') ;
		fwrite($repfile, $line); 
	}


	$idArray = split('@', $selIds);

	for($compareCount = 0; $compareCount < count($idArray); $compareCount++){
		if($idArray[$compareCount] == 'allEvents') $allEventFlag='true';
	}

	for($id = 0; $id < count($idArray); $id++){
		try
		{
		if($idArray[$id] != 'criticalEvents')
		{
			generateReport($idArray[$id]);
		}
		else
		{
			if( $allEventFlag!='true')
				generateReport($idArray[$id]);
		}
		}
		catch(Exception $e)
		{
		}
	}
	if($filetype == 'xml')
	{
		$docReport->save($filename);
	}


	//close($repfile);

/*	// fix for IE  on php 
	header("Pragma: public");
	header("Expires: 0"); 
	header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
	//download from server instead of cache

	// force download 
	header("Content-Type: application/force-download");
	header("Content-Type: application/octet-stream");
	header("Content-Type: application/download");


	header("Content-Disposition: attachment; filename=".basename($filename).";");

	header("Content-Transfer-Encoding: binary");
	header("Content-Length: ".filesize($filename));

	readfile("$filename");

	exit();*/



}

function getElementsByTagName_safe($doc, $tag)
{
	$data = $doc->getElementsByTagName($tag);
	if(is_null($data->item(0)))
	{
	    error_log("\n failed to locate" . $tag . "\n", 0);		
		throw new Exception("failed");
	}
	return $data;
}

function fix_cdata($xml)
{
	$tags = get_report_tags1();
	foreach ($tags as $tag)
	{
		$start = "<".$tag .">";
		$end = "<\/".$tag.">";
		$xml = preg_replace("/".$start."/", "$0<![CDATA[", $xml);
		$xml = preg_replace("/".$end."/", "]]>$0", $xml);
	}
	return $xml;
}

function get_report_tags1() 
{
	return array("ASSET_TAG","BANKNAME","SIZE","SLOTNAME","SPEED","TYPE","FREESPACE","TOTALSPACE","id","BOARD_NAME","CHASSIS_TYPE","FRU_DEVICE_NAME","FRU_ID","MANUFACTURE_DATE","PART_NUMBER","PRODUCT_NAME","SERIAL_NUMBER","VERSION_NUMBER","CORES","CURRENTSPEED","DESCRIPTION","FAMILY","L1-ERRORCORRECTION","L1-NAME","L1-SIZE","L1-TYPE","L1-UNIT","L2-ERRORCORRECTION","L2-NAME","L2-SIZE","L2-TYPE","L2-UNIT","L3-ERRORCORRECTION","L3-NAME","L3-SIZE","L3-TYPE","L3-UNIT","MANUFACTURER","MAXSPEED","PRESENT","SOCKET","SENSORTYPE","CURRENTREADING","HEALTH","INTERPRET_SENSOR_UNITS","LOWERCRITICAL","LOWERNONCRITICAL","NAME","UNIT","UPPERCRITICAL","UPPERNONCRITICAL","AUTHENTICATION","BAUD_RATE","ENABLEUSER","ENCRIPTION","PRIVILEGE","BACKUPGATEWAYIP","DEFAULTGATEWAYIP","IP","IPTYPE","MAC","SUBNETMASK","IPMI_AUTHENTICATION","PASSWORD","STATUS", "SOURCEIP", "EVENTID", "ID", "RAWSEL", "RECOMPUTABLE", "RECORDID", "SEVERITY", "STATE", "TIMESTAMP");
}

//new function created by kpteh to query SMS_Events.db for sorting time and ID.
function getdata($Event){
   
	//query for TimeStamp in SMS_EVENTS databse.
	$return = exec('sqlite3 "/usr/local/asc/bin/SMS_EVENTS.db" "SELECT Action_TimeStamp FROM ActionLog ORDER BY Action_TimeStamp DESC"', $resultTime);
	if($return == NULL)
		exec('sqlite3 "c:\Program Files (x86)\Intel\ASC\SMS_EVENTS.db" "SELECT Action_TimeStamp FROM ActionLog ORDER BY Action_TimeStamp ASC"', $resultTime);
	
	$datacount = sizeof($resultTime);
	
	for($i = 0, $num = 1; $i < sizeof($resultTime); $i++, $num++){
		$TimeStamp[$i] = '<ID>'.$num.'</ID>'.'<TIMESTAMP>'.$resultTime[$i].'</TIMESTAMP>';
		//error_log("\n sqlite DB:" . $TimeStamp[$i], 0);
		}
	
	//query for Description in SMS_EVENTS databse.
	$return = exec('sqlite3 "/usr/local/asc/bin/SMS_EVENTS.db" "SELECT Action_Description FROM ActionLog ORDER BY Action_TimeStamp DESC"', $resultDesp);
	if($return == NULL)
		exec('sqlite3 "c:\Program Files (x86)\Intel\ASC\SMS_EVENTS.db" "SELECT Action_Description FROM ActionLog ORDER BY Action_TimeStamp ASC"', $resultDesp);
	
	for($i = 0; $i < sizeof($resultDesp); $i++){
		$Description[$i] = str_replace("Warning event: ", "", $resultDesp[$i]);
		$Description[$i] = str_replace("Informational event: ", "", $Description[$i]);
		$Description[$i] = str_replace("CRITICAL event: ", "", $Description[$i]);
		$Description[$i] = str_replace(",", " ", $Description[$i]);
		$Description[$i] = '<DESCRIPTION>'.$Description[$i].'</DESCRIPTION>';
		//error_log("\n sqlite DB:" . $Description[$i], 0);
		}
	
	//query for severity in SMS_EVENTS databse.
	$return = exec('sqlite3 "/usr/local/asc/bin/SMS_EVENTS.db" "SELECT Action_Severity FROM ActionLog ORDER BY Action_TimeStamp DESC"', $resultSVrity);
	if($return == NULL)
		exec('sqlite3 "c:\Program Files (x86)\Intel\ASC\SMS_EVENTS.db" "SELECT Action_Severity FROM ActionLog ORDER BY Action_TimeStamp ASC"', $resultSVrity);
	
	for($i = 0; $i < sizeof($resultSVrity); $i++){
		$Severity[$i] = '<SEVERITY>'.$resultSVrity[$i].'</SEVERITY>';
		//error_log("\n sqlite DB:" . $Severity[$i], 0);
		}
	
	//query for State in SMS_EVENTS databse.
	$return = exec('sqlite3 "/usr/local/asc/bin/SMS_EVENTS.db" "SELECT Action_State FROM ActionLog ORDER BY Action_TimeStamp DESC"', $resultState);
	if($return == NULL)
		exec('sqlite3 "c:\Program Files (x86)\Intel\ASC\SMS_EVENTS.db" "SELECT Action_State FROM ActionLog ORDER BY Action_TimeStamp ASC"', $resultState);
	
	for($i = 0; $i < sizeof($resultState); $i++){
		$State[$i] = '<STATE>'.$resultState[$i].'</STATE>';
		//error_log("\n sqlite DB:" . $State[$i], 0);
		}
	
	//filter for all or Critical events
	if($Event == 'TRUE'){
		//construct xml string 
		for($i = 0; $i < $datacount; $i++){
			$xmlAllresult[$i] = '<Row>'.$TimeStamp[$i].$Description[$i].$Severity[$i].$State[$i].'</Row>';
			}
		
		$xmlAllstring = implode("",$xmlAllresult);
		$FinalxmlAllstring ='<?xml version="1.0" encoding="UTF-8"?><Rows>'.$xmlAllstring.'</Rows>';
		//error_log("\n sqlite DB:" . $FinalxmlAllstring, 0);
		return $FinalxmlAllstring;
	}
	
	if($Event == 'FALSE'){
		//construct xml string 
		for($i = 0; $i < $datacount; $i++){
			if($Severity[$i] == '<SEVERITY>CRITICAL</SEVERITY>' || $Severity[$i] == '<SEVERITY>Critical</SEVERITY>')
				$xmlAllresult[$i] = '<Row>'.$TimeStamp[$i].$Description[$i].$Severity[$i].$State[$i].'</Row>';
			else
				continue;
			}
		
		$xmlAllstring = implode("",$xmlAllresult);
		$FinalxmlAllCriticalstring ='<?xml version="1.0" encoding="UTF-8"?><Rows>'.$xmlAllstring.'</Rows>';
		//error_log("\n sqlite DB:" . $FinalxmlAllCriticalstring, 0);
		return $FinalxmlAllCriticalstring;
	}
	
	}
?>

