/******************************************************************************
 *
 *                   INTEL CORPORATION PROPRIETARY INFORMATION
 *       This software is supplied under the terms of a license agreement or
 *       nondisclosure agreement with Intel Corporation and may not be copied
 *       or disclosed except in accordance with the terms of that agreement.
 *
 *            Copyright (c) 2008-2009 Intel Corporation. All Rights Reserved.
 *
 *       All rights reserved.  No part of this program or publication may be
 *       reproduced, transmitted, transcribed, stored in a retrieval system,
 *       or translated into any language or computer language, in any form or
 *       by any means, electronic, mechanical, magnetic, optical, chemical,
 *       manual, or otherwise, without the prior written permission of Intel
 *       Corporation.
 *
 *
 *******************************************************************************/
#ifndef _CACHERIVER_SYSTEM_H_
#define _CACHERIVER_SYSTEM_H_

//common header files
#include <os/include/cr_osal.h>
#include <modules/cr_modularization.h>
#if PLATFORM_CONFIGURATION && OOB_CONFIGURATION
#ifndef CR_EFI
//OOB header files
#include <modules/OOBConnect.h>
#endif
#endif
#if PLATFORM_UPDATE
#if (CFG_UPDATE || FRUSDR_UPDATE)
//FRUSDR Update header files
#include <modules/bmc/update/SDRFile.h>
#include <modules/bmc/update/FRUFile.h>
#endif
#if (CFG_UPDATE || FW_UPDATE)
//FW Update header files
#include <modules/bmc/update/IntelHexFile.h>
#endif
#if (CFG_UPDATE)
//CFG based update header files
#include <modules/bmc/update/cfgfile/CfgFileData.h>
#endif
#if (CFG_UPDATE || BIOS_UPDATE)
//BIOS update header files
#include <modules/bios/update/CapsuleFileInt.h>
#include <modules/bios/SuperCapsuleGenerator/SuperCapsuleGenerator.h>
#endif
#include <modules/SysFwUpdate/SysFwUpdateParam.h>
#endif
/*
 * System overloads the [] and << operators to perform
 * the Get and Set of system configuration.
 */

//Configuration flags related to multithreading and runtime logging
#define MULTITHREADING_ON               0x01
#define LOG_LEVEL1                      0x02
#define LOG_LEVEL2                      0x04
#define LOG_LEVEL3                      0x08
#define SEM_CLEAR                       0x10
#define DISABLE_LOGGING                     0x20 // rajneesh

#if SAVE_RESTORE_CONFIGURATION
#define     BIOS_DATA                   0
#define     BMC_DATA                    1
#define     BIOS_BMC_DATA               2
#define     MAX_FILE_PATH_LENGTH        1024
#define     MAX_PASSWORD_LENGTH         15

struct SavenRestoreOptions
{
    int opt;
    char FileName[MAX_FILE_PATH_LENGTH];
    char adminPw[MAX_PASSWORD_LENGTH];
    bool noplatformCheck;
    SavenRestoreOptions()
        : opt(-1)
    {
        memset((void*)FileName, 0, MAX_FILE_PATH_LENGTH);
        memset((void*)adminPw, 0, MAX_PASSWORD_LENGTH);
        noplatformCheck = false;
    }
};
#endif
namespace SDK
{
class CLASSINDLL_CLASS_DECL System
{
public:
    System ();
    virtual ~System ();

public:
    bool ACCycleRequired;
    void SetFlags(unsigned char switchOn = 0x0);
#if PLATFORM_CONFIGURATION
/* Inband configuration and save/restore */
    void Get(STRING xPathString, ResultMap& rMap);
    void Get(SettingsMap& xSettingsMap, ResultMap&);
    void Set(XSettingMap& xSettingMap);
    void Set(SettingsMap& xSettingsMap);

#if SAVE_RESTORE_CONFIGURATION
    void Restore(SavenRestoreOptions srOption);
    void Save(SavenRestoreOptions srOption);
#endif
#if OOB_CONFIGURATION
/* OOB configuration */
    bool InitiateOOBConnection(OOBConnect& oobconnect);
    bool TerminateOOBConnection(OOBConnect&);
    void Get(STRING, ResultMap &, OOBConnect &);
    void Get(SettingsMap& xSettingsMap, ResultMap &, OOBConnect&);
    void Set(XSettingMap, OOBConnect &);
    void Set(SettingsMap, OOBConnect &);
#endif
#endif
/* This macros are defined in cr_modularization.h */
#if PLATFORM_UPDATE
#if (CFG_UPDATE || FRUSDR_UPDATE)
/* Perform the FRUSDR Update. */
    void Update(Module::Update::SDRFile &sSdrFile);
    void Update(Module::Update::FRUFile &fruFile);
#endif
#if (CFG_UPDATE || FW_UPDATE)
/* Perform the Firmware Update. */
    void Update(Module::IntelHexFile_NS::IntelHexFile &hexFile);
#endif
#if (CFG_UPDATE || BIOS_UPDATE)
/*Perform BIOS update */
    void Update(Module::FileParser::CapsuleFileInt &capFile);
#endif
#if CFG_UPDATE
/* Perform the CFG based Update. */
    void Update(struct CFG_var &cfgFile);
    void Update(Module::FileParser::SUPER_CAPSULE_UPDATE_OPTIONS opt);
#endif
    void Update(Module::Update::SysFwUpdateParam &updateParam);
#endif
};
}
#endif // _CACHERIVER_SYSTEM_H_
