/******************************************************************************
 *
 *                   INTEL CORPORATION PROPRIETARY INFORMATION
 *       This software is supplied under the terms of a license agreement or
 *       nondisclosure agreement with Intel Corporation and may not be copied
 *       or disclosed except in accordance with the terms of that agreement.
 *
 *            Copyright (c) 2008-2009 Intel Corporation. All Rights Reserved.
 *
 *       All rights reserved.  No part of this program or publication may be
 *       reproduced, transmitted, transcribed, stored in a retrieval system,
 *       or translated into any language or computer language, in any form or
 *       by any means, electronic, mechanical, magnetic, optical, chemical,
 *       manual, or otherwise, without the prior written permission of Intel
 *       Corporation.
 *
 *
 *******************************************************************************/
#ifndef __COMMON_ERROR_CODES_H__
#define __COMMON_ERROR_CODES_H__

typedef enum _ERROR_NAME
{
    ERROR_INVALID_QUERY = 1001,
    ERROR_MEM_MAP_DRIVER = 1002,
    ERROR_RONLY_BIOS_SETTING = 1003,
    ERROR_INVALID_SETTING_VALUE = 1004,
    ERROR_SET_ON_GROUP_SETTING = 1005,
    ERROR_MEM_ALLOC = 1006,
    ERROR_OPEN_DEVICE = 1007,
    ERROR_MEM_LOCK = 1008,
    ERROR_PHY_VIRT_MAPPING = 1009,
    ERROR_VIRT_PHY_MAPPING = 1010,
    ERROR_CREATION_INFO_NOT_FOUND = 1011,
    ERROR_NO_CREATE_INSTANCE_FUNC = 1012,
    ERROR_NO_SMBIOS_ENTRY_PTR = 1013,
    ERROR_INIT_SMI_DRV_FAILED = 1014,
    ERROR_UNINIT_SMI_DRV_FAILED = 1015,
    ERROR_SMI_CONTIG_MEM_FAILED = 1016,
    ERROR_SMI_BUFFER_SIZE_EXCEEDED = 1017,
    ERROR_SMI_GET_VARIABLE_FAILED = 1018,
    ERROR_SMI_SET_VARIABLE_FAILED = 1019,
    ERROR_SMI_INVALID_VARIABLE_WIDTH = 1020,
    ERROR_EXPORT_HII_BASE_ADDR = 1021,
    ERROR_NUM_HII_TABLES = 1022,
    ERROR_SELECTOR_GET_OBJ = 1023,
    ERROR_CHECKSUM_INCORRECT = 1024,
    ERROR_SYSTEMCONFIG_SET_TIME_OF_DAY = 1025,
    ERROR_BMC_INTERFACE_ERROR = 1026,
    ERROR_PLATFORM_PROCESSOR_INITIALIZATION = 1027,
    ERROR_PLATFORM_MEMORY_INITIALIZATION = 1028,
    ERROR_PLATFORM_LAYER_INITIALIZATION = 1029,
    ERROR_GET_LOGICAL_PROCESSOR_NO = 1030,
    ERROR_GET_PHYSICAL_PROCESSOR_INFO = 1031,
    ERROR_GET_PHYSICAL_PROCESSOR_STATUS = 1032,
    ERROR_GET_LOGICAL_PROCESSOR_USAGE = 1033,
    ERROR_PLATFORM_GETQUERY = 1034,
    ERROR_GET_PHYSICAL_PROCESSOR_NO = 1035,
    ERROR_GET_MEMORY_DIMM_STATE = 1036,
    ERROR_GET_MEMORY_ECC_ERROR_COUNT = 1037,
    ERROR_GET_MEMORY_ARRAY_NO = 1038,
    ERROR_GET_MEMORY_DEVICE_NO = 1039,
    ERROR_FILE_NAME_INVALID = 1040,
    ERROR_FILE_PATH_INVALID = 1041,
    ERROR_GET_SYSTEM_INFO_FROM_SYSTEM_FAILED = 1042,
    ERROR_GET_SYSTEM_INFO_FROM_FILE_FAILED = 1043,
    SYSTEM_INI_PLATFORM_NOMATCH = 1044,
    SYSTEM_INI_FIRMWARE_MISMATCH = 1045,
    ERROR_FILE_NOT_PRESENT = 1046,
    ERROR_SET_ON_PLATFORM_QUERIES_NOT_ALLOWED = 1047,
    ERROR_INIT_OOB_FAILED = 1048,
    ERROR_TERM_OOB_FAILED = 1049,
    ERROR_INVALID_AUTH_OOB = 1050,
    ERROR_SERIAL_CONNECT_MODE = 1051,
    ERROR_SERIAL_TIMEOUT = 1052,
    ERROR_USER_NAME_ERROR = 1053,
    ERROR_USER_PASSWORD = 1054,
    ERROR_COMMUNITY_STRING = 1055,
    ERROR_IP_ADDRESS = 1056,
    ERROR_IP_ADDRESS_MISSING = 1057,
    ERROR_SENDER_MACHINE_NAME_64 = 1058,
    ERROR_SMTP_STATUS_MISSING = 1059,
    ERROR_SMTP_STATUS_INVALID = 1060,
    ERROR_SMTP_DATA_SIZE = 1061,
    ERROR_SENDER_MACHINE_NAME_32 = 1062,
    ERROR_FROM_EMAIL_64 = 1063,
    ERROR_FROM_EMAIL_32 = 1064,
    ERROR_TO_EMAIL = 1065,
    ERROR_SUBJECT_LINE_64 = 1066,
    ERROR_SUBJECT_LINE_32 = 1067,
    ERROR_EMAIL_CONTENT_SIZE = 1068,
    ERROR_RETRY_COUNT = 1069,
    ERROR_ACK_TIMEOUT = 1070,
    ERROR_LAN_ALERT_USER_NAME = 1071,
    ERROR_MISSING_USER_NAME = 1072,
    ERROR_MISSING_PASSWORD = 1073,
    ERROR_LAN_ALERT_PASSWORD = 1074,
    ERROR_MAC_ADDRESS = 1075,
    ERROR_RESOLVE_MAC = 1076,
    ERROR_LAN_ALERT_IP_SET = 1077,
    ERROR_SMTP_SET_FAILED = 1078,
    ERROR_GET_SMTP_CONFIG_SUPPORTED = 1079,
    ERROR_DESTINATION_INDEX_MISSING = 1080,
    ERROR_LAN_NUMBER_MISSING = 1081,
    ERROR_DESTINATION_INDEX = 1082,
    ERROR_ASSET_LENGTH = 1083,
    ERROR_SOL_CHARACTER_ACC_INTERVAL = 1084,
    ERROR_SOL_CHARACTER_SEND_THRESHOLD = 1085,
    ERROR_SOL_RETRY_COUNT = 1086,
    ERROR_SOL_RETRY_INTERVAL = 1087,
    ERROR_CHASSIS_LED_INTERVAL = 1088,
    ERROR_INVALID_DATAVAL = 1089,
    ERROR_INVALID_RANGE = 1090,
    ERROR_RANGE_CHECK = 1091,
    ERROR_STRING_LENGTH_CHECK = 1092,
    ERROR_SMTP_SERVER_NAME = 1093,
    ERROR_LOCK_ACQUIRE_ERROR = 1094,
    ERROR_LAN_ACK_SET = 1095,
    ERROR_PASSWORD_MISMATCH = 1096,
    ERROR_USER_PASSWORD_MISMATCH = 1097,
    ERROR_NM_NOT_SUPPORTED = 1098,
    ERROR_OPERATION_FAILED = 1099,
    ERROR_PEF_NOT_SUPPORTED = 1100,
    ERROR_DATA_TYPE_OUT_OF_RANGE = 1101,
    ERROR_READ_OUT_OF_RANGE = 1102,
    ERROR_TIME_FORMAT = 1103,
    ERROR_FRU_AREA_OFFSET_EXCEEDS_LENGTH = 1104,
    ERROR_INDEX_DATA_NOT_AVAILABLE = 1105,
    ERROR_INVALID_DOMAIN_ID = 1106,
    ERROR_INVALID_POLICY_ID = 1107,
    ERROR_UNKNOWN_POLICY_TYPE = 1108,
    ERROR_INVALID_MODE = 1109,
    ERROR_POLICY_EXISTS_AND_ENABLED = 1110,
    ERROR_UNSUPPORTED_SMBIOS_VERSION = 1111,
    ERROR_INVALID_SDR_FILE = 1112,
    ERROR_SDR_UPDATE = 1113,
    ERROR_LOAD_SYSTEM_SDR_PROPERTIES = 1114,
    ERROR_READING_SYSTEM_SDR = 1115,
    ERROR_VERIFY_SDR_UPDATE = 1116,
    ERROR_INVALID_FRU_FILE = 1117,
    ERROR_FRU_UPDATE = 1118,
    ERROR_READING_SYSTEM_FRU = 1119,
    ERROR_VERIFY_FRU_UPDATE = 1120,
    ERROR_HSC_NOT_PRESENT = 1121,
    ERROR_HSC_PIA_OPCODE_NOT_PRESENT = 1122,
    ERROR_FW_ENTER_XFER_MODE = 1123,
    ERROR_FW_EXIT_XFER_MODE = 1124,
    ERROR_FW_CONFIG_LOAD_SYSTEM = 1125,
    ERROR_FW_UPDATE_FAILED = 1126,
    ERROR_FILE_NOT_FOUND_ON_SYSTEM = 1127,
    ERROR_ME_NOT_PRESENT = 1128,
    ERROR_LCP_NOT_PRESENT = 1129,
    ERROR_LCP_PIA_NOT_PRESENT = 1130,
    ERROR_RMM_NOT_PRESENT = 1131,
    ERROR_LOADING_BIOS_UPDATE_DRIVER = 1132,
    ERROR_BOOT_ORDER_NO = 1133,
    ERROR_SECTION_NOT_FOUND = 1134,
    ERROR_FILE_NAME_TYPE_NOT_FOUND = 1135,
    ERROR_FILE_NOT_LOADED = 1136,
    ERROR_POLICY_TABLE_FULL = 1137,
    ERROR_POLICY_SET_FAILED = 1138,
    ERROR_POLICY_GET_FAILED = 1139,
    ERROR_FILTER_SET_FAILED = 1140,
    ERROR_FILTER_GET_FAILED = 1141,
    ERROR_FILTER_MASK_ZERO = 1142,
    ERROR_FILTER_MASK_GREATER = 1143,
    ERROR_LAN_INVALID = 1144,
    ERROR_DESTINATION_INVALID = 1145,
    ERROR_COMMUNITY_STRING_SET_FAILED = 1146,
    ERROR_ACCESS_MODE_SET_FAILED = 1147,
    ERROR_PEF_ENABLE_FAILED = 1148,
    ERROR_PEF_ALERT_SET_FAILED = 1149,
    ERROR_CFG_FILE_PARSING_FAILED = 1150,
    ERROR_CFG_FILE_UPDATE_FAILED = 1151,
    ERROR_FRU_FILE_NAME_INVALID = 1152,
    ERROR_SDR_FILE_NAME_INVALID = 1153,
    ERROR_CAPSULE_FILE_PARSING_FAILED = 1154,
    ERROR_BIOS_UPDATE_FAILED = 1155,
    ERROR_CAPSULE_FILE_INCOMPATIBLE_WITH_PLATFORM = 1156,
    ERROR_FAILED_TO_UNLOCK_BIOS_FLASH = 1157,
    ERROR_FAILED_TO_LOCK_BIOS_FLASH = 1158,
    ERROR_DOWNGRADE_BIOS_VERSION_NOT_ALLOWED = 1159,
    ERROR_READING_CAPSULE_FILE = 1160,
    ERROR_MEMORY_ALLOCATION_FAILED = 1161,
    ERROR_EFI_VAR_ALREADY_EXIST = 1162,
    ERROR_EFI_VAR_MORE_THAN_ONE = 1163,
    ERROR_EFI_VAR_NOT_PRESENT = 1164,
    ERROR_EFI_VAR_INVALID_GUID = 1165,
    ERROR_EFI_VAR_INVALID_ATTRIBUTES = 1166,
    ERROR_EFI_VAR_INVALID_ATTRIBUTES_CREATE_OPTION = 1167,
    ERROR_EFI_VAR_INVALID_DATA_CREATE_MODIFY_OPTION = 1168,
    ERROR_EFI_VAR_INVALID_COMMAND = 1169,
    ERROR_FILE_READ_FAILED = 1170,
    ERROR_INVALID_FIRMWARE_UPLOAD_FILE = 1171,
    ERROR_INVALID_PARAMETERS = 1172,
    ERROR_FILE_NOT_COMPATIBLE_WITH_PLATFORM = 1173,
    ERROR_DOWN_REVISION_NOT_ALLOWED = 1174,
    SYSTEM_SCF_FIRMWARE_MISMATCH = 1175,
    SYSTEM_SCF_BIOS_MISMATCH = 1176,
    SYSTEM_SCF_HEADER_CORRUPTED = 1177,
    SYSTEM_SCF_SAVE_FAILED = 1178,
    SYSTEM_SCF_RESTORE_FAILED = 1179,
    SYSTEM_SCF_INVALID_OPTION = 1180,
    ERROR_AREA_NOT_PRESENT = 1181,
    ERROR_CONTROLLER_NOT_PRESENT = 1182,
    ERROR_NO_HRS_INI_FILE_PRESENT = 1183,
    ERROR_UNKNOWN = 1184,
    ERROR_LAN_IP_SET = 1185,
    ERROR_LAN_IP_GET = 1186,
    ERROR_LAN_ALERT_DESTINATION_MAC_GET = 1187,
    ERROR_LAN_MAC_GET = 1188,
    ERROR_LAN_DEFAULTGATEWAYIP_SET = 1189,
    ERROR_LAN_DEFAULTGATEWAYIP_GET = 1190,
    ERROR_LAN_IPTYPE_SET = 1191,
    ERROR_LAN_IPTYPE_GET = 1192,
    ERROR_LAN_GET_SUBNETMASK = 1193,
    ERROR_LAN_SET_SUBNETMASK = 1194,
    ERROR_LAN_SET_BACKUPGATEWAYIP = 1195,
    ERROR_USER_SET_PRIVILEGE = 1196,
    ERROR_USER_SET_PASSWORD = 1197,
    ERROR_USER_SET_USERNAME = 1198,
    ERROR_BIOS_CANTSETTIMEOFDAY = 1199,
    ER_BOOTDEVICE_CONFIGNOTLOADED = 1200,
    ER_BOOTDEVICE_BOOT_TABLE_GET = 1201,
    ER_BOOTDEVICE_TOOMANY_PRIORITIES = 1202,
    ER_BOOTDEVICE_NOT_VALID_PRIORITY = 1203,
    ER_BOOTDEVICE_PRIORITY_REPEATED = 1204,
    ER_BOOTDEVICE_DEVICETYPE_NOTSELECTED = 1205,
    ERROR_LAN_GET_BACKUPGATEWAYIP = 1206,
    ERROR_LAN_GET_BACKUPGATEWAYMAC = 1207,
    ERROR_LAN_SET_BACKUPGATEWAYMAC = 1208,
    ERROR_SEL_RESERVE = 1209,
    ERROR_SEL_CLEAR = 1210,
    ERROR_PEF_FILTER_GET = 1211,
    ERROR_PEF_POLICY_GET = 1212,
    ERROR_LAN_DEFAULTGATEWAYMAC_GET = 1213,
    ERROR_BMC_TYPE = 1214,
    ERROR_CHANNEL_ACCESS_MODE_SET = 1215,
    ERROR_SET_PEF_ACTION = 1216,
    ERROR_LAN_SET_COMMUNITY_STRING = 1217,
    ERROR_LAN_GET_COMMUNITY_STRING = 1218,
    ERROR_INVALID_GATEWAY_DATA = 1219,
    ERROR_FW_VERIFYFAILURE = 1220,
    ERROR_FW_UNKNOWNBOOTDIB = 1221,
    ERROR_FW_UNKNOWNOPDIB = 1222,
    ERROR_FW_UNKNOWNPIADIB = 1223,
    ERROR_HEXRECORDEXTSEG = 1224,
    ERROR_HEXRECORDSTRTSEG = 1225,
    ERROR_HEXRECORDSTRTLIN = 1226,
    ERROR_HEXRECORDUNKNOWN = 1227,
    ERROR_NOTHINGTOUPDATE = 1228,
    ERROR_NOTHINGTOVERIFY = 1229,
    ERROR_BYTEMISMATCH = 1230,
    ERROR_FWXFERSETSEG = 1231,
    ERROR_FWXFERREAD = 1232,
    ERROR_FWXFERWRITE = 1233,
    ERROR_DATABEFORESEGMENT = 1234,
    ERROR_REPEATSEGMENT = 1235,
    ERROR_SEGMENTOUTOFRANGE = 1236,
    ERROR_FWXFERGETMODE = 1237,
    ERROR_FWXFERGETVER = 1238,
    ERROR_FWXFERRANGECHKSM = 1239,
    ERROR_CMDRETURNEDDONTMATCH = 1240,
    ERROR_COMPCODEERR = 1241,
    ERROR_GETTINGIPMIMESSAGE = 1242,
    ERROR_SETSEGMENTFAILURE = 1243,
    ERROR_DATABUFFERGET = 1244,
    ERROR_LOCKFRONTPANEL = 1245,
    ERROR_RESTORECONFIGFAIL = 1246,
    ERROR_SYSTEM_BUSY = 1247,
    ERROR_PEF_POLICY_EXCEED_NUMBER = 1248,
    ERROR_SOL_PRIVILEGE_GET = 1249,
    ERROR_SOL_PRIVILEGE_SET = 1250,
    ERROR_SOL_RETRY_COUNT_GET = 1251,
    ERROR_SOL_RETRY_COUNT_SET = 1252,
    ERROR_SOL_RETRY_INTERVAL_GET = 1253,
    ERROR_SOL_RETRY_INTERVAL_SET = 1254,
    ERROR_SOL_PAYLOAD_AUTHENTICATION_GET = 1255,
    ERROR_SOL_PAYLOAD_AUTHENTICATION_SET = 1256,
    ERROR_CRC_MISMATCH = 1257,
    ERROR_FRU_DEVICE_ID_NOT_PRESENT = 1258,
    ERROR_USER_GET_USERNAME = 1259,
    ERROR_CHASSIS_CONTROL_SET = 1260,
    ERROR_GET_SOL_PAYLOADACCESS = 1261,
    ERROR_NOT_VALID_CHANNEL = 1262,
    ERROR_BOOTORDER_FILE_SYSTEM_NOT_SAME = 1263,
    ERROR_USER_GET_PRIVILEGE = 1264,
    ERROR_KCS_INTERFACE_INITIALIZATION_FAILED = 1265,
    ERROR_FAILED_GET_LOCK = 1266,
    ERROR_TIME_PERIOD = 1267,
    ERROR_META_INFO_TABLE = 1268,
    ERROR_SDR_REPOSITORY_EXCEPTION = 1269,
    ERROR_EVENT_TABLE = 1270,
    ERROR_OEM_TABLE = 1271,
    ERROR_GPT_UNSUPPORTED = 1272,
    ERROR_OS_PARTITION_API_FAILED = 1273,
    ERROR_IPMI_DRIVER_INIT_FAILED = 1274,
    ERROR_FAILED_TO_UNLOCK_ME_FLASH = 1275,
    ERROR_CFG_FILE_COMMAND_INVALID = 1276,
    ERROR_CFG_PARSE_LOAD = 1278,
    ERROR_CFG_PARSE_UNLOAD = 1279,
    ERROR_CFG_PARSE_IPMILOAD = 1280,
    ERROR_CFG_PARSE_BMCINTERFACE = 1281,
    ERROR_CFG_PARSE_UNINITIALIZED = 1282,
    ERROR_CFG_PARSE_DENITIALIZE = 1283,
    ERROR_CFG_PARSE_FILENOTFOUND = 1284,
    ERROR_CFG_PARSE_FILEFORMAT = 1285,
    ERROR_CFG_PARSE_INVALIDFILETYPE = 1286,
    ERROR_CFG_PARSE_INVALIDFILEPLATFORM = 1287,
    ERROR_CFG_PARSE_PARAMCOUNT = 1288,
    ERROR_CFG_PARSE_INVALIDPARAM = 1289,
    ERROR_CFG_PARSE_FILEREAD = 1290,
    ERROR_CFG_PARSE_ENVREAD = 1291,
    ERROR_CFG_PARSE_STDINREAD = 1292,
    ERROR_CFG_PARSE_PROBECREATE = 1293,
    ERROR_CFG_PARSE_PROCESSCOMMANDS = 1294,
    ERROR_CFG_PARSE_SELECTRANGE = 1295,
    ERROR_CFG_PARSE_OPENIFSETELSE = 1296,
    ERROR_CFG_PARSE_EARLYENDOFFILE = 1297,
    ERROR_CFG_PARSE_COMMANDORDER = 1298,
    ERROR_CFG_PARSE_INVALIDCOMMAND = 1299,
    ERROR_CFG_PARSE_INVALIDFRUNAME = 1300,
    ERROR_CFG_PARSE_INVALIDFRUADDRESS = 1301,
    ERROR_CFG_PARSE_INVALIDFRUAREA = 1302,
    ERROR_CFG_PARSE_INVALIDFRUFIELD = 1303,
    ERROR_CFG_PARSE_NONOTIFYAREA = 1304,
    ERROR_CFG_PARSE_CREATECOMMAND = 1305,
    ERROR_CFG_PARSE_CONFIGNAMEUSED = 1306,
    ERROR_LAN_FAILOVER_STATUS = 1307,
    ERROR_LAN_FAILOVER_SET_FAILED = 1308,
    ERROR_LAN_FAILOVER_NOT_SUPPORTED = 1309,
    //ERROR_IPV6_NOT_SUPPORTED=1310,
    ERROR_IPV6_PREFIX_LENGTH_EXCEEDED = 1311,
    ERROR_IPV6_ADDRESS = 1312,
    ERROR_IPV6_GATEWAY_ADDRESS = 1313,
    ERROR_SMBIOS_TABLE_READ = 1314,
    ERROR_INVALID_SMBIOS_REGION = 1315,
    ERROR_SMBIOS_REGION_IS_LOCKED = 1316,
    ERROR_DFS_BIOS_VALIDATION = 1317, //ww22.2 rajneesh
    ERROR_IPV6_DESTINATION_ADDRESS_FAILED = 1318,
    ERROR_BMC_ALREADY_IN_PLDB_TRANSFER_MODE = 1319,
    ERROR_PLDB_FILE_SELECTOR_OUT_OF_RANGE = 1320,
    ERROR_PLDB_INVALID_DATA_FIELD = 1321,
    ERROR_PLDB_FILE_READ_FAILED = 1322,
    ERROR_PLDB_INVALID_COMMAND = 1323,
    ERROR_PLDB_OFFSET_AND_LENGTH_OUTOFRANGE = 1324,
    ERROR_BMC_DEBUG_FILE_NAME_INVALID = 1325,
    ERROR_BMC_DEBUG_FILE_SIZE_INVALID = 1326,
    ERROR_IPV6_PREFIX_IP_SET = 1327,
    ERROR_ADMIN_PASSWORD_NOT_CORRECT_RETRIES_LESSTHAN_3 = 1328,
    ERROR_ADMIN_PASSWORD_NOT_CORRECT_RETRIES_GREATERTHAN_3 = 1329,
    ERROR_PWD_MISMATCH = 1330,
    ERROR_IPV6_STATUS_GET = 1331,
    ERROR_IPV6_STATUS_SET = 1332,
    ERROR_IPV6_SOURCE_GET = 1333,
    ERROR_IPV6_SOURCE_SET = 1334,
    ERROR_IPV6_PREFIX_LENGTH_GET = 1335,
    ERROR_IPV6_PREFIX_LENGTH_SET = 1336,
    ERROR_IPV6_IP_GET = 1337,
    ERROR_IPV6_IP_SET = 1338,
    ERROR_IPV6_GATEWAY_IP_GET = 1339,
    ERROR_IPV6_GATEWAY_IP_SET = 1340,
    ERROR_IPV6_DESTINATION_IP_GET = 1341,
    ERROR_IPV6_DESTINATION_IP_SET = 1342,
    ERROR_CAPSULE_FILE_NAME_INVALID = 1343,
    ERROR_CFG_UPDATE_ABORT_OPERATION = 1344,
    ERROR_FRU_FILE_INVALID_CHECKSUM = 1345,
    ERROR_FRU_FILE_CORRUPTED = 1346,
    ERROR_ADMIN_USER_PWD_SAME = 1347,
    ERROR_INVALID_SPL_CHAR = 1348,
    WARNING_WEAK_PSWD = 1349,
    ERROR_WEAK_SAME_PSWD = 1350,
    ERROR_BAUD_RATE_NOT_SUPPORTED = 1351,
    ERROR_BIOS_UPDATE_FAILED_SECURITY = 1352,
    ERROR_SERIAL_AANDB_SAME_VALUE = 1353,
    ERROR_CFG_FRUFIELD_LENGTH = 1354,
    ERROR_COLD_REDUNDANCY_SET_FAILED = 1355,
    ENVVAR_ERROR_LEN = 1356,
    ERROR_ENV_VAR_NOT_SET = 1357,
    ERROR_UPDATE_FORBIDDEN_BY_POLICY = 1358, // CCB 128
    ERROR_NOT_A_PMBUS_POWER_SUPPLY = 1359,

    ERROR_BIOS_SMI_SET_RECOVERY_BIT = 1360,
    ERROR_BIOS_SMI_READ_BLOCK = 1361,
    ERROR_BIOS_SMI_WRITE_BLOCK = 1362,
    ERROR_BIOS_SMI_ERASE_BLOCK = 1363,
    ERROR_BIOS_SMI_FLASH_DESCRIPTOR = 1364,
    ERROR_BIOS_SMI_SEND_CAPSULE = 1365,
    IPMI_ERROR_RESOURCE_UNAVAILABLE = 2001,
    IPMI_ERROR_INVALID_COMMAND,
    IPMI_ERROR_INVALID_COMMAND_FOR_GIVEN_LUN,
    IPMI_ERROR_TIME_OUT,
    IPMI_ERROR_OUT_OF_SPACE,
    IPMI_ERROR_INVALID_RESERVATION_ID,
    IPMI_ERROR_REQUESTED_SENSOR_DATA_NOT_PRESENT,
    IPMI_ERROR_REQUEST_DATA_TRUNCATED,
    IPMI_ERROR_REQUEST_DATA_LENGTH_INVALID,
    IPMI_ERROR_REQUEST_DATA_FIELD_LENGTH_EXCEEDED,
    IPMI_ERROR_PARAMETER_OUT_OF_RANGE,
    IPMI_ERROR_NO_OF_REQUESTED_BYTES,
    IPMI_ERROR_INVALID_DATA_FIELD_IN_REQUEST,
    IPMI_ERROR_ILLEGAL_COMMAND,
    IPMI_RESPONSE_ERROR,
    ERROR_DOWNGRADE_ME_VERSION_NOT_ALLOWED,
    ERROR_BOOT_DEVICE_EXCEED_MAX_NUMBER,
    ERROR_FW_UPDATE_DOWNGRADE_FAILED,
    ERROR_SMI_SET_ADMIN_PW_FAILED,
    ERROR_SMI_SET_USER_PW_FAILED,
    ERROR_SMI_GET_PW_STATUS_FAILED,

    // For BMC SOL log
    ERROR_BMC_SOL_FILE_NAME_INVALID,
    ERROR_BMC_SOL_FILE_SIZE_INVALID,
    ERROR_BMC_SOL_FILE_CREATED_FAILED,

    // For UEFI Secure Boot
    ERROR_SMI_SET_SECURE_BOOT_FAILED,
    ERROR_SMI_SECURITY_VIOLATION_FAILED,
    ERROR_SMI_NOT_SUPPORT_SECURE_BOOT,

    // For BootOrder
    ERROR_BIOS_BOOTNAME_MISMATCH,

    // For IFWI 
    ERROR_IFWI_FILE_NAME_INVALID,
    ERROR_IFWI_FILE_PARSING_FAILED,
    ERROR_IFWI_READED_LAST_ENTRY,
    ERROR_IFWI_CANNOT_FIND_REGION,

    ERROR_NAME_END
} ERROR_NAME;
#endif
