/******************************************************************************
 *
 *                   INTEL CORPORATION PROPRIETARY INFORMATION
 *       This software is supplied under the terms of a license agreement or
 *       nondisclosure agreement with Intel Corporation and may not be copied
 *       or disclosed except in accordance with the terms of that agreement.
 *
 *            Copyright (c) 2008-2009 Intel Corporation. All Rights Reserved.
 *
 *       All rights reserved.  No part of this program or publication may be
 *       reproduced, transmitted, transcribed, stored in a retrieval system,
 *       or translated into any language or computer language, in any form or
 *       by any means, electronic, mechanical, magnetic, optical, chemical,
 *       manual, or otherwise, without the prior written permission of Intel
 *       Corporation.
 *
 *
 *******************************************************************************/
#ifndef __CR_OSAL_HASH_MAP_H_
#define __CR_OSAL_HASH_MAP_H_

#ifdef CR_EFI
#include <os/include/efi/cr_hash_map.h>
using namespace osal_stl;
namespace osal_stl {
template <>
struct cr_hash<STRING>
{
    size_t operator()(const STRING & myString) const
    {
        return cr_hash < const char * > () (myString.c_str());
    }
};
}

namespace Module
{
namespace Osal
{
typedef osal_stl::cr_hash_map<STRING, STRING> STRING_TO_STRING_HMAP;

#define TYPEDEF_HASH_MAPOF(x, y, z) typedef osal_stl::cr_hash_map<x, y> z
} // end of namespace Osal
} // end of namespace Module
#endif //ifdef CR_EFI
#endif //ifndef__CR_OSAL_HASH_MAP_H_
