#!/bin/bash
echo OFF
## this is a auto script for IASC Red Hat 32 bit rpm installation from CD.
## this script only support Red Hat 6.4, 6.5 and 7.0.
## for Red Hat 6.4 used x64 CD and for 6.5 used x32bit CD.
## created by Teh Kok Piaw 
## version 1.0 :first release.
## version 1.1 :added rhat7 support

uname_r=`uname -r`
I=0;

echo @Please do not access installation CD content or open any file when run this script.
echo @or else this script will fail to mount/unmount installation CD.
echo
read -p "Press Enter To Start"

## sleep for 5 second to makse sure CDROM in detected by Rhat
sleep 5

##unmount CD put in CDROM and remount it to new label. if fail maybe CDROM not detected
if [ -e "/dev/cdrom" ]; then
  ##echo "/dev/cdrom"
  umount /dev/cdrom
  if [ -e "/mnt/cdrom" ]; then
	  ##echo "found /mnt/cdrom"
	  mount /dev/cdrom /mnt/cdrom
	  CD_DIR='/mnt/cdrom'
  else
	  ##echo "cannot /dev/cdrom"
	  mkdir /mnt/cdrom
	  mount /dev/cdrom /mnt/cdrom
	  CD_DIR='/mnt/cdrom'
  fi;
else
for I in 1 2 3 4 5   ## use for loop to search cdrom in /dev folder.
  do
	if [ -e "/dev/cdrom$I" ]; then
	  umount /dev/cdrom$I
	  if [ -e "/mnt/cdrom" ]; then
		##echo "found /mnt/cdrom"
		mount /dev/cdrom$I /mnt/cdrom
		CD_DIR='/mnt/cdrom'
		break;
	  else
		##echo "cannot /dev/cdrom"
		mkdir /mnt/cdrom
		mount /dev/cdrom$I /mnt/cdrom
		CD_DIR='/mnt/cdrom'
		break;
	  fi;
	else
	  ##echo "cannot find cdrom$I or CDROM cannot be detected"
	  ##echo "Automation: script stopped."
	  continue;
	fi;
  done
fi;

## check if no /dev/cdrom found fail it.
if [ $I == 5 ]; then
	echo "mounting CDROM failed or CDROM cannot be detected"
	echo "Automation: script stopped."
	exit 1
fi;

if [ -d "${CD_DIR}" ]; then
	echo
	##echo @found the installation CD
	echo
		my_path=$(find /mnt/cdrom -iname "zlib*i686*")
	if [ "$my_path" != "" ]; then
		echo "RPM found"
		rpm -ivh --force --nodeps $my_path
	else
		echo @cannot find the rpm for zlib*i686*
		echo @check for correct Red Hat installation CD version
		exit 1
	fi;
################################################################
	my_path=$(find /mnt/cdrom -iname "libxml2*i686*")
	if [ "$my_path" != "" ]; then
		echo "RPM found"
		rpm -ivh --force --nodeps $my_path
	else
		echo @lcannot find the rpm for ibxml2*i686*
		echo @check for correct Red Hat installation CD version
		exit 1
	fi;
################################################################	
	my_path=$(find /mnt/cdrom -iname "libgpg-error*i686*")
	if [ "$my_path" != "" ]; then
		echo "RPM found"
		rpm -ivh --force --nodeps $my_path
	else
		echo @cannot find the rpm for libqpg-error*i686*
		echo @check for correct Red Hat installation CD version
		exit 1
	fi;
#################################################################
	my_path=$(find /mnt/cdrom -iname "libgcrypt*i686*")
	if [ "$my_path" != "" ]; then
		echo "RPM found"
		rpm -ivh --force --nodeps $my_path
	else
		echo @cannot find the rpm for libgcrypt*i686*
		echo @check for correct Red Hat installation CD version
		exit 1
	fi;
#################################################################
	my_path=$(find /mnt/cdrom -iname "libxslt*i686*")
	if [ "$my_path" != "" ]; then
		echo "RPM found"
		rpm -ivh --force --nodeps $my_path
	else
		echo @cannot find the rpm for libxslt*i686*
		echo @check for correct Red Hat installation CD version
		exit 1
	fi;	
#################################################################
	my_path=$(find /mnt/cdrom -iname "libstdc++*i686*")
	if [ "$my_path" != "" ]; then
		echo "RPM found"
		rpm -ivh --force --nodeps $my_path
	else
		echo @cannot find the rpm for libstdc++*i686*
		echo @check for correct Red Hat installation CD version
		exit 1
	fi;
##################################################################	
##	my_path=$(find /mnt/cdrom -iname "libstdc++-4.8.2*i686*")
##	if [ "$my_path" != "" ]; then
##		echo "RPM found"
##		rpm -ivh --force --nodeps $my_path
##	else
##		echo @cannot find the rpm for libstdc++-4.8.2*i686*
##		echo @check for correct Red Hat installation CD version
##		exit 1
##	fi;
###################################################################	
	my_path=$(find /mnt/cdrom -iname "ncurses-libs*i686*")
	if [ "$my_path" != "" ]; then
		echo "RPM found"
		rpm -ivh --force --nodeps $my_path
	else
		echo @cannot find the rpm for ncurses-libs*i686*
		echo @check for correct Red Hat installation CD version
		exit 1
	fi;
###################################################################	
	my_path=$(find /mnt/cdrom -iname "ncurses-devel*i686*")
	if [ "$my_path" != "" ]; then
		echo "RPM found"
		rpm -ivh --force --nodeps $my_path
	else
		echo @cannot find the rpm for ncurses-devel*i686*
		echo @check for correct Red Hat installation CD version
		exit 1
	fi;
###################################################################	
	my_path=$(find /mnt/cdrom -iname "compat-db*i686*")
	if [ "$my_path" != "" ]; then
		echo "RPM found"
		rpm -ivh --force --nodeps $my_path
	else
		echo @cannot find the rpm for compat-db*i686*
		echo @check for correct Red Hat installation CD version
		exit 1
	fi;
####################################################################
	my_path=$(find /mnt/cdrom -iname "nspr*i686*")
	if [ "$my_path" != "" ]; then
		echo "RPM found"
		rpm -ivh --force --nodeps $my_path
	else
		echo @cannot find the rpm for nspr*i686*
		echo @check for correct Red Hat installation CD version
		exit 1
	fi;
####################################################################	
	my_path=$(find /mnt/cdrom -iname "nss-util*i686*")
	if [ "$my_path" != "" ]; then
		echo "RPM found"
		rpm -ivh --force --nodeps $my_path
	else
		echo @cannot find the rpm for nss-util*i686*
		echo @check for correct Red Hat installation CD version
		exit 1
	fi;
#####################################################################
	my_path=$(find /mnt/cdrom -iname "readline*i686*")
	if [ "$my_path" != "" ]; then
		echo "RPM found"
		rpm -ivh --force --nodeps $my_path
	else
		echo @cannot find the rpm for readline*i686*
		echo @check for correct Red Hat installation CD version
		exit 1
	fi;
#####################################################################	
	my_path=$(find /mnt/cdrom -iname "sqlite*i686*")
	if [ "$my_path" != "" ]; then
		echo "RPM found"
		rpm -ivh --force --nodeps $my_path
	else
		echo @cannot find the rpm for sqlite*i686*
		echo @check for correct Red Hat installation CD version
		exit 1
	fi;
######################################################################	
	my_path=$(find /mnt/cdrom -iname "nss-softokn*i686*")
	if [ "$my_path" != "" ]; then
		echo "RPM found"
		rpm -ivh --force --nodeps $my_path
	else
		echo @cannot find the rpm for nss-softokn*i686*
		echo @check for correct Red Hat installation CD version
		exit 1
	fi;
######################################################################	
	my_path=$(find /mnt/cdrom -iname "nss*i686*")
	if [ "$my_path" != "" ]; then 
		echo "RPM found"
		rpm -ivh --force --nodeps $my_path
	else
		echo @cannot find the rpm for nss*i686*
		echo @check for correct Red Hat installation CD version
		exit 1
	fi;
######################################################################	
	my_path=$(find /mnt/cdrom -iname "cyrus-sasl-lib*i686*")
	if [ "$my_path" != "" ]; then
		echo "RPM found"	
		rpm -ivh --force --nodeps $my_path
	else
		echo @cannot find the rpm for cyrus-sasl-lib*i686*
		echo @check for correct Red Hat installation CD version
		exit 1
	fi;
######################################################################	
	my_path=$(find /mnt/cdrom -iname "libidn*i686*")
	if [ "$my_path" != "" ]; then 
		echo "RPM found"
		rpm -ivh --force --nodeps $my_path
	else
		echo @cannot find the rpm for libidn*i686*
		echo @check for correct Red Hat installation CD version
		exit 1
	fi;
######################################################################	
	my_path=$(find /mnt/cdrom -iname "libcom_err*i686*")
	if [ "$my_path" != "" ]; then 
		echo "RPM found"	
		rpm -ivh --force --nodeps $my_path
	else
		echo @cannot find the rpm for libcom_err*i686*
		echo @check for correct Red Hat installation CD version
		exit 1
	fi;
#######################################################################	
	my_path=$(find /mnt/cdrom -iname "openldap*i686*")
	if [ "$my_path" != "" ]; then
		echo "RPM found"	
		rpm -ivh --force --nodeps $my_path
	else
		echo @cannot find the rpm for openldap*i686*
		echo @check for correct Red Hat installation CD version
		exit 1
	fi;
#######################################################################	
	my_path=$(find /mnt/cdrom -iname "keyutils-libs*i686*")
	if [ "$my_path" != "" ]; then
		echo "RPM found"		
		rpm -ivh --force --nodeps $my_path
	else
		echo @cannot find the rpm for keyutils-libs*i686*
		echo @check for correct Red Hat installation CD version
		exit 1
	fi;
#######################################################################	
	my_path=$(find /mnt/cdrom -iname "libselinux*i686*")
	if [ "$my_path" != "" ]; then 
		echo "RPM found"
		rpm -ivh --force --nodeps $my_path
	else
		echo @cannot find the rpm for libselinux*i686*
		echo @check for correct Red Hat installation CD version
		exit 1
	fi;
#######################################################################	
	my_path=$(find /mnt/cdrom -iname "krb5-libs-*i686*")
	if [ "$my_path" != "" ]; then 
		echo "RPM found"
		rpm -ivh --force --nodeps $my_path
	else
		echo @cannot find the rpm for krb5-libs-*i686*
		echo @check for correct Red Hat installation CD version
		exit 1
	fi;
#######################################################################	
	
	my_path=$(find /mnt/cdrom -iname "openssl098e*i686*")
	if [ "$my_path" != "" ]; then 
		echo "RPM found"
		rpm -ivh --force --nodeps $my_path
	else
		echo @cannot find the rpm for openssl098e*i686*
		echo @check for correct Red Hat installation CD version
		exit 1
	fi;
#######################################################################	
	my_path=$(find /mnt/cdrom -iname "libcurl*i686*")
	if [ "$my_path" != "" ]; then
		echo "RPM found"
		rpm -ivh --force --nodeps $my_path
	else
		echo @cannot find the rpm for libcurl*i686*
		echo @check for correct Red Hat installation CD version
		exit 1
	fi;
#######################################################################	
	my_path=$(find /mnt/cdrom -iname "libssh2*i686*")
	if [ "$my_path" != "" ]; then
		echo "RPM found"
		rpm -ivh --force --nodeps $my_path
	else
		echo @cannot find the rpm for libssh2*i686*
		echo @check for correct Red Hat installation CD version
		exit 1
	fi;
#######################################################################	
	my_path=$(find /mnt/cdrom -iname "libgcc*i686*")
	if [ "$my_path" != "" ]; then
		echo "RPM found"
		rpm -ivh --force --nodeps $my_path
	else
		echo @cannot find the rpm for libgcc*i686*
		echo @check for correct Red Hat installation CD version
		exit 1
	fi;
#######################################################################	
	my_path=$(find /mnt/cdrom -iname "glibc*i686*")
	if [ "$my_path" != "" ]; then
		echo "RPM found"
		rpm -ivh --force --nodeps $my_path
	else
		echo @cannot find the rpm for glibc*i686*
		echo @check for correct Red Hat installation CD version
		exit 1
	fi;	
#######################################################################	
	my_path=$(find /mnt/cdrom -iname "libgcrypt*i686*")
	if [ "$my_path" != "" ]; then
		echo "RPM found"
		rpm -ivh --force --nodeps $my_path
	else
		echo @cannot find the rpm for libgcrypt*i686*
		echo @check for correct Red Hat installation CD version
		exit 1
	fi;	
#######################################################################	
	my_path=$(find /mnt/cdrom -iname "libxslt*i686*")
	if [ "$my_path" != "" ]; then
		echo "RPM found"
		rpm -ivh --force --nodeps $my_path
	else
		echo @cannot find the rpm for libxslt*i686*
		echo @check for correct Red Hat installation CD version
		exit 1
	fi;
#######################################################################	
	my_path=$(find /mnt/cdrom -iname "openssl*i686*")
	if [ "$my_path" != "" ]; then
		echo "RPM found"
		rpm -ivh --force --nodeps $my_path
	else
		echo @cannot find the rpm for openssl*i686*
		echo @check for correct Red Hat installation CD version
		exit 1
	fi;
#######################################################################	
	my_path=$(find /mnt/cdrom -iname "pcre*i686*")
	if [ "$my_path" != "" ]; then
		echo "RPM found"
		rpm -ivh --force --nodeps $my_path
	else
		echo @cannot find the rpm for pcre*i686*
		echo @check for correct Red Hat installation CD version
		exit 1
	fi;
#######################################################################	
	my_path=$(find /mnt/cdrom -iname "xz-libs*i686*")
	if [ "$my_path" != "" ]; then
		echo "RPM found"
		rpm -ivh --force --nodeps $my_path
	else
		echo @cannot find the rpm for xz-libs*i686*
		echo @check for correct Red Hat installation CD version
		exit 1
	fi;	
#######################################################################	
	my_path=$(find /mnt/cdrom -iname "nss-softokn-freebl*i686*")
	if [ "$my_path" != "" ]; then
		echo "RPM found"
		rpm -ivh --force --nodeps $my_path
	else
		echo @cannot find the rpm for nss-softokn-freebl*i686*
		echo @check for correct Red Hat installation CD version
		exit 1
	fi;
	echo @IASC Red Hat 7.1 32 bit rpm installation completed.....!!
	if [ $I == 0 ]; then
	  umount /dev/cdrom
	else
	  umount /dev/cdrom$I
	fi;
else
		echo @Installation CD  not detected.
		echo @make sure installation CD is not busy or in used.
		echo @suspect mount/unmount installation CD not working.
		echo @Automation: script stopped.
		echo 
		exit 1
fi;

		
		
