/******************************************************************************
 *
 *                   INTEL CORPORATION PROPRIETARY INFORMATION
 *       This software is supplied under the terms of a license agreement or
 *       nondisclosure agreement with Intel Corporation and may not be copied
 *       or disclosed except in accordance with the terms of that agreement.
 *
 *            Copyright (c) 2008-2009 Intel Corporation. All Rights Reserved.
 *
 *       All rights reserved.  No part of this program or publication may be
 *       reproduced, transmitted, transcribed, stored in a retrieval system,
 *       or translated into any language or computer language, in any form or
 *       by any means, electronic, mechanical, magnetic, optical, chemical,
 *       manual, or otherwise, without the prior written permission of Intel
 *       Corporation.
 *
 *
 *******************************************************************************/
#ifndef __CR_OSAL_DLL_TYPES_H_
#define __CR_OSAL_DLL_TYPES_H_

#ifdef CR_LINUX
#include <dlfcn.h>

//Information for dynamic libs
typedef char* DllNameType;
typedef void* DllHandleType;
typedef char* CreationInfoFuncNameType;
typedef void* FARPROC;

#ifndef CRDllLoadLibrary_API
#define CRDllLoadLibrary_API
static inline DllHandleType CRDllLoadLibrary(DllNameType dllName)
{
    return (DllHandleType)dlopen((const char*)dllName, RTLD_LAZY);
}
#endif //#ifdef CRDllLoadSymbol_API

#ifndef CRDllLoadSymbol_API
#define CRDllLoadSymbol_API
static inline FARPROC CRDllLoadSymbol(DllHandleType dllHandle, CreationInfoFuncNameType functionName)
{
    return (FARPROC)dlsym((void*)dllHandle, (const char*)functionName);
}
#endif //#ifdef CRDllLoadSymbol_API

#ifndef CRDllCloseLibrary_API
#define CRDllCloseLibrary_API
static inline int CRDllCloseLibrary(DllHandleType dllHdl)
{
    return dlclose((void*)dllHdl);
}
#endif //#ifndef CRDllCloseLibrary_API


#ifndef CR_LOG4CPP_DLL
#define CR_LOG4CPP_DLL "CRLog4cpp.so"
#endif

#ifndef CR_BMCCONFIG_MODULE_DLL
#define CR_BMCCONFIG_MODULE_DLL "libbmcconfig.so"
#endif

#ifndef CR_OOB_MODULE_DLL
#define CR_OOB_MODULE_DLL "libOOBLib.so"
#endif

#ifndef CR_BIOSCONFIG_MODULE_DLL
#define CR_BIOSCONFIG_MODULE_DLL "libbiosconfig.so"
#endif

#ifndef CR_SMBPROTOCOL_MODULE_DLL
#define CR_SMBPROTOCOL_MODULE_DLL "libsmbprotocol.so"
#endif

#ifndef CR_MEM_MAP_DRIVER_MODULE_DLL
#define CR_MEM_MAP_DRIVER_MODULE_DLL "libmemmapdriver.so"
#endif

#ifndef CR_SMIPROTOCOL_MODULE_DLL
#define CR_SMIPROTOCOL_MODULE_DLL "libsmiprotocol.so"
#endif

#ifndef CR_HIIPROTOCOL_MODULE_DLL
#define CR_HIIPROTOCOL_MODULE_DLL "libhiiprotocol.so"
#endif

#ifndef CR_ACPIPROTOCOL_MODULE_DLL
#define CR_ACPIPROTOCOL_MODULE_DLL "libacpiprotocol.so"
#endif

#ifndef CR_SYSTEMCONFIG_MODULE_DLL
#define CR_SYSTEMCONFIG_MODULE_DLL "libsystemconfig.so"
#endif

#ifndef CR_PLATFORMCONFIG_MODULE_DLL
#define CR_PLATFORMCONFIG_MODULE_DLL "libplatformconfig.so"
#endif
#endif //#ifdef CR_LINUX
#endif //#ifndef __CR_OSAL_DLL_TYPES_H_
